/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.editor.LogListViewer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.Key;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.services.ServiceException;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.IdFilter;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.ParametersInterface;
import com.sas.workspace.PhysicalTableUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class UpdateTableRunnable
implements Runnable {
    private static final WAdminResource bundle = WAdminResource.getBundle(UpdateTableRunnable.class);
    private CMetadata[] m_tables;
    private OpRequestUI m_request;
    private boolean m_bUpdateStatus;
    private ParametersInterface m_parametersInterface;
    private WsAppServer m_defaultServer;
    private LogListViewer m_log;
    private Map m_tablesModified;
    private Map<String, PasswordAuthentication> m_libraryMap;
    private CMetadata m_workLibrary;

    public UpdateTableRunnable(WsAppServer server, LogListViewer logViewer, ParametersInterface parmInterface, CMetadata[] tableArray, Map tablesModified, OpRequestUI request, Map<String, PasswordAuthentication> libraryMap) {
        this.m_defaultServer = server;
        this.m_log = logViewer;
        this.m_tables = tableArray;
        this.m_parametersInterface = parmInterface;
        this.m_tablesModified = tablesModified;
        this.m_request = request;
        this.m_libraryMap = libraryMap;
    }

    public UpdateTableRunnable(WsAppServer server, LogListViewer logViewer, ParametersInterface parmInterface, CMetadata[] tableArray, Map tablesModified, OpRequestUI request, Map<String, PasswordAuthentication> libraryMap, CMetadata workLibrary) {
        this.m_defaultServer = server;
        this.m_log = logViewer;
        this.m_tables = tableArray;
        this.m_parametersInterface = parmInterface;
        this.m_tablesModified = tablesModified;
        this.m_request = request;
        this.m_libraryMap = libraryMap;
        this.m_workLibrary = workLibrary;
    }

    @Override
    public void run() {
        this.m_bUpdateStatus = this.doUpdate();
    }

    public boolean getUpdateStatus() {
        return this.m_bUpdateStatus;
    }

    private boolean doUpdate() {
        try {
            int i;
            HashMap<String, AssociationList> columns = new HashMap<String, AssociationList>();
            HashMap<String, AssociationList> indexes = new HashMap<String, AssociationList>();
            HashMap<String, AssociationList> keys = new HashMap<String, AssociationList>();
            HashMap<String, AssociationList> foreignKeys = new HashMap<String, AssociationList>();
            try {
                if (this.m_tables != null) {
                    for (i = 0; i < this.m_tables.length; ++i) {
                        columns.put(this.m_tables[i].getFQID(), ((PhysicalTable)this.m_tables[i]).getColumns());
                        indexes.put(this.m_tables[i].getFQID(), ((PhysicalTable)this.m_tables[i]).getIndexes());
                        keys.put(this.m_tables[i].getFQID(), ((PhysicalTable)this.m_tables[i]).getUniqueKeys());
                        foreignKeys.put(this.m_tables[i].getFQID(), ((PhysicalTable)this.m_tables[i]).getForeignKeys());
                    }
                }
            }
            catch (MdException failException) {
                MessageUtil.displayDetailsMessage(bundle.getString("UpdateTableRunnable.AppServerError.Message.txt"), bundle.getString("UpdateTableRunnable.AppServerError.Message.Title.txt"), 0, failException.getLocalizedMessage());
                return false;
            }
            for (i = 0; i < this.m_tables.length; ++i) {
                PhysicalTable table = (PhysicalTable)this.m_tables[i];
                this.m_request.setMessage(bundle.formatString("UpdateTableRunnable.UpdateMessage.fmt.txt", table.getName()));
                this.m_log.appendLine(UpdateTableRunnable.getFormatLine(table.getName(), table.getFQID(), i));
                if (!Workspace.getWorkspace().isObjectEditable((CMetadata)table)) {
                    this.m_log.appendLine(bundle.getString("UpdateTableRunnable.Resync.ObjectNotEditableError.Message.txt"));
                    this.m_log.appendLine(UpdateTableRunnable.getFormatLine());
                    continue;
                }
                try {
                    SASLibrary library = LibraryUtil.getLibrary((DataTable)table, this.m_defaultServer.getServerContext());
                    if (library == null && !table.getCMetadataType().equalsIgnoreCase("WorkTable")) {
                        this.m_log.appendLine(bundle.getString("UpdateTableRunnable.LibraryError.Message.txt"));
                        this.m_log.appendLine(UpdateTableRunnable.getFormatLine());
                        continue;
                    }
                    PhysicalTableUtil.updateMetadata(this.m_parametersInterface, null, this.m_tablesModified, this.m_log, this.m_defaultServer, library, table, this.m_libraryMap, this.m_workLibrary);
                }
                catch (WsAppServerFailException failException) {
                    MessageUtil.displayDetailsMessage(bundle.getString("UpdateTableRunnable.AppServerError.Message.txt"), bundle.getString("UpdateTableRunnable.AppServerError.Message.Title.txt"), 0, failException.getLocalizedMessage());
                    return false;
                }
                catch (MdException mdException) {
                    MessageUtil.displayDetailsMessage(bundle.getString("UpdateTableRunnable.MetadataError.Message.txt"), bundle.getString("UpdateTableRunnable.MetadataError.Title.txt"), 1, mdException.getLocalizedMessage());
                    return false;
                }
                catch (WsAppServerCodeException codeException) {
                    this.m_log.appendLine(UpdateTableRunnable.getFormatLine());
                    continue;
                }
                this.m_log.appendLine(UpdateTableRunnable.getFormatLine());
            }
            if (!this.m_tablesModified.isEmpty()) {
                MdFactory factory = Workspace.getMdFactory();
                HashMap modifiedMap = new HashMap();
                HashMap<String, String> deletedMap = new HashMap<String, String>();
                for (String id : this.m_tablesModified.keySet()) {
                    modifiedMap.put(id, this.m_tablesModified.get(id));
                    List cols = (List)columns.get(id);
                    for (int i2 = 0; i2 < cols.size(); ++i2) {
                        Column col = (Column)cols.get(i2);
                        if (this.doesObjectExist((Root)col)) {
                            modifiedMap.put(col.getFQID(), col.getCMetadataType());
                            continue;
                        }
                        deletedMap.put(col.getFQID(), col.getCMetadataType());
                    }
                    List inds = (List)indexes.get(id);
                    for (int i3 = 0; i3 < inds.size(); ++i3) {
                        Index ind = (Index)inds.get(i3);
                        if (this.doesObjectExist((Root)ind)) {
                            modifiedMap.put(ind.getFQID(), ind.getCMetadataType());
                            continue;
                        }
                        deletedMap.put(ind.getFQID(), ind.getCMetadataType());
                    }
                    List fKeys = (List)foreignKeys.get(id);
                    for (int i4 = 0; i4 < fKeys.size(); ++i4) {
                        ForeignKey fKey = (ForeignKey)fKeys.get(i4);
                        if (this.doesObjectExist((Root)fKey)) {
                            modifiedMap.put(fKey.getFQID(), fKey.getCMetadataType());
                            continue;
                        }
                        deletedMap.put(fKey.getFQID(), fKey.getCMetadataType());
                    }
                    List lstKeys = (List)keys.get(id);
                    for (int i5 = 0; i5 < lstKeys.size(); ++i5) {
                        Key key = (Key)lstKeys.get(i5);
                        if (this.doesObjectExist((Root)key)) {
                            modifiedMap.put(key.getFQID(), key.getCMetadataType());
                            continue;
                        }
                        deletedMap.put(key.getFQID(), key.getCMetadataType());
                    }
                }
                factory.fireMdObjectsModified(new MdFactoryEvent(factory, modifiedMap));
                factory.fireMdObjectsDeleted(new MdFactoryEvent(factory, deletedMap));
            }
            return true;
        }
        catch (ServiceException ex) {
            Workspace.handleServiceException(ex);
            return false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return false;
        }
    }

    private boolean doesObjectExist(Root mdObject) throws RemoteException, ServiceException {
        IdFilter filter = new IdFilter(mdObject.getFQID());
        filter.setOMRRepository("A0000001." + mdObject.getRepositoryID());
        filter.setOMRTemplate("<Templates><Root Name=\"\" /></Templates>");
        filter.setOMRFlags(-2147483644);
        ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
        List lBrowseObjects = server.browseSearch((FilterInterface)filter);
        return !lBrowseObjects.isEmpty();
    }

    private static String getFormatLine() {
        String longCommentLine = "/********************************************************************************/";
        return "\n" + longCommentLine + "\n";
    }

    private static String getFormatLine(String tableName, String tableId, int tableNumber) {
        String reposId = tableId.substring(0, tableId.indexOf("."));
        String longCommentLine = "********************************************************************************";
        String shortCommentLine = "*\t";
        StringBuffer formatLines = new StringBuffer();
        formatLines.append("\n\n");
        formatLines.append("/" + longCommentLine);
        formatLines.append("\n\n");
        formatLines.append(shortCommentLine);
        formatLines.append(bundle.formatString("UpdateTableRunnable.TableNumber.Fmt.txt", new Integer(tableNumber + 1)));
        formatLines.append("\n");
        formatLines.append(shortCommentLine);
        formatLines.append(bundle.formatString("UpdateTableRunnable.TableName.Fmt.txt", tableName));
        formatLines.append("\n");
        formatLines.append(longCommentLine + "/");
        formatLines.append("\n\n");
        return formatLines.toString();
    }
}

