/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class SplitManager {
    public static final int HORIZONTAL_SPLIT = 1;
    public static final int VERTICAL_SPLIT = 0;
    public static final int DIRECTION_NONE = 0;
    public static final int DIRECTION_UP = 1;
    public static final int DIRECTION_LEFT = 2;
    public static final int DIRECTION_DOWN = 3;
    public static final int DIRECTION_RIGHT = 4;
    public static final double FIRST_IS_FIXED = 0.0;
    public static final double SECOND_IS_FIXED = 1.0;
    HashMap m_hash = new HashMap();
    JPanel m_panel;

    public SplitManager(JPanel p) {
        this.m_panel = p;
        p.setLayout(new BorderLayout());
    }

    public void add(JComponent newComponent) throws ManagerNotEmptyException {
        if (!this.isEmpty()) {
            throw new ManagerNotEmptyException();
        }
        ComponentInfo newComponentInfo = new ComponentInfo(newComponent);
        this.m_hash.put(newComponent, newComponentInfo);
        newComponent.setSize(this.m_panel.getSize());
        this.m_panel.removeAll();
        this.m_panel.add((Component)newComponent, "Center");
    }

    public void add(int orientation, JComponent first, JComponent second, int size, double ratio) throws IllegalOrientationException, IllegalAdditionException, IllegalDirectionException, ManagerNotEmptyException {
        boolean secondIsNew;
        if (orientation != 1 && orientation != 0) {
            throw new IllegalOrientationException();
        }
        ComponentInfo firstInfo = null;
        ComponentInfo secondInfo = null;
        boolean firstIsNew = !this.m_hash.containsKey(first);
        boolean bl = secondIsNew = !this.m_hash.containsKey(second);
        if (!firstIsNew && !secondIsNew) {
            throw new IllegalAdditionException();
        }
        if (firstIsNew && secondIsNew) {
            if (!this.isEmpty()) {
                throw new ManagerNotEmptyException();
            }
            firstInfo = new ComponentInfo(first);
            secondInfo = new ComponentInfo(second);
            WASplitPane newPane = new WASplitPane(orientation, first, second, null, 0);
            newPane.setDividerLocation(size);
            newPane.setResizeWeight(ratio);
            this.updateParentOf(newPane);
            firstInfo.setParentPane(newPane);
            secondInfo.setParentPane(newPane);
            if (orientation == 1) {
                firstInfo.setDirection(2);
                secondInfo.setDirection(4);
            }
            if (orientation == 0) {
                firstInfo.setDirection(1);
                secondInfo.setDirection(3);
            }
            this.m_hash.put(first, firstInfo);
            this.m_hash.put(second, secondInfo);
        } else {
            ComponentInfo oldInfo;
            if (firstIsNew) {
                firstInfo = new ComponentInfo(first);
                oldInfo = secondInfo = (ComponentInfo)this.m_hash.get(second);
            } else {
                firstInfo = (ComponentInfo)this.m_hash.get(first);
                secondInfo = new ComponentInfo(second);
                oldInfo = firstInfo;
            }
            WASplitPane newPane = new WASplitPane(orientation, firstInfo.getComponent(), secondInfo.getComponent(), oldInfo.getParentPane(), oldInfo.getDirection());
            newPane.setDividerLocation(size);
            newPane.setResizeWeight(ratio);
            newPane.setDividerSize(6);
            newPane.setOneTouchExpandable(true);
            this.updateParentOf(newPane);
            firstInfo.setParentPane(newPane);
            secondInfo.setParentPane(newPane);
            if (orientation == 1) {
                firstInfo.setDirection(2);
                secondInfo.setDirection(4);
            }
            if (orientation == 0) {
                firstInfo.setDirection(1);
                secondInfo.setDirection(3);
            }
            this.m_hash.put(first, firstInfo);
            this.m_hash.put(second, secondInfo);
        }
    }

    public void remove(JComponent target) throws ComponentNotFoundException {
        if (!this.m_hash.containsKey(target)) {
            throw new ComponentNotFoundException();
        }
        ComponentInfo targetInfo = (ComponentInfo)this.m_hash.get(target);
        WASplitPane targetParent = targetInfo.getParentPane();
        this.m_hash.remove(target);
        if (targetParent == null) {
            this.m_panel.remove(target);
            this.m_panel.revalidate();
            this.m_panel.repaint();
            return;
        }
        WASplitPane targetGrandparent = targetParent.getParentPane();
        JComponent targetPartner = targetInfo.getPartnerComponent();
        if (targetGrandparent == null) {
            if (targetPartner instanceof WASplitPane) {
                WASplitPane targetPartnerPane = (WASplitPane)targetPartner;
                targetPartnerPane.setParentPane(null);
                targetPartnerPane.setPreferredSize(this.m_panel.getPreferredSize());
                this.updateParentOf(targetPartnerPane);
            } else if (this.m_hash.containsKey(targetPartner)) {
                ComponentInfo targetPartnerInfo = (ComponentInfo)this.m_hash.get(targetPartner);
                targetPartnerInfo.setParentPane(null);
                this.m_panel.removeAll();
                this.m_panel.add((Component)targetPartner, "Center");
            } else {
                throw new ComponentNotFoundException();
            }
            this.m_panel.revalidate();
            this.m_panel.repaint();
            return;
        }
        int dividerLocation = targetGrandparent.getDividerLocation();
        if (targetPartner instanceof WASplitPane) {
            WASplitPane targetPane = (WASplitPane)targetPartner;
            targetPane.setParentPane(targetGrandparent);
            switch (targetParent.getDirection()) {
                case 1: {
                    targetGrandparent.setTopComponent(targetPartner);
                    targetPane.setDirection(1);
                    break;
                }
                case 2: {
                    targetGrandparent.setLeftComponent(targetPartner);
                    targetPane.setDirection(2);
                    break;
                }
                case 3: {
                    targetGrandparent.setBottomComponent(targetPartner);
                    targetPane.setDirection(3);
                    break;
                }
                case 4: {
                    targetGrandparent.setRightComponent(targetPartner);
                    targetPane.setDirection(4);
                }
            }
        } else if (this.m_hash.containsKey(targetPartner)) {
            ComponentInfo targetPartnerInfo = (ComponentInfo)this.m_hash.get(targetPartner);
            targetPartnerInfo.setParentPane(targetGrandparent);
            try {
                switch (targetParent.getDirection()) {
                    case 1: {
                        targetGrandparent.setTopComponent(targetPartner);
                        targetPartnerInfo.setDirection(1);
                        break;
                    }
                    case 2: {
                        targetGrandparent.setLeftComponent(targetPartner);
                        targetPartnerInfo.setDirection(2);
                        break;
                    }
                    case 3: {
                        targetGrandparent.setBottomComponent(targetPartner);
                        targetPartnerInfo.setDirection(3);
                        break;
                    }
                    case 4: {
                        targetGrandparent.setRightComponent(targetPartner);
                        targetPartnerInfo.setDirection(4);
                    }
                }
            }
            catch (IllegalDirectionException e) {
                e.printStackTrace();
            }
        } else {
            throw new ComponentNotFoundException();
        }
        targetGrandparent.setDividerLocation(dividerLocation);
    }

    public boolean isEmpty() {
        return this.m_hash.isEmpty();
    }

    public boolean contains(JComponent c) {
        return this.m_hash.containsKey(c);
    }

    public int getParentDividerLocation(JComponent child) throws ComponentNotFoundException {
        if (this.contains(child)) {
            ComponentInfo ci = (ComponentInfo)this.m_hash.get(child);
            return ci.getParentPane().getDividerLocation();
        }
        throw new ComponentNotFoundException();
    }

    public void setParentDividerLocation(JComponent child, int dividerLocation) throws ComponentNotFoundException {
        if (!this.contains(child)) {
            throw new ComponentNotFoundException();
        }
        ComponentInfo ci = (ComponentInfo)this.m_hash.get(child);
        ci.getParentPane().setDividerLocation(dividerLocation);
    }

    protected void updateParentOf(WASplitPane child) {
        WASplitPane parent = child.getParentPane();
        if (parent == null) {
            this.m_panel.removeAll();
            this.m_panel.add((Component)child, "Center");
        } else {
            switch (child.getDirection()) {
                case 1: {
                    parent.setTopComponent(child);
                    break;
                }
                case 2: {
                    parent.setLeftComponent(child);
                    break;
                }
                case 3: {
                    parent.setBottomComponent(child);
                    break;
                }
                case 4: {
                    parent.setRightComponent(child);
                }
            }
        }
        this.m_panel.revalidate();
        this.m_panel.repaint();
    }

    protected class WASplitPane
    extends JSplitPane {
        private static final long serialVersionUID = 1L;
        protected static final double MIDDLE = 0.5;
        private WASplitPane m_parentPane;
        private int m_direction;
        boolean hasLocation;
        boolean isPainted;
        int dividerLocation;

        protected WASplitPane(int Orientation, JComponent first, JComponent second, WASplitPane parent, int direction) {
            super(Orientation, first, second);
            this.hasLocation = false;
            this.isPainted = false;
            this.dividerLocation = 0;
            this.setBorder(null);
            this.m_parentPane = parent;
            this.m_direction = direction;
        }

        protected WASplitPane getParentPane() {
            return this.m_parentPane;
        }

        protected void setParentPane(WASplitPane p) {
            this.m_parentPane = p;
        }

        protected int getDirection() {
            return this.m_direction;
        }

        protected void setDirection(int d) {
            this.m_direction = d;
        }

        @Override
        public int getDividerLocation() {
            int returnLocation = super.getDividerLocation();
            if (this.hasLocation) {
                return this.dividerLocation;
            }
            return returnLocation;
        }

        @Override
        public void setDividerLocation(int location) {
            int temp_location = location;
            if (!this.isPainted) {
                this.hasLocation = true;
                this.dividerLocation = temp_location;
            } else {
                this.hasLocation = false;
            }
            super.setDividerLocation(temp_location);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (!this.isPainted && this.hasLocation) {
                super.setDividerLocation(this.dividerLocation);
                this.hasLocation = false;
            }
            this.isPainted = true;
        }
    }

    protected class ComponentInfo {
        private JComponent m_component = null;
        private WASplitPane m_parentPane = null;
        private int m_direction = 0;

        protected ComponentInfo(JComponent c) {
            this.m_component = c;
        }

        protected JComponent getPartnerComponent() {
            Component c = null;
            switch (this.m_direction) {
                case 1: {
                    c = this.m_parentPane.getBottomComponent();
                    break;
                }
                case 2: {
                    c = this.m_parentPane.getRightComponent();
                    break;
                }
                case 3: {
                    c = this.m_parentPane.getTopComponent();
                    break;
                }
                case 4: {
                    c = this.m_parentPane.getLeftComponent();
                }
            }
            return (JComponent)c;
        }

        protected void setParentPane(WASplitPane p) {
            this.m_parentPane = p;
        }

        protected void setDirection(int d) throws IllegalDirectionException {
            if (d != 0 && d != 1 && d != 2 && d != 3 && d != 4) {
                throw new IllegalDirectionException();
            }
            this.m_direction = d;
        }

        protected JComponent getComponent() {
            return this.m_component;
        }

        protected WASplitPane getParentPane() {
            return this.m_parentPane;
        }

        protected int getDirection() {
            return this.m_direction;
        }
    }

    public class ManagerIsEmptyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        protected ManagerIsEmptyException() {
            super("manager is empty - unable to remove items from manager");
        }
    }

    public class ManagerNotEmptyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        protected ManagerNotEmptyException() {
            super("components not in SplitManager can only be added freely when the manager is empty");
        }
    }

    public class ComponentNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        protected ComponentNotFoundException() {
            super("unable to find component");
        }
    }

    public class IllegalDirectionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        protected IllegalDirectionException() {
            super("direction must be one of SplitManager.DIRECTION_UP, DIRECTION_LEFT, DIRECTION_DOWN, DIRECTION_RIGHT, or DIRECTION_NONE");
        }
    }

    public class IllegalAdditionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        protected IllegalAdditionException() {
            super("violation of restrictions on add");
        }
    }

    public class IllegalOrientationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        protected IllegalOrientationException() {
            super("orientation must be one of SplitManager.HORIZONTAL_SPLIT or SplitManager.VERTICAL_SPLIT");
        }
    }
}

