/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Key;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Role;
import com.sas.metadata.remote.Root;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SCDType2Utilities {
    protected static final String SCD2ROLE = "ETLS_SCD2Loader";
    private static WAdminResource bundle = WAdminResource.getBundle(SCDType2Utilities.class);
    public static final String SCD2_ROLE_CONTEXT = "ETLS_SCD2";
    public static final String SCD2_TABLE_ROLE = "SCD2_TABLE";
    public static final String SCD_KEY_PROPERTY = "SCD_KEY";
    public static final String GENERATEDKEYPROPERTYVALUE = "GENERATED_KEY";
    public static final String BUSINESSKEYPROPERTYVALUE = "BUSINESS_KEY";
    public static final String DIGEST_TRANSFORMROLE = "SCD2_DIGESTVARS";
    public static final String TODATE_TRANSFORMROLE = "SCD2_TODATE";
    public static final String FROMDATE_TRANSFORMROLE = "SCD2_FROMDATE";
    public static final String KEYEFFDT_TRANSFORMROLE = "SCD2_KEYEFFDATE";
    public static final String VERSION_TRANSFORMROLE = "SCD2_Version";
    public static final String CURRIND_TRANSFORMROLE = "SCD2_CurrentIndicator";
    public static final String NEWKEY_TRANSFORMROLE = "SCD2_NewSurrogateKey";
    public static final String CHGKEY_TRANSFORMROLE = "SCD2_ChangeSurrogateKey";
    public static final String MAXKEY_TRANSFORMROLE = "SCD2_MaxKeyGenerator";
    public static final String DEFAULT_FROM_DATE_NAME = "VALID_FROM_DTTM";
    public static final String DEFAULT_FROM_DATE_EXP = "DATETIME()";
    public static final String DEFAULT_TO_DATE_NAME = "VALID_TO_DTTM";
    public static final String DEFAULT_TO_DATE_EXP = "'01JAN5999:00:00:00'DT";
    public static final String DEFAULT_MAXKEY_EXP = "sum(NewMaxKey, 1)";
    public static final int TYPE_FROM_DATE = 0;
    public static final int TYPE_TO_DATE = 1;
    public static final int TYPE_VERSION = 2;
    public static final int TYPE_CURRENT_IND = 3;
    public static final int TYPE_DIGEST_VARS = 4;
    public static final int TYPE_MAX_KEY = 5;
    public static final int TYPE_GK_NEW_RCD = 6;
    public static final int TYPE_GK_CHG_RCD = 7;
    public static final int TYPE_KEYEFFDATE = 8;
    public static final int SCD2DATE = 0;
    public static final int SCD2VERSION = 1;
    public static final int SCD2CURRIND = 2;
    public static final String BUSINESSPROPERTY = "BUSINESS";
    public static final String BEGDATEPROPERTY = "BEGDATE";
    public static final String ENDDATEPROPERTY = "ENDDATE";
    public static final String CURRINDPROPERTY = "CURRIND";
    public static final String VERSIONPROPERTY = "VERSION";
    public static final String CHANGEMETHODPROPERTY = "CHANGEMETHOD";
    public static final String DATEVALUE = "DATE";
    public static final String DIGESTPROPERTY = "DIGEST";
    public static final String XREFPROPERTY = "XREF";
    public static final String LOADTMPROPERTY = "LOADTIME";
    public static final String GENERATEDPROPERTY = "GENERATED";
    public static final String KEYEFFDATEPROPERTY = "KEYEFFDATE";
    public static final String RETAINEDKEYPROPERTY = "RetainedKey";
    public static final String UNIQUERETAINEDKEYPROPERTY = "UniqueRetainedKey";
    public static final String SES_PROCESSED_DTTM = "PROCESSED_DTTM";
    public static final String WA_LOADTM = "_LOADTM";
    public static final String FACT_TRANSFORMROLE = "FACTTABLE";
    public static final String TRANSLATE_TRANSFORMROLE = "TRANSLATOR";
    public static final String ACTIONPROPERTY = "UNAVAILABLEACTION";
    public static final String ROLE_RETAINEDKEY = "SCD2_RETAINEDKEY";
    public static final String NODIGEST = "NODIGEST";

    public static DataTable findSCD2Table(ClassifierMap clsMap) throws MdException, RemoteException {
        DataTable oTable = null;
        AssociationList alClassifierTargets = clsMap.getClassifierTargets();
        int nTarget = alClassifierTargets.size();
        if (nTarget == 1) {
            oTable = (DataTable)alClassifierTargets.get(0);
        } else {
            for (int i = 0; i < nTarget; ++i) {
                oTable = (DataTable)alClassifierTargets.get(i);
                AssociationList alRoles = oTable.getRoles();
                for (int j = 0; j < alRoles.size(); ++j) {
                    Role oRole = (Role)alRoles.get(j);
                    if (!oRole.getContext().equalsIgnoreCase(SCD2_ROLE_CONTEXT) || !oRole.getObjectRole().equalsIgnoreCase(SCD2_TABLE_ROLE)) continue;
                    return oTable;
                }
            }
        }
        return oTable;
    }

    public static Key findLogicalKey(DataTable table, String propRole) throws MdException, RemoteException {
        Key key = null;
        AssociationList alCols = table.getColumns();
        for (int i = 0; i < alCols.size(); ++i) {
            Column col = (Column)alCols.get(i);
            AssociationList alKeys = col.getKeys();
            for (int j = 0; j < alKeys.size(); ++j) {
                PropertyHandler pros;
                String propValue;
                key = (Key)alKeys.get(j);
                if (!key.getCMetadataType().equalsIgnoreCase("Key") || !(propValue = (pros = new PropertyHandler((Root)key, SCD_KEY_PROPERTY, true)).getSpecificOptionValue(SCD_KEY_PROPERTY)).equalsIgnoreCase(propRole)) continue;
                return key;
            }
        }
        return null;
    }

    public static Column findMetadataColumnFromName(DataTable table, String colName) {
        try {
            AssociationList alCols = table.getColumns();
            Column column = null;
            for (int i = 0; i < alCols.size(); ++i) {
                column = (Column)alCols.get(i);
                if (!colName.equalsIgnoreCase(column.getSASColumnName()) && !colName.equalsIgnoreCase(column.getName())) continue;
                return column;
            }
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage(me, "Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        return null;
    }

    public static FeatureMap findFeatureMapByRole(ClassifierMap clsMap, String role) throws MdException, RemoteException {
        FeatureMap fM = null;
        AssociationList alFM = clsMap.getFeatureMaps();
        int nFM = alFM.size();
        for (int i = 0; i < nFM; ++i) {
            fM = (FeatureMap)alFM.get(i);
            if (!fM.getTransformRole().equalsIgnoreCase(role)) continue;
            return fM;
        }
        return null;
    }

    public static FeatureMap createSCD2FeatureMap(ClassifierMap clsMap, Column col, int type) throws MdException, RemoteException {
        MdObjectStore store = (MdObjectStore)clsMap.getObjectStore();
        String reposID = clsMap.getRepositoryID();
        String name = "";
        String desc = "";
        String role = "";
        switch (type) {
            case 0: {
                name = bundle.getString("SCDType2Utilities.FromDateFMName.txt");
                desc = bundle.getString("SCDType2Utilities.FromDateFMDesc.txt");
                role = FROMDATE_TRANSFORMROLE;
                break;
            }
            case 1: {
                name = bundle.getString("SCDType2Utilities.ToDateFMName.txt");
                desc = bundle.getString("SCDType2Utilities.ToDateFMDesc.txt");
                role = TODATE_TRANSFORMROLE;
                break;
            }
            case 2: {
                name = bundle.getString("SCDType2Utilities.VersFMName.txt");
                desc = bundle.getString("SCDType2Utilities.VersFMDesc.txt");
                role = VERSION_TRANSFORMROLE;
                break;
            }
            case 3: {
                name = bundle.getString("SCDType2Utilities.CurrIndFMName.txt");
                desc = bundle.getString("SCDType2Utilities.CurrIndFMDesc.txt");
                role = CURRIND_TRANSFORMROLE;
                break;
            }
            case 4: {
                name = bundle.getString("SCDType2Utilities.DigestFMName.txt");
                desc = bundle.getString("SCDType2Utilities.DigestFMDesc.txt");
                role = DIGEST_TRANSFORMROLE;
                break;
            }
            case 5: {
                name = bundle.getString("SCDType2Utilities.MaxKeyFMName.txt");
                desc = bundle.getString("SCDType2Utilities.MaxKeyFMDesc.txt");
                role = MAXKEY_TRANSFORMROLE;
                break;
            }
            case 6: {
                name = bundle.getString("SCDType2Utilities.NewKeyFMName.txt");
                desc = bundle.getString("SCDType2Utilities.NewKeyFMDesc.txt");
                role = NEWKEY_TRANSFORMROLE;
                break;
            }
            case 7: {
                name = bundle.getString("SCDType2Utilities.ChgKeyFMName.txt");
                desc = bundle.getString("SCDType2Utilities.ChgKeyFMDesc.txt");
                role = CHGKEY_TRANSFORMROLE;
                break;
            }
        }
        MdFactory factory = store.getFactory();
        FeatureMap oFM = (FeatureMap)factory.createComplexMetadataObject(store, name, "FeatureMap", reposID);
        oFM.setDesc(desc);
        oFM.setTransformRole(role);
        oFM.setIsUserDefined(1);
        if (col != null) {
            oFM.getFeatureTargets().add((Object)col);
        }
        clsMap.getFeatureMaps().addElement((Object)oFM);
        return oFM;
    }

    public static FeatureMap createKeyEffectiveDateFeatureMap(ClassifierMap clsMap, List keyColumns) throws MdException, RemoteException {
        MdObjectStore store = (MdObjectStore)clsMap.getObjectStore();
        String reposID = clsMap.getRepositoryID();
        MdFactory factory = store.getFactory();
        FeatureMap oFM = (FeatureMap)factory.createComplexMetadataObject(store, bundle.getString("SCDType2Utilities.KeyEffDateFMName.txt"), "FeatureMap", reposID);
        oFM.setDesc(bundle.getString("SCDType2Utilities.KeyEffDateFMDesc.txt"));
        oFM.setTransformRole(KEYEFFDT_TRANSFORMROLE);
        oFM.setIsUserDefined(1);
        oFM.getFeatureTargets().addAll((Collection)keyColumns);
        clsMap.getFeatureMaps().addElement((Object)oFM);
        return oFM;
    }

    public static int findSCD2MethodBeingRequested(ClassifierMap clsMap) throws MdException, RemoteException {
        int type = -1;
        AssociationList alFeatureMaps = clsMap.getFeatureMaps();
        for (int i = 0; i < alFeatureMaps.size(); ++i) {
            FeatureMap fM = (FeatureMap)alFeatureMaps.get(i);
            String role = fM.getTransformRole();
            if (role.compareToIgnoreCase("ONETOONE") == 0 || role.compareToIgnoreCase("DERIVED") == 0) continue;
            if (role.compareToIgnoreCase(FROMDATE_TRANSFORMROLE) == 0 || role.compareToIgnoreCase(TODATE_TRANSFORMROLE) == 0) {
                type = 0;
                break;
            }
            if (role.compareToIgnoreCase(VERSION_TRANSFORMROLE) == 0) {
                type = 1;
                break;
            }
            if (role.compareToIgnoreCase(CURRIND_TRANSFORMROLE) != 0) continue;
            type = 2;
            break;
        }
        return type;
    }

    public static String createDigestParameter(FeatureMap digestFeatureMap, List columns, DataTable table) throws MdException, RemoteException {
        StringBuffer digestList = new StringBuffer();
        boolean needsQuotes = DBMSNamesPropertyHandler.needQuotes(table);
        AssociationList alColumns = digestFeatureMap != null ? digestFeatureMap.getFeatureTargets() : table.getColumns();
        int maxLineLength = 60;
        int nSize = alColumns.size();
        for (int i = 0; i < nSize; ++i) {
            boolean isColumnSpecial;
            Column col = (Column)alColumns.get(i);
            String colName = col.getSASColumnName();
            if (needsQuotes) {
                colName = DBMSNamesUtil.getQuotedString(colName, false);
            }
            if (isColumnSpecial = SCDType2Utilities.isSelectedColumnSpecial(col, columns)) continue;
            if (digestList.length() + colName.length() + 16 > maxLineLength) {
                digestList.append("\n      ");
                maxLineLength += 60;
            }
            if (digestList.length() == 0) {
                digestList.append("TRIM(LEFT(").append(colName).append(")) ");
                continue;
            }
            digestList.append("|| TRIM(LEFT(").append(colName).append(")) ");
        }
        return digestList.toString();
    }

    public static String createKeyColumnListTableProperty(List alKeyColumns) {
        String colList = "";
        try {
            for (int i = 0; i < alKeyColumns.size(); ++i) {
                Column col = (Column)alKeyColumns.get(i);
                colList = i == 0 ? col.getSASColumnName() : colList + " " + col.getSASColumnName();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return colList;
    }

    public static boolean isSelectedColumnSpecial(Column col, List columns) {
        boolean isSpecial = false;
        try {
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                if (column.getFQID().compareToIgnoreCase(col.getFQID()) != 0) continue;
                isSpecial = true;
                break;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return isSpecial;
    }

    public static Column findLoadTimeColumn(List cols) {
        try {
            for (int i = 0; i < cols.size(); ++i) {
                Column col = (Column)cols.get(i);
                String colName = col.getSASColumnName();
                if (!colName.equalsIgnoreCase(SES_PROCESSED_DTTM) && !colName.equalsIgnoreCase(WA_LOADTM)) continue;
                return col;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return null;
    }

    public static List findSpecialColumnsList(ClassifierMap clsMap, DataTable table) throws MdException, RemoteException {
        Column loadCol;
        OptionsPropertyHandler OP;
        String option;
        String loadTime;
        AssociationList alCols;
        ArrayList<Object> specCols = new ArrayList<Object>();
        AssociationList alTblCols = table.getColumns();
        Key key = SCDType2Utilities.findLogicalKey(table, GENERATEDKEYPROPERTYVALUE);
        if (key != null && (alCols = key.getKeyedColumns()).size() > 0) {
            specCols.add(alCols.get(0));
        }
        if ((key = SCDType2Utilities.findLogicalKey(table, BUSINESSKEYPROPERTYVALUE)) != null) {
            alCols = key.getKeyedColumns();
            for (int i = 0; i < alCols.size(); ++i) {
                Object col = alCols.get(i);
                specCols.add(col);
            }
        }
        if ((loadTime = (option = (OP = new OptionsPropertyHandler((Root)clsMap)).getOptionsString("LoadTime")).substring(option.indexOf("=") + 1)).length() > 0) {
            loadCol = SCDType2Utilities.findMetadataColumnFromName(table, loadTime);
            if (loadCol != null) {
                specCols.add(loadCol);
            }
        } else {
            loadCol = SCDType2Utilities.findLoadTimeColumn((List)alTblCols);
            if (loadCol != null) {
                specCols.add(loadCol);
            }
        }
        int type = SCDType2Utilities.findSCD2MethodBeingRequested(clsMap);
        if (type == 0) {
            FeatureMap fM = SCDType2Utilities.findFeatureMapByRole(clsMap, FROMDATE_TRANSFORMROLE);
            if (fM != null && !fM.getFeatureTargets().isEmpty()) {
                specCols.add(fM.getFeatureTargets().get(0));
            }
            if ((fM = SCDType2Utilities.findFeatureMapByRole(clsMap, TODATE_TRANSFORMROLE)) != null && !fM.getFeatureTargets().isEmpty()) {
                specCols.add(fM.getFeatureTargets().get(0));
            }
        } else if (type == 2) {
            FeatureMap fM = SCDType2Utilities.findFeatureMapByRole(clsMap, CURRIND_TRANSFORMROLE);
            if (fM != null) {
                specCols.add(fM.getFeatureTargets().get(0));
            }
        } else {
            FeatureMap fM = SCDType2Utilities.findFeatureMapByRole(clsMap, VERSION_TRANSFORMROLE);
            if (fM != null) {
                specCols.add(fM.getFeatureTargets().get(0));
            }
        }
        return specCols;
    }

    public static void createDimensionXrefTableProperties(ClassifierMap clsMap) throws MdException, RemoteException {
        AssociationList alKeyCols;
        String colName;
        Column col;
        String role = clsMap.getTransformRole();
        if (!role.equalsIgnoreCase(SCD2ROLE)) {
            return;
        }
        DataTable table = SCDType2Utilities.findSCD2Table(clsMap);
        if (table == null) {
            return;
        }
        MdObjectStore store = (MdObjectStore)table.getObjectStore();
        String reposId = table.getRepositoryID();
        AssociationList alRoles = table.getRoles();
        boolean isFound = false;
        for (int j = 0; j < alRoles.size(); ++j) {
            Role tblrole = (Role)alRoles.get(j);
            if (!tblrole.getContext().equals(SCD2_ROLE_CONTEXT)) continue;
            isFound = true;
            break;
        }
        if (!isFound) {
            MdFactory factory = store.getFactory();
            Role oRole = (Role)factory.createComplexMetadataObject(store, bundle.getString("SCDType2Utilities.DimTableRole.Name.txt"), "Role", reposId);
            oRole.setContext(SCD2_ROLE_CONTEXT);
            oRole.setObjectRole(SCD2_TABLE_ROLE);
            table.getRoles().addElement((Object)oRole);
        }
        PropertyHandler prop = new PropertyHandler((Root)table, SCD2_ROLE_CONTEXT, true);
        OptionsPropertyHandler OP = new OptionsPropertyHandler((Root)clsMap);
        String option = OP.getOptionsString("XREFTABLE");
        String xRefName = option.substring(option.indexOf("=") + 1);
        int iTwoLevel = xRefName.indexOf(".");
        if (iTwoLevel > -1) {
            xRefName = xRefName.substring(iTwoLevel + 1);
        }
        prop.setSpecificProperty(XREFPROPERTY, xRefName);
        option = OP.getOptionsString("LoadTime");
        String strLoadTime = option.substring(option.indexOf("=") + 1);
        prop.setSpecificProperty(LOADTMPROPERTY, strLoadTime);
        int methodType = SCDType2Utilities.findSCD2MethodBeingRequested(clsMap);
        switch (methodType) {
            case 0: {
                FeatureMap toDate;
                prop.setSpecificProperty(CHANGEMETHODPROPERTY, DATEVALUE);
                FeatureMap fromDate = SCDType2Utilities.findFeatureMapByRole(clsMap, FROMDATE_TRANSFORMROLE);
                AssociationList alFeatureTargets = fromDate.getFeatureTargets();
                if (!alFeatureTargets.isEmpty()) {
                    col = (Column)alFeatureTargets.get(0);
                    colName = col.getSASColumnName();
                    prop.setSpecificProperty(BEGDATEPROPERTY, colName);
                }
                if ((alFeatureTargets = (toDate = SCDType2Utilities.findFeatureMapByRole(clsMap, TODATE_TRANSFORMROLE)).getFeatureTargets()).isEmpty()) break;
                Column col2 = (Column)alFeatureTargets.get(0);
                String colName2 = col2.getSASColumnName();
                prop.setSpecificProperty(ENDDATEPROPERTY, colName2);
                break;
            }
            case 2: {
                FeatureMap currInd = SCDType2Utilities.findFeatureMapByRole(clsMap, CURRIND_TRANSFORMROLE);
                AssociationList alFeatureTargets = currInd.getFeatureTargets();
                if (!alFeatureTargets.isEmpty()) {
                    col = (Column)alFeatureTargets.get(0);
                    colName = col.getSASColumnName();
                    prop.setSpecificProperty(CURRINDPROPERTY, colName);
                }
            }
            case 1: {
                AssociationList alFeatureTargets;
                FeatureMap version = SCDType2Utilities.findFeatureMapByRole(clsMap, VERSION_TRANSFORMROLE);
                if (version == null || (alFeatureTargets = version.getFeatureTargets()).isEmpty()) break;
                col = (Column)alFeatureTargets.get(0);
                colName = col.getSASColumnName();
                prop.setSpecificProperty(VERSIONPROPERTY, colName);
            }
        }
        Key key = SCDType2Utilities.findLogicalKey(table, BUSINESSKEYPROPERTYVALUE);
        if (key != null && !(alKeyCols = key.getKeyedColumns()).isEmpty()) {
            col = (Column)alKeyCols.get(0);
            colName = col.getSASColumnName();
            prop.setSpecificProperty(BUSINESSPROPERTY, colName);
        }
        if ((key = SCDType2Utilities.findLogicalKey(table, GENERATEDKEYPROPERTYVALUE)) != null) {
            PropertyHandler keyProp = new PropertyHandler((Root)key, ROLE_RETAINEDKEY, true);
            String strRetainedValue = keyProp.getSpecificOptionValue(RETAINEDKEYPROPERTY);
            prop.setSpecificProperty(RETAINEDKEYPROPERTY, strRetainedValue);
            AssociationList alKeyCols2 = key.getKeyedColumns();
            if (!alKeyCols2.isEmpty()) {
                Column col3 = (Column)alKeyCols2.get(0);
                String colName3 = col3.getSASColumnName();
                prop.setSpecificProperty(GENERATEDPROPERTY, colName3);
            }
        }
        FeatureMap digestFeatureMap = SCDType2Utilities.findFeatureMapByRole(clsMap, DIGEST_TRANSFORMROLE);
        List lSpecialColumns = SCDType2Utilities.findSpecialColumnsList(clsMap, table);
        String strDigestColumns = "";
        if (digestFeatureMap != null) {
            strDigestColumns = SCDType2Utilities.createDigestParameter(digestFeatureMap, lSpecialColumns, table);
        }
        prop.setSpecificProperty(DIGESTPROPERTY, strDigestColumns);
    }

    public static void removeSCDLogicalKeys(DataTable table, MdObjectStore store) throws MdException, RemoteException {
        String strTemplate = "<Key><PropertySets><SetProperties><OwningType/></SetProperties><Properties><OwningType/></Properties></PropertySets></Key>";
        Key key = SCDType2Utilities.findLogicalKey(table, BUSINESSKEYPROPERTYVALUE);
        if (key != null) {
            store.removeObjectFromStore((CMetadata)key, strTemplate);
        }
        if ((key = SCDType2Utilities.findLogicalKey(table, GENERATEDKEYPROPERTYVALUE)) != null) {
            store.removeObjectFromStore((CMetadata)key, strTemplate);
        }
    }

    public static boolean isFromDateColumnInList(List alColumns, Column column) {
        try {
            String colFQID = column.getFQID();
            for (int i = 0; i < alColumns.size(); ++i) {
                Column col = (Column)alColumns.get(i);
                if (!colFQID.equals(col.getFQID())) continue;
                return true;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return false;
    }

    public static List removeColumnFromColumnList(List columns, Column column) {
        ArrayList<Column> columnList = new ArrayList<Column>();
        try {
            int totalColumns = columns.size();
            for (int i = 0; i < totalColumns; ++i) {
                Column col = (Column)columns.get(i);
                if (col.getFQID().equals(column.getFQID())) continue;
                columnList.add(col);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return columnList;
    }

    public static List removeFromDateFromKeyColumnList(List keyColumns, Column fromDate) {
        ArrayList<Column> columnListNoFromDate = new ArrayList<Column>();
        try {
            int totalColumns = keyColumns.size();
            for (int i = 0; i < totalColumns; ++i) {
                Column col = (Column)keyColumns.get(i);
                if (col.getFQID().equals(fromDate.getFQID())) continue;
                columnListNoFromDate.add(col);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return columnListNoFromDate;
    }
}

