/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.workspace.IdentityUtil;
import com.sas.workspace.RepositoryInterface;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.Vector;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Repository
implements RepositoryInterface {
    public static final int OMS_UNDEF = -1;
    public static final int OMS_FULL = 0;
    public static final int OMS_READONLY = 1;
    public static final int OMS_ADMIN = 2;
    public static final int OMS_NONE = 4;
    protected String m_strName = null;
    protected String m_strFQID = null;
    protected String m_strDescription = null;
    protected String m_strEngine = "BASE";
    protected String m_strPath = null;
    protected String m_strOptions = null;
    protected boolean m_bAccess = false;
    protected int m_iAccess = 0;
    protected static MdFactory m_MdFactory = null;
    protected static final String m_strReposManager = "A0000001.A0000001";
    protected String m_strDefaultNamespace;
    protected String m_strMetadataCreated;
    protected String m_strMetadataUpdated;
    protected String m_strAuditType = null;
    protected String m_strAuditPath = null;
    protected String m_strAuditEngine = null;
    protected String m_strAuditOptions = null;
    protected String m_strPauseState;
    protected IOMI m_omiConnection;
    protected String m_strType = null;
    protected boolean b_replicating = false;
    protected boolean b_isCM = true;

    public Repository(IOMI omiConnection) {
        this.m_omiConnection = omiConnection;
        m_MdFactory = Workspace.getMdFactory();
        this.m_strFQID = m_strReposManager;
    }

    public Repository(MdFactory m_Factory) {
        m_MdFactory = m_Factory;
        try {
            this.m_omiConnection = m_MdFactory.getConnection().getCMRHandle();
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        this.m_strFQID = m_strReposManager;
    }

    @Override
    public String getName() {
        return this.m_strName;
    }

    @Override
    public void setName(String strName) {
        this.m_strName = strName;
    }

    @Override
    public String getFQID() {
        return this.m_strFQID;
    }

    @Override
    public void setFQID(String strFQID) {
        this.m_strFQID = strFQID;
    }

    public boolean getReplicating() {
        return this.b_replicating;
    }

    public void setReplicating(boolean repl) {
        this.b_replicating = repl;
    }

    @Override
    public String getDesc() {
        return this.m_strDescription;
    }

    @Override
    public void setDesc(String strDesc) {
        this.m_strDescription = strDesc;
    }

    public String getDefaultNamespace() {
        return this.m_strDefaultNamespace;
    }

    @Override
    public String getEngine() {
        return this.m_strEngine;
    }

    @Override
    public void setEngine(String strEngine) {
        this.m_strEngine = strEngine;
    }

    @Override
    public String getPath() {
        return this.m_strPath;
    }

    @Override
    public void setPath(String strPath) {
        this.m_strPath = strPath;
    }

    public String getPauseState() {
        return this.m_strPauseState;
    }

    public void setPauseState(String strPauseState) {
        this.m_strPauseState = strPauseState;
    }

    @Override
    public String getOptions() {
        return this.m_strOptions;
    }

    @Override
    public void setOptions(String strOptions) {
        this.m_strOptions = strOptions;
    }

    @Override
    public boolean getAccess() {
        return this.m_bAccess;
    }

    @Override
    public void setAccess(boolean bAccess) {
        this.m_bAccess = bAccess;
    }

    @Override
    public int getExtendedAccess() {
        return this.m_iAccess;
    }

    @Override
    public void setExtendedAccess(int iAccess) {
        this.m_iAccess = iAccess;
    }

    @Override
    public String getMetadataCreated() {
        return this.m_strMetadataCreated;
    }

    @Override
    public String getMetadataUpdated() {
        return this.m_strMetadataUpdated;
    }

    @Override
    public String getType() {
        return this.m_strType;
    }

    @Override
    public void setType(String type) {
        this.m_strType = type;
    }

    @Override
    public IOMI getOMIConnection() {
        return this.m_omiConnection;
    }

    @Override
    public boolean getIsChangeManaged() {
        return this.b_isCM;
    }

    @Override
    public void setIsChangeManaged(boolean isCM) {
        this.b_isCM = isCM;
    }

    public String getShortRepositoryID() {
        String shortId = this.getFQID();
        if (shortId != null) {
            return shortId.substring(9);
        }
        return null;
    }

    @Override
    public String getAuditType() {
        return this.m_strAuditType;
    }

    @Override
    public String getAuditPath() {
        return this.m_strAuditPath;
    }

    @Override
    public String getAuditEngine() {
        return this.m_strAuditEngine;
    }

    @Override
    public String getAuditOptions() {
        return this.m_strAuditOptions;
    }

    public static Repository[] getRepositories(IOMI omiConnection) throws Exception {
        Vector<Repository> returnValues = new Vector<Repository>();
        StringHolder outXML = new StringHolder();
        omiConnection.GetRepositories(outXML, 1, "");
        String outXMLString = outXML.value;
        if (m_MdFactory == null) {
            m_MdFactory = Workspace.getMdFactory();
        }
        Document mainDoc = null;
        mainDoc = m_MdFactory.getOMIUtil().parseXML(outXMLString);
        if (mainDoc != null) {
            Node firstNode = mainDoc.getFirstChild();
            NodeList nodeList = firstNode.getChildNodes();
            int cRepositories = nodeList.getLength();
            for (int index = 0; index < cRepositories; ++index) {
                NamedNodeMap childNodeMap = nodeList.item(index).getAttributes();
                String strName = childNodeMap.getNamedItem("Name").getNodeValue();
                String strFQID = childNodeMap.getNamedItem("Id").getNodeValue();
                if (strFQID.equals(m_strReposManager)) continue;
                String strDesc = childNodeMap.getNamedItem("Desc").getNodeValue();
                String strDefaultNamespace = childNodeMap.getNamedItem("DefaultNS").getNodeValue();
                String strState = childNodeMap.getNamedItem("PauseState").getNodeValue();
                Repository repository = new Repository(omiConnection);
                repository.m_strName = strName;
                repository.m_strFQID = strFQID;
                repository.m_strDescription = strDesc;
                repository.m_strDefaultNamespace = strDefaultNamespace;
                repository.m_strPauseState = strState;
                if (strState.equalsIgnoreCase("OFFLINE") || strState.equalsIgnoreCase("ADMIN") && !IdentityUtil.isAdministrator(m_MdFactory)) {
                    String strType;
                    String strAccess = childNodeMap.getNamedItem("Access").getNodeValue();
                    repository.m_strType = strType = childNodeMap.getNamedItem("RepositoryType").getNodeValue();
                    repository.m_iAccess = strAccess.equals("OMS_FULL") ? 0 : (strAccess.equals("OMS_READONLY") ? 1 : (strAccess.equals("OMS_ADMIN") ? 2 : 4));
                } else {
                    repository._getDetailedInfo();
                }
                returnValues.addElement(repository);
            }
        }
        return returnValues.toArray(new Repository[0]);
    }

    public static Repository[] getRepositories(MdFactory m_Factory) throws Exception {
        Vector<Repository> returnValues = new Vector<Repository>();
        StringHolder outXML = new StringHolder();
        IOMI omiConnection = m_Factory.getConnection().getCMRHandle();
        omiConnection.GetRepositories(outXML, 1, "");
        String outXMLString = outXML.value;
        Document mainDoc = null;
        mainDoc = m_Factory.getOMIUtil().parseXML(outXMLString);
        if (mainDoc != null) {
            Node firstNode = mainDoc.getFirstChild();
            NodeList nodeList = firstNode.getChildNodes();
            int cRepositories = nodeList.getLength();
            for (int index = 0; index < cRepositories; ++index) {
                NamedNodeMap childNodeMap = nodeList.item(index).getAttributes();
                String strName = childNodeMap.getNamedItem("Name").getNodeValue();
                String strFQID = childNodeMap.getNamedItem("Id").getNodeValue();
                if (strFQID.equals(m_strReposManager)) continue;
                String strDesc = childNodeMap.getNamedItem("Desc").getNodeValue();
                String strDefaultNamespace = childNodeMap.getNamedItem("DefaultNS").getNodeValue();
                String strState = childNodeMap.getNamedItem("PauseState").getNodeValue();
                Repository repository = new Repository(m_Factory);
                repository.m_strName = strName;
                repository.m_strFQID = strFQID;
                repository.m_strDescription = strDesc;
                repository.m_strDefaultNamespace = strDefaultNamespace;
                repository.m_strPauseState = strState;
                if (strState.equalsIgnoreCase("OFFLINE") || strState.equalsIgnoreCase("ADMIN") && !IdentityUtil.isAdministrator(m_MdFactory)) {
                    String strType;
                    String strAccess = childNodeMap.getNamedItem("Access").getNodeValue();
                    repository.m_strType = strType = childNodeMap.getNamedItem("RepositoryType").getNodeValue();
                    repository.m_iAccess = strAccess.equals("OMS_FULL") ? 0 : (strAccess.equals("OMS_READONLY") ? 1 : (strAccess.equals("OMS_ADMIN") ? 2 : 4));
                } else {
                    repository._getDetailedInfo();
                }
                returnValues.addElement(repository);
            }
        }
        return returnValues.toArray(new Repository[0]);
    }

    public void persist() throws Exception {
        boolean bNewRepository;
        String accessSetting = null;
        StringBuffer inXMLBuffer = new StringBuffer("<RepositoryBase ");
        boolean bl = bNewRepository = this.m_strFQID.equals(m_strReposManager) || this.b_replicating;
        if (this.m_strFQID != null) {
            inXMLBuffer.append(" ID=\"" + this.m_strFQID + "\"");
        }
        if (this.m_strName != null) {
            inXMLBuffer.append(" Name=\"" + this.m_strName + "\"");
        }
        if (this.m_strDescription != null) {
            inXMLBuffer.append(" Desc=\"" + this.m_strDescription + "\"");
        }
        if (bNewRepository && this.m_strType != null && this.m_strType.length() > 0) {
            inXMLBuffer.append(" RepositoryType=\"" + this.m_strType + "\"");
        }
        if (bNewRepository && this.m_strEngine != null) {
            inXMLBuffer.append(" Engine=\"" + this.m_strEngine + "\"");
        }
        if (bNewRepository && this.m_strPath != null && this.m_strPath.length() > 0) {
            inXMLBuffer.append(" Path=\"" + this.m_strPath + "\"");
        } else if (!this.b_replicating && !this.m_strEngine.equals("BASE")) {
            inXMLBuffer.append(" Path=\"\"");
        }
        if (!this.b_replicating && this.m_strOptions != null && this.m_strOptions.length() > 0) {
            inXMLBuffer.append(" Options=\"" + this.m_strOptions + "\"");
        } else if (!this.b_replicating) {
            inXMLBuffer.append(" Options=\"\"");
        }
        MdOMRConnection metaWorkspace = m_MdFactory.getConnection();
        if (metaWorkspace.getPlatformVersion() < 9200) {
            if (this.m_bAccess) {
                inXMLBuffer.append(" Access=\"1\"");
            } else {
                inXMLBuffer.append(" Access=\"0\"");
            }
        } else {
            switch (this.m_iAccess) {
                case 0: {
                    inXMLBuffer.append(" Access=\"0\"");
                    break;
                }
                case 1: {
                    if (bNewRepository) {
                        inXMLBuffer.append(" Access=\"2\"");
                        accessSetting = " Access=\"1\"";
                        break;
                    }
                    inXMLBuffer.append(" Access=\"1\"");
                    break;
                }
                case 2: {
                    inXMLBuffer.append(" Access=\"2\"");
                    break;
                }
                case 4: {
                    if (bNewRepository) {
                        inXMLBuffer.append(" Access=\"2\"");
                        accessSetting = " Access=\"4\"";
                        break;
                    }
                    inXMLBuffer.append(" Access=\"4\"");
                }
            }
        }
        inXMLBuffer.append("/>");
        StringHolder outXML = new StringHolder();
        String inXML = inXMLBuffer.toString();
        if (bNewRepository) {
            String reposId = m_strReposManager;
            int flags = this.b_replicating ? 0x10800000 : 0x10000000;
            this.m_omiConnection.AddMetadata(inXML, reposId, outXML, "REPOS", flags, "");
            String outXMLString = outXML.value;
            Document mainDoc = m_MdFactory.getOMIUtil().parseXML(outXMLString);
            if (mainDoc != null) {
                Node firstNode = mainDoc.getFirstChild();
                NamedNodeMap attrMap = firstNode.getAttributes();
                this.m_strFQID = attrMap.getNamedItem("ID").getNodeValue();
            }
            if (accessSetting != null) {
                StringBuffer followUpdateXMLBuffer = new StringBuffer("<RepositoryBase ");
                followUpdateXMLBuffer.append(" ID=\"" + this.m_strFQID + "\"" + accessSetting + "/>");
                String followUpdateXML = followUpdateXMLBuffer.toString();
                this.m_omiConnection.UpdateMetadata(followUpdateXML, outXML, "REPOS", 0x10000000, "");
            }
        } else {
            this.m_omiConnection.UpdateMetadata(inXML, outXML, "REPOS", 0x10000000, "");
        }
    }

    public void persist(boolean createDir) throws Exception {
        boolean bNewRepository;
        String accessSetting = null;
        StringBuffer inXMLBuffer = new StringBuffer("<RepositoryBase ");
        boolean bl = bNewRepository = this.m_strFQID.equals(m_strReposManager) || this.b_replicating;
        if (this.m_strFQID != null) {
            inXMLBuffer.append(" ID=\"" + this.m_strFQID + "\"");
        }
        if (this.m_strName != null) {
            inXMLBuffer.append(" Name=\"" + this.m_strName + "\"");
        }
        if (this.m_strDescription != null) {
            inXMLBuffer.append(" Desc=\"" + this.m_strDescription + "\"");
        }
        if (bNewRepository && this.m_strType != null && this.m_strType.length() > 0) {
            inXMLBuffer.append(" RepositoryType=\"" + this.m_strType + "\"");
        }
        if (bNewRepository && this.m_strEngine != null) {
            inXMLBuffer.append(" Engine=\"" + this.m_strEngine + "\"");
        }
        if (bNewRepository && this.m_strPath != null && this.m_strPath.length() > 0) {
            inXMLBuffer.append(" Path=\"" + this.m_strPath + "\"");
        } else if (!this.b_replicating && !this.m_strEngine.equals("BASE")) {
            inXMLBuffer.append(" Path=\"\"");
        }
        if (!this.b_replicating && this.m_strOptions != null && this.m_strOptions.length() > 0) {
            inXMLBuffer.append(" Options=\"" + this.m_strOptions + "\"");
        } else if (!this.b_replicating) {
            inXMLBuffer.append(" Options=\"\"");
        }
        MdOMRConnection metaWorkspace = m_MdFactory.getConnection();
        if (metaWorkspace.getPlatformVersion() < 9200) {
            if (this.m_bAccess) {
                inXMLBuffer.append(" Access=\"1\"");
            } else {
                inXMLBuffer.append(" Access=\"0\"");
            }
        } else {
            switch (this.m_iAccess) {
                case 0: {
                    inXMLBuffer.append(" Access=\"0\"");
                    break;
                }
                case 1: {
                    if (bNewRepository) {
                        inXMLBuffer.append(" Access=\"2\"");
                        accessSetting = " Access=\"1\"";
                        break;
                    }
                    inXMLBuffer.append(" Access=\"1\"");
                    break;
                }
                case 2: {
                    inXMLBuffer.append(" Access=\"2\"");
                    break;
                }
                case 4: {
                    if (bNewRepository) {
                        inXMLBuffer.append(" Access=\"2\"");
                        accessSetting = " Access=\"4\"";
                        break;
                    }
                    inXMLBuffer.append(" Access=\"4\"");
                }
            }
        }
        inXMLBuffer.append("/>");
        StringHolder outXML = new StringHolder();
        String inXML = inXMLBuffer.toString();
        if (bNewRepository) {
            int flags;
            String reposId = m_strReposManager;
            int n = flags = this.b_replicating ? 0x10800000 : 0x10000000;
            if (createDir) {
                this.m_omiConnection.AddMetadata(inXML, reposId, outXML, "REPOS", flags, "<CreateReposContainer/>");
            } else {
                this.m_omiConnection.AddMetadata(inXML, reposId, outXML, "REPOS", flags, "");
            }
            String outXMLString = outXML.value;
            Document mainDoc = m_MdFactory.getOMIUtil().parseXML(outXMLString);
            if (mainDoc != null) {
                Node firstNode = mainDoc.getFirstChild();
                NamedNodeMap attrMap = firstNode.getAttributes();
                this.m_strFQID = attrMap.getNamedItem("ID").getNodeValue();
            }
            if (accessSetting != null) {
                StringBuffer followUpdateXMLBuffer = new StringBuffer("<RepositoryBase ");
                followUpdateXMLBuffer.append(" ID=\"" + this.m_strFQID + "\"" + accessSetting + "/>");
                String followUpdateXML = followUpdateXMLBuffer.toString();
                this.m_omiConnection.UpdateMetadata(followUpdateXML, outXML, "REPOS", 0x10000000, "");
            }
        } else {
            this.m_omiConnection.UpdateMetadata(inXML, outXML, "REPOS", 0x10000000, "");
        }
    }

    public int deleteRepository(String reposName, String reposID, int flag) throws Exception {
        int rc = 0;
        StringHolder outXML = new StringHolder();
        String inXML = "";
        inXML = "<RepositoryBase ID=\"" + reposID + "\"></RepositoryBase>";
        int flags = flag + 0x10000000;
        rc = this.m_omiConnection.DeleteMetadata(inXML, outXML, "REPOS", flags, "");
        return rc;
    }

    public boolean isEmpty() {
        StringHolder outXML = new StringHolder();
        try {
            this.m_omiConnection.GetMetadataObjects(this.getFQID(), "Root", outXML, "SAS", 16, "");
            String outXMLString = outXML.value;
            if (outXMLString.equalsIgnoreCase("<Objects/>")) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    protected void _getDetailedInfo() throws Exception {
        StringHolder outXML = new StringHolder();
        String inXML = "";
        inXML = "<RepositoryBase ID=\"" + this.m_strFQID + "\"></RepositoryBase>";
        this.m_omiConnection.GetMetadata(inXML, outXML, "REPOS", 0x4000001, "");
        String outXMLString = outXML.value;
        Document mainDoc = m_MdFactory.getOMIUtil().parseXML(outXMLString);
        if (mainDoc != null) {
            int iAccess;
            boolean bAccess;
            Node AuditOptionsNode;
            Node AuditEngineNode;
            Node AuditPathNode;
            Node AuditTypeNode;
            Node firstNode = mainDoc.getFirstChild();
            String strType = null;
            String strAuditType = null;
            String strAuditPath = null;
            String strAuditEngine = null;
            String strAuditOptions = null;
            NamedNodeMap childNodeMap = firstNode.getAttributes();
            String strEngine = childNodeMap.getNamedItem("Engine").getNodeValue();
            String strPath = childNodeMap.getNamedItem("Path").getNodeValue();
            String strOptions = childNodeMap.getNamedItem("Options").getNodeValue();
            String strAccess = childNodeMap.getNamedItem("Access").getNodeValue();
            String strMetadataCreated = childNodeMap.getNamedItem("MetadataCreated").getNodeValue();
            String strMetadataUpdated = childNodeMap.getNamedItem("MetadataUpdated").getNodeValue();
            Node typeNode = childNodeMap.getNamedItem("RepositoryType");
            if (typeNode != null) {
                strType = typeNode.getNodeValue();
            }
            if ((AuditTypeNode = childNodeMap.getNamedItem("AuditType")) != null) {
                strAuditType = AuditTypeNode.getNodeValue();
            }
            if ((AuditPathNode = childNodeMap.getNamedItem("AuditPath")) != null) {
                strAuditPath = AuditPathNode.getNodeValue();
            }
            if ((AuditEngineNode = childNodeMap.getNamedItem("AuditEngine")) != null) {
                strAuditEngine = AuditEngineNode.getNodeValue();
            }
            if ((AuditOptionsNode = childNodeMap.getNamedItem("AuditOptions")) != null) {
                strAuditOptions = AuditOptionsNode.getNodeValue();
            }
            MdOMRConnection metaWorkspace = m_MdFactory.getConnection();
            if (metaWorkspace.getPlatformVersion() < 9200) {
                bAccess = !strAccess.equals("0");
                iAccess = strAccess.equals("0") ? 0 : 1;
            } else {
                bAccess = strAccess.equals("1");
                iAccess = strAccess.equals("0") ? 0 : (strAccess.equals("1") ? 1 : (strAccess.equals("2") ? 2 : 4));
            }
            this.m_strEngine = strEngine;
            this.m_strPath = strPath;
            this.m_strOptions = strOptions;
            this.m_bAccess = bAccess;
            this.m_iAccess = iAccess;
            this.m_strMetadataCreated = strMetadataCreated;
            this.m_strMetadataUpdated = strMetadataUpdated;
            if (strType != null) {
                this.m_strType = strType;
            }
            this.m_strAuditType = strAuditType;
            this.m_strAuditPath = strAuditPath;
            this.m_strAuditEngine = strAuditEngine;
            this.m_strAuditOptions = strAuditOptions;
        }
    }

    public static boolean isRepositoryOffline(String reposId, Repository[] repositories) throws Exception {
        if (repositories == null) {
            return true;
        }
        for (int i = 0; i < repositories.length; ++i) {
            Repository repos = repositories[i];
            if (!reposId.equalsIgnoreCase(repos.getFQID()) || repos.getExtendedAccess() != 4) continue;
            return true;
        }
        return false;
    }

    public static boolean isRepositoryOffline(MdFactory m_Factory, String reposId) throws Exception {
        Repository[] repositories = Repository.getRepositories(m_Factory);
        if (repositories == null) {
            return true;
        }
        for (int i = 0; i < repositories.length; ++i) {
            Repository repos = repositories[i];
            if (!reposId.equalsIgnoreCase(repos.getFQID()) || repos.getExtendedAccess() != 4) continue;
            return true;
        }
        return false;
    }
}

