/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.editor.LogListViewer;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.impl.WorkTableImpl;
import com.sas.rio.MVAResultSet;
import com.sas.services.ServiceException;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.ParametersInterface;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.ServerSupport;
import com.sas.workspace.UpdateTableRunnable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.metadata.WsMetadataUtil;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;

public class PhysicalTableUtil {
    private static final WAdminResource bundle = WAdminResource.getBundle(PhysicalTableUtil.class);
    private static final String ENCRYPTED_NAME = "Encrypted";
    private static final String ENCRTYPED_PROPERTY_NAME = "encrypt";
    private static final String COMPRESS_NAME = "Compressed";
    private static final String COMPRESS_PROPERTY_NAME = "compress";
    public static final String COMPRESS_NO = "NO";
    public static final String COMPRESS_YES = "CHAR";
    public static final String COMPRESS_BINARY = "BINARY";
    public static final String COMPRESS_TEMPLATE_YES = "YES";
    public static final String COMPRESS_TEMPLATE_BINARY = "Binary";
    public static final String ENCRYPT_YES = "YES";
    public static final String ENCRYPT_NO = "NO";
    public static final Pattern ALTER_PASSWORD_PATTERN = Pattern.compile("(?i)\\b(password|pw|alter)\\s*=\\s*(\\\"[^\\\"]*\\\"|[^\\s*]*)");
    public static final Pattern WRITE_PASSWORD_PATTERN = Pattern.compile("(?i)\\b(password|pw|write)\\s*=\\s*(\\\"[^\\\"]*\\\"|[^\\s*]*)");
    public static final Pattern READ_PASSWORD_PATTERN = Pattern.compile("(?i)\\b(password|pw|read|obs)\\s*=\\s*(\\\"[^\\\"]*\\\"|[^\\s*]*)");

    public static String parsePasswordOption(String sTableOptions, Pattern passwordType) {
        Matcher oMatcher = passwordType.matcher(sTableOptions);
        return oMatcher.find() ? oMatcher.group(0) : "";
    }

    public static void setAttributeOptions(PhysicalTable table, boolean encrypted, String compressed) throws RemoteException, MdException {
        Property prop;
        PropertyHandler handler = new PropertyHandler((Root)table, false);
        if (encrypted) {
            handler.setSpecificProperty(ENCRYPTED_NAME, ENCRTYPED_PROPERTY_NAME, "YES", "", "=", 0, null, 12);
        } else {
            prop = handler.getSpecificProperty(ENCRTYPED_PROPERTY_NAME);
            if (prop != null) {
                prop.delete();
            }
        }
        if (!"NO".equals(compressed)) {
            if (COMPRESS_YES.equals(compressed)) {
                handler.setSpecificProperty(COMPRESS_NAME, COMPRESS_PROPERTY_NAME, "YES", "", "=", 0, null, 12);
            } else if (COMPRESS_BINARY.equals(compressed)) {
                handler.setSpecificProperty(COMPRESS_NAME, COMPRESS_PROPERTY_NAME, COMPRESS_TEMPLATE_BINARY, "", "=", 0, null, 12);
            }
        } else {
            prop = handler.getSpecificProperty(COMPRESS_PROPERTY_NAME);
            if (prop != null) {
                prop.delete();
            }
        }
    }

    public static String getReadTableOptions(PhysicalTable table) throws RemoteException, MdException {
        PropertyHandler handler = new PropertyHandler((Root)table, false);
        return handler.getOptionsString("INPUT");
    }

    public static boolean updateTableMetadata(ParametersInterface parametersModel, Map tablesModified, LogListViewer sasLog, WsAppServer defaultServer, CMetadata[] tableArray) {
        return PhysicalTableUtil.updateTableMetadata(parametersModel, tablesModified, sasLog, defaultServer, tableArray, null);
    }

    public static boolean updateTableMetadata(ParametersInterface parametersModel, Map tablesModified, LogListViewer sasLog, WsAppServer defaultServer, CMetadata[] tableArray, CMetadata workLibrary) {
        if (defaultServer == null) {
            MessageUtil.displayMessage(bundle.getString("PhysicalTableUtil.NoAppserverError.txt"), bundle.getString("PhysicalTableUtil.NoAppserverError.title.txt"), 0);
            return false;
        }
        int val = MessageUtil.displayMessage(bundle.getString("PhysicalTableUtil.Resync.message.txt"), 2, 0);
        if (val == 0) {
            try {
                defaultServer.open();
            }
            catch (WsAppServerFailException ex) {
                MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
                return false;
            }
            HashMap<String, PasswordAuthentication> libraryLibnames = new HashMap<String, PasswordAuthentication>();
            try {
                for (int i = 0; i < tableArray.length; ++i) {
                    SASLibrary library;
                    if (!(tableArray[i] instanceof PhysicalTable) || (library = LibraryUtil.getLibrary((DataTable)((PhysicalTable)tableArray[i]), defaultServer.getServerContext())) == null) continue;
                    libraryLibnames.put(library.getFQID(), LibraryUtil.isCredentialPromptRequired(library) ? LibraryUtil.getPromptedCredentialsLibraryUserPass(library) : null);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
                return false;
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage(ex, "Accessing");
                return false;
            }
            OpRequestUI request = new OpRequestUI(Workspace.getWorkspace(), bundle.getString("PhysicalTableUtil.ProgressIndicator.Message.txt"), bundle.getString("PhysicalTableUtil.ProgressIndicator.Title.txt"));
            JLabel messageLabel = new JLabel("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            request.setMessagePreferredSize(messageLabel.getPreferredSize());
            request.setDelayBeforeProgressCancelDialog(200);
            request.setProgressShownOnStatusBar(true);
            UpdateTableRunnable updater = new UpdateTableRunnable(defaultServer, sasLog, parametersModel, tableArray, tablesModified, request, libraryLibnames, workLibrary);
            request.execute(updater);
            return updater.getUpdateStatus();
        }
        return false;
    }

    static Map updateMetadata(ParametersInterface parametersModel, String macroOptionCode, Map tablesModified, LogListViewer sasLog, WsAppServer defaultServer, SASLibrary library, PhysicalTable table, Map<String, PasswordAuthentication> libraryMap) throws MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException {
        return PhysicalTableUtil.updateMetadata(parametersModel, macroOptionCode, tablesModified, sasLog, defaultServer, library, table, libraryMap, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Map updateMetadata(ParametersInterface parametersModel, String macroOptionCode, Map tablesModified, LogListViewer sasLog, WsAppServer defaultServer, SASLibrary library, PhysicalTable table, Map<String, PasswordAuthentication> libraryMap, CMetadata workLibrary) throws MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException {
        Object iSupport;
        ServerContext submitServer;
        StringBuffer sascode = new StringBuffer();
        ServerContext libServer = submitServer = defaultServer.getServerContext();
        if (library != null) {
            libServer = LibraryUtil.getServer(library, submitServer);
        }
        PasswordAuthentication pw = null;
        if (library != null && libraryMap.get(library.getFQID()) != null) {
            pw = libraryMap.get(library.getFQID());
        }
        if (!ServerSupport.isEqual(libServer.getFQID(), submitServer.getFQID())) {
            iSupport = new ServerSupport(libServer, submitServer);
            sascode.append(((ServerSupport)iSupport).access());
            sascode.append(((ServerSupport)iSupport).startSubmit());
            sascode.append(PhysicalTableUtil.getMetaLibCode(parametersModel, library, table, pw, workLibrary).toString());
            sascode.append(((ServerSupport)iSupport).endSubmit());
        } else {
            sascode.append(PhysicalTableUtil.getMetaLibCode(parametersModel, library, table, pw, workLibrary));
        }
        try {
            MVAResultSet tableInfo;
            block15: {
                block14: {
                    defaultServer.submitSASCode(sascode.toString());
                    tablesModified.put(table.getFQID(), table.getCMetadataType());
                    if (Workspace.useProcMetalibChanges()) break block14;
                    iSupport = tablesModified;
                    sasLog.append(defaultServer.getLog());
                    sasLog.append(defaultServer.getOutput());
                    return iSupport;
                }
                tableInfo = defaultServer.getTable("WORK", "tab_info", null, null, null);
                if (tableInfo != null) break block15;
                Map map = tablesModified;
                sasLog.append(defaultServer.getLog());
                sasLog.append(defaultServer.getOutput());
                return map;
            }
            try {
                while (tableInfo.next()) {
                    String tabName = tableInfo.getString(1).trim();
                    String tabFQID = tableInfo.getString(2).trim();
                    String tabSASName = tableInfo.getString(3).trim();
                    MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "PhysicalTableUtil.updateMetadata");
                    if (!table.getCMetadataType().equalsIgnoreCase("WorkTable")) {
                        PhysicalTable pt = (PhysicalTable)Workspace.getMdFactory().createComplexMetadataObject(store, tabName, "PhysicalTable", tabFQID);
                        WsMetadataUtil.updateModifiedByFor((Root)pt);
                        pt.updateMetadataAll();
                    }
                    store.dispose();
                }
                tableInfo.close();
                return tablesModified;
            }
            catch (SQLException e) {
                Workspace.getDefaultLogger().debug((Object)"SQLException", e);
                return tablesModified;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            sasLog.append(defaultServer.getLog());
            sasLog.append(defaultServer.getOutput());
        }
    }

    public static StringBuffer getMetaLibCode(ParametersInterface parametersModel, SASLibrary library, PhysicalTable pTable) {
        return PhysicalTableUtil.getMetaLibCode(parametersModel, library, pTable, null);
    }

    public static StringBuffer getMetaLibCode(ParametersInterface parametersModel, SASLibrary library, PhysicalTable pTable, PasswordAuthentication pw) {
        return PhysicalTableUtil.getMetaLibCode(parametersModel, library, pTable, pw, null);
    }

    public static StringBuffer getMetaLibCode(ParametersInterface parametersModel, SASLibrary library, PhysicalTable pTable, PasswordAuthentication pw, CMetadata workLibrary) {
        if (!Workspace.useProcMetalibChanges()) {
            return PhysicalTableUtil.getMetaLibCode94M5(parametersModel, library, pTable, pw);
        }
        try {
            String readStr;
            String libraryid;
            StringBuffer code = new StringBuffer();
            StringBuffer buffer = null;
            String repid = pTable.getFQID();
            String libid = "";
            String librepid = "";
            if (library != null) {
                libraryid = library.getFQID();
                libid = libraryid.substring(libraryid.indexOf(".") + 1);
                librepid = libraryid.substring(0, libraryid.indexOf("."));
                if (library.getEngine().equalsIgnoreCase("CAS")) {
                    code.append(LibraryUtil.getAccessPath(library, true));
                }
            }
            if (workLibrary != null) {
                libraryid = workLibrary.getFQID();
                libid = libraryid.substring(libraryid.indexOf(".") + 1);
                librepid = libraryid.substring(0, libraryid.indexOf("."));
            }
            boolean isProjectTable = WsMetadataUtil.isProjectObject((CMetadata)pTable);
            boolean bUseMetalibEnhancements = Workspace.useProcMetalibChanges();
            repid = repid.substring(0, repid.indexOf("."));
            if (parametersModel != null) {
                parametersModel.setMetadata((Root)pTable);
                try {
                    buffer = parametersModel.getParameterMacroCode();
                }
                catch (MdException e) {
                    buffer = null;
                }
            }
            if (DBMSNamesUtil.isTableQuoted((DataTable)pTable)) {
                code.append("options VALIDVARNAME=ANY VALIDMEMNAME=EXTEND;\n");
            }
            if (buffer != null) {
                code.append(buffer);
            }
            code.append("\n");
            code.append("proc metalib");
            if (Workspace.isDebug()) {
                code.append(" tl=16383");
            }
            code.append(";\n");
            code.append("\n");
            code.append("   omr (libid=\"");
            code.append(libid);
            code.append("\"");
            code.append("      repid=\"");
            code.append(librepid);
            code.append("\"");
            String userName = Workspace.getWorkspace().getConnectionManager().getUser();
            String userPass = Workspace.getWorkspace().getConnectionManager().getPassword();
            if (userName != null && userPass != null && !userName.isEmpty() && !userPass.isEmpty()) {
                code.append("\n   user=\"").append(userName).append("\" password=\"").append(userPass).append("\"\n");
            }
            if (pTable instanceof WorkTableImpl && bUseMetalibEnhancements || isProjectTable && bUseMetalibEnhancements) {
                code.append(" / ");
            }
            if (isProjectTable && bUseMetalibEnhancements) {
                code.append("project_reposid = \"").append(repid).append("\"");
            }
            if (pTable instanceof WorkTableImpl && bUseMetalibEnhancements) {
                code.append(" worktables=yes");
            }
            code.append(");\n");
            if (bUseMetalibEnhancements) {
                code.append("   report(type = summary out = \"tab_info\");\n");
            } else {
                code.append("   report(type = summary);\n");
            }
            code.append("   update_rule = (noadd);\n");
            boolean isCredentialPromptRequired = false;
            if (library != null) {
                isCredentialPromptRequired = LibraryUtil.requiresPromptForCrendentials(library);
            } else if (workLibrary != null) {
                isCredentialPromptRequired = LibraryUtil.requiresPromptForCrendentials((SASLibrary)workLibrary);
            }
            if (pw != null && isCredentialPromptRequired) {
                code.append("   dbauth(dbuser=\"").append(pw.getUserName()).append("\"\n").append("          dbpassword=\"").append(pw.getPassword()).append("\");\n");
            }
            code.append("   select (");
            code.append(pTable.getFQID());
            String options = PhysicalTableUtil.getReadTableOptions(pTable);
            if (options != null && options.length() > 0 && (readStr = PhysicalTableUtil.parsePasswordOption(options, READ_PASSWORD_PATTERN)) != null && readStr.length() > 0) {
                code.append(" ").append(readStr);
            }
            code.append(");\n");
            code.append("\n");
            code.append("run;\n");
            return code;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return null;
        }
        catch (ServiceException ex) {
            Workspace.handleServiceException(ex);
            return null;
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage(ex, "Accessing");
            return null;
        }
    }

    public static StringBuffer getMetaLibCode94M5(ParametersInterface parametersModel, SASLibrary library, PhysicalTable pTable, PasswordAuthentication pw) {
        try {
            String readStr;
            StringBuffer code = new StringBuffer();
            StringBuffer buffer = null;
            String repid = pTable.getFQID();
            String libid = "";
            String librepid = "";
            if (library != null && !(pTable instanceof WorkTableImpl)) {
                String libraryid = library.getFQID();
                libid = libraryid.substring(libraryid.indexOf(".") + 1);
                librepid = libraryid.substring(0, libraryid.indexOf("."));
            }
            repid = repid.substring(0, repid.indexOf("."));
            if (parametersModel != null) {
                parametersModel.setMetadata((Root)pTable);
                try {
                    buffer = parametersModel.getParameterMacroCode();
                }
                catch (MdException e) {
                    buffer = null;
                }
            }
            if (DBMSNamesUtil.isTableQuoted((DataTable)pTable)) {
                code.append("options VALIDVARNAME=ANY VALIDMEMNAME=EXTEND;\n");
            }
            if (buffer != null) {
                code.append(buffer);
            }
            code.append("\n");
            code.append("proc metalib");
            if (Workspace.isDebug()) {
                code.append(" tl=16383");
            }
            code.append(";\n");
            code.append("\n");
            code.append("   omr (libid=\"");
            code.append(libid);
            code.append("\"");
            code.append("      repid=\"");
            code.append(librepid);
            code.append("\");\n");
            code.append("   report(type = summary);\n");
            code.append("   update_rule = (noadd);\n");
            if (pw != null) {
                code.append("   dbauth(dbuser=\"").append(pw.getUserName()).append("\"\n").append("          dbpassword=\"'").append(pw.getPassword()).append("'\");\n");
            }
            code.append("   select (");
            code.append(pTable.getFQID());
            String options = PhysicalTableUtil.getReadTableOptions(pTable);
            if (options != null && options.length() > 0 && (readStr = PhysicalTableUtil.parsePasswordOption(options, READ_PASSWORD_PATTERN)) != null && readStr.length() > 0) {
                code.append(" ").append(readStr);
            }
            code.append(");\n");
            code.append("\n");
            code.append("run;\n");
            return code;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return null;
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage(ex, "Accessing");
            return null;
        }
    }
}

