/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;

public class DBMSNamesUtil {
    private static WAdminResource bundle = WAdminResource.getBundle(DBMSNamesUtil.class);

    private DBMSNamesUtil() {
    }

    public static String getTableNamePart(String librefTable) {
        int index = librefTable.indexOf(46);
        if (index < 0) {
            return librefTable;
        }
        return librefTable.substring(index + 1);
    }

    public static String getLibrefPart(String librefTable) {
        int index = librefTable.indexOf(46);
        if (index < 0) {
            return "";
        }
        return librefTable.substring(0, index);
    }

    public static String getQuotedString(String value, DataTable table, boolean passthru) throws MdException, RemoteException {
        if (DBMSNamesUtil.isTableQuoted(table)) {
            return DBMSNamesUtil.getQuotedString(value, passthru);
        }
        return value;
    }

    public static String getQuotedColumnName(Column column, boolean quoted, boolean passthru) throws MdException, RemoteException {
        return DBMSNamesUtil.getQuotedColumnName(column, column.getTable(), quoted, passthru);
    }

    public static String getQuotedColumnName(Column column, DataTable table, boolean quoted, boolean passthru) throws MdException, RemoteException {
        return DBMSNamesUtil.getQuotedName(column.getSASColumnName(), table, quoted, passthru);
    }

    public static String getQuotedTableName(PhysicalTable table, boolean quoted, boolean passthru) throws MdException, RemoteException {
        return DBMSNamesUtil.getQuotedName(table.getSASTableName(), (DataTable)table, quoted, passthru);
    }

    public static String getQuotedIndexName(Index index, boolean quoted, boolean passthru) throws MdException, RemoteException {
        return DBMSNamesUtil.getQuotedName(index.getName(), (DataTable)index.getOwningPhysicalTable(), quoted, passthru);
    }

    public static String getQuotedName(String name, DataTable table, boolean quoted, boolean passthru) throws MdException, RemoteException {
        String text = name;
        if (passthru && quoted) {
            text = DBMSNamesUtil.getQuotedString(text, table, passthru);
        } else if (quoted) {
            text = DBMSNamesUtil.getQuotedString(text, passthru);
        }
        return text;
    }

    public static String getQuotedName(String name, boolean tableQuoted, boolean quoted, boolean passthru) throws MdException, RemoteException {
        String text = name;
        if (passthru && tableQuoted && quoted) {
            text = DBMSNamesUtil.getQuotedString(text, passthru);
        } else if (!passthru && quoted) {
            text = DBMSNamesUtil.getQuotedString(text, passthru);
        }
        return text;
    }

    public static boolean isTableQuoted(DataTable table) throws MdException, RemoteException {
        String specChar = DBMSNamesPropertyHandler.getSpecCharPropertyValue((Root)table);
        String preserveCase = DBMSNamesPropertyHandler.getCasePropertyValue((Root)table);
        return specChar.compareToIgnoreCase("Y") == 0 || preserveCase.compareToIgnoreCase("Y") == 0;
    }

    public static String getQuotedString(String value, DataTable table) throws MdException, RemoteException {
        return DBMSNamesUtil.getQuotedString(value, table, false);
    }

    public static String getQuotedString(String value, PhysicalTable table) throws MdException, RemoteException {
        return DBMSNamesUtil.getQuotedString(value, (DataTable)table, false);
    }

    public static String getQuotedString(String value) throws MdException, RemoteException {
        if (value == null || value.length() <= 0) {
            return "";
        }
        String quote = "\"";
        if (value.indexOf("\"") > -1 || value.substring(value.length() - 1).equals("%")) {
            if (value.indexOf("'") == -1) {
                quote = "'";
            } else {
                throw new MdException(bundle.getString("DBMSNamesUtil.InvalidTableName.txt"));
            }
        }
        value = quote + value.trim() + quote;
        return value;
    }

    public static String getQuotedString(String value, boolean passthru) throws MdException, RemoteException {
        if (value == null || value.length() <= 0) {
            return "";
        }
        if (!passthru) {
            value = DBMSNamesUtil.getQuotedString(value) + "n";
        } else {
            String quote = "\"";
            value = quote + value.trim() + quote;
        }
        return value;
    }
}

