/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.CustomDesktopUI;
import com.sas.workspace.WAStandardInternalFrame;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;

public class CustomDesktop
extends JDesktopPane {
    private static final long serialVersionUID = 1L;
    protected static final int m_cascadeXoffset = 20;
    protected static final int m_cascadeYoffset = 20;
    protected static int m_nextFrameX = 0;
    protected static int m_nextFrameY = 0;

    public CustomDesktop() {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    @Override
    public String getUIClassID() {
        String sUIClassID = "CustomDesktopUI";
        if (!UIManager.getDefaults().containsKey(sUIClassID)) {
            UIManager.put(sUIClassID, CustomDesktopUI.class.getName());
        }
        return sUIClassID;
    }

    public void activateFrame(JInternalFrame frm) {
        try {
            if (frm.isIcon()) {
                frm.setIcon(false);
            } else {
                frm.setSelected(true);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public int getCascadeXOffset() {
        return 20;
    }

    public int getCascadeYOffset() {
        return 20;
    }

    public void addCascaded(Component component) {
        this.add(component);
        Dimension szComponent = component.getSize();
        Dimension szDesktop = this.getSize();
        if (m_nextFrameX + szComponent.width > szDesktop.width || m_nextFrameY + szComponent.height > szDesktop.height) {
            m_nextFrameX = 0;
            m_nextFrameY = 0;
        }
        component.setLocation(m_nextFrameX, m_nextFrameY);
        m_nextFrameX += 20;
        m_nextFrameY += 20;
    }

    public void tileHorizontal() {
        int nFrames = this.countFrames();
        if (nFrames == 0) {
            return;
        }
        int nCols = (int)Math.sqrt(nFrames);
        int nRows = nFrames / nCols;
        int nShortRows = nRows - nFrames % nCols;
        int cxFrame = this.getWidth() / nCols;
        int cyFrame = this.getHeight() / nRows;
        int rFrame = 0;
        int cFrame = 0;
        JInternalFrame[] aFrames = this.getAllFrames();
        nFrames = aFrames.length;
        for (int iFrame = 0; iFrame < nFrames; ++iFrame) {
            if (aFrames[iFrame].isIcon()) continue;
            try {
                aFrames[iFrame].setMaximum(false);
                aFrames[iFrame].reshape(cFrame * cxFrame, rFrame * cyFrame, cxFrame, cyFrame);
                if (++cFrame != nCols) continue;
                cFrame = 0;
                if (++rFrame != nShortRows) continue;
                cxFrame = this.getWidth() / ++nCols;
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void arrangeAll() {
        this.tileVertical();
    }

    public void tileVertical() {
        int nFrames = this.countFrames();
        if (nFrames == 0) {
            return;
        }
        int nRows = (int)Math.sqrt(nFrames);
        int nCols = nFrames / nRows;
        int nShortCols = nCols - nFrames % nRows;
        int cxFrame = this.getWidth() / nCols;
        int cyFrame = this.getHeight() / nRows;
        int rFrame = 0;
        int cFrame = 0;
        JInternalFrame[] aFrames = this.getAllFrames();
        for (int iFrame = 0; iFrame < aFrames.length; ++iFrame) {
            if (aFrames[iFrame].isIcon()) continue;
            try {
                aFrames[iFrame].setMaximum(false);
                aFrames[iFrame].reshape(cFrame * cxFrame, rFrame * cyFrame, cxFrame, cyFrame);
                if (++rFrame != nRows) continue;
                rFrame = 0;
                if (++cFrame != nShortCols) continue;
                cyFrame = this.getHeight() / ++nRows;
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void closeSelectedFrame() {
        try {
            this.getSelectedFrame().setClosed(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() throws PropertyVetoException {
        if (this.getTopLevelAncestor() == null) {
            return;
        }
        Workspace frmMain = Workspace.getWorkspace();
        frmMain.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Graphics g = frmMain.getGraphics();
            try {
                frmMain.paint(g);
            }
            finally {
                g.dispose();
            }
            g = this.getGraphics();
            try {
                JInternalFrame[] frames = this.getAllFrames();
                for (int index = 0; index < frames.length; ++index) {
                    if (index != 0) {
                        frames[index].paint(g);
                    }
                    frames[index].setClosed(true);
                }
            }
            finally {
                g.dispose();
            }
        }
        finally {
            frmMain.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void restoreAll() {
        JInternalFrame[] frames = this.getAllFrames();
        for (int index = 0; index < frames.length; ++index) {
            if (!frames[index].isIcon()) continue;
            try {
                frames[index].setIcon(false);
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void minimizeAll() {
        JInternalFrame[] frames = this.getAllFrames();
        for (int index = 0; index < frames.length; ++index) {
            if (frames[index].isIcon()) continue;
            try {
                frames[index].setIcon(true);
                continue;
            }
            catch (PropertyVetoException ex) {
                Workspace.getDefaultLogger().debug("restoration vetoed!");
            }
        }
    }

    public void cascade() {
        JInternalFrame[] frames = this.getAllFrames();
        Dimension dimDesktop = this.getSize();
        int Space = (dimDesktop.height + 2) / 3;
        int cxFrame = dimDesktop.width - Space;
        int cyFrame = dimDesktop.height - Space;
        int xFrame = 0;
        int yFrame = 0;
        for (int iFrame = frames.length - 1; iFrame >= 0; --iFrame) {
            if (frames[iFrame].isIcon()) continue;
            frames[iFrame].setBounds(xFrame, yFrame, cxFrame, cyFrame);
            if ((xFrame += 20) + cxFrame < dimDesktop.width && (yFrame += 20) + cyFrame < dimDesktop.height) continue;
            xFrame = 0;
            yFrame = 0;
        }
        if (frames.length >= 1) {
            this.getDesktopManager().activateFrame(frames[0]);
        }
        m_nextFrameX = xFrame;
        m_nextFrameY = yFrame;
    }

    public void refresh() {
        JInternalFrame frame = this.getSelectedFrame();
        if (frame != null && frame instanceof WAStandardInternalFrame) {
            ((WAStandardInternalFrame)frame).refresh();
        }
    }

    public void refreshAll() {
        JInternalFrame[] aFrames = this.getAllFrames();
        for (int iFrame = aFrames.length - 1; iFrame >= 0; --iFrame) {
            if (!(aFrames[iFrame] instanceof WAStandardInternalFrame)) continue;
            ((WAStandardInternalFrame)aFrames[iFrame]).refresh();
        }
    }

    protected int countFrames() {
        int nNormal = 0;
        JInternalFrame[] aFrames = this.getAllFrames();
        for (int iFrame = 0; iFrame < aFrames.length; ++iFrame) {
            if (aFrames[iFrame].isIcon()) continue;
            ++nNormal;
        }
        return nNormal;
    }

    public void checkFrameSize(JInternalFrame frame) {
        int cxFrame = Math.min(frame.getWidth(), this.getWidth() - this.getCascadeXOffset());
        int cyFrame = Math.min(frame.getHeight(), this.getHeight() - this.getCascadeYOffset());
        frame.setSize(cxFrame, cyFrame);
    }
}

