/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.MdException;
import com.sas.workspace.AppServer;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.AppServerPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JLabel;
import javax.swing.JSeparator;

public class AppServerDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(AppServerDialog.class);
    protected WAPanel m_centerPanel;
    protected JLabel m_infoText;
    protected AppServerPanel m_appServerPanel;
    protected AppServer m_appServer;
    protected String m_strInfo;

    public AppServerDialog(Frame owner, AppServer appServer) {
        this(owner, appServer, null);
    }

    public AppServerDialog(Frame owner, AppServer appServer, String strInfoText) {
        super(owner, bundle.getString("AppServerDialog.Title.txt"), true);
        this.m_strInfo = strInfoText;
        this.m_appServer = appServer;
    }

    @Override
    protected void initialize() {
        this.m_appServerPanel = new AppServerPanel(this.m_appServer, false, false);
        this.m_infoText = new JLabel();
        if (this.m_strInfo != null) {
            this.m_infoText.setText(this.m_strInfo);
        }
        this.m_centerPanel = new WAPanel();
        this.m_centerPanel.setHelpTopic(this.m_appServerPanel.getHelpTopic());
        super.initialize();
        this.setHelpTopic(this.m_appServerPanel.getHelpTopic());
    }

    @Override
    protected void layoutWidgets() {
        super.layoutWidgets();
        this.m_centerPanel.setLayout(new GridBagLayout());
        this.m_centerPanel.add((Component)this.m_infoText, new GridBagConstraints(0, 0, 4, 4, 1.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        JSeparator m_separator = new JSeparator();
        this.m_centerPanel.add((Component)m_separator, new GridBagConstraints(0, 4, 1, 4, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.m_centerPanel.add((Component)this.m_appServerPanel, new GridBagConstraints(0, 5, 4, 4, 1.0, 1.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.setMainPanel(this.m_centerPanel);
    }

    @Override
    public boolean doDataExchange(boolean saveToModel) {
        try {
            return this.m_appServerPanel.doDataExchange(saveToModel);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Accessing");
            return false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
            return false;
        }
    }

    @Override
    public boolean validateData() {
        return this.m_appServerPanel.validateData();
    }

    @Override
    public boolean onCancel() {
        this.m_appServerPanel.setDataChanged(false);
        if (super.onCancel()) {
            this.m_appServer.termAppServer();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasDataChanged() {
        boolean changed = super.hasDataChanged();
        if (!changed) {
            changed = this.m_appServerPanel.hasDataChanged();
        }
        return changed;
    }
}

