/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.commons.springextensions.jcr;

import com.sas.svcs.content.commons.springextensions.jcr.JcrAccessor;
import com.sas.svcs.content.commons.springextensions.jcr.JcrCallback;
import com.sas.svcs.content.commons.springextensions.jcr.JcrOperations;
import com.sas.svcs.content.commons.springextensions.jcr.JcrSystemException;
import com.sas.svcs.content.commons.springextensions.jcr.SessionFactory;
import com.sas.svcs.content.commons.springextensions.jcr.SessionFactoryUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.xml.sax.ContentHandler;

public class JcrTemplate
extends JcrAccessor
implements JcrOperations {
    private static final Logger LOG = LoggerFactory.getLogger(JcrTemplate.class);
    private boolean allowCreate = false;
    private boolean exposeNativeSession = false;

    public JcrTemplate() {
    }

    public JcrTemplate(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
        this.afterPropertiesSet();
    }

    @Override
    public <T> T execute(JcrCallback<T> action, boolean exposeNativeSession) throws DataAccessException {
        Session session = this.getSession();
        try {
            T result;
            T t = result = action.doInJcr(session);
            return t;
        }
        catch (RepositoryException ex) {
            throw this.convertJcrAccessException(ex);
        }
        catch (IOException ex) {
            throw this.convertJcrAccessException(ex);
        }
        catch (RuntimeException ex) {
            throw this.convertJcrAccessException(ex);
        }
        finally {
            SessionFactoryUtils.releaseSession(session, this.getSessionFactory());
        }
    }

    @Override
    public <T> T execute(JcrCallback<T> callback) throws DataAccessException {
        return this.execute(callback, this.isExposeNativeSession());
    }

    protected Session getSession() {
        return SessionFactoryUtils.getSession(this.getSessionFactory(), this.allowCreate);
    }

    @Override
    public void addLockToken(final String lock) {
        this.execute(new JcrCallback<Void>(){

            @Override
            public Void doInJcr(Session session) throws RepositoryException {
                session.addLockToken(lock);
                return null;
            }
        }, true);
    }

    @Override
    public Object getAttribute(final String name) {
        return this.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws RepositoryException {
                return session.getAttribute(name);
            }
        }, true);
    }

    @Override
    public String[] getAttributeNames() {
        return this.execute(new JcrCallback<String[]>(){

            @Override
            public String[] doInJcr(Session session) throws RepositoryException {
                return session.getAttributeNames();
            }
        }, true);
    }

    @Override
    public ContentHandler getImportContentHandler(final String parentAbsPath, final int uuidBehavior) {
        return this.execute(new JcrCallback<ContentHandler>(){

            @Override
            public ContentHandler doInJcr(Session session) throws RepositoryException {
                return session.getImportContentHandler(parentAbsPath, uuidBehavior);
            }
        }, true);
    }

    @Override
    public Item getItem(final String absPath) {
        return this.execute(new JcrCallback<Item>(){

            @Override
            public Item doInJcr(Session session) throws RepositoryException {
                return session.getItem(absPath);
            }
        }, true);
    }

    @Override
    public String[] getLockTokens() {
        return this.execute(new JcrCallback<String[]>(){

            @Override
            public String[] doInJcr(Session session) throws RepositoryException {
                return session.getLockTokens();
            }
        }, true);
    }

    @Override
    public String getNamespacePrefix(final String uri) {
        return (String)this.execute(new JcrCallback(){

            public Object doInJcr(Session session) throws RepositoryException {
                return session.getNamespacePrefix(uri);
            }
        }, true);
    }

    @Override
    public String[] getNamespacePrefixes() {
        return this.execute(new JcrCallback<String[]>(){

            @Override
            public String[] doInJcr(Session session) throws RepositoryException {
                return session.getNamespacePrefixes();
            }
        }, true);
    }

    @Override
    public String getNamespaceURI(final String prefix) {
        return this.execute(new JcrCallback<String>(){

            @Override
            public String doInJcr(Session session) throws RepositoryException {
                return session.getNamespaceURI(prefix);
            }
        }, true);
    }

    @Override
    public Node getNodeByUUID(final String uuid) {
        return this.execute(new JcrCallback<Node>(){

            @Override
            public Node doInJcr(Session session) throws RepositoryException {
                return session.getNodeByUUID(uuid);
            }
        }, true);
    }

    @Override
    public Node getRootNode() {
        return this.execute(new JcrCallback<Node>(){

            @Override
            public Node doInJcr(Session session) throws RepositoryException {
                return session.getRootNode();
            }
        }, true);
    }

    @Override
    public String getUserID() {
        return this.execute(new JcrCallback<String>(){

            @Override
            public String doInJcr(Session session) throws RepositoryException {
                return session.getUserID();
            }
        }, true);
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.execute(new JcrCallback<ValueFactory>(){

            @Override
            public ValueFactory doInJcr(Session session) throws RepositoryException {
                return session.getValueFactory();
            }
        }, true);
    }

    @Override
    public boolean hasPendingChanges() {
        return this.execute(new JcrCallback<Boolean>(){

            @Override
            public Boolean doInJcr(Session session) throws RepositoryException {
                return session.hasPendingChanges();
            }
        }, true);
    }

    @Override
    public void importXML(final String parentAbsPath, final InputStream in, final int uuidBehavior) {
        this.execute(new JcrCallback<Void>(){

            @Override
            public Void doInJcr(Session session) throws RepositoryException {
                try {
                    session.importXML(parentAbsPath, in, uuidBehavior);
                }
                catch (IOException e) {
                    throw new JcrSystemException(e);
                }
                return null;
            }
        }, true);
    }

    @Override
    public void refresh(final boolean keepChanges) {
        this.execute(new JcrCallback<Void>(){

            @Override
            public Void doInJcr(Session session) throws RepositoryException {
                session.refresh(keepChanges);
                return null;
            }
        }, true);
    }

    @Override
    public void removeLockToken(final String lt) {
        this.execute(new JcrCallback<Void>(){

            @Override
            public Void doInJcr(Session session) throws RepositoryException {
                session.removeLockToken(lt);
                return null;
            }
        }, true);
    }

    @Override
    public void rename(final Node node, final String newName) {
        this.execute(new JcrCallback<Void>(){

            @Override
            public Void doInJcr(Session session) throws RepositoryException {
                session.move(node.getPath(), node.getParent().getPath() + "/" + newName);
                return null;
            }
        }, true);
    }

    @Override
    public void setNamespacePrefix(final String prefix, final String uri) {
        this.execute(new JcrCallback<Void>(){

            @Override
            public Void doInJcr(Session session) throws RepositoryException {
                session.setNamespacePrefix(prefix, uri);
                return null;
            }
        }, true);
    }

    @Override
    public boolean isLive() {
        return this.execute(new JcrCallback<Boolean>(){

            @Override
            public Boolean doInJcr(Session session) throws RepositoryException {
                return session.isLive();
            }
        }, true);
    }

    @Override
    public boolean itemExists(final String absPath) {
        return this.execute(new JcrCallback<Boolean>(){

            @Override
            public Boolean doInJcr(Session session) throws RepositoryException {
                return session.itemExists(absPath);
            }
        }, true);
    }

    @Override
    public void move(final String srcAbsPath, final String destAbsPath) {
        this.execute(new JcrCallback<Void>(){

            @Override
            public Void doInJcr(Session session) throws RepositoryException {
                session.move(srcAbsPath, destAbsPath);
                return null;
            }
        }, true);
    }

    public void copy(final String srcAbsPath, final String destAbsPath) {
        this.execute(new JcrCallback<Void>(){

            @Override
            public Void doInJcr(Session session) throws RepositoryException {
                session.getWorkspace().copy(srcAbsPath, destAbsPath);
                return null;
            }
        }, true);
    }

    @Override
    public void save() {
        this.execute(new JcrCallback<Void>(){

            @Override
            public Void doInJcr(Session session) throws RepositoryException {
                session.save();
                return null;
            }
        }, true);
    }

    @Override
    public String dump(final Node node) {
        return this.execute(new JcrCallback<String>(){

            @Override
            public String doInJcr(Session session) throws RepositoryException {
                Node nd = node;
                if (nd == null) {
                    nd = session.getRootNode();
                }
                return JcrTemplate.this.dumpNode(nd);
            }
        }, true);
    }

    protected String dumpNode(Node node) throws RepositoryException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(node.getPath());
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property property = properties.nextProperty();
            buffer.append(property.getPath()).append("=");
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append(values[i].getString());
                }
            } else {
                buffer.append(property.getString());
            }
            buffer.append("\n");
        }
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            Node child = nodes.nextNode();
            buffer.append(this.dumpNode(child));
        }
        return buffer.toString();
    }

    @Override
    public QueryResult query(final Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node can't be null");
        }
        return this.execute(new JcrCallback<QueryResult>(){

            @Override
            public QueryResult doInJcr(Session session) throws RepositoryException {
                boolean debug = LOG.isDebugEnabled();
                QueryManager manager = session.getWorkspace().getQueryManager();
                if (debug) {
                    LOG.debug("retrieved manager " + manager);
                }
                Query query = manager.getQuery(node);
                if (debug) {
                    LOG.debug("created query " + query);
                }
                return query.execute();
            }
        }, true);
    }

    @Override
    public QueryResult query(String statement) {
        return this.query(statement, null);
    }

    @Override
    public QueryResult query(final String statement, final String language) {
        if (statement == null) {
            throw new IllegalArgumentException("statement can't be null");
        }
        return this.execute(new JcrCallback<QueryResult>(){

            @Override
            public QueryResult doInJcr(Session session) throws RepositoryException {
                String lang = language;
                if (lang == null) {
                    lang = "xpath";
                }
                boolean debug = LOG.isDebugEnabled();
                QueryManager manager = session.getWorkspace().getQueryManager();
                if (debug) {
                    LOG.debug("retrieved manager " + manager);
                }
                Query query = manager.createQuery(statement, lang);
                if (debug) {
                    LOG.debug("created query " + query);
                }
                return query.execute();
            }
        }, true);
    }

    @Override
    public Map<String, QueryResult> query(List<String> list) {
        return this.query(list, null, false);
    }

    @Override
    public Map<String, QueryResult> query(final List<String> list, final String language, final boolean ignoreErrors) {
        if (list == null) {
            throw new IllegalArgumentException("list can't be null");
        }
        return this.execute(new JcrCallback<Map<String, QueryResult>>(){

            @Override
            public Map<String, QueryResult> doInJcr(Session session) throws RepositoryException {
                String lang = language;
                if (lang == null) {
                    lang = "xpath";
                }
                boolean debug = LOG.isDebugEnabled();
                LinkedHashMap<String, QueryResult> map = new LinkedHashMap<String, QueryResult>(list.size());
                QueryManager manager = session.getWorkspace().getQueryManager();
                if (debug) {
                    LOG.debug("retrieved manager " + manager);
                }
                for (String statement : list) {
                    Query query = manager.createQuery(statement, lang);
                    if (debug) {
                        LOG.debug("created query " + query);
                    }
                    try {
                        QueryResult result = query.execute();
                        map.put(statement, result);
                    }
                    catch (RepositoryException e) {
                        if (ignoreErrors) {
                            map.put(statement, null);
                            continue;
                        }
                        throw JcrTemplate.this.convertJcrAccessException(e);
                    }
                }
                return map;
            }
        }, true);
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    protected Session createSessionProxy(Session session) {
        return (Session)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Session.class}, (InvocationHandler)new LogoutSuppressingInvocationHandler(session));
    }

    protected boolean isVersionable(Node node) throws RepositoryException {
        return node.isNodeType("mix:versionable");
    }

    public boolean isExposeNativeSession() {
        return this.exposeNativeSession;
    }

    public void setExposeNativeSession(boolean exposeNativeSession) {
        this.exposeNativeSession = exposeNativeSession;
    }

    private class LogoutSuppressingInvocationHandler
    implements InvocationHandler {
        private final Session target;

        public LogoutSuppressingInvocationHandler(Session target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("logout")) {
                return null;
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

