/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.jcr;

import com.sas.svcs.common.client.dao.jcr.JcrContentUtils;
import com.sas.svcs.common.client.dao.jcr.JcrNodeMapper;
import com.sas.svcs.common.client.dao.jcr.MutableJcrNodeMapper;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.commons.springextensions.jcr.JcrCallback;
import com.sas.svcs.content.commons.springextensions.jcr.JcrTemplate;
import com.sas.svcs.content.framework.client.ContainerNotEmptyException;
import com.sas.svcs.content.framework.client.ObjectExistsException;
import com.sas.svcs.content.framework.client.ObjectModifiedException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.framework.client.ValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.util.SpecialNameChars;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Repository;

@Repository(value="sasJcrTemplate")
public class SASJcrTemplate {
    private JcrTemplate jcrTemplate;
    private JcrContentUtils jcrUtils = new JcrContentUtils();

    @Autowired
    public void setJcrTemplate(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    public void setJcrContentUtils(JcrContentUtils jcrContentUtils) {
        this.jcrUtils = jcrContentUtils;
    }

    public <T extends Identifiable> T findById(ObjectIdentity objectId, JcrNodeMapper<T> mapper) {
        return (T)((Identifiable)this.jcrTemplate.execute(new FindByIdCallback<T>(objectId, mapper)));
    }

    public <T extends Identifiable> T findVersionById(ObjectIdentity id, String versionName, JcrNodeMapper<T> mapper) {
        return (T)((Identifiable)this.jcrTemplate.execute(new FindVersionByIdCallback<T>(id, versionName, mapper)));
    }

    public <T extends Identifiable> List<T> findAllVersionsById(ObjectIdentity id, JcrNodeMapper<T> mapper) {
        return (List)this.jcrTemplate.execute(new FindAllVersionsByIdCallback<T>(id, mapper));
    }

    public boolean deleteById(ObjectIdentity objectId) throws ObjectNotFoundException {
        if (!this.jcrTemplate.execute(new DeleteByIdCallback(objectId, true)).booleanValue()) {
            throw new ObjectNotFoundException("Object not found for delete: " + objectId, objectId.getId());
        }
        return true;
    }

    public boolean deleteContainerById(ObjectIdentity objectId, boolean recurse) throws ObjectNotFoundException, ContainerNotEmptyException {
        if (!this.jcrTemplate.execute(new DeleteByIdCallback(objectId, recurse)).booleanValue()) {
            throw new ObjectNotFoundException("Object not found for delete: " + objectId, objectId.getId());
        }
        return true;
    }

    public boolean deleteByPath(String path, long objectType) throws ObjectNotFoundException {
        if (!this.jcrTemplate.execute(new DeleteByPathCallback(path, objectType, true)).booleanValue()) {
            throw new ObjectNotFoundException("Object not found for delete: " + path, path);
        }
        return true;
    }

    public boolean deleteContainerByPath(String path, long objectType, boolean recurse) throws ObjectNotFoundException, ContainerNotEmptyException {
        if (!this.jcrTemplate.execute(new DeleteByPathCallback(path, objectType, recurse)).booleanValue()) {
            throw new ObjectNotFoundException("Object not found for delete: " + path, path);
        }
        return true;
    }

    public <T extends Identifiable> T update(T object, long incomingInternalVersion, MutableJcrNodeMapper<T> mapper) throws ObjectNotFoundException, ObjectModifiedException {
        Identifiable ret;
        try {
            ret = (Identifiable)this.jcrTemplate.execute(new UpdateCallback(this, object, incomingInternalVersion, mapper));
        }
        catch (JcrContentUtils.InternalModifiedException e) {
            throw new ObjectModifiedException("Object has been modified since it was retrieved.", object.getId());
        }
        if (null == ret) {
            throw new ObjectNotFoundException("Object node found for update: " + object, object.getId());
        }
        return (T)ret;
    }

    public <T extends Identifiable> T rename(T contentObject, long incomingInternalVersion, String newName, JcrNodeMapper<T> mapper) throws ObjectNotFoundException, ValidationException, ObjectModifiedException {
        Identifiable ret;
        try {
            ret = (Identifiable)this.jcrTemplate.execute(new RenameCallback(this, contentObject, incomingInternalVersion, newName, mapper));
        }
        catch (JcrContentUtils.InternalModifiedException e) {
            throw new ObjectModifiedException("Can't rename object: " + contentObject + " - Object has been modified externally.", contentObject.getId());
        }
        if (null == ret) {
            throw new ObjectNotFoundException("Object not found to rename: " + contentObject.getId(), contentObject.getId());
        }
        return (T)ret;
    }

    public <T extends Identifiable> T create(String parentPath, T object, String name, String jcrTypeName, boolean versioned, MutableJcrNodeMapper<T> mapper) throws ObjectExistsException, ValidationException {
        this.jcrUtils.validateName(name);
        Identifiable ret = (Identifiable)this.jcrTemplate.execute(new CreateByPathCallback(this, parentPath, object, name, jcrTypeName, versioned, mapper));
        if (ret == null) {
            throw new ObjectExistsException("Content object already exists: " + name, name);
        }
        return (T)ret;
    }

    public <T extends Identifiable> T create(ObjectIdentity parent, T object, String name, String jcrTypeName, boolean versioned, MutableJcrNodeMapper<T> mapper) throws ObjectNotFoundException, ObjectExistsException, ValidationException {
        this.jcrUtils.validateName(name);
        this.jcrUtils.validateContainer(name, object.getObjectType(), parent);
        if (79L != parent.getObjectType()) {
            throw new ObjectNotFoundException("Parent folder not found: " + parent.getId(), parent.getId());
        }
        Identifiable ret = (Identifiable)this.jcrTemplate.execute(new CreateByIdCallback(this, parent, object, name, jcrTypeName, versioned, mapper));
        if (ret == null) {
            throw new ObjectExistsException("Content object already exists: " + name, name);
        }
        return (T)ret;
    }

    public <T extends Identifiable> T findByPath(String path, long objectType, JcrNodeMapper<T> mapper) {
        return (T)((Identifiable)this.jcrTemplate.execute(new FindByPathCallback<T>(path, objectType, mapper)));
    }

    public <T extends Identifiable> T findVersionByPath(String path, long objectType, String versionName, JcrNodeMapper<T> mapper) {
        return (T)((Identifiable)this.jcrTemplate.execute(new FindVersionByPathCallback<T>(path, versionName, objectType, mapper)));
    }

    public <T extends Identifiable> List<T> findAllVersionsByPath(String path, long objectType, JcrNodeMapper<T> mapper) {
        return (List)this.jcrTemplate.execute(new FindAllVersionsByPathCallback<T>(path, objectType, mapper));
    }

    public InputStream findFileContentsByPath(final String path) {
        return this.jcrTemplate.execute(new JcrCallback<InputStream>(){

            @Override
            public InputStream doInJcr(Session session) throws IOException, RepositoryException {
                try {
                    Node node = SASJcrTemplate.this.jcrUtils.getNodeByPath(path, session);
                    if (node == null) {
                        return null;
                    }
                    Node cNode = node.getNode("jcr:content");
                    if (cNode.hasProperty("jcr:data")) {
                        return cNode.getProperty("jcr:data").getStream();
                    }
                    return null;
                }
                catch (PathNotFoundException e) {
                    return null;
                }
            }
        });
    }

    public <T extends Identifiable> List<T> getChildrenOfTypeByPath(String path, long parentObjectType, long objectType, JcrNodeMapper<T> mapper) {
        return (List)this.jcrTemplate.execute(new GetChildrenOfTypeByPathCallback<T>(path, parentObjectType, objectType, mapper));
    }

    public <T extends Identifiable> List<T> getChildrenOfTypeById(ObjectIdentity id, long objectType, JcrNodeMapper<T> mapper) {
        return (List)this.jcrTemplate.execute(new GetChildrenOfTypeByIdCallback<T>(id, objectType, mapper));
    }

    protected <T extends Identifiable> T getVersion(Node node, String versionName, JcrNodeMapper<T> mapper) throws RepositoryException, UnsupportedRepositoryOperationException, IOException {
        Version version = this.jcrUtils.getJcrVersion(node, versionName);
        if (version == null) {
            return null;
        }
        return (T)((Identifiable)mapper.mapFromJcrVersion(node, version));
    }

    private String getCurrentUserId() {
        return SecurityContextHolder.getContext().getAuthentication().getName();
    }

    private Version getCorrectVersion(Node node) throws RepositoryException, UnsupportedRepositoryOperationException {
        Version version = null;
        if (this.jcrUtils.isVersioned(node) && node.isCheckedOut()) {
            String checkedOutBy = this.jcrUtils.getCheckedOutBy(node);
            String currentUser = this.getCurrentUserId();
            if (!currentUser.equals(checkedOutBy)) {
                version = node.getBaseVersion();
            }
        }
        return version;
    }

    private <T extends Identifiable> List<T> getAllVersions(Node node, JcrNodeMapper<T> mapper) throws UnsupportedRepositoryOperationException, RepositoryException, IOException {
        VersionHistory vh = node.getVersionHistory();
        VersionIterator vIter = vh.getAllVersions();
        ArrayList<Identifiable> ret = new ArrayList<Identifiable>();
        while (vIter.hasNext()) {
            Version version = vIter.nextVersion();
            if (version.getName().equals("jcr:rootVersion")) continue;
            ret.add((Identifiable)mapper.mapFromJcrVersion(node, version));
        }
        return ret;
    }

    private <T extends Identifiable> List<T> getChildrenOfType(Node parentNode, JcrNodeMapper<T> mapper, long objectType) throws RepositoryException, IOException {
        ArrayList<Identifiable> ret = new ArrayList<Identifiable>();
        NodeIterator kids = parentNode.getNodes();
        while (kids.hasNext()) {
            Node kid = kids.nextNode();
            Long fetchedObjectType = this.jcrUtils.getLongProperty(kid, "sas:objectType");
            if (fetchedObjectType == null || !fetchedObjectType.equals(objectType)) continue;
            ret.add((Identifiable)mapper.mapFromJcrNode(kid));
        }
        return ret;
    }

    protected final class FindAllVersionsByIdCallback<T extends Identifiable>
    implements JcrCallback<List<T>> {
        private final JcrNodeMapper<T> mapper;
        private final ObjectIdentity id;

        protected FindAllVersionsByIdCallback(ObjectIdentity id, JcrNodeMapper<T> mapper) {
            this.mapper = mapper;
            this.id = id;
        }

        @Override
        public List<T> doInJcr(Session session) throws IOException, RepositoryException {
            Node node = SASJcrTemplate.this.jcrUtils.getNodeByObjectIdentity(this.id, session);
            if (node == null) {
                return null;
            }
            return SASJcrTemplate.this.getAllVersions(node, this.mapper);
        }
    }

    protected final class FindVersionByIdCallback<T extends Identifiable>
    implements JcrCallback<T> {
        private final JcrNodeMapper<T> mapper;
        private final String versionName;
        private final ObjectIdentity id;

        protected FindVersionByIdCallback(ObjectIdentity id, String versionName, JcrNodeMapper<T> mapper) {
            this.mapper = mapper;
            this.versionName = versionName;
            this.id = id;
        }

        @Override
        public T doInJcr(Session session) throws IOException, RepositoryException {
            Node node = SASJcrTemplate.this.jcrUtils.getNodeByObjectIdentity(this.id, session);
            if (node == null) {
                return null;
            }
            return SASJcrTemplate.this.getVersion(node, this.versionName, this.mapper);
        }
    }

    protected final class FindByIdCallback<T extends Identifiable>
    implements JcrCallback<T> {
        private final ObjectIdentity objectId;
        private final JcrNodeMapper<T> mapper;

        protected FindByIdCallback(ObjectIdentity objectId, JcrNodeMapper<T> mapper) {
            this.objectId = objectId;
            this.mapper = mapper;
        }

        @Override
        public T doInJcr(Session session) throws IOException, RepositoryException {
            Node node = SASJcrTemplate.this.jcrUtils.getNodeByObjectIdentity(this.objectId, session);
            if (node == null) {
                return null;
            }
            Version version = SASJcrTemplate.this.getCorrectVersion(node);
            return (T)(version == null ? (Identifiable)this.mapper.mapFromJcrNode(node) : (Identifiable)this.mapper.mapFromJcrVersion(node, version));
        }
    }

    protected final class DeleteByPathCallback
    implements JcrCallback<Boolean> {
        private final String path;
        private final long objectType;
        private final boolean recurse;

        protected DeleteByPathCallback(String path, long objectType, boolean recurse) {
            this.path = path;
            this.objectType = objectType;
            this.recurse = recurse;
        }

        @Override
        public Boolean doInJcr(Session session) throws IOException, RepositoryException {
            Node node = SASJcrTemplate.this.jcrUtils.getNodeByPath(this.path, this.objectType, session);
            if (node == null) {
                return false;
            }
            if (!this.recurse && node.hasNodes()) {
                throw new ContainerNotEmptyException("Container must be empty to delete it.");
            }
            node.remove();
            session.save();
            return true;
        }
    }

    protected final class DeleteByIdCallback
    implements JcrCallback<Boolean> {
        private final ObjectIdentity objectId;
        private boolean recurse;

        protected DeleteByIdCallback(ObjectIdentity objectId, boolean recurse) {
            this.objectId = objectId;
            this.recurse = recurse;
        }

        @Override
        public Boolean doInJcr(Session session) throws IOException, RepositoryException {
            Node node = SASJcrTemplate.this.jcrUtils.getNodeByObjectIdentity(this.objectId, session);
            if (node == null) {
                return false;
            }
            if (!this.recurse && node.hasNodes()) {
                throw new ContainerNotEmptyException("Container must be empty to delete it.");
            }
            node.remove();
            session.save();
            return true;
        }
    }

    protected final class UpdateCallback<T extends Identifiable>
    implements JcrCallback<T> {
        private final MutableJcrNodeMapper<T> mapper;
        private final T object;
        private final long incomingInternalVersion;
        final /* synthetic */ SASJcrTemplate this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        protected UpdateCallback(T t, long mapper, MutableJcrNodeMapper<T> mutableJcrNodeMapper) {
            void var3_3;
            void object;
            this.this$0 = (SASJcrTemplate)this$0;
            this.mapper = (MutableJcrNodeMapper<T>)mapper;
            this.object = object;
            this.incomingInternalVersion = var3_3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T doInJcr(Session session) throws IOException, RepositoryException {
            Node node = this.this$0.jcrUtils.getNodeForUpdateByObjectIdentity(new ObjectIdentity(this.object), this.incomingInternalVersion, session);
            try {
                if (node == null) {
                    T t = null;
                    return t;
                }
                this.mapper.mapToJcrNode(this.object, node);
                Identifiable ret = (Identifiable)this.mapper.mapFromJcrNode(node);
                session.save();
                Identifiable identifiable = ret;
                return (T)identifiable;
            }
            finally {
                if (node != null) {
                    node.unlock();
                }
            }
        }
    }

    protected final class RenameCallback<T extends Identifiable>
    implements JcrCallback<T> {
        private final String newName;
        private final JcrNodeMapper<T> mapper;
        private final T contentObject;
        private final long incomingInternalVersion;
        final /* synthetic */ SASJcrTemplate this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        protected RenameCallback(T t, long newName, String string, JcrNodeMapper<T> jcrNodeMapper) {
            void var3_3;
            void contentObject;
            void mapper;
            this.this$0 = (SASJcrTemplate)this$0;
            this.newName = newName;
            this.mapper = mapper;
            this.contentObject = contentObject;
            this.incomingInternalVersion = var3_3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T doInJcr(Session session) throws IOException, RepositoryException {
            ObjectIdentity objectId = new ObjectIdentity(this.contentObject);
            Node node = null;
            try {
                node = this.this$0.jcrUtils.getNodeForUpdateByObjectIdentity(objectId, this.incomingInternalVersion, session);
                if (null == node) {
                    T t = null;
                    return t;
                }
                session.move(node.getPath(), node.getParent().getPath() + "/" + SpecialNameChars.encode((String)this.newName));
                session.save();
                node = this.this$0.jcrUtils.getNodeByObjectIdentity(objectId, session);
                Identifiable identifiable = (Identifiable)this.mapper.mapFromJcrNode(node);
                return (T)identifiable;
            }
            finally {
                if (node != null) {
                    node.unlock();
                }
            }
        }
    }

    protected static abstract class CreateCallback<T extends Identifiable>
    implements JcrCallback<T> {
        private final String name;
        private final T object;
        private final String jcrTypeName;
        private final boolean versioned;
        private final MutableJcrNodeMapper<T> mapper;
        final /* synthetic */ SASJcrTemplate this$0;

        protected CreateCallback(T object, String name, String jcrTypeName, boolean versioned, MutableJcrNodeMapper<T> mapper) {
            this.this$0 = this$0;
            this.name = name;
            this.object = object;
            this.jcrTypeName = jcrTypeName;
            this.versioned = versioned;
            this.mapper = mapper;
        }

        protected abstract Node getParentNode(Session var1) throws RepositoryException;

        @Override
        public T doInJcr(Session session) throws IOException, RepositoryException {
            Node parentNode = this.getParentNode(session);
            if (parentNode.hasNode(SpecialNameChars.encode((String)this.name))) {
                return null;
            }
            Node jcrNode = parentNode.addNode(SpecialNameChars.encode((String)this.name), this.jcrTypeName);
            this.mapper.mapToJcrNode(this.object, jcrNode);
            if (this.versioned) {
                session.save();
                this.this$0.jcrUtils.enableVersioning(jcrNode, false);
            }
            session.save();
            Node node = session.getNodeByUUID(jcrNode.getUUID());
            return (T)((Identifiable)this.mapper.mapFromJcrNode(node));
        }
    }

    protected static final class CreateByIdCallback<T extends Identifiable>
    extends CreateCallback<T> {
        private ObjectIdentity parentId;
        final /* synthetic */ SASJcrTemplate this$0;

        protected CreateByIdCallback(ObjectIdentity parentId, T object, String name, String jcrTypeName, boolean versioned, MutableJcrNodeMapper<T> mapper) {
            this.this$0 = this$0;
            super((SASJcrTemplate)this$0, object, name, jcrTypeName, versioned, mapper);
            this.parentId = parentId;
        }

        @Override
        protected Node getParentNode(Session session) throws RepositoryException {
            Node ret = this.this$0.jcrUtils.getNodeByObjectIdentity(this.parentId, session);
            if (ret == null) {
                throw new RuntimeException("Parent not found: " + this.parentId);
            }
            return ret;
        }
    }

    protected static final class CreateByPathCallback<T extends Identifiable>
    extends CreateCallback<T> {
        private String parentPath;
        final /* synthetic */ SASJcrTemplate this$0;

        protected CreateByPathCallback(String parentPath, T object, String name, String jcrTypeName, boolean versioned, MutableJcrNodeMapper<T> mapper) {
            this.this$0 = this$0;
            super((SASJcrTemplate)this$0, object, name, jcrTypeName, versioned, mapper);
            this.parentPath = parentPath;
        }

        @Override
        protected Node getParentNode(Session session) throws RepositoryException {
            Node ret = this.this$0.jcrUtils.getNodeByPath(this.parentPath, session);
            if (ret == null) {
                throw new RuntimeException("Parent path not found: " + this.parentPath);
            }
            return ret;
        }
    }

    protected final class FindByPathCallback<T>
    implements JcrCallback<T> {
        private final String path;
        private final long objectType;
        private final JcrNodeMapper<T> mapper;

        protected FindByPathCallback(String path, long objectType, JcrNodeMapper<T> mapper) {
            this.path = path;
            this.objectType = objectType;
            this.mapper = mapper;
        }

        @Override
        public T doInJcr(Session session) throws IOException, RepositoryException {
            Node node = SASJcrTemplate.this.jcrUtils.getNodeByPath(this.path, this.objectType, session);
            if (node == null) {
                return null;
            }
            Version version = SASJcrTemplate.this.getCorrectVersion(node);
            return version == null ? this.mapper.mapFromJcrNode(node) : this.mapper.mapFromJcrVersion(node, version);
        }
    }

    protected final class FindAllVersionsByPathCallback<T extends Identifiable>
    implements JcrCallback<List<T>> {
        private final long objectType;
        private final JcrNodeMapper<T> mapper;
        private final String path;

        protected FindAllVersionsByPathCallback(String path, long objectType, JcrNodeMapper<T> mapper) {
            this.objectType = objectType;
            this.mapper = mapper;
            this.path = path;
        }

        @Override
        public List<T> doInJcr(Session session) throws IOException, RepositoryException {
            Node node = SASJcrTemplate.this.jcrUtils.getNodeByPath(this.path, this.objectType, session);
            if (node == null) {
                return null;
            }
            return SASJcrTemplate.this.getAllVersions(node, this.mapper);
        }
    }

    protected final class FindVersionByPathCallback<T extends Identifiable>
    implements JcrCallback<T> {
        private final long objectType;
        private final JcrNodeMapper<T> mapper;
        private final String versionName;
        private final String path;

        protected FindVersionByPathCallback(String path, String versionName, long objectType, JcrNodeMapper<T> mapper) {
            this.objectType = objectType;
            this.mapper = mapper;
            this.versionName = versionName;
            this.path = path;
        }

        @Override
        public T doInJcr(Session session) throws IOException, RepositoryException {
            Node node = SASJcrTemplate.this.jcrUtils.getNodeByPath(this.path, this.objectType, session);
            if (node == null) {
                return null;
            }
            return SASJcrTemplate.this.getVersion(node, this.versionName, this.mapper);
        }
    }

    protected final class GetChildrenOfTypeByIdCallback<T extends Identifiable>
    implements JcrCallback<List<T>> {
        private final long objectType;
        private final JcrNodeMapper<T> mapper;
        private final ObjectIdentity id;

        protected GetChildrenOfTypeByIdCallback(ObjectIdentity id, long objectType, JcrNodeMapper<T> mapper) {
            this.objectType = objectType;
            this.mapper = mapper;
            this.id = id;
        }

        @Override
        public List<T> doInJcr(Session session) throws IOException, RepositoryException {
            Node parentNode = SASJcrTemplate.this.jcrUtils.getNodeByObjectIdentity(this.id, session);
            return SASJcrTemplate.this.getChildrenOfType(parentNode, this.mapper, this.objectType);
        }
    }

    protected final class GetChildrenOfTypeByPathCallback<T extends Identifiable>
    implements JcrCallback<List<T>> {
        private final long objectType;
        private final long parentObjectType;
        private final JcrNodeMapper<T> mapper;
        private final String path;

        protected GetChildrenOfTypeByPathCallback(String path, long parentObjectType, long objectType, JcrNodeMapper<T> mapper) {
            this.parentObjectType = parentObjectType;
            this.objectType = objectType;
            this.mapper = mapper;
            this.path = path;
        }

        @Override
        public List<T> doInJcr(Session session) throws IOException, RepositoryException {
            Node parentNode = SASJcrTemplate.this.jcrUtils.getNodeByPath(this.path, this.parentObjectType, session);
            if (parentNode == null) {
                return null;
            }
            return SASJcrTemplate.this.getChildrenOfType(parentNode, this.mapper, this.objectType);
        }
    }
}

