/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.jcr;

import com.sas.svcs.common.client.dao.VersionDAO;
import com.sas.svcs.common.client.dao.jcr.BaseJCRDAO;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.commons.springextensions.jcr.JcrCallback;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import com.sas.svcs.content.versioning.client.CheckoutStatus;
import com.sas.svcs.content.versioning.client.VersioningException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.util.SpecialNameChars;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Repository;

@Repository(value="jcrVersionDao")
public class JcrVersionDAO
extends BaseJCRDAO
implements VersionDAO {
    private ObjectTypeService objectTypeService;

    @Autowired
    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }

    public void cancelCheckOut(final ObjectIdentity objId) throws ObjectNotFoundException {
        ObjectNotFoundException e = this.getTemplate().execute(new JcrCallback<ObjectNotFoundException>(){

            @Override
            public ObjectNotFoundException doInJcr(Session session) throws IOException, RepositoryException {
                Node node = JcrVersionDAO.this.getNodeByObjectIdentity(objId, session);
                if (node == null) {
                    return new ObjectNotFoundException("Object not found: " + objId, objId.getId());
                }
                if (!JcrVersionDAO.this.isCheckedOut(node)) {
                    return null;
                }
                node.restore(node.getBaseVersion(), true);
                node.save();
                return null;
            }
        });
        if (e != null) {
            throw e;
        }
    }

    private String getCurrentUserId() {
        return SecurityContextHolder.getContext().getAuthentication().getName();
    }

    private boolean isCheckedOutByCurrentUser(Node node) throws RepositoryException {
        String checkedOutBy = this.getCheckedOutBy(node);
        String currUser = this.getCurrentUserId();
        return currUser.equals(checkedOutBy);
    }

    private void throwException(Exception e) throws ObjectNotFoundException, VersioningException {
        if (null == e) {
            return;
        }
        if (e instanceof ObjectNotFoundException) {
            throw (ObjectNotFoundException)e;
        }
        if (e instanceof VersioningException) {
            throw (VersioningException)e;
        }
        throw new RuntimeException(e);
    }

    public void checkIn(final ObjectIdentity objId, final String checkinComment) throws ObjectNotFoundException, VersioningException {
        Exception e = this.getTemplate().execute(new JcrCallback<Exception>(){

            @Override
            public Exception doInJcr(Session session) throws IOException, RepositoryException {
                Node node = JcrVersionDAO.this.getNodeByObjectIdentity(objId, session);
                if (node == null) {
                    return new ObjectNotFoundException("Object not found: " + objId, objId.getId());
                }
                if (!JcrVersionDAO.this.isCheckedOut(node)) {
                    return new VersioningException("Can't check in object.  Object is not checked out - " + objId);
                }
                if (!JcrVersionDAO.this.isCheckedOutByCurrentUser(node)) {
                    return new VersioningException("Can't check in object because it is checked out by another user - " + objId);
                }
                JcrVersionDAO.this.setCheckedOutBy(node, null);
                JcrVersionDAO.this.setCheckedOutDate(node, null);
                node.setProperty("sas:checkinComment", checkinComment);
                node.save();
                node.checkin();
                return null;
            }
        });
        this.throwException(e);
    }

    public void checkOut(final ObjectIdentity objId) throws ObjectNotFoundException, VersioningException {
        Exception e = this.getTemplate().execute(new JcrCallback<Exception>(){

            @Override
            public Exception doInJcr(Session session) throws IOException, RepositoryException {
                Node node = JcrVersionDAO.this.getNodeByObjectIdentity(objId, session);
                if (node == null) {
                    return new ObjectNotFoundException("Object not found: " + objId, objId.getId());
                }
                if (!JcrVersionDAO.this.isVersioned(node)) {
                    return new VersioningException("Can't check out object.  Object is not versioned: " + objId);
                }
                node.checkout();
                JcrVersionDAO.this.setCheckedOutBy(node, JcrVersionDAO.this.getCurrentUserId());
                JcrVersionDAO.this.setCheckedOutDate(node, Calendar.getInstance());
                node.save();
                return null;
            }
        });
        this.throwException(e);
    }

    public void version(final ObjectIdentity objId) throws ObjectNotFoundException {
        ObjectNotFoundException e = this.getTemplate().execute(new JcrCallback<ObjectNotFoundException>(){

            @Override
            public ObjectNotFoundException doInJcr(Session session) throws IOException, RepositoryException {
                Node node = JcrVersionDAO.this.getNodeByObjectIdentity(objId, session);
                if (node == null) {
                    return new ObjectNotFoundException("Object not found: " + objId, objId.getId());
                }
                JcrVersionDAO.this.enableVersioning(node, true);
                return null;
            }
        });
        if (e != null) {
            throw e;
        }
    }

    public List<com.sas.svcs.content.versioning.client.Version> getAllVersions(final ObjectIdentity objId) throws VersioningException {
        List<com.sas.svcs.content.versioning.client.Version> ret;
        try {
            ret = this.getTemplate().execute(new JcrCallback<List<com.sas.svcs.content.versioning.client.Version>>(){

                @Override
                public List<com.sas.svcs.content.versioning.client.Version> doInJcr(Session session) throws IOException, RepositoryException {
                    Node node = JcrVersionDAO.this.getNodeByObjectIdentity(objId, session);
                    if (node == null) {
                        return null;
                    }
                    if (!JcrVersionDAO.this.isVersioned(node)) {
                        throw new NotVersionedException();
                    }
                    VersionHistory vh = node.getVersionHistory();
                    VersionIterator vIter = vh.getAllVersions();
                    ArrayList<com.sas.svcs.content.versioning.client.Version> list = new ArrayList<com.sas.svcs.content.versioning.client.Version>();
                    while (vIter.hasNext()) {
                        Version version = vIter.nextVersion();
                        if (version.getName().equals("jcr:rootVersion")) continue;
                        list.add(JcrVersionDAO.this.getVersionFromJCRNode(node, version));
                    }
                    return list;
                }
            });
        }
        catch (NotVersionedException e) {
            throw new VersioningException("Can't get versions.  Object is not versioned: " + objId);
        }
        return ret;
    }

    public List<String> getVersionNames(final ObjectIdentity objId) throws ObjectNotFoundException, VersioningException {
        List<String> ret;
        try {
            ret = this.getTemplate().execute(new JcrCallback<List<String>>(){

                @Override
                public List<String> doInJcr(Session session) throws IOException, RepositoryException {
                    Node node = JcrVersionDAO.this.getNodeByObjectIdentity(objId, session);
                    if (null == node) {
                        return null;
                    }
                    if (!JcrVersionDAO.this.isVersioned(node)) {
                        throw new NotVersionedException();
                    }
                    VersionHistory vh = node.getVersionHistory();
                    VersionIterator vIter = vh.getAllVersions();
                    ArrayList<String> list = new ArrayList<String>();
                    while (vIter.hasNext()) {
                        Version version = vIter.nextVersion();
                        if (version.getName().equals("jcr:rootVersion")) continue;
                        list.add(version.getName());
                    }
                    return list;
                }
            });
        }
        catch (NotVersionedException e) {
            throw new VersioningException("Can't get version names.  Object is not versioned: " + objId);
        }
        if (ret == null) {
            throw new ObjectNotFoundException("Can't get versions for object.  Object not found - " + objId, objId.getId());
        }
        return ret;
    }

    public void addVersionLabel(final ObjectIdentity objId, final String versionName, final String versionLabel) throws ObjectNotFoundException, VersioningException {
        Exception e = this.getTemplate().execute(new JcrCallback<Exception>(){

            @Override
            public Exception doInJcr(Session session) throws IOException, RepositoryException {
                Version version;
                Node node = JcrVersionDAO.this.getNodeByObjectIdentity(objId, session);
                if (node == null) {
                    return new ObjectNotFoundException("Object not found: " + objId, objId.getId());
                }
                if (!JcrVersionDAO.this.isVersioned(node)) {
                    return new VersioningException("Can't add version label.  Object is not versioned: " + objId);
                }
                VersionHistory vh = node.getVersionHistory();
                try {
                    version = vh.getVersion(versionName);
                }
                catch (VersionException e) {
                    return new ObjectNotFoundException("Version: " + versionName + " not found on object: " + objId, objId.getId());
                }
                if (vh.hasVersionLabel(versionLabel)) {
                    if (vh.hasVersionLabel(version, versionLabel)) {
                        return null;
                    }
                    throw new RuntimeException("Version label already exists on this object on another version.");
                }
                vh.addVersionLabel(versionName, versionLabel, false);
                return null;
            }
        });
        this.throwException(e);
    }

    public com.sas.svcs.content.versioning.client.Version getVersion(final ObjectIdentity objId, final String versionName) throws VersioningException {
        com.sas.svcs.content.versioning.client.Version ret;
        try {
            ret = this.getTemplate().execute(new JcrCallback<com.sas.svcs.content.versioning.client.Version>(){

                @Override
                public com.sas.svcs.content.versioning.client.Version doInJcr(Session session) throws IOException, RepositoryException {
                    Version v;
                    Node node = JcrVersionDAO.this.getNodeByObjectIdentity(objId, session);
                    if (null == node) {
                        return null;
                    }
                    if (!JcrVersionDAO.this.isVersioned(node)) {
                        throw new NotVersionedException();
                    }
                    VersionHistory vh = node.getVersionHistory();
                    try {
                        v = vh.getVersion(versionName);
                    }
                    catch (VersionException e) {
                        return null;
                    }
                    return JcrVersionDAO.this.getVersionFromJCRNode(node, v);
                }
            });
        }
        catch (NotVersionedException e) {
            throw new VersioningException("Can't get version.  Object is not versioned: " + objId);
        }
        return ret;
    }

    public com.sas.svcs.content.versioning.client.Version getVersionByLabel(final ObjectIdentity objId, final String versionLabel) throws VersioningException {
        com.sas.svcs.content.versioning.client.Version ret;
        try {
            ret = this.getTemplate().execute(new JcrCallback<com.sas.svcs.content.versioning.client.Version>(){

                @Override
                public com.sas.svcs.content.versioning.client.Version doInJcr(Session session) throws IOException, RepositoryException {
                    Node node = JcrVersionDAO.this.getNodeByObjectIdentity(objId, session);
                    if (node == null) {
                        return null;
                    }
                    if (!JcrVersionDAO.this.isVersioned(node)) {
                        throw new NotVersionedException();
                    }
                    VersionHistory vh = node.getVersionHistory();
                    if (!vh.hasVersionLabel(versionLabel)) {
                        return null;
                    }
                    Version v = vh.getVersionByLabel(versionLabel);
                    return JcrVersionDAO.this.getVersionFromJCRNode(node, v);
                }
            });
        }
        catch (NotVersionedException e) {
            throw new VersioningException("Can't get version label.  Object is not versioned: " + objId);
        }
        return ret;
    }

    public List<String> getVersionLabels(final ObjectIdentity objId) throws VersioningException {
        List<String> ret;
        try {
            ret = this.getTemplate().execute(new JcrCallback<List<String>>(){

                @Override
                public List<String> doInJcr(Session session) throws IOException, RepositoryException {
                    Node node = JcrVersionDAO.this.getNodeByObjectIdentity(objId, session);
                    if (null == node) {
                        return null;
                    }
                    if (!JcrVersionDAO.this.isVersioned(node)) {
                        throw new NotVersionedException();
                    }
                    VersionHistory vh = node.getVersionHistory();
                    String[] labels = vh.getVersionLabels();
                    return Arrays.asList(labels);
                }
            });
        }
        catch (NotVersionedException e) {
            throw new VersioningException("Can't get version labels.  Object is not versioned: " + objId);
        }
        return ret;
    }

    public void removeVersionLabel(final ObjectIdentity objId, final String versionLabel) throws ObjectNotFoundException, VersioningException {
        Exception e = this.getTemplate().execute(new JcrCallback<Exception>(){

            @Override
            public Exception doInJcr(Session session) throws IOException, RepositoryException {
                Node node = JcrVersionDAO.this.getNodeByObjectIdentity(objId, session);
                if (node == null) {
                    return new ObjectNotFoundException("Object not found: " + objId, objId.getId());
                }
                if (!JcrVersionDAO.this.isVersioned(node)) {
                    return new VersioningException("Can't remove version label.  Object is not versioned: " + objId);
                }
                VersionHistory vh = node.getVersionHistory();
                if (!vh.hasVersionLabel(versionLabel)) {
                    return null;
                }
                vh.removeVersionLabel(versionLabel);
                return null;
            }
        });
        this.throwException(e);
    }

    public CheckoutStatus getCheckoutStatus(final ObjectIdentity objId) throws ObjectNotFoundException, VersioningException {
        CheckoutStatus ret;
        try {
            ret = this.getTemplate().execute(new JcrCallback<CheckoutStatus>(){

                @Override
                public CheckoutStatus doInJcr(Session session) throws IOException, RepositoryException {
                    Node node = JcrVersionDAO.this.getNodeByObjectIdentity(objId, session);
                    if (null == node) {
                        return null;
                    }
                    if (!JcrVersionDAO.this.isVersioned(node)) {
                        throw new NotVersionedException();
                    }
                    return JcrVersionDAO.this.getCheckoutStatus(node);
                }
            });
        }
        catch (NotVersionedException e) {
            throw new VersioningException("Can't get checkout status.  Object is not versioned: " + objId);
        }
        if (ret == null) {
            throw new ObjectNotFoundException("Can't get versions for object.  Object not found - " + objId, objId.getId());
        }
        return ret;
    }

    public boolean isVersioned(final ObjectIdentity objId) throws ObjectNotFoundException {
        Boolean ret = this.getTemplate().execute(new JcrCallback<Boolean>(){

            @Override
            public Boolean doInJcr(Session session) throws IOException, RepositoryException {
                Node node = JcrVersionDAO.this.getNodeByObjectIdentity(objId, session);
                if (null == node) {
                    return null;
                }
                return JcrVersionDAO.this.isVersioned(node);
            }
        });
        if (null == ret) {
            throw new ObjectNotFoundException("Object not found: " + objId, objId.getId());
        }
        return ret;
    }

    private boolean isCheckedOut(Node node) throws RepositoryException {
        return this.isVersioned(node) && node.isCheckedOut();
    }

    private com.sas.svcs.content.versioning.client.Version getVersionFromJCRNode(Node jcrNode, Version jcrVersion) throws RepositoryException {
        com.sas.svcs.content.versioning.client.Version ret = new com.sas.svcs.content.versioning.client.Version();
        Node frozenNode = jcrVersion.getNode("jcr:frozenNode");
        String[] jcrLabels = jcrVersion.getContainingHistory().getVersionLabels(jcrVersion);
        List<String> labels = Arrays.asList(jcrLabels);
        ret.setVersionLabels(labels);
        ret.setCreationDate(frozenNode.getProperty("sas:created").getDate().getTime());
        ret.setModifiedDate(frozenNode.getProperty("sas:lastModified").getDate().getTime());
        ret.setCreatedBy(frozenNode.getProperty("sas:createdBy").getString());
        ret.setModifiedBy(frozenNode.getProperty("sas:modifiedBy").getString());
        ret.setDescription(this.getStringProperty(frozenNode, "sas:description"));
        ret.setInternalVersion(-1L);
        ret.setName(SpecialNameChars.decode((String)jcrNode.getName()));
        ret.setId(jcrNode.getUUID());
        long typeId = frozenNode.getProperty("sas:objectType").getLong();
        ret.setObjectType(typeId);
        ret.setObjectTypeName(this.objectTypeService.getTypeById(typeId).getName());
        ret.setVersionName(jcrVersion.getName());
        ret.setVersionCreationDate(jcrVersion.getCreated().getTime());
        ret.setCheckinComment(this.getStringProperty(frozenNode, "sas:checkinComment"));
        return ret;
    }

    private class NotVersionedException
    extends RuntimeException {
    }
}

