/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.jcr;

import com.sas.framework.annotation.services.Content;
import com.sas.svcs.common.client.dao.jcr.BaseJCRDAO;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.commons.springextensions.jcr.JcrCallback;
import com.sas.svcs.content.commons.springextensions.jcr.JcrTemplate;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.navigation.client.ContainerNode;
import com.sas.svcs.content.navigation.client.NavigationNode;
import com.sas.svcs.content.navigation.spi.NodeNavigationService;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import java.io.IOException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.SpecialNameChars;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Service
@Content(objectTypes={"ContentDocument"})
public class JcrNodeNavigationService
extends BaseJCRDAO
implements NodeNavigationService {
    private static final Logger perfLogger = LogManager.getLogger((String)"perf.com.sas.svcs.common.client.dao.jcr.NodeNavigationService");
    private ObjectTypeService objectTypeService;
    private JcrTemplate template;

    @Autowired
    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }

    protected ObjectTypeService getObjectTypeService() {
        return this.objectTypeService;
    }

    @Override
    @Autowired
    public void setTemplate(JcrTemplate template) {
        this.template = template;
    }

    @Override
    protected JcrTemplate getTemplate() {
        return this.template;
    }

    protected boolean isServerConfigured(Session session) throws RepositoryException {
        try {
            session.getNamespaceURI("sas");
        }
        catch (NamespaceException e) {
            return false;
        }
        return true;
    }

    protected NavigationNode getNavigationNodeFromJcrNode(Node node, String path, ObjectType type, Session session) throws RepositoryException {
        long start = System.currentTimeMillis();
        ContentNode contentObject = new ContentNode();
        long pstart = System.currentTimeMillis();
        PropertyIterator piter = node.getProperties();
        while (piter.hasNext()) {
            Property property = piter.nextProperty();
            String propertyName = property.getName();
            if (propertyName.equals("sas:created")) {
                contentObject.setCreationDate(property.getDate().getTime());
                continue;
            }
            if (propertyName.equals("sas:lastModified")) {
                contentObject.setModifiedDate(property.getDate().getTime());
                continue;
            }
            if (propertyName.equals("sas:createdBy")) {
                contentObject.setCreatedBy(property.getString());
                continue;
            }
            if (propertyName.equals("sas:modifiedBy")) {
                contentObject.setModifiedBy(property.getString());
                continue;
            }
            if (propertyName.equals("sas:description")) {
                contentObject.setDescription(property.getString());
                continue;
            }
            if (!propertyName.equals("sas:objectType") || property.getLong() == type.getId()) continue;
            throw new RuntimeException("Fetched object doesn't match configured object type for object: " + node.getPath());
        }
        contentObject.setInternalVersion(-1L);
        contentObject.setObjectType(type.getId());
        contentObject.setObjectTypeName(type.getName());
        contentObject.setName(SpecialNameChars.decode((String)node.getName()));
        contentObject.setId(node.getUUID());
        contentObject.setPath(SpecialNameChars.decode((String)node.getPath()));
        long pend = System.currentTimeMillis();
        perfLogger.debug("Setting content object properties took " + (pend - pstart) + " milliseconds.");
        long end = System.currentTimeMillis();
        perfLogger.debug("Making content object took: " + (end - start) + " milliseconds.");
        start = System.currentTimeMillis();
        ContainerNode ret = type.isContainer() ? new ContainerNode() : new NavigationNode();
        ret.setContentObject((ContentComponent)contentObject);
        ret.setNavigationPath(path);
        Node parentNode = node.getParent();
        if (parentNode != null) {
            String parentPath = parentNode.getPath();
            if ("/".equals(parentPath)) {
                ret.setParentId(new ObjectIdentity(29L, "ROOT_FOLDER_ID"));
            } else {
                String parentId = parentNode.getUUID();
                long parentObjectType = parentNode.getProperty("sas:objectType").getLong();
                ret.setParentId(new ObjectIdentity(parentObjectType, parentId));
            }
        }
        end = System.currentTimeMillis();
        perfLogger.debug("Making Navigation Node took: " + (end - start) + " millseconds.");
        return ret;
    }

    @PostAuthorize(value="hasPermission(returnObject, 'read')")
    public NavigationNode getObjectByPath(final String path, long objectType) {
        if ("/".equals(path)) {
            return null;
        }
        final ObjectType type = this.objectTypeService.getTypeById(objectType);
        if (type == null) {
            return null;
        }
        return this.getTemplate().execute(new JcrCallback<NavigationNode>(){

            @Override
            public NavigationNode doInJcr(Session session) throws IOException, RepositoryException {
                if (!JcrNodeNavigationService.this.isServerConfigured(session)) {
                    return null;
                }
                Node node = JcrNodeNavigationService.this.getNodeByPath(path, session);
                if (node == null) {
                    return null;
                }
                return JcrNodeNavigationService.this.getNavigationNodeFromJcrNode(node, path, type, session);
            }
        });
    }

    @PreAuthorize(value="hasPermission(#objectIdentity, 'read')")
    public NavigationNode getObjectById(final ObjectIdentity objectIdentity) {
        final ObjectType type = this.objectTypeService.getTypeById(objectIdentity.getObjectType());
        if (type == null) {
            return null;
        }
        return this.getTemplate().execute(new JcrCallback<NavigationNode>(){

            @Override
            public NavigationNode doInJcr(Session session) throws IOException, RepositoryException {
                if (!JcrNodeNavigationService.this.isServerConfigured(session)) {
                    return null;
                }
                Node node = JcrNodeNavigationService.this.getNodeByObjectIdentity(objectIdentity, session);
                if (node == null) {
                    return null;
                }
                return JcrNodeNavigationService.this.getNavigationNodeFromJcrNode(node, node.getPath(), type, session);
            }
        });
    }
}

