/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.jcr;

import com.sas.svcs.content.framework.client.ContentObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JcrFileHelper {
    private static final Logger log = LogManager.getLogger(JcrFileHelper.class);

    public static void initNewNode(Node jcrNode, Calendar cal, long objectType) throws RepositoryException {
        Node cNode = jcrNode.addNode("jcr:content", "nt:resource");
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
        cNode.setProperty("jcr:data", (InputStream)bais);
        cNode.setProperty("jcr:mimeType", "");
        cNode.setProperty("jcr:lastModified", cal);
    }

    public static void populateContentObjectFromJCRNode(ContentObject contentObject, Node jcrNode) throws RepositoryException {
        Node cNode = jcrNode.getNode("jcr:content");
        contentObject.setModifiedDate(cNode.getProperty("jcr:lastModified").getDate().getTime());
    }

    public static void populateJCRNodeFromContentObject(Node jcrNode, ContentObject contentObject) throws RepositoryException {
        Node cNode = jcrNode.getNode("jcr:content");
        Calendar cal = Calendar.getInstance();
        cNode.setProperty("jcr:lastModified", cal);
    }
}

