/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.jcr;

import com.sas.commons.expr.BaseVisitor;
import com.sas.commons.expr.Expression;
import com.sas.commons.expr.ExpressionVisitor;
import com.sas.commons.expr.Function;
import com.sas.commons.expr.SimpleName;
import com.sas.commons.expr.StringExpression;
import com.sas.svcs.common.client.AttributeMapper;
import com.sas.svcs.common.client.FieldMapper;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JcrExpressionVisitor
extends BaseVisitor {
    private static Logger logger = LogManager.getLogger(JcrExpressionVisitor.class);
    private static final String OPERATOR_EQUALS = "eq";
    private static final String OPERATOR_NE = "ne";
    private static final String OPERATOR_LT = "lt";
    private static final String OPERATOR_LTE = "le";
    private static final String OPERATOR_GT = "gt";
    private static final String OPERATOR_GTE = "ge";
    private static final String OPERATOR_CONTAINS = "contains";
    private static final String OPERATOR_STARTSWITH = "startsWith";
    private static final String OPERATOR_ENDSWITH = "endsWith";
    private static final String OPERATOR_IN = "in";
    private static final String OPERATOR_AND = "and";
    private static final String OPERATOR_OR = "or";
    private static Map<String, Integer> supportedOperators = new HashMap<String, Integer>();
    private StringBuilder sb;
    private Map<String, FieldMapper> fieldMappings;

    public JcrExpressionVisitor() {
        supportedOperators.put(OPERATOR_EQUALS, 0);
        supportedOperators.put(OPERATOR_NE, 11);
        supportedOperators.put(OPERATOR_LT, 6);
        supportedOperators.put(OPERATOR_LTE, 7);
        supportedOperators.put(OPERATOR_GT, 8);
        supportedOperators.put(OPERATOR_GTE, 9);
        supportedOperators.put(OPERATOR_CONTAINS, 1);
        supportedOperators.put(OPERATOR_STARTSWITH, 2);
        supportedOperators.put(OPERATOR_ENDSWITH, 3);
        this.sb = new StringBuilder("SELECT * from [nt:davresource] as t WHERE ");
    }

    public JcrExpressionVisitor(Map<String, FieldMapper> fieldMappings) {
        this();
        this.fieldMappings = fieldMappings;
    }

    public String getSearchString() {
        return this.sb.toString();
    }

    public Expression visitSimpleName(SimpleName name) {
        return name;
    }

    public Expression visitString(StringExpression string) {
        return string;
    }

    public Expression visitFunction(Function function) {
        String name = function.getFunctionName();
        logger.trace("Starting parse of function " + name);
        if (OPERATOR_AND.equalsIgnoreCase(name)) {
            this.parseLogicalFunction(function, " and ");
        } else if (OPERATOR_OR.equalsIgnoreCase(name)) {
            this.parseLogicalFunction(function, " or ");
        } else if (OPERATOR_IN.equalsIgnoreCase(name)) {
            this.parseInFunction(function, name);
        } else if (OPERATOR_CONTAINS.equalsIgnoreCase(name)) {
            this.parseContainsFunction(function, name);
        } else if (supportedOperators.containsKey(name)) {
            this.parseArguments(function, name, name);
        } else {
            for (Expression expr : function.getArguments()) {
                expr.accept((ExpressionVisitor)this);
            }
        }
        logger.trace("finished parsing " + name);
        return function;
    }

    private void parseInFunction(Function function, String name) {
        logger.trace("Parsing in function");
        this.sb.append("(");
        this.parseArguments(function, name, OPERATOR_EQUALS, " or ");
        this.sb.append(")");
        logger.trace("finished parsing in");
    }

    private void parseContainsFunction(Function function, String name) {
        logger.trace("Parsing contains function");
        this.sb.append("(");
        this.parseArguments(function, name, OPERATOR_CONTAINS, " or ");
        this.sb.append(")");
        logger.trace("finished parsing contains");
    }

    private void parseLogicalFunction(Function function, String aggregator) {
        logger.trace("Parsing logical function " + function.getName());
        List expressions = function.getArguments();
        boolean isFirst = true;
        for (Expression expression : expressions) {
            if (!isFirst) {
                this.sb.append(aggregator);
            }
            expression.accept((ExpressionVisitor)this);
            isFirst = false;
        }
        logger.trace("finished parsing " + function.getName());
    }

    private void parseArguments(Function function, String name, String operator) {
        this.parseArguments(function, name, operator, null);
    }

    private void parseArguments(Function function, String name, String operator, String aggregator) {
        logger.trace("Parsing arguments for " + name);
        List args = function.getArguments();
        this.validateArgs(name, args);
        String key = this.decodeString(((Expression)args.get(0)).toString());
        logger.trace("key = " + key);
        int index = 0;
        LinkedHashSet<String> values = new LinkedHashSet<String>(args.size() - 1);
        for (Expression arg : args) {
            if (index++ == 0) continue;
            String value = this.decodeString(arg.toString());
            values.add(value);
        }
        FieldMapper mapper = this.fieldMappings == null ? null : this.fieldMappings.get(key);
        String fieldName = key;
        AttributeMapper am = null;
        if (mapper != null && mapper instanceof AttributeMapper) {
            am = (AttributeMapper)mapper;
            fieldName = am.getAttributeName();
        }
        boolean first = true;
        for (String value : values) {
            String actualValue;
            String string = actualValue = am == null ? value : am.getValue(value);
            if (!first) {
                this.sb.append(aggregator);
            }
            if (fieldName.indexOf(40) > -1) {
                this.sb.append(fieldName);
            } else {
                this.sb.append("[" + fieldName + "] ");
            }
            if (OPERATOR_EQUALS.equals(operator)) {
                this.sb.append(" = " + actualValue);
            } else if (OPERATOR_NE.equals(operator)) {
                this.sb.append(" != " + actualValue);
            } else if (OPERATOR_LT.equals(operator)) {
                this.sb.append(" < " + actualValue);
            } else if (OPERATOR_LTE.equals(operator)) {
                this.sb.append(" <= " + actualValue);
            } else if (OPERATOR_GT.equals(operator)) {
                this.sb.append(" > " + actualValue);
            } else if (OPERATOR_GTE.equals(operator)) {
                this.sb.append(" >= " + actualValue);
            } else if (OPERATOR_CONTAINS.equals(operator)) {
                actualValue = "'%" + actualValue.substring(1, actualValue.length() - 1) + "%'";
                this.sb.append(" like " + actualValue);
            } else if (OPERATOR_STARTSWITH.equals(operator)) {
                actualValue = "'%" + actualValue.substring(1);
                this.sb.append(" like " + actualValue);
            } else if (OPERATOR_ENDSWITH.equals(operator)) {
                actualValue = actualValue.substring(0, actualValue.length() - 1) + "%'";
                this.sb.append(" like " + actualValue);
            }
            first = false;
        }
    }

    private void validateArgs(String name, List<Expression> args) {
        if (args == null || args.size() <= 1) {
            throw new IllegalArgumentException("Invalid argument list.  Arguments must be provided for the " + name + " function.");
        }
        if (OPERATOR_NE.equalsIgnoreCase(name) && args.size() != 2) {
            throw new IllegalArgumentException("Invalid argument list.  The \"ne\" function only supports two arguments.");
        }
    }

    private String decodeString(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }
}

