/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.jcr;

import com.sas.svcs.common.client.dao.jcr.JcrFileHelper;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.content.framework.client.InvalidNameException;
import com.sas.svcs.content.framework.client.InvalidParentException;
import com.sas.svcs.content.framework.client.ValidationException;
import com.sas.svcs.content.versioning.client.CheckoutStatus;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.xml.namespace.QName;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NameParser;
import org.apache.jackrabbit.util.SpecialNameChars;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.context.SecurityContextHolder;

public class JcrContentUtils {
    private static final Logger log = LogManager.getLogger(JcrContentUtils.class);
    public static final char INVALID_CHARACTER_BACKSLASH = '\\';
    public static final char[] INVALID_CHARACTERS = new char[]{'\\', '/', ':'};
    public static final String PROPERTY_CHECKED_OUT_BY = "sas:checkedOutBy";
    public static final String PROPERTY_CHECKED_OUT_DATE = "sas:checkedOutDate";
    public static final String PROPERTY_CREATED_BY = "sas:createdBy";
    public static final String PROPERTY_MODIFIED_BY = "sas:modifiedBy";
    public static final String PROPERTY_OBJECT_TYPE = "sas:objectType";
    public static final String PROPERTY_LAST_MODIFIED = "sas:lastModified";
    public static final String PROPERTY_CREATED = "sas:created";
    public static final String PROPERTY_DESCRIPTION = "sas:description";
    public static final String PROPERTY_INTERNAL_VERSION = "sas:internalVersion";
    public static final String PROPERTY_CHECKIN_COMMENT = "sas:checkinComment";
    public static final String MIXIN_SAS_CONTENT = "mix:sasContent";
    public static final String MIXIN_PROPERTIES = "mix:properties";

    public Node getNodeByPath(String path, Session session) throws RepositoryException, PathNotFoundException {
        if (!session.itemExists(SpecialNameChars.encode((String)path))) {
            return null;
        }
        String relPath = this.getRelPath(path);
        Node node = null;
        node = relPath.length() == 0 ? session.getRootNode() : session.getRootNode().getNode(SpecialNameChars.encode((String)relPath));
        return node;
    }

    public Node getNodeByPath(String path, long objectType, Session session) throws RepositoryException, PathNotFoundException {
        Node node = this.getNodeByPath(path, session);
        if (node == null || objectType != this.getLongProperty(node, PROPERTY_OBJECT_TYPE)) {
            return null;
        }
        return node;
    }

    public String getLatestCheckedInVersion(Node node) throws RepositoryException {
        Node tmpNode = this.getVersionableNode(node);
        if (!tmpNode.isNodeType("mix:versionable")) {
            return null;
        }
        return tmpNode.getBaseVersion().getName();
    }

    public String getCheckedOutBy(Node node) throws RepositoryException {
        Node tmpNode = this.getVersionableNode(node);
        return this.getStringProperty(tmpNode, PROPERTY_CHECKED_OUT_BY);
    }

    public Date getCheckedOutDate(Node node) throws RepositoryException {
        Node tmpNode = this.getVersionableNode(node);
        return this.getDateProperty(tmpNode, PROPERTY_CHECKED_OUT_DATE);
    }

    public void setCheckedOutBy(Node node, String userid) throws RepositoryException {
        node.setProperty(PROPERTY_CHECKED_OUT_BY, userid);
    }

    public void setCheckedOutDate(Node node, Calendar date) throws RepositoryException {
        node.setProperty(PROPERTY_CHECKED_OUT_DATE, date);
    }

    public void enableVersioning(Node node, boolean checkin) throws RepositoryException {
        if (!node.isNodeType("mix:versionable")) {
            node.addMixin("mix:versionable");
            if (checkin) {
                node.save();
                node.checkin();
            } else {
                this.setCheckedOutBy(node, this.getCurrentUserId());
                this.setCheckedOutDate(node, Calendar.getInstance());
                node.save();
            }
        }
    }

    public Version getJcrVersion(Node node, String versionName) throws RepositoryException {
        if (!node.isNodeType("mix:versionable")) {
            return null;
        }
        VersionHistory vh = node.getVersionHistory();
        try {
            return vh.getVersion(versionName);
        }
        catch (VersionException e) {
            log.debug("Version not found: " + versionName + " - returning null", (Throwable)e);
            return null;
        }
    }

    public Node getNodeByObjectIdentity(ObjectIdentity id, Session session) throws RepositoryException {
        try {
            UUID.fromString(id.getId());
        }
        catch (IllegalArgumentException e) {
            log.debug("Bad UUID passed in: " + id.getId());
            return null;
        }
        Node ret = null;
        try {
            ret = session.getNodeByUUID(id.getId());
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        if (id.getObjectType() != this.getLongProperty(ret, PROPERTY_OBJECT_TYPE).longValue()) {
            return null;
        }
        return ret;
    }

    private String getCurrentUserId() {
        return SecurityContextHolder.getContext().getAuthentication().getName();
    }

    public Node getNodeForUpdateByObjectIdentity(ObjectIdentity objectId, long incomingInternalVersion, Session session) throws RepositoryException, InternalModifiedException {
        Node ret = this.getNodeByObjectIdentity(objectId, session);
        try {
            Long internalVersion;
            if (ret.isNodeType("mix:versionable")) {
                if (ret.isCheckedOut()) {
                    String checkedOutBy = this.getCheckedOutBy(ret);
                    if (!this.getCurrentUserId().equals(checkedOutBy)) {
                        throw new RuntimeException("Object can't be updated because it is checked out by another user - " + ret);
                    }
                } else {
                    throw new RuntimeException("Object is versioned and must be checked out to be updated - " + ret);
                }
            }
            if (null == (internalVersion = this.getLongProperty(ret, PROPERTY_INTERNAL_VERSION)) ? incomingInternalVersion != -1L : incomingInternalVersion != internalVersion) {
                throw new InternalModifiedException();
            }
            ret.lock(false, true);
            return ret;
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    public String getStringProperty(Node node, String propName) throws RepositoryException {
        if (node.hasProperty(propName)) {
            return node.getProperty(propName).getString();
        }
        return null;
    }

    public Long getLongProperty(Node node, String propName) throws RepositoryException {
        if (node.hasProperty(propName)) {
            return node.getProperty(propName).getLong();
        }
        return null;
    }

    public Date getDateProperty(Node node, String propName) throws RepositoryException {
        if (node.hasProperty(propName)) {
            return node.getProperty(propName).getDate().getTime();
        }
        return null;
    }

    public List<String> getStringListProperty(Node node, String propName) throws RepositoryException {
        if (node.hasProperty(propName)) {
            Value[] vals = node.getProperty(propName).getValues();
            ArrayList<String> list = new ArrayList<String>(vals.length);
            for (int i = 0; i < vals.length; ++i) {
                list.add(vals[i].getString());
            }
            return list;
        }
        return null;
    }

    public List<Date> getDateListProperty(Node node, String propName) throws RepositoryException {
        if (node.hasProperty(propName)) {
            Value[] vals = node.getProperty(propName).getValues();
            ArrayList<Date> list = new ArrayList<Date>(vals.length);
            for (int i = 0; i < vals.length; ++i) {
                list.add(vals[i].getDate().getTime());
            }
            return list;
        }
        return null;
    }

    public List<Long> getLongListProperty(Node node, String propName) throws RepositoryException {
        if (node.hasProperty(propName)) {
            Value[] vals = node.getProperty(propName).getValues();
            ArrayList<Long> list = new ArrayList<Long>(vals.length);
            for (int i = 0; i < vals.length; ++i) {
                list.add(vals[i].getLong());
            }
            return list;
        }
        return null;
    }

    public void setStringListProperty(Node node, String propName, List<String> propValues) throws RepositoryException {
        if (propValues == null) {
            node.setProperty(propName, (Value[])null);
            return;
        }
        ValueFactory factory = node.getSession().getValueFactory();
        ArrayList<Value> values = new ArrayList<Value>(propValues.size());
        for (String propValue : propValues) {
            values.add(factory.createValue(propValue));
        }
        node.setProperty(propName, values.toArray(new Value[0]));
    }

    public void setLongListProperty(Node node, String propName, List<Long> propValues) throws RepositoryException {
        if (propValues == null) {
            node.setProperty(propName, (Value[])null);
            return;
        }
        ValueFactory factory = node.getSession().getValueFactory();
        ArrayList<Value> values = new ArrayList<Value>(propValues.size());
        for (long propValue : propValues) {
            values.add(factory.createValue(propValue));
        }
        node.setProperty(propName, values.toArray(new Value[0]));
    }

    public void setDateListProperty(Node node, String propName, List<Date> propValues) throws RepositoryException {
        if (propValues == null) {
            node.setProperty(propName, (Value[])null);
            return;
        }
        ValueFactory factory = node.getSession().getValueFactory();
        ArrayList<Value> values = new ArrayList<Value>(propValues.size());
        for (Date propValue : propValues) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(propValue);
            values.add(factory.createValue(cal));
        }
        node.setProperty(propName, values.toArray(new Value[0]));
    }

    private Node getVersionableNode(Node node) throws RepositoryException, ItemNotFoundException, ValueFormatException, PathNotFoundException {
        Node tmpNode = node;
        if ("nt:frozenNode".equals(node.getPrimaryNodeType().getName())) {
            tmpNode = node.getSession().getNodeByUUID(this.getStringProperty(node, "jcr:frozenUuid"));
        }
        return tmpNode;
    }

    public CheckoutStatus getCheckoutStatus(Node node) throws RepositoryException {
        CheckoutStatus ret = new CheckoutStatus();
        Node tmpNode = this.getVersionableNode(node);
        if (tmpNode.isNodeType("mix:versionable") && tmpNode.isCheckedOut()) {
            ret.setCheckedOut(Boolean.valueOf(true));
            ret.setCheckedOutBy(this.getCheckedOutBy(tmpNode));
            ret.setCheckedOutDate(this.getCheckedOutDate(tmpNode));
        } else {
            ret.setCheckedOut(Boolean.valueOf(false));
            ret.setCheckedOutBy(null);
            ret.setCheckedOutDate(null);
        }
        return ret;
    }

    private String getRelPath(String absolutePath) {
        return absolutePath.startsWith("/") ? absolutePath.substring(1) : absolutePath;
    }

    public boolean isVersioned(Node node) throws RepositoryException {
        return node.isNodeType("mix:versionable");
    }

    public void initNewNode(Node jcrNode, Calendar cal, long objectType) throws RepositoryException {
        jcrNode.addMixin("mix:referenceable");
        jcrNode.addMixin("mix:lockable");
        jcrNode.setProperty(PROPERTY_LAST_MODIFIED, cal);
        jcrNode.setProperty(PROPERTY_CREATED, cal);
        jcrNode.setProperty(PROPERTY_CREATED_BY, this.getCurrentUserId());
        jcrNode.setProperty(PROPERTY_MODIFIED_BY, this.getCurrentUserId());
        jcrNode.setProperty(PROPERTY_OBJECT_TYPE, objectType);
    }

    public void initNewFile(Node jcrNode, Calendar cal, long objectType) throws RepositoryException {
        this.initNewNode(jcrNode, cal, objectType);
        JcrFileHelper.initNewNode(jcrNode, cal, objectType);
    }

    public void populateJCRNodeFromContentComponent(Node node, ContentComponent contentComponent) throws RepositoryException {
        Calendar cal = Calendar.getInstance();
        node.setProperty(PROPERTY_LAST_MODIFIED, cal);
        node.setProperty(PROPERTY_MODIFIED_BY, this.getCurrentUserId());
        node.setProperty(PROPERTY_DESCRIPTION, contentComponent.getDescription());
        node.setProperty(PROPERTY_INTERNAL_VERSION, contentComponent.getInternalVersion() + 1L);
    }

    public void populateJCRNodeFromContentObject(Node node, ContentObject contentObject) throws RepositoryException {
        this.populateJCRNodeFromContentComponent(node, (ContentComponent)contentObject);
    }

    public void populateJCRNodeFromContentNode(Node node, ContentNode contentNode) throws RepositoryException {
        this.populateJCRNodeFromContentObject(node, (ContentObject)contentNode);
    }

    public void populateJCRNodeFromContentNodeFile(Node node, ContentNode contentNode) throws RepositoryException {
        this.populateJCRNodeFromContentNode(node, contentNode);
        JcrFileHelper.populateJCRNodeFromContentObject(node, (ContentObject)contentNode);
    }

    public void populateJCRNodeFromContentObjectFile(Node node, ContentObject contentObject) throws RepositoryException {
        this.populateJCRNodeFromContentObject(node, contentObject);
        JcrFileHelper.populateJCRNodeFromContentObject(node, contentObject);
    }

    public Map<QName, Object> cullAttributeMap(Map<QName, Object> attrMap) {
        HashMap<QName, Object> result = new HashMap<QName, Object>();
        for (Map.Entry<QName, Object> nextEntry : attrMap.entrySet()) {
            QName key = nextEntry.getKey();
            String testKey = key.getPrefix() + ":" + key.getLocalPart();
            if (PROPERTY_CREATED.equals(testKey) || PROPERTY_CREATED_BY.equals(testKey) || PROPERTY_DESCRIPTION.equals(testKey) || PROPERTY_INTERNAL_VERSION.equals(testKey) || PROPERTY_LAST_MODIFIED.equals(testKey) || PROPERTY_MODIFIED_BY.equals(testKey) || PROPERTY_OBJECT_TYPE.equals(testKey)) continue;
            result.put(key, nextEntry.getValue());
        }
        return result;
    }

    private void populatePropertiesFromJCRNode(ContentComponent contentObject, Node node, long objectType, String objectTypeName) throws RepositoryException {
        contentObject.setCreationDate(this.getDateProperty(node, PROPERTY_CREATED));
        contentObject.setModifiedDate(this.getDateProperty(node, PROPERTY_LAST_MODIFIED));
        contentObject.setCreatedBy(this.getStringProperty(node, PROPERTY_CREATED_BY));
        contentObject.setModifiedBy(this.getStringProperty(node, PROPERTY_MODIFIED_BY));
        contentObject.setDescription(this.getStringProperty(node, PROPERTY_DESCRIPTION));
        Long internalVersion = this.getLongProperty(node, PROPERTY_INTERNAL_VERSION);
        contentObject.setInternalVersion(internalVersion != null ? internalVersion : -1L);
        Long fetchedObjectType = this.getLongProperty(node, PROPERTY_OBJECT_TYPE);
        if (fetchedObjectType == null || objectType != fetchedObjectType) {
            throw new RuntimeException("Fetched object doesn't match configured object type for object: " + node.getPath());
        }
        contentObject.setObjectType(objectType);
        contentObject.setObjectTypeName(objectTypeName);
    }

    public void populateContentComponentFromJCRVersion(ContentComponent contentComponent, Node node, Version version, long objectType, String objectTypeName) throws RepositoryException {
        Node frozenNode = version.getNode("jcr:frozenNode");
        contentComponent.setId(node.getUUID());
        contentComponent.setName(SpecialNameChars.decode((String)node.getName()));
        this.populatePropertiesFromJCRNode(contentComponent, frozenNode, objectType, objectTypeName);
    }

    public void populateContentObjectFromJCRVersion(ContentObject contentObject, Node node, Version version, long objectType, String objectTypeName) throws RepositoryException {
        this.populateContentComponentFromJCRVersion((ContentComponent)contentObject, node, version, objectType, objectTypeName);
    }

    public void populateContentNodeFromJCRVersion(ContentNode contentNode, Node node, Version version, long objectType, String objectTypeName) throws RepositoryException {
        this.populateContentObjectFromJCRVersion((ContentObject)contentNode, node, version, objectType, objectTypeName);
        contentNode.setPath(SpecialNameChars.decode((String)node.getPath()));
    }

    public void populateContentComponentFromJCRNode(ContentComponent contentComponent, Node node, long objectType, String objectTypeName) throws RepositoryException {
        contentComponent.setName(SpecialNameChars.decode((String)node.getName()));
        contentComponent.setId(node.getUUID());
        Node tmpNode = node;
        if (this.isVersioned(node) && node.isCheckedOut()) {
            String checkedOutBy = node.getProperty(PROPERTY_CHECKED_OUT_BY).getString();
            String currentUser = this.getCurrentUserId();
            if (!currentUser.equals(checkedOutBy)) {
                Version version = node.getBaseVersion();
                tmpNode = version.getNode("jcr:frozenNode");
            }
        }
        this.populatePropertiesFromJCRNode(contentComponent, tmpNode, objectType, objectTypeName);
    }

    public void populateContentObjectFromJCRNode(ContentObject contentObject, Node node, long objectType, String objectTypeName) throws RepositoryException {
        this.populateContentComponentFromJCRNode((ContentComponent)contentObject, node, objectType, objectTypeName);
    }

    public void populateContentNodeFromJCRNode(ContentNode contentNode, Node node, long objectType, String objectTypeName) throws RepositoryException {
        this.populateContentObjectFromJCRNode((ContentObject)contentNode, node, objectType, objectTypeName);
        contentNode.setPath(SpecialNameChars.decode((String)node.getPath()));
    }

    public void populateContentNodeFileFromJCRNode(ContentNode contentNode, Node node, long objectType, String objectTypeName) throws RepositoryException {
        this.populateContentNodeFromJCRNode(contentNode, node, objectType, objectTypeName);
        JcrFileHelper.populateContentObjectFromJCRNode((ContentObject)contentNode, node);
    }

    public void populateContentNodeFileFromJCRVersion(ContentNode contentNode, Node node, Version version, long objectType, String objectTypeName) throws RepositoryException {
        this.populateContentNodeFromJCRVersion(contentNode, node, version, objectType, objectTypeName);
        JcrFileHelper.populateContentObjectFromJCRNode((ContentObject)contentNode, version.getNode("jcr:frozenNode"));
    }

    public void populateContentObjectFileFromJCRNode(ContentObject contentObject, Node node, long objectType, String objectTypeName) throws RepositoryException {
        this.populateContentObjectFromJCRNode(contentObject, node, objectType, objectTypeName);
        JcrFileHelper.populateContentObjectFromJCRNode(contentObject, node);
    }

    public void populateContentObjectFileFromJCRVersion(ContentObject contentObject, Node node, Version version, long objectType, String objectTypeName) throws RepositoryException {
        this.populateContentObjectFromJCRVersion(contentObject, node, version, objectType, objectTypeName);
        JcrFileHelper.populateContentObjectFromJCRNode(contentObject, version.getNode("jcr:frozenNode"));
    }

    public void setFileContents(Node node, InputStream contents, String mimeType) throws RepositoryException {
        Node cNode = node.getNode("jcr:content");
        if (mimeType != null) {
            cNode.setProperty("jcr:mimeType", mimeType);
        }
        if (contents != null) {
            cNode.setProperty("jcr:data", contents);
        }
    }

    public boolean validateName(String name) throws ValidationException {
        try {
            NameParser.checkFormat((String)SpecialNameChars.encode((String)("prefix:" + name)));
        }
        catch (IllegalNameException ex) {
            InvalidNameException e = new InvalidNameException(ex.getLocalizedMessage(), name);
            e.setIllegalChars(INVALID_CHARACTERS);
            throw e;
        }
        if (name.indexOf(92) > -1) {
            InvalidNameException e = new InvalidNameException("Name may not contain '\\'", name);
            e.setIllegalChars(INVALID_CHARACTERS);
            throw e;
        }
        return true;
    }

    public boolean validateContainer(String name, long objectType, ObjectIdentity parent) throws ValidationException {
        if (parent.getObjectType() != 79L) {
            throw new InvalidParentException(name, objectType, parent.getObjectType());
        }
        return true;
    }

    public static class InternalModifiedException
    extends RuntimeException {
    }
}

