/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.jcr;

import com.sas.svcs.common.client.dao.ContentObjectDAO;
import com.sas.svcs.common.client.dao.jcr.BaseContentJCRDAO;
import com.sas.svcs.content.commons.springextensions.jcr.JcrCallback;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.content.framework.client.ObjectExistsException;
import com.sas.svcs.content.framework.client.ValidationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class JcrContentObjectDAO<T extends ContentObject>
extends BaseContentJCRDAO<T>
implements ContentObjectDAO<T> {
    private static final Logger log = LogManager.getLogger(JcrContentObjectDAO.class);
    private String basePath;
    private boolean versionOnCreate = false;

    public JcrContentObjectDAO(Class<T> contentClazz, long objectType, String objectTypeName, String jcrTypeName) {
        super(contentClazz, objectType, objectTypeName, jcrTypeName);
    }

    public JcrContentObjectDAO(Class<T> contentClazz, long objectType, String objectTypeName, String jcrTypeName, boolean versionOnCreate) {
        super(contentClazz, objectType, objectTypeName, jcrTypeName);
        this.versionOnCreate = versionOnCreate;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath.startsWith("/") ? basePath.substring(1) : basePath;
    }

    protected String getBasePath() {
        return this.basePath;
    }

    private String getAbsoluteBasePath() {
        return "/" + this.getBasePath();
    }

    protected Node getBaseFolder(Session session) throws RepositoryException {
        return session.getRootNode().getNode(this.basePath);
    }

    public T create(T object) throws ObjectExistsException {
        try {
            return (T)((ContentObject)this.getSASJcrTemplate().create(this.getAbsoluteBasePath(), object, object.getName(), this.getJcrTypeName(), this.versionOnCreate, this.getCreateMapper()));
        }
        catch (ValidationException e) {
            log.error("Validation exception", (Throwable)e);
            throw new RuntimeException("Validation exception: " + e.getMessage());
        }
    }

    @Override
    public List<T> findAll() {
        return (List)this.getTemplate().execute(new JcrCallback<List<T>>(){

            @Override
            public List<T> doInJcr(Session session) throws IOException, RepositoryException {
                Node parentNode = JcrContentObjectDAO.this.getBaseFolder(session);
                ArrayList ret = new ArrayList();
                NodeIterator kids = parentNode.getNodes();
                while (kids.hasNext()) {
                    Node kid = kids.nextNode();
                    if (kid.getProperty("sas:objectType").getLong() != JcrContentObjectDAO.this.getObjectType()) continue;
                    ret.add(JcrContentObjectDAO.this.getMapper().mapFromJcrNode(kid));
                }
                return ret;
            }
        });
    }
}

