/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.jcr;

import com.sas.svcs.common.client.dao.jcr.JcrContentUtils;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.commons.springextensions.jcr.JcrTemplate;
import com.sas.svcs.content.versioning.client.CheckoutStatus;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.version.Version;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseJCRDAO {
    private static final Logger log = LogManager.getLogger(BaseJCRDAO.class);
    public static final String PROPERTY_CHECKED_OUT_BY = "sas:checkedOutBy";
    public static final String PROPERTY_CHECKED_OUT_DATE = "sas:checkedOutDate";
    public static final String PROPERTY_CREATED_BY = "sas:createdBy";
    public static final String PROPERTY_MODIFIED_BY = "sas:modifiedBy";
    public static final String PROPERTY_OBJECT_TYPE = "sas:objectType";
    public static final String PROPERTY_LAST_MODIFIED = "sas:lastModified";
    public static final String PROPERTY_CREATED = "sas:created";
    public static final String PROPERTY_DESCRIPTION = "sas:description";
    public static final String PROPERTY_INTERNAL_VERSION = "sas:internalVersion";
    public static final String PROPERTY_CHECKIN_COMMENT = "sas:checkinComment";
    public static final String MIXIN_SAS_CONTENT = "mix:sasContent";
    public static final String MIXIN_PROPERTIES = "mix:properties";
    private JcrTemplate template;
    private JcrContentUtils jcrUtils = new JcrContentUtils();

    @Autowired
    public void setTemplate(JcrTemplate template) {
        this.template = template;
    }

    protected JcrTemplate getTemplate() {
        return this.template;
    }

    protected JcrContentUtils getJcrContentUtils() {
        return this.jcrUtils;
    }

    protected Session getSession() {
        try {
            return this.getTemplate().getSessionFactory().getSession();
        }
        catch (RepositoryException e) {
            log.error("Error getting jcr session", (Throwable)e);
            throw new RuntimeException("Error getting jcr session - " + e.getMessage());
        }
    }

    protected Node getNodeByPath(String path, Session session) throws RepositoryException, PathNotFoundException {
        return this.jcrUtils.getNodeByPath(path, session);
    }

    protected String getRelPath(String absolutePath) {
        return absolutePath.startsWith("/") ? absolutePath.substring(1) : absolutePath;
    }

    protected boolean isVersioned(Node node) throws RepositoryException {
        return this.jcrUtils.isVersioned(node);
    }

    protected CheckoutStatus getCheckoutStatus(Node node) throws RepositoryException {
        return this.jcrUtils.getCheckoutStatus(node);
    }

    protected String getLatestCheckedInVersion(Node node) throws RepositoryException {
        return this.jcrUtils.getLatestCheckedInVersion(node);
    }

    protected String getCheckedOutBy(Node node) throws RepositoryException {
        return this.jcrUtils.getCheckedOutBy(node);
    }

    protected Date getCheckedOutDate(Node node) throws RepositoryException {
        return this.jcrUtils.getCheckedOutDate(node);
    }

    protected Property setCheckedOutBy(Node node, String userid) throws RepositoryException {
        this.jcrUtils.setCheckedOutBy(node, userid);
        if (node.hasProperty(PROPERTY_CHECKED_OUT_BY)) {
            return node.getProperty(PROPERTY_CHECKED_OUT_BY);
        }
        return null;
    }

    protected void setCheckedOutDate(Node node, Calendar date) throws RepositoryException {
        this.jcrUtils.setCheckedOutDate(node, date);
    }

    protected void enableVersioning(Node node, boolean checkin) throws RepositoryException {
        this.jcrUtils.enableVersioning(node, checkin);
    }

    protected Version getJcrVersion(Node node, String versionName) throws RepositoryException, UnsupportedRepositoryOperationException {
        return this.jcrUtils.getJcrVersion(node, versionName);
    }

    protected Node getNodeByObjectIdentity(ObjectIdentity id, Session session) throws RepositoryException {
        return this.jcrUtils.getNodeByObjectIdentity(id, session);
    }

    protected List<String> getStringList(Value[] vals) throws RepositoryException {
        ArrayList<String> list = new ArrayList<String>(vals.length);
        for (int i = 0; i < vals.length; ++i) {
            list.add(vals[i].getString());
        }
        return list;
    }

    protected List<Date> getDateList(Value[] vals) throws RepositoryException {
        ArrayList<Date> list = new ArrayList<Date>(vals.length);
        for (int i = 0; i < vals.length; ++i) {
            list.add(vals[i].getDate().getTime());
        }
        return list;
    }

    protected List<Long> getLongList(Value[] vals) throws RepositoryException {
        ArrayList<Long> list = new ArrayList<Long>(vals.length);
        for (int i = 0; i < vals.length; ++i) {
            list.add(vals[i].getLong());
        }
        return list;
    }

    protected String getStringProperty(Node node, String propName) throws RepositoryException {
        return this.jcrUtils.getStringProperty(node, propName);
    }

    protected Long getLongProperty(Node node, String propName) throws RepositoryException {
        return this.jcrUtils.getLongProperty(node, propName);
    }

    protected Date getDateProperty(Node node, String propName) throws RepositoryException {
        return this.jcrUtils.getDateProperty(node, propName);
    }

    @Deprecated
    protected List<String> getStringListProprety(Node node, String propName) throws RepositoryException {
        return this.jcrUtils.getStringListProperty(node, propName);
    }

    protected List<String> getStringListProperty(Node node, String propName) throws RepositoryException {
        return this.jcrUtils.getStringListProperty(node, propName);
    }

    protected List<Date> getDateListProperty(Node node, String propName) throws RepositoryException {
        return this.jcrUtils.getDateListProperty(node, propName);
    }

    protected List<Long> getLongListProperty(Node node, String propName) throws RepositoryException {
        return this.jcrUtils.getLongListProperty(node, propName);
    }

    protected void setStringListProperty(Node node, String propName, List<String> propValues) throws RepositoryException {
        this.jcrUtils.setStringListProperty(node, propName, propValues);
    }

    protected void setLongListProperty(Node node, String propName, List<Long> propValues) throws RepositoryException {
        this.jcrUtils.setLongListProperty(node, propName, propValues);
    }

    protected void setDateListProperty(Node node, String propName, List<Date> propValues) throws RepositoryException {
        this.jcrUtils.setDateListProperty(node, propName, propValues);
    }
}

