/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.jcr;

import com.sas.services.security.login.OMIServerPrincipal;
import com.sas.services.security.login.PFSPrincipal;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.authentication.helper.UserSessionFactory;
import java.rmi.RemoteException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminChecker {
    private static final Logger log = LogManager.getLogger(AdminChecker.class);
    private UserSessionFactory userSessionFactory;

    @Autowired
    public void setUserSessionFactory(UserSessionFactory userSessionFactory) {
        this.userSessionFactory = userSessionFactory;
    }

    public boolean isAdmin() {
        try {
            UserContextInterface user = this.userSessionFactory.getLocalUser();
            for (Object obj : user.getPrincipals()) {
                PFSPrincipal principal;
                if (!(obj instanceof PFSPrincipal) || !((principal = (PFSPrincipal)obj) instanceof OMIServerPrincipal)) continue;
                OMIServerPrincipal omiPrincipal = (OMIServerPrincipal)principal;
                String[] keywords = omiPrincipal.getUserClass().split(",");
                for (int idx = 0; idx < keywords.length; ++idx) {
                    String perm = keywords[idx].trim();
                    if (!perm.equalsIgnoreCase("Unrestricted") && !perm.equalsIgnoreCase("Trusted")) continue;
                    return true;
                }
            }
        }
        catch (RemoteException e) {
            log.error("Can't get session context for current user", (Throwable)e);
            throw new RuntimeException("Can't get session context for current user: " + e.getMessage());
        }
        return false;
    }
}

