/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.omrclient;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class DAVCredentialsHelper {
    private static final String REPOSITORY_CONTENT_MAPPING = "Report Repository Content Mapping";
    private static final String DAV_URI_TYPE = "DAV";

    public static boolean credentialsSecured(MetadataInterface metadataObj) throws ServiceException, RemoteException {
        Document doc;
        FolderInterface folder = metadataObj instanceof FolderInterface ? (FolderInterface)metadataObj : metadataObj.getParent();
        if (folder == null) {
            return false;
        }
        try {
            doc = DAVCredentialsHelper.getContentInfoDoc(folder);
        }
        catch (IllegalStateException ex) {
            doc = null;
        }
        return DAVCredentialsHelper.credentialsSecured(metadataObj.getRepository().getUserContext(), doc);
    }

    public static boolean credentialsSecured(UserContextInterface userContext) throws ServiceException, RemoteException {
        Document doc = null;
        for (FolderInterface folder : userContext.getAuthServer().getRootFolder().getSubfolders()) {
            try {
                doc = DAVCredentialsHelper.getContentInfoDoc(folder);
            }
            catch (IllegalStateException ex) {
                doc = null;
            }
            if (doc == null) continue;
            break;
        }
        return DAVCredentialsHelper.credentialsSecured(userContext, doc);
    }

    private static boolean credentialsSecured(UserContextInterface userContext, Document doc) throws ServiceException, RemoteException {
        if (doc == null) {
            return false;
        }
        String uri = doc.getURI();
        if (uri == null || uri.length() == 0) {
            return false;
        }
        String uriType = doc.getURIType();
        if (!DAV_URI_TYPE.equals(uriType)) {
            return false;
        }
        TextStore ts = DAVCredentialsHelper.getAuthenticationTextStore(doc);
        if (ts != null) {
            return false;
        }
        MetadataServerInterface server = (MetadataServerInterface)userContext.getAuthServer();
        int count = DAVCredentialsHelper.getAuthenticationTextStoreCount(server, doc);
        return count > 0;
    }

    private static int getAuthenticationTextStoreCount(MetadataServerInterface server, Document doc) throws RemoteException, ServiceException {
        String docName = doc.getName();
        String xmlSelect = "<XMLSelect search=\"TextStore[@Name='" + docName + "'][Objects/Document[@Id='" + doc.getId() + "']]\"/>";
        Filter filter = new Filter();
        filter.setExplicitSearchString("omi", xmlSelect);
        filter.setType("TextStore");
        return server.getCountNoSecurity(filter, null);
    }

    private static Document getContentInfoDoc(FolderInterface folder) throws IllegalArgumentException, ServiceException, RemoteException {
        PathUrl myPath = folder.getPathUrl();
        if (myPath == null) {
            return null;
        }
        String rootFolderName = myPath.getRootTree();
        ServerInterface server = folder.getRepository().getServer();
        RootFolderInterface serverRoot = server.getRootFolder();
        try {
            FolderInterface rootFolder = serverRoot.getSubfolder(rootFolderName);
            Tree rootFolderMdObj = null;
            if (rootFolder != null) {
                rootFolderMdObj = (Tree)rootFolder.getRepositoryEntity();
            }
            if (rootFolderMdObj == null) {
                throw new IllegalStateException(Message.format((ResourceBundle)RB.getResources(), (String)"Folder.noMatchForRoot.ex.fmt.txt", (Object)myPath.toString()));
            }
            AssociationList rootDocList = rootFolderMdObj.getDocuments();
            Document contentInfoDoc = DAVCredentialsHelper.getContentInfoDocFromList((List)rootDocList, rootFolderName);
            if (contentInfoDoc != null) {
                return contentInfoDoc;
            }
            SoftwareComponent sc = (SoftwareComponent)serverRoot.getRepositoryEntity();
            AssociationList scDocList = sc.getDocuments();
            contentInfoDoc = DAVCredentialsHelper.getContentInfoDocFromList((List)scDocList, rootFolderName);
            if (contentInfoDoc == null && (contentInfoDoc = DAVCredentialsHelper.getContentInfoDocFromList((List)scDocList, REPOSITORY_CONTENT_MAPPING)) == null) {
                return null;
            }
            return contentInfoDoc;
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e, e.getMessage());
        }
        catch (ServiceException e) {
            throw new ServiceException((Throwable)e, e.getMessage());
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e, e.getMessage());
        }
    }

    private static Document getContentInfoDocFromList(List list, String docName) throws RemoteException {
        Document contentInfoDoc = null;
        Iterator docItor = list.iterator();
        while (contentInfoDoc == null && docItor.hasNext()) {
            Document doc = (Document)docItor.next();
            if (!doc.getName().equals(docName)) continue;
            contentInfoDoc = doc;
        }
        return contentInfoDoc;
    }

    private static TextStore getAuthenticationTextStore(Document doc) throws ServiceException {
        try {
            String nameToMatch = doc.getName();
            AssociationList noteList = doc.getNotes();
            for (TextStore textStore : noteList) {
                String tsName = textStore.getName();
                if (!nameToMatch.equals(tsName)) continue;
                return textStore;
            }
            return null;
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e, e.getMessage());
        }
    }
}

