/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.xml;

import java.util.Stack;
import org.apache.geode.cache.CacheXmlException;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.xml.LuceneIndexCreation;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.extension.Extension;
import org.apache.geode.internal.cache.xmlcache.AbstractXmlParser;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.cache.xmlcache.CacheXmlParser;
import org.apache.geode.internal.cache.xmlcache.RegionCreation;
import org.apache.lucene.analysis.Analyzer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LuceneXmlParser
extends AbstractXmlParser {
    private CacheCreation cache;

    public String getNamespaceUri() {
        return "http://geode.apache.org/schema/lucene";
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!"http://geode.apache.org/schema/lucene".equals(uri)) {
            return;
        }
        if ("index".equals(localName)) {
            this.startIndex(atts);
        }
        if ("field".equals(localName)) {
            this.startField(atts);
        }
        if ("serializer".equals(localName)) {
            this.startSerializer(atts);
        }
    }

    private void startSerializer(Attributes atts) {
        if (this.stack.peek() instanceof StringBuilder) {
            this.stack.pop();
        }
        if (!(this.stack.peek() instanceof LuceneIndexCreation)) {
            throw new CacheXmlException("lucene <serializer> elements must occur within lucene <index> elements");
        }
        LuceneIndexCreation creation = (LuceneIndexCreation)this.stack.peek();
    }

    private void startField(Attributes atts) {
        if (this.stack.peek() instanceof StringBuilder) {
            this.stack.pop();
        }
        if (!(this.stack.peek() instanceof LuceneIndexCreation)) {
            throw new CacheXmlException("lucene <field> elements must occur within lucene <index> elements");
        }
        LuceneIndexCreation creation = (LuceneIndexCreation)this.stack.peek();
        String name = atts.getValue("name");
        String className = atts.getValue("analyzer");
        if (className == null) {
            creation.addField(name);
        } else {
            Analyzer analyzer = this.createAnalyzer(className);
            creation.addFieldAndAnalyzer(name, analyzer);
        }
    }

    private void startIndex(Attributes atts) {
        if (!(this.stack.peek() instanceof RegionCreation)) {
            throw new CacheXmlException("lucene <index> elements must occur within <region> elements");
        }
        RegionCreation region = (RegionCreation)this.stack.peek();
        String name = atts.getValue("name");
        LuceneIndexCreation indexCreation = new LuceneIndexCreation();
        indexCreation.setName(name);
        indexCreation.setRegion((Region)region);
        region.getExtensionPoint().addExtension((Extension)indexCreation);
        this.stack.push(indexCreation);
        this.cache = (CacheCreation)region.getCache();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!"http://geode.apache.org/schema/lucene".equals(uri)) {
            return;
        }
        if ("index".equals(localName)) {
            this.endIndex();
        }
        if ("serializer".equals(localName)) {
            this.endSerializer();
        }
    }

    private void endIndex() {
        if (this.stack.peek() instanceof StringBuilder) {
            this.stack.pop();
        }
        this.stack.pop();
    }

    private void endSerializer() {
        Declarable d = CacheXmlParser.createDeclarable((CacheCreation)this.cache, (Stack)this.stack);
        if (!(d instanceof LuceneSerializer)) {
            throw new CacheXmlException(d.getClass().getName() + " is not an instance of LuceneSerializer");
        }
        LuceneIndexCreation indexCreation = (LuceneIndexCreation)this.stack.peek();
        indexCreation.setLuceneSerializer((LuceneSerializer)d);
    }

    private Analyzer createAnalyzer(String className) {
        Object obj;
        try {
            Class c = InternalDataSerializer.getCachedClass((String)className);
            obj = c.newInstance();
        }
        catch (Exception ex) {
            throw new CacheXmlException(String.format("While instantiating a %s", className), (Throwable)ex);
        }
        if (!(obj instanceof Analyzer)) {
            throw new CacheXmlException(String.format("Class %s is not an instance of Analyzer.", className));
        }
        return (Analyzer)obj;
    }
}

