/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.xml.data;

import com.sas.graphics.xml.GraphParser;
import com.sas.graphics.xml.GraphParserUtils;
import com.sas.graphics.xml.data.FormatStruct;
import com.sas.graphics.xml.data.Mapping;
import java.io.StringReader;
import org.w3c.dom.Element;

public class FormatParser {
    public static void parse(String formats) {
        if (formats == null || formats.trim().length() == 0) {
            return;
        }
        Element root = GraphParser.getElement(new StringReader(formats));
        int index = 1;
        Element format = null;
        while ((format = GraphParserUtils.getChildWithTagName("Format", root, index++)) != null) {
            FormatParser.parseFormat(format, new FormatStruct());
        }
    }

    private static void parseFormat(Element format, FormatStruct fmt) {
        Element nameOptions;
        String name = format.getAttribute("name");
        if (name == null || name.length() == 0) {
            return;
        }
        fmt.name = name;
        Element type = GraphParserUtils.getChildWithTagName("Type", format);
        if (type != null) {
            String typ = GraphParserUtils.getElementText(type).trim();
            if (typ.equalsIgnoreCase("Picture")) {
                fmt.setValueFormat = false;
            } else if (typ.equalsIgnoreCase("Value")) {
                fmt.setValueFormat = true;
            }
        }
        if ((nameOptions = GraphParserUtils.getChildWithTagName("Name-Options", format)) != null) {
            String defaultWidth;
            String max;
            String min = nameOptions.getAttribute("min");
            if (min != null && min.length() > 0) {
                fmt.min = min;
            }
            if ((max = nameOptions.getAttribute("max")) != null && max.length() > 0) {
                fmt.max = max;
            }
            if ((defaultWidth = nameOptions.getAttribute("default")) != null && defaultWidth.length() > 0) {
                fmt.defaultWidth = defaultWidth;
            }
            fmt.round = GraphParserUtils.getBooleanValue(nameOptions.getAttribute("round"));
            fmt.notsorted = GraphParserUtils.getBooleanValue(nameOptions.getAttribute("notSorted"));
        }
        Element mapping = null;
        int index = 1;
        while ((mapping = GraphParserUtils.getChildWithTagName("Mapping", format, index)) != null) {
            FormatParser.parseMapping(mapping, fmt);
            ++index;
        }
        fmt.registerFormat();
    }

    private static void parseMapping(Element mapping, FormatStruct fmt) {
        Element label;
        Element range;
        Mapping currentMapping = new Mapping();
        Element labelOptions = GraphParserUtils.getChildWithTagName("Label-Options", mapping);
        if (labelOptions != null) {
            currentMapping.fill = labelOptions.getAttribute("fill");
            if (currentMapping.fill != null && currentMapping.fill.equalsIgnoreCase("00x")) {
                currentMapping.fill = " ";
            }
            currentMapping.mult = GraphParserUtils.getDoubleValue(labelOptions.getAttribute("mult"));
            currentMapping.prefix = labelOptions.getAttribute("prefix");
            currentMapping.noEdit = GraphParserUtils.getBooleanValue(labelOptions.getAttribute("noEdit"));
        }
        if ((range = GraphParserUtils.getChildWithTagName("Range", mapping)) != null) {
            currentMapping.range = GraphParserUtils.getElementText(range).trim();
        }
        if ((label = GraphParserUtils.getChildWithTagName("Label", mapping)) != null) {
            currentMapping.label = GraphParserUtils.convertValidXMLString(GraphParserUtils.getElementText(label).trim());
        }
        if (!fmt.setValueFormat) {
            currentMapping.buildPictureOptions();
        }
        fmt.addMapping(currentMapping);
    }
}

