/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.xml;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.util.ColorParse;
import com.sas.graphics.util.DisplayNumber;
import com.sas.graphics.xml.GraphParser;
import java.awt.Color;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class GraphParserUtils {
    private static final int TYPE_ANY = 0;
    private static final int TYPE_LIST = 1;
    private static final int TYPE_BOOLEAN = 2;
    private static final int TYPE_INTEGER = 3;
    private static final int TYPE_DOUBLE = 4;
    private static final int TYPE_COLOR = 5;
    private static final int TYPE_CONTEXT = 6;
    private static final int TYPE_ARRAY_DOUBLE = 7;
    private static final int TYPE_ARRAY_INT = 8;
    private static final int TYPE_ARRAY_BOOLEAN = 9;

    public static String getDataID(String str) {
        if (str == null || str.indexOf(46) < 0 && str.indexOf(35) < 0) {
            return str;
        }
        if (str.indexOf(35) > 0) {
            return str.substring(0, str.indexOf(35));
        }
        if (str.indexOf(46) > 0) {
            return str.substring(0, str.indexOf(46));
        }
        return str;
    }

    public static Object getDataFromContext(Hashtable context, String name) {
        if (context.get(name) != null) {
            return context.get(name);
        }
        SourceInterface di = GraphParser.getDataRepository(context);
        if (di != null) {
            return di.getDataSource(name);
        }
        return null;
    }

    public static String getVariableID(String str) {
        if (str == null || str.indexOf(46) < 0 && str.indexOf(35) < 0) {
            return str;
        }
        if (str.indexOf(35) > 0) {
            return str.substring(str.indexOf(35) + 1, str.length());
        }
        if (str.indexOf(46) > 0) {
            return str.substring(str.indexOf(46) + 1, str.length());
        }
        return str;
    }

    public static String buildValidXMLString(String invalidString) {
        return GraphParserUtils.buildValidXMLString(invalidString, false);
    }

    public static String buildValidXMLString(String invalidString, boolean cleanString) {
        if (!cleanString) {
            return invalidString;
        }
        String rc = "";
        for (int i = 0; i < invalidString.length(); ++i) {
            char ch = invalidString.charAt(i);
            rc = ch == '<' ? rc + "&#60;" : (ch == '>' ? rc + "&#62;" : (ch == '&' ? rc + "&#38;" : (ch == '\'' ? rc + "&#39;" : (ch == '\"' ? rc + "&#34;" : rc + ch))));
        }
        return rc;
    }

    public static String convertValidXMLString(String validString) {
        String rc = "";
        rc = validString.replaceAll("&#60;", "<");
        rc = rc.replaceAll("&#62;", ">");
        rc = rc.replaceAll("&#38;", "&");
        rc = rc.replaceAll("&#39;", "'");
        rc = rc.replaceAll("&apos;", "'");
        rc = rc.replaceAll("&#34;", "\"");
        return rc;
    }

    public static boolean getBooleanValue(String value) {
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on");
    }

    public static int getIntValue(String value) {
        int rc = -1;
        try {
            rc = Double.valueOf(value.trim()).intValue();
        }
        catch (Exception e) {
            rc = -1;
        }
        return rc;
    }

    public static double getDoubleValue(String value) {
        double rc = Double.NaN;
        try {
            rc = Double.valueOf(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rc;
    }

    public static String getElementText(Element element) {
        NodeList list = element.getChildNodes();
        String rc = "";
        for (int i = 0; i < list.getLength(); ++i) {
            rc = rc + list.item(i).getNodeValue();
        }
        return rc;
    }

    public static Element getChildWithTagName(String name, Element parent) {
        return GraphParserUtils.getChildWithTagName(name, parent, 1);
    }

    public static Element getChildWithTagName(String name, Element parent, int which) {
        NodeList children = parent.getChildNodes();
        int num = children.getLength();
        int numSeen = 0;
        for (int i = 0; i < num; ++i) {
            Element e;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(e = (Element)child).getTagName().equalsIgnoreCase(name) || ++numSeen != which) continue;
            return e;
        }
        return null;
    }

    public static String[] parseStringArray(String string, String seperator) {
        StringTokenizer st = new StringTokenizer(string, seperator);
        String[] rc = new String[st.countTokens()];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = st.nextToken();
        }
        return rc;
    }

    public static int[] parseIntArray(String s) {
        String[] strs = GraphParserUtils.parseStringArray(s, ",");
        int[] rc = new int[strs.length];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = GraphParserUtils.getIntValue(strs[i]);
        }
        return rc;
    }

    public static Color[] parseColorArray(String s) {
        String[] strs = GraphParserUtils.parseStringArray(s, ",");
        Color[] colors = new Color[strs.length];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = ColorParse.getColorFromString(strs[i]);
        }
        return colors;
    }

    public static String getNameForDataObject(Object data, Hashtable context) {
        Object source;
        String rc = "NONE";
        if (context != null) {
            Enumeration keys = context.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (!context.get(key).equals(data)) continue;
                return key.toString();
            }
        }
        DataFilterReadInterface dfri = FilterFactory.getDataSourceFilter(data);
        for (source = dfri; source != null && source instanceof DataFilterReadInterface && source != source.getSource(); source = source.getSource()) {
        }
        FilterFactory.detachFilter(dfri);
        if (source != null) {
            rc = "Data_" + source.hashCode();
        }
        return rc;
    }

    public static String getString(Object obj) {
        String rc = "";
        if (obj == null) {
            return rc;
        }
        rc = obj instanceof Color ? "CX" + ColorParse.getColorStrg((Color)obj, false) : (obj instanceof DisplayNumber ? GraphParserUtils.buildValidXMLString(((DisplayNumber)obj).getEnglishName()) : (obj instanceof double[] || obj instanceof int[] || obj instanceof boolean[] || obj instanceof Object[] ? GraphParserUtils.buildValidXMLString(GraphParserUtils.arrayToString(obj)) : (obj instanceof Element ? GraphParserUtils.buildValidXMLString(GraphParserUtils.toString((Element)obj)) : GraphParserUtils.buildValidXMLString(obj.toString()))));
        return rc;
    }

    protected static Object validateAndConvert(Object valids, String target, Hashtable context) {
        String s;
        int validType = 0;
        validType = valids == null ? 0 : (valids instanceof String ? ((s = (String)valids).equalsIgnoreCase("%BOOLEAN") ? 2 : (s.equalsIgnoreCase("%INTEGER") ? 3 : (s.equalsIgnoreCase("%DOUBLE") ? 4 : (s.equalsIgnoreCase("%COLOR") ? 5 : (s.equalsIgnoreCase("%CONTEXT") ? 6 : (s.equalsIgnoreCase("%ARRAY:%DOUBLE") ? 7 : (s.equalsIgnoreCase("%ARRAY:%INT") ? 8 : (s.equalsIgnoreCase("%ARRAY:%BOOLEAN") ? 9 : (s.startsWith("[") ? 1 : 0))))))))) : 0);
        Object rc = null;
        switch (validType) {
            case 0: {
                rc = target;
                break;
            }
            case 1: {
                String array = valids.toString().substring(1, valids.toString().indexOf(93));
                String[] validValues = GraphParserUtils.parseStringArray(array, ",");
                for (int i = 0; i < validValues.length; ++i) {
                    if (!validValues[i].trim().equalsIgnoreCase(target.trim())) continue;
                    String type = valids.toString().substring(valids.toString().indexOf(93));
                    rc = GraphParserUtils.validateAndConvert(type, target, context);
                }
                break;
            }
            case 3: {
                rc = new Integer(GraphParserUtils.getIntValue(target));
                break;
            }
            case 4: {
                rc = new Double(GraphParserUtils.getDoubleValue(target));
                break;
            }
            case 5: {
                rc = ColorParse.getColorFromString(target);
                break;
            }
            case 2: {
                rc = new Boolean(GraphParserUtils.getBooleanValue(target));
                break;
            }
            case 6: {
                rc = context.get(target);
                break;
            }
            case 7: {
                String[] values = GraphParserUtils.parseStringArray(target, ",");
                if (values == null) break;
                double[] d = new double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    d[i] = GraphParserUtils.getDoubleValue(values[i]);
                }
                rc = d;
                break;
            }
            case 8: {
                String[] values = GraphParserUtils.parseStringArray(target, ",");
                if (values == null) break;
                int[] n = new int[values.length];
                for (int i = 0; i < values.length; ++i) {
                    n[i] = GraphParserUtils.getIntValue(values[i]);
                }
                rc = n;
                break;
            }
            case 9: {
                String[] values = GraphParserUtils.parseStringArray(target, ",");
                if (values == null) break;
                boolean[] b = new boolean[values.length];
                for (int i = 0; i < values.length; ++i) {
                    b[i] = GraphParserUtils.getBooleanValue(values[i]);
                }
                rc = b;
            }
        }
        return rc;
    }

    public static Hashtable parseMetaData(Element element) {
        Element e = GraphParserUtils.getChildWithTagName("Meta", element);
        if (e == null) {
            return null;
        }
        Hashtable<String, String> rc = new Hashtable<String, String>();
        NamedNodeMap map = e.getAttributes();
        Node n = null;
        int i = 0;
        while ((n = map.item(i)) != null) {
            if (n.getNodeType() != 2) continue;
            Attr attr = (Attr)n;
            rc.put(attr.getName(), attr.getValue());
            ++i;
        }
        return rc;
    }

    public static Element newElement(Hashtable context, String name) {
        Document doc = null;
        Element rc = null;
        if (context == null || context.get("XML_DOCUMENT") == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = factory.newDocumentBuilder();
                doc = db.newDocument();
                context.put("XML_DOCUMENT", doc);
                rc = doc.createElement(name);
            }
            catch (ParserConfigurationException pce) {
                pce.printStackTrace();
            }
        } else {
            doc = (Document)context.get("XML_DOCUMENT");
            rc = doc.createElement(name);
        }
        return rc;
    }

    public static Text newTextNode(Hashtable context, String name) {
        Document doc = null;
        Text rc = null;
        if (context == null || context.get("XML_DOCUMENT") == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = factory.newDocumentBuilder();
                doc = db.newDocument();
                rc = doc.createTextNode(name);
            }
            catch (ParserConfigurationException pce) {
                pce.printStackTrace();
            }
        } else {
            doc = (Document)context.get("XML_DOCUMENT");
            rc = doc.createTextNode(name);
        }
        return rc;
    }

    public static String toString(Node node) {
        return GraphParserUtils.toString(node, false);
    }

    public static String toString(Node node, boolean xmlDeclaration) {
        Transformer transformer;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
            Properties p = new Properties();
            p.setProperty("indent", "yes");
            if (!xmlDeclaration) {
                p.setProperty("omit-xml-declaration", "yes");
            }
            transformer.setOutputProperties(p);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
            return null;
        }
        DOMSource src = new DOMSource(node);
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        try {
            transformer.transform(src, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return null;
        }
        return sw.toString();
    }

    public static String arrayToString(Object o) {
        StringBuffer sb;
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (o == null) {
                            return null;
                        }
                        sb = new StringBuffer();
                        if (!(o instanceof double[])) break block5;
                        double[] d = (double[])o;
                        for (int i = 0; i < d.length; ++i) {
                            sb.append(Double.toString(d[i]));
                            if (i == d.length - 1) continue;
                            sb.append(",");
                        }
                        break block6;
                    }
                    if (!(o instanceof int[])) break block7;
                    int[] n = (int[])o;
                    for (int i = 0; i < n.length; ++i) {
                        sb.append(Integer.toString(n[i]));
                        if (i == n.length - 1) continue;
                        sb.append(",");
                    }
                    break block6;
                }
                if (!(o instanceof boolean[])) break block8;
                boolean[] b = (boolean[])o;
                for (int i = 0; i < b.length; ++i) {
                    sb.append(Boolean.toString(b[i]));
                    if (i == b.length - 1) continue;
                    sb.append(",");
                }
                break block6;
            }
            if (!(o instanceof Object[])) break block6;
            Object[] oa = (Object[])o;
            for (int i = 0; i < oa.length; ++i) {
                if (oa[i] == null) continue;
                sb.append(oa[i].toString());
                if (i == oa.length - 1) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }
}

