/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.xml;

import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.xml.data.DataValueParserInterface;
import java.util.Enumeration;
import java.util.Properties;

public class GraphParserFactory {
    public static final boolean printDebugMessages = false;
    protected static Properties parsers = new Properties();
    protected static Properties dataValueParsers = new Properties();
    protected static Properties outParsers = new Properties();
    public static final int PARSER_LOOKUP = 0;
    public static final int REVERSE_PARSER_LOOKUP = 1;
    public static final int DATA_VALUE_PARSER_LOOKUP = 2;

    public static ElementParserInterface loadParser(String tagName) {
        String className;
        ElementParserInterface rc;
        if (tagName == null) {
            return null;
        }
        if (tagName.indexOf(58) > 0) {
            tagName = tagName.substring(0, tagName.indexOf(58));
        }
        if ((rc = (ElementParserInterface)GraphParserFactory.loadClass(className = ResourceLoader.getResourceString(parsers, tagName, null), ElementParserInterface.class)) != null) {
            return rc;
        }
        return null;
    }

    public static DataValueParserInterface loadDataValueParser(String tagName) {
        String className;
        DataValueParserInterface rc;
        if (tagName == null) {
            return null;
        }
        if (tagName.indexOf(58) > 0) {
            tagName = tagName.substring(0, tagName.indexOf(58));
        }
        if ((rc = (DataValueParserInterface)GraphParserFactory.loadClass(className = ResourceLoader.getResourceString(dataValueParsers, tagName, null), DataValueParserInterface.class)) != null) {
            return rc;
        }
        return null;
    }

    private static Object loadClass(String classname, Class type) {
        if (classname != null) {
            try {
                Class<?> c = Class.forName(classname);
                Object o = c.newInstance();
                if (type.isInstance(o)) {
                    return o;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static ElementParserInterface loadParser(Object object) {
        if (object == null) {
            return null;
        }
        String classname = GraphParserFactory.getElementTagName(object);
        ElementParserInterface rc = GraphParserFactory.loadParser(classname);
        if (rc != null) {
            return rc;
        }
        return null;
    }

    public static String getElementTagName(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> c = object.getClass();
        String name = c.getName();
        String classname = null;
        while ((classname = ResourceLoader.getResourceString(outParsers, name, null)) == null && name != null && !name.equals("java.lang.Object")) {
            c = c.getSuperclass();
            name = c.getName();
        }
        return classname;
    }

    public static void addToParserLookup(String tagName, String className) {
        if (tagName == null || className == null) {
            return;
        }
        parsers.setProperty(tagName, className);
    }

    public static void addToReverseParserLookup(String className, String tagName) {
        if (tagName == null || className == null) {
            return;
        }
        outParsers.setProperty(className, tagName);
    }

    public static void addToDataValueParserLookup(String tagName, String className) {
        if (tagName == null || className == null) {
            return;
        }
        dataValueParsers.setProperty(tagName, className);
    }

    public static void addAllProperties(int whichPropertiesList, Properties properties) {
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String s1 = (String)keys.nextElement();
            String s2 = properties.getProperty(s1);
            GraphParserFactory.addToWhichParserLookup(whichPropertiesList, s1, s2);
        }
    }

    private static void addToWhichParserLookup(int which, String s1, String s2) {
        switch (which) {
            case 0: {
                GraphParserFactory.addToParserLookup(s1, s2);
                break;
            }
            case 1: {
                GraphParserFactory.addToReverseParserLookup(s1, s2);
                break;
            }
            case 2: {
                GraphParserFactory.addToDataValueParserLookup(s1, s2);
            }
        }
    }
}

