/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.xml;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.styles.PredefinedStyles;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.xml.Filter2XML;
import com.sas.graphics.xml.GraphParserFactory;
import com.sas.graphics.xml.GraphParserUtils;
import com.sas.graphics.xml.data.DataHandler;
import com.sas.graphics.xml.data.FormatParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class GraphParser {
    public static final int XML_TYPE_STATGRAPH = 0;
    public static final int XML_TYPE_ODS = 1;
    public static final String CONTEXT_KEY_XMLTYPE = "XML_TYPE";
    public static final String CONTEXT_KEY_DATALIST = "DATA_LIST";
    public static final String CONTEXT_KEY_CHARTLIST = "CHART_LIST";
    public static final String CONTEXT_KEY_STYLELIST = "STYLE_LIST";
    public static final String CONTEXT_KEY_COLORRAMPLIST = "COLOR_RAMP_LIST";
    public static final String CONTEXT_KEY_DEFAULT_STYLE = "DEFAULT_STYLE";
    public static final String CONTEXT_KEY_APPLET_CONTEXT = "APPLET_CONTEXT";
    public static final String CONTEXT_KEY_SCRIPT_ROLES = "SCRIPT_ROLES";
    public static final String CONTEXT_KEY_SILK_DESKTOP = "SILK_DESKTOP";
    public static final String CONTEXT_KEY_META_TABLE = "META_TABLE";
    private static final String CONTEXT_KEY_DATA_REPOSITORY = "DATA_REPOSITORY";
    public static final String CONTEXT_KEY_XML_DOCUMENT = "XML_DOCUMENT";
    public static final String CONTEXT_KEY_SAVE_VIEW_STATE = "SAVE_VIEW_STATE";
    public static final String CONTEXT_KEY_OVERLAY_ACTIVE = "OVERLAY_ACTIVE";
    public static final String CONTEXT_KEY_CURRENT_OVERLAY = "CURRENT_OVERLAY";
    public static final String CONTEXT_KEY_ROLE_INDEX = "ROLE_INDEX";
    public static final String CONTEXT_KEY_SCRIPT_STATGRAPH_WRAPPER = "SCRIPT_STATGRAPH";
    public static final String CONTEXT_KEY_XML_VERSION = "XML_VERSION";
    public static final String CONTEXT_KEY_STYLE_COLLECTION = "STYLE_COLLECTION";
    public static final String XML_VERSION_9_2 = "9.2";
    public static final String XML_VERSION_9_2_C = "9.2C";
    public static final String XML_VERSION_9_2_S2DVR = "9.2_S2DVR";
    public static double VERSION_PRE_9_2 = 0.0;
    public static double VERSION_9_2_C = 92.0;
    public static double VERSION_9_2 = 92.5;
    public static double VERSION_9_2_S2DVR;
    public static final String XML_CURRENT_VERSION = "9.2_S2DVR";
    public static final double CURRENT_VERSION;
    private static PrintStream errorStream;
    private static PrintStream outStream;

    public Hashtable parse(Hashtable context, String data, String view, String formats) {
        this.parseFormats(formats);
        Hashtable ht = context;
        if (ht == null) {
            ht = new Hashtable();
        }
        this.parseData(context, data);
        this.parseView(context, view);
        return context;
    }

    public String getXML(Hashtable context, Object object, boolean saveViewState) {
        DataFilterReadInterface filter = FilterFactory.getDataSourceFilter(object);
        if (filter != null) {
            StringBuffer rc = new StringBuffer();
            Vector<String> v = new Vector<String>();
            v.addElement("<Data>");
            Filter2XML.saveAsXML(filter, v);
            v.addElement("</Data>");
            for (int i = 0; i < v.size(); ++i) {
                rc.append(v.elementAt(i) + "\n");
            }
            return rc.toString();
        }
        if (context == null) {
            context = new Hashtable<String, Boolean>();
        }
        context.put(CONTEXT_KEY_SAVE_VIEW_STATE, new Boolean(saveViewState));
        Element e = this.getXMLElement(context, object);
        if (e != null) {
            return GraphParserUtils.toString(e);
        }
        return null;
    }

    public Element getXMLElement(Hashtable context, Object object) {
        Element e;
        ElementParserInterface parser;
        if (context == null) {
            context = new Hashtable<String, Boolean>();
        }
        context.put(CONTEXT_KEY_SCRIPT_ROLES, new Boolean(true));
        if (context.get(CONTEXT_KEY_XML_DOCUMENT) == null) {
            Document document;
            block7: {
                document = null;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    factory.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
                try {
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    document = builder.newDocument();
                }
                catch (ParserConfigurationException pce) {
                    if (errorStream == null) break block7;
                    pce.printStackTrace(errorStream);
                }
            }
            context.put(CONTEXT_KEY_XML_DOCUMENT, (Boolean)((Object)document));
        }
        if ((parser = GraphParserFactory.loadParser(object)) != null && (e = parser.putToXML(context, object)) != null) {
            return this.wrapElementWithStatgraph(context, e);
        }
        return null;
    }

    public String getStandAloneXML(Hashtable context, Object object, boolean saveViewState) {
        String viewXML;
        if (context == null) {
            context = new Hashtable<String, Boolean>();
        }
        Object oldScriptRoles = context.get(CONTEXT_KEY_SCRIPT_ROLES);
        context.put(CONTEXT_KEY_SCRIPT_ROLES, new Boolean(true));
        StringBuffer rc = new StringBuffer();
        rc.append("<Document>\n");
        if (object instanceof SourceInterface) {
            Object[] sourceNames = ((SourceInterface)object).getDataIds();
            Object[] sources = null;
            if (sourceNames != null) {
                int i;
                Vector<Object> sourcesVector = new Vector<Object>();
                for (i = 0; i < sourceNames.length; ++i) {
                    Object dm = ((SourceInterface)object).getDataSource(sourceNames[i]);
                    if (sourcesVector.contains(dm)) continue;
                    sourcesVector.addElement(dm);
                }
                sources = new Object[sourcesVector.size()];
                for (i = 0; i < sourcesVector.size(); ++i) {
                    sources[i] = sourcesVector.elementAt(i);
                }
            } else {
                sources = new Object[]{((SourceInterface)object).getDataSource()};
            }
            rc.append("<Data>\n");
            for (int i = 0; i < sources.length; ++i) {
                Vector output;
                DataFilterReadInterface filter = FilterFactory.getDataSourceFilter(sources[i]);
                boolean result = Filter2XML.saveAsXML(filter, output = new Vector(), true, true);
                if (!result) continue;
                for (int j = 0; j < output.size(); ++j) {
                    rc.append(output.elementAt(j).toString() + "\n");
                }
            }
            rc.append("</Data>\n");
        }
        rc.append("<View>");
        StyleCollection sc = (StyleCollection)context.get(CONTEXT_KEY_STYLE_COLLECTION);
        if (sc != null) {
            for (int i = 0; i < sc.getNumberStyles(); ++i) {
                if (PredefinedStyles.isPredefinedStyle((String)sc.getStyleAt(i).getSchemeName())) continue;
                rc.append(sc.getStyleAt(i).toElement().toString());
            }
        }
        if ((viewXML = this.getXML(context, object, saveViewState)) != null && viewXML.indexOf("?>") >= 0) {
            int index2 = viewXML.indexOf("?>");
            viewXML = viewXML.substring(index2 + 2);
        }
        rc.append(viewXML);
        if (oldScriptRoles == null) {
            context.remove(CONTEXT_KEY_SCRIPT_ROLES);
        } else {
            context.put(CONTEXT_KEY_SCRIPT_ROLES, (Boolean)oldScriptRoles);
        }
        rc.append("</View>\n");
        rc.append("</Document>");
        return rc.toString();
    }

    private void parseData(Hashtable context, String data) {
        if (data != null && data.trim().length() > 0) {
            DataHandler.parse(context, data);
        }
    }

    private void parseView(Hashtable context, String view) {
        if (view == null || view.trim().length() == 0) {
            return;
        }
        Element root = GraphParser.getElement(new StringReader(view));
        ElementParserInterface loader = GraphParserFactory.loadParser(root.getTagName());
        if (loader != null) {
            loader.getFromXML(context, root, null);
        } else {
            this.load(context, root);
        }
    }

    protected abstract void load(Hashtable var1, Element var2);

    private void parseFormats(String formats) {
        FormatParser.parse(formats);
    }

    public boolean initComponentFromXML(Object component, Element element, Hashtable context) {
        ElementParserInterface parser = GraphParserFactory.loadParser(component);
        if (parser == null) {
            return false;
        }
        if (context == null) {
            context = new Hashtable();
        }
        parser.getFromXML(context, element, component);
        return true;
    }

    public static Element getElement(InputStream xml) {
        Document document;
        block11: {
            if (xml == null) {
                return null;
            }
            document = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                factory.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                document = builder.parse(new InputSource(new BufferedInputStream(xml)));
            }
            catch (SAXException sxe) {
                Exception x = sxe;
                if (sxe.getException() != null) {
                    x = sxe.getException();
                }
                if (errorStream != null) {
                    x.printStackTrace(errorStream);
                }
            }
            catch (ParserConfigurationException pce) {
                if (errorStream != null) {
                    pce.printStackTrace(errorStream);
                }
            }
            catch (IOException ioe) {
                if (errorStream == null) break block11;
                ioe.printStackTrace(errorStream);
            }
        }
        if (document == null) {
            return null;
        }
        Element rc = document.getDocumentElement();
        return rc;
    }

    public static Element getElement(Reader xml) {
        Document document;
        block11: {
            if (xml == null) {
                return null;
            }
            document = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                factory.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                document = builder.parse(new InputSource(xml));
            }
            catch (SAXException sxe) {
                Exception x = sxe;
                if (sxe.getException() != null) {
                    x = sxe.getException();
                }
                if (errorStream != null) {
                    x.printStackTrace(errorStream);
                }
            }
            catch (ParserConfigurationException pce) {
                if (errorStream != null) {
                    pce.printStackTrace(errorStream);
                }
            }
            catch (IOException ioe) {
                if (errorStream == null) break block11;
                ioe.printStackTrace(errorStream);
            }
        }
        if (document == null) {
            return null;
        }
        Element rc = document.getDocumentElement();
        return rc;
    }

    public static boolean addChart(Hashtable context, String chart) {
        if (context == null) {
            return false;
        }
        if (!context.containsKey(CONTEXT_KEY_CHARTLIST)) {
            context.put(CONTEXT_KEY_CHARTLIST, new Vector());
        }
        Vector vec = (Vector)context.get(CONTEXT_KEY_CHARTLIST);
        if (chart == null || vec.contains(chart)) {
            return false;
        }
        vec.addElement(chart);
        return true;
    }

    public boolean removeChart(Hashtable context, String chart) {
        if (!context.containsKey(CONTEXT_KEY_CHARTLIST)) {
            return false;
        }
        Vector vec = (Vector)context.get(CONTEXT_KEY_CHARTLIST);
        if (chart == null || !vec.contains(chart)) {
            return false;
        }
        vec.removeElement(chart);
        return true;
    }

    public static boolean addData(Hashtable context, String dataName) {
        if (!context.containsKey(CONTEXT_KEY_DATALIST)) {
            context.put(CONTEXT_KEY_DATALIST, new Vector());
        }
        Vector vec = (Vector)context.get(CONTEXT_KEY_DATALIST);
        if (dataName == null || vec.contains(dataName)) {
            return false;
        }
        vec.addElement(dataName);
        if (GraphParser.getDataRepository(context) != null) {
            SourceInterface di = GraphParser.getDataRepository(context);
            di.setDataSource(context.get(dataName), dataName);
        }
        return true;
    }

    public boolean addStyle(Hashtable context, String style) {
        if (!context.containsKey(CONTEXT_KEY_STYLELIST)) {
            context.put(CONTEXT_KEY_STYLELIST, new Vector());
        }
        Vector vec = (Vector)context.get(CONTEXT_KEY_STYLELIST);
        if (style == null || vec.contains(style)) {
            return false;
        }
        vec.addElement(style);
        return true;
    }

    public Object[] getDataModels(Hashtable context) {
        if (context == null || !context.containsKey(CONTEXT_KEY_DATALIST)) {
            return null;
        }
        Vector vec = (Vector)context.get(CONTEXT_KEY_DATALIST);
        Object[] rc = new Object[vec.size()];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = context.get(vec.elementAt(i));
        }
        return rc;
    }

    public Object[] getCharts(Hashtable context) {
        if (context == null || !context.containsKey(CONTEXT_KEY_CHARTLIST)) {
            return null;
        }
        Vector vec = (Vector)context.get(CONTEXT_KEY_CHARTLIST);
        Object[] rc = new Object[vec.size()];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = context.get(vec.elementAt(i));
        }
        return rc;
    }

    public int getXMLType(Hashtable context) {
        Integer obj = new Integer(0);
        if (context != null) {
            obj = context.get(CONTEXT_KEY_XMLTYPE);
        }
        if (obj == null || !(obj instanceof Number)) {
            return 0;
        }
        return ((Number)obj).intValue();
    }

    public boolean setAppletContext(Hashtable context, Object applet) {
        if (applet == null) {
            return false;
        }
        context.put(CONTEXT_KEY_APPLET_CONTEXT, applet);
        return true;
    }

    public Hashtable getMetaData(Object obj, Hashtable context) {
        if (context == null || obj == null) {
            return null;
        }
        Object list = context.get(CONTEXT_KEY_META_TABLE);
        if (!(list instanceof Hashtable)) {
            return null;
        }
        Object rc = ((Hashtable)list).get(obj.getClass().getName() + obj.hashCode());
        if (rc == null || !(rc instanceof Hashtable)) {
            return null;
        }
        return (Hashtable)rc;
    }

    public boolean addMetaData(Object obj, Hashtable context, Hashtable metaData) {
        if (obj == null || context == null || metaData == null) {
            return false;
        }
        Hashtable<String, Hashtable> list = (Hashtable<String, Hashtable>)context.get(CONTEXT_KEY_META_TABLE);
        if (list == null) {
            list = new Hashtable<String, Hashtable>();
            context.put(CONTEXT_KEY_META_TABLE, list);
        }
        list.put(obj.getClass().getName() + obj.hashCode(), metaData);
        return true;
    }

    public boolean setDataRepository(SourceInterface dri, Hashtable context) {
        if (dri == null || context == null) {
            return false;
        }
        context.put(CONTEXT_KEY_DATA_REPOSITORY, dri);
        return true;
    }

    public static SourceInterface getDataRepository(Hashtable context) {
        return (SourceInterface)context.get(CONTEXT_KEY_DATA_REPOSITORY);
    }

    public static Object getData(String dataName, Hashtable context) {
        if (dataName == null || context == null) {
            return null;
        }
        Object rc = null;
        if (GraphParser.getDataRepository(context) != null) {
            rc = GraphParser.getDataRepository(context).getDataSource(dataName);
        }
        if (rc == null) {
            rc = context.get(dataName);
        }
        return rc;
    }

    public boolean saveAsXML(Object objToSave, Hashtable context, boolean standAlone) {
        block6: {
            if (objToSave == null) {
                return false;
            }
            JFileChooser fileChooser = new JFileChooser(new File(System.getProperty("user.home")));
            int result = fileChooser.showSaveDialog(null);
            if (result == 0) {
                Object o;
                File f = fileChooser.getSelectedFile();
                String xml = null;
                boolean saveViewState = false;
                if (context != null && (o = context.get(CONTEXT_KEY_SAVE_VIEW_STATE)) instanceof Boolean) {
                    saveViewState = (Boolean)o;
                }
                xml = saveViewState ? (standAlone ? this.getStandAloneXML(context, objToSave, true) : this.getXML(context, objToSave, true)) : (standAlone ? this.getStandAloneXML(context, objToSave, false) : this.getXML(context, objToSave, false));
                if (xml == null) {
                    return false;
                }
                try {
                    FileOutputStream out = new FileOutputStream(f);
                    byte[] bytes = xml.getBytes();
                    out.write(bytes);
                    out.close();
                }
                catch (Exception e) {
                    if (outStream == null) break block6;
                    outStream.println("FILE WRITE FAILED. " + e.getMessage());
                }
            }
        }
        return true;
    }

    public final String getCurrentXMLVersion() {
        return "9.2_S2DVR";
    }

    public static PrintStream getErrorStream() {
        return errorStream;
    }

    public static void setErrorStream(PrintStream err) {
        errorStream = err;
    }

    public static void setOutputStream(PrintStream out) {
        outStream = out;
    }

    public void setQuietMode(boolean on) {
        GraphParser.setErrorStream(on ? null : System.err);
        GraphParser.setOutputStream(on ? null : System.out);
    }

    private Element wrapElementWithStatgraph(Hashtable context, Element e) {
        Object obj;
        if (context.containsKey(CONTEXT_KEY_SCRIPT_STATGRAPH_WRAPPER) && (obj = context.get(CONTEXT_KEY_SCRIPT_STATGRAPH_WRAPPER)) instanceof Boolean && !((Boolean)obj).booleanValue()) {
            return e;
        }
        Element sg = GraphParserUtils.newElement(context, "StatGraph");
        if (sg == null) {
            return e;
        }
        sg.setAttribute("version", this.getCurrentXMLVersion());
        sg.appendChild(e);
        return sg;
    }

    public abstract double getCurrentVersion(Hashtable var1);

    static {
        CURRENT_VERSION = VERSION_9_2_S2DVR = 92.51;
        errorStream = System.err;
        outStream = System.out;
    }
}

