/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.xml;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.xml.GraphParserUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Date;
import java.util.Vector;

public class Filter2XML {
    protected static boolean writeString(Object writer, String s) {
        if (writer == null) {
            return false;
        }
        if (s == null) {
            s = "";
        }
        if (writer instanceof Vector) {
            ((Vector)writer).addElement(s);
        } else if (writer instanceof Writer || writer instanceof OutputStream) {
            try {
                if (writer instanceof Writer) {
                    ((Writer)writer).write(s + "\r\n");
                } else {
                    ((OutputStream)writer).write((s + "\r\n").getBytes());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static boolean saveAsXML(DataFilterReadInterface filter, String outputFile) {
        return Filter2XML.saveAsXML(filter, outputFile, false, false);
    }

    public static boolean saveAsXML(DataFilterReadInterface filter, String outputFile, boolean statGraphFormat, boolean legacy, boolean noComments) {
        return Filter2XML.saveFilterAsXML(filter, outputFile, statGraphFormat, legacy, noComments);
    }

    public static boolean saveAsXML(DataFilterReadInterface filter, String outputFile, boolean statGraphFormat, boolean noComments) {
        return Filter2XML.saveFilterAsXML(filter, outputFile, statGraphFormat, false, noComments);
    }

    public static boolean saveAsXML(DataFilterReadInterface filter, Vector outputVec) {
        return Filter2XML.saveAsXML(filter, outputVec, false, false);
    }

    public static boolean saveAsXML(DataFilterReadInterface filter, Vector outputVec, boolean statGraphFormat, boolean legacy, boolean noComments) {
        return Filter2XML.saveFilterAsXML(filter, outputVec, statGraphFormat, legacy, noComments);
    }

    public static boolean saveAsXML(DataFilterReadInterface filter, Vector outputVec, boolean statGraphFormat, boolean noComments) {
        return Filter2XML.saveFilterAsXML(filter, outputVec, statGraphFormat, false, noComments);
    }

    protected static boolean saveFilterAsXML(DataFilterReadInterface filter, Object output, boolean statGraphFormat, boolean legacy, boolean noComments) {
        String strg;
        Object o;
        int ivar;
        boolean closeWriter = false;
        int nvars = 0;
        int nobs = 0;
        String valTag = "Value";
        String missAttrib = "missing";
        Date today = new Date();
        Object fw = null;
        if (output == null) {
            return false;
        }
        if (output instanceof String) {
            try {
                closeWriter = true;
                fw = new FileWriter((String)output);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        } else if (output instanceof Writer || output instanceof Vector || output instanceof OutputStream) {
            fw = output;
        } else {
            return false;
        }
        if (filter == null || fw == null) {
            return false;
        }
        String name = GraphParserUtils.getNameForDataObject(filter, null);
        if (!noComments) {
            Filter2XML.writeString(fw, "<!-- ");
            Filter2XML.writeString(fw, "COPYRIGHT (C) 2001 BY SAS INSTITUTE INC., CARY NC");
            Filter2XML.writeString(fw, null);
            if (output instanceof String) {
                Filter2XML.writeString(fw, "Name: " + (String)output);
                Filter2XML.writeString(fw, null);
            }
            Filter2XML.writeString(fw, "Author:  Autogenerated");
            Filter2XML.writeString(fw, "Support: sasres - Ron Stogner");
            Filter2XML.writeString(fw, null);
            if (today != null) {
                Filter2XML.writeString(fw, "Created: " + today.toString());
                Filter2XML.writeString(fw, null);
            }
            Filter2XML.writeString(fw, "-->");
            Filter2XML.writeString(fw, null);
        }
        if (!(fw instanceof Vector)) {
            Filter2XML.writeString(fw, "<Data>");
        }
        Filter2XML.writeString(fw, "  <IQData type=\"2DEmbedded\" name=\"" + name + "\">");
        Filter2XML.writeString(fw, "    <EmbeddedData>");
        Filter2XML.writeString(fw, "      <Variables>");
        nvars = filter.getNumberVariables();
        for (ivar = 0; ivar < nvars; ++ivar) {
            o = filter.getVariableId(ivar);
            name = o == null ? "Var" + ivar : o.toString();
            String type = filter.isNumericVariable(ivar) ? "Numeric" : "String";
            o = filter.getVariableDescription(ivar);
            String desc = o == null ? null : o.toString();
            if (desc != null && desc.equals(name)) {
                desc = null;
            }
            String fmt = (String)filter.getFormat(name, String.class);
            name = GraphParserUtils.buildValidXMLString(name, true);
            strg = "        <Variable encoding=\"Text\" name=\"" + name.trim() + "\" varName=\"" + name.trim() + "\"";
            if (desc != null) {
                strg = strg + " label=\"" + desc.trim() + "\"";
            }
            if (fmt != null) {
                strg = strg + " sasFormat=\"" + fmt.trim() + "\"";
            }
            strg = strg + " type=\"" + type + "\"/>";
            Filter2XML.writeString(fw, strg);
        }
        Filter2XML.writeString(fw, "      </Variables>");
        if (statGraphFormat && legacy) {
            Filter2XML.writeString(fw, "      <Rows>");
        } else if (!statGraphFormat) {
            Filter2XML.writeString(fw, "      <ValuesList>");
        }
        if (statGraphFormat) {
            valTag = "V";
            missAttrib = "m";
        }
        nobs = filter.getNumberObservations(-1);
        for (int irec = 0; irec < nobs; ++irec) {
            if (statGraphFormat && legacy) {
                Filter2XML.writeString(fw, "        <Row>");
            } else if (!statGraphFormat) {
                Filter2XML.writeString(fw, "        <Values>");
            }
            for (ivar = 0; ivar < nvars; ++ivar) {
                o = filter.getValue(ivar, (long)irec);
                boolean numeric = filter.isNumericVariable(ivar);
                boolean missing = o == null ? true : filter.isMissing(ivar, o);
                strg = !missing ? o.toString() : (numeric ? "." : " ");
                strg = GraphParserUtils.buildValidXMLString(strg, true);
                if (statGraphFormat && legacy) {
                    Filter2XML.writeString(fw, "\"" + strg + "\" ");
                    continue;
                }
                if (missing) {
                    Filter2XML.writeString(fw, "          <" + valTag + " " + missAttrib + "=\".\"></" + valTag + ">");
                    continue;
                }
                Filter2XML.writeString(fw, "          <" + valTag + ">" + strg + "</" + valTag + ">");
            }
            if (statGraphFormat && legacy) {
                Filter2XML.writeString(fw, "</Row>");
                continue;
            }
            if (statGraphFormat) continue;
            Filter2XML.writeString(fw, "        </Values>");
        }
        if (statGraphFormat && legacy) {
            Filter2XML.writeString(fw, "      </Rows>");
        } else if (!statGraphFormat) {
            Filter2XML.writeString(fw, "      </ValuesList>");
        }
        Filter2XML.writeString(fw, "    </EmbeddedData>");
        Filter2XML.writeString(fw, "  </IQData>");
        if (!(fw instanceof Vector)) {
            Filter2XML.writeString(fw, "</Data>");
        }
        if (fw != null && fw instanceof Writer) {
            try {
                ((Writer)fw).flush();
                if (closeWriter) {
                    ((Writer)fw).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

