/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.ods.visual.jxd;

import com.sas.graphics.util.Plane;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Bbox;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.ods.visual.Contours;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Stack;
import java.util.Vector;

public class JxdContours
extends Contours {
    protected long rootId;
    protected long ctrId;
    protected long highlightId;
    protected Channel ch;
    protected int glMode;
    protected int vertexCount;
    protected Stack pickStack;
    protected Bbox box;
    protected double[][] segs;

    public JxdContours(Object channel, Object transObjIn) {
        super(transObjIn);
        this.edgeColorSupport = true;
        this.ch = channel instanceof Channel ? (Channel)channel : null;
        this.glMode = 0;
        this.vertexCount = 0;
        this.rootId = 0L;
        this.ctrId = 0L;
        this.highlightId = 0L;
        this.pickStack = new Stack();
        this.box = new Bbox();
        this.segs = new double[6][2];
        this.averageVertexColors = false;
    }

    public JxdContours(Object channel) {
        this(channel, null);
    }

    @Override
    public boolean Create() {
        if (this.ch == null) {
            return false;
        }
        this.ch.glEdgeFlag(false);
        this.rootId = this.ch.glGenLists(1L);
        this.ctrId = this.ch.glGenLists(1L);
        this.highlightId = this.ch.glGenLists(1L);
        this.ch.glNewList(this.rootId);
        this.ch.glCallList(this.ctrId);
        this.ch.glCallList(this.highlightId);
        this.ch.glEndList();
        return true;
    }

    @Override
    public boolean Build(Object bldPtr) {
        this.useDisplayList = this.RequresAdvancedPicking();
        if (this.useDisplayList) {
            return this.BuildDisplayList(bldPtr);
        }
        return this.BuildImmediateMode(bldPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean BuildSetup() {
        if (this.ch == null) {
            return false;
        }
        JxdContours jxdContours = this;
        synchronized (jxdContours) {
            this.inBuild = true;
        }
        if (this.edgeColorSupport) {
            this.ch.glEdgeColor(this.GetOutlineColor());
        }
        switch (this.style) {
            default: {
                this.ch.glEdgeFlag(true);
                break;
            }
            case 3: {
                this.ch.glEdgeFlag(false);
            }
        }
        if (this.highlightBuild) {
            this.ch.glNewList(this.highlightId);
        } else {
            this.ch.glNewList(this.ctrId);
        }
        this.ch.glInitNames();
        this.ch.glPushName(null);
        this.applyFont(this.font);
        this.applyLineStyle(this.linestyle);
        this.ch.glLineWidth((float)this.lineWidth);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean BuildCleanup() {
        if (this.ch == null) {
            return false;
        }
        this.applyLineStyle(0);
        this.ch.glLineWidth(1.0f);
        this.ch.glEndList();
        JxdContours jxdContours = this;
        synchronized (jxdContours) {
            this.inBuild = false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean BuildSetup_immediateMode() {
        if (this.ch == null) {
            return false;
        }
        JxdContours jxdContours = this;
        synchronized (jxdContours) {
            this.inBuild = true;
        }
        if (this.edgeColorSupport) {
            this.ch.glEdgeColor(this.GetOutlineColor());
        }
        switch (this.style) {
            default: {
                this.ch.glEdgeFlag(true);
                break;
            }
            case 3: {
                this.ch.glEdgeFlag(false);
            }
        }
        this.ch.glInitNames();
        this.ch.glPushName(null);
        this.applyFont(this.font);
        this.applyLineStyle(this.linestyle);
        this.ch.glLineWidth((float)this.lineWidth);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean BuildCleanup_immediateMode() {
        if (this.ch == null) {
            return false;
        }
        this.applyLineStyle(0);
        this.ch.glLineWidth(1.0f);
        JxdContours jxdContours = this;
        synchronized (jxdContours) {
            this.inBuild = false;
        }
        return true;
    }

    protected boolean RequresAdvancedPicking() {
        boolean status = false;
        switch (this.style) {
            case 0: 
            case 1: 
            case 3: {
                status = this.stacked && this.pickEnable;
                break;
            }
            case 5: {
                status = this.pickEnable;
            }
        }
        return status;
    }

    protected Vec3d DoAdvancedPicking(int x, int y, double[] nearCoords, double[] farCoords) {
        Vec3d intersection = null;
        Plane plane = null;
        double[][] polygon = null;
        if (this.pickStack == null || this.ch == null || nearCoords == null || farCoords == null) {
            return null;
        }
        this.pickStack.removeAllElements();
        this.ch.glSelectBuffer(this.pickStack);
        this.ch.glRenderMode(1);
        this.ch.gluPickMatrix(x, y, 1, 1);
        if (this.useDisplayList) {
            this.ch.glCallList(this.ctrId);
        } else {
            this.drawImmediateMode();
        }
        if (this.ch.glRenderMode(0)) {
            if (this.pickStack.size() < 2) {
                return null;
            }
            polygon = (double[][])this.pickStack.elementAt(this.pickStack.size() - 1);
            if (polygon == null) {
                return null;
            }
            plane = new Plane(polygon[0][0], polygon[0][1], polygon[0][2], polygon[1][0], polygon[1][1], polygon[1][2], polygon[2][0], polygon[2][1], polygon[2][2]);
            if (plane == null) {
                return null;
            }
            intersection = plane.getPointOfIntersection(new Vec3d(nearCoords[0], nearCoords[1], nearCoords[2]), new Vec3d(farCoords[0], farCoords[1], farCoords[2]));
        }
        return intersection;
    }

    @Override
    public boolean SetHighlightLocation(int x, int y) {
        double[] nearCoords = this.UnProject(x, y, 0.0);
        double[] farCoords = this.UnProject(x, y, 1.0);
        Vec3d intersection = null;
        if (this.RequresAdvancedPicking()) {
            intersection = this.DoAdvancedPicking(x, y, nearCoords, farCoords);
            if (intersection == null) {
                return false;
            }
            return this.SetHighLightLocation(intersection.x, intersection.y, intersection.z);
        }
        return this.SetHighlightLocation(nearCoords, farCoords);
    }

    public boolean SetHighlightArea(int startX, int startY, int endX, int endY) {
        double[] startCoords = this.UnProject(startX, startY, 0.0);
        double[] endCoords = this.UnProject(endX, endY, 0.0);
        return this.SetHighlightArea(startCoords[0], startCoords[1], 0.0, endCoords[0], endCoords[1], 0.0);
    }

    @Override
    public double[] FindLocation(int x, int y, boolean clampToData) {
        Vec3d intersection = null;
        double[] nearCoords = this.UnProject(x, y, 0.0);
        double[] farCoords = this.UnProject(x, y, 1.0);
        double[] out = null;
        if (this.RequresAdvancedPicking()) {
            intersection = this.DoAdvancedPicking(x, y, nearCoords, farCoords);
            if (intersection == null) {
                return null;
            }
            out = new double[3];
            if (out == null) {
                return null;
            }
            out[0] = intersection.x;
            out[1] = intersection.y;
            out[2] = intersection.z;
            return out;
        }
        return this.FindLocation(nearCoords, farCoords, clampToData);
    }

    @Override
    public Double GetValueAtLocation(int x, int y) {
        Vec3d intersection = null;
        double[] nearCoords = this.UnProject(x, y, 0.0);
        double[] farCoords = this.UnProject(x, y, 1.0);
        if (this.RequresAdvancedPicking()) {
            intersection = this.DoAdvancedPicking(x, y, nearCoords, farCoords);
            if (intersection == null) {
                return null;
            }
            return this.GetValueAtLocation(intersection.x, intersection.y, intersection.z);
        }
        return this.GetValueAtLocation(nearCoords, farCoords);
    }

    @Override
    public int[] GetNearestLocation(int x, int y) {
        double[] nearCoords = null;
        double[] farCoords = null;
        nearCoords = this.UnProject(x, y, 0.0);
        farCoords = this.UnProject(x, y, 1.0);
        return this.GetNearestLocation(nearCoords, farCoords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void BuildError() {
        long list = 0L;
        if (this.ch == null) {
            return;
        }
        this.ch.glEndList();
        list = this.highlightBuild ? this.highlightId : this.ctrId;
        this.ch.glNewList(list);
        this.ch.glEndList();
        JxdContours jxdContours = this;
        synchronized (jxdContours) {
            this.inBuild = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void BuildError_immediateMode() {
        JxdContours jxdContours = this;
        synchronized (jxdContours) {
            this.inBuild = false;
        }
    }

    @Override
    protected double getTextWidth(String text) {
        if (text == null || this.ch == null) {
            return 0.0;
        }
        return this.ch.glGetTextWidth(text);
    }

    @Override
    protected double getLabelAngle(double x1In, double y1In, double x2In, double y2In) {
        double y2;
        double x2;
        double y1;
        double x1;
        double angle = 0.0;
        double[] obj = new double[3];
        double[] win = new double[3];
        obj[0] = x1In;
        obj[1] = y1In;
        this.ch.gluProject(obj, win);
        double winX1 = win[0];
        double winY1 = win[1];
        obj[0] = x2In;
        obj[1] = y2In;
        this.ch.gluProject(obj, win);
        double winX2 = win[0];
        double winY2 = win[1];
        if (winX2 < winX1) {
            x1 = winX2;
            y1 = winY2;
            x2 = winX1;
            y2 = winY1;
        } else {
            x1 = winX1;
            y1 = winY1;
            x2 = winX2;
            y2 = winY2;
        }
        double dx = x2 - x1;
        double dy = y2 - y1;
        angle = dx == 0.0 ? (dy > 0.0 ? 90.0 : -90.0) : Math.atan(dy / dx) * 57.29577951308232;
        return -angle;
    }

    @Override
    protected void getTextBBoxPts(String text, double x, double y, double z, int justLR, int justTB, double angle, double[] out) {
        int alignTB;
        int alignLR;
        if (this.ch == null || this.box == null || text == null) {
            return;
        }
        switch (justLR) {
            default: {
                alignLR = 0;
                break;
            }
            case 0: {
                alignLR = 1;
                break;
            }
            case 1: {
                alignLR = 2;
            }
        }
        switch (justTB) {
            default: {
                alignTB = 3;
                break;
            }
            case 0: {
                alignTB = 1;
                break;
            }
            case 1: {
                alignTB = 0;
            }
        }
        this.ch.glTextAlign(alignLR, alignTB);
        this.ch.glGetText2DBbox(text, x, y, z, 0, this.box);
        if (angle == 0.0) {
            out[0] = this.box.xmin;
            out[1] = this.box.ymin;
            out[2] = this.box.xmin;
            out[3] = this.box.ymax;
            out[4] = this.box.xmax;
            out[5] = this.box.ymax;
            out[6] = this.box.xmax;
            out[7] = this.box.ymin;
        } else {
            double temp;
            double[] obj = new double[3];
            double[] win = new double[3];
            obj[0] = this.box.xmin;
            obj[1] = this.box.ymin;
            obj[2] = this.box.zmin;
            this.ch.gluProject(obj, win);
            out[0] = win[0];
            out[1] = win[1];
            out[2] = win[2];
            obj[0] = this.box.xmax;
            obj[1] = this.box.ymax;
            obj[2] = this.box.zmax;
            this.ch.gluProject(obj, win);
            out[3] = win[0];
            out[4] = win[1];
            out[5] = win[2];
            if (out[0] > out[3]) {
                temp = out[0];
                out[0] = out[3];
                out[3] = temp;
            }
            if (out[1] > out[4]) {
                temp = out[1];
                out[1] = out[4];
                out[4] = temp;
            }
            Rectangle2D.Double rect = new Rectangle2D.Double(out[0], out[1], out[3] - out[0], out[4] - out[1]);
            AffineTransform transform = AffineTransform.getRotateInstance(-angle / 57.29577951308232, rect.x + rect.width / 2.0, rect.y + rect.height / 2.0);
            Shape rotatedRect = transform.createTransformedShape(rect);
            double[] rectPts = this.getShapePoints(rotatedRect);
            win[0] = rectPts[0];
            win[1] = rectPts[1];
            win[2] = 0.0;
            this.ch.gluUnProject(win, obj);
            out[0] = obj[0];
            out[1] = obj[1];
            win[0] = rectPts[2];
            win[1] = rectPts[3];
            this.ch.gluUnProject(win, obj);
            out[2] = obj[0];
            out[3] = obj[1];
            win[0] = rectPts[4];
            win[1] = rectPts[5];
            this.ch.gluUnProject(win, obj);
            out[4] = obj[0];
            out[5] = obj[1];
            win[0] = rectPts[6];
            win[1] = rectPts[7];
            this.ch.gluUnProject(win, obj);
            out[6] = obj[0];
            out[7] = obj[1];
        }
    }

    @Override
    protected void getTextBoundingBox(String text, double x, double y, double z, int justLR, int justTB, double angle, double[] out) {
        int alignTB;
        int alignLR;
        if (this.ch == null || this.box == null || out == null || text == null) {
            return;
        }
        switch (justLR) {
            default: {
                alignLR = 0;
                break;
            }
            case 0: {
                alignLR = 1;
                break;
            }
            case 1: {
                alignLR = 2;
            }
        }
        switch (justTB) {
            default: {
                alignTB = 3;
                break;
            }
            case 0: {
                alignTB = 1;
                break;
            }
            case 1: {
                alignTB = 0;
            }
        }
        this.ch.glTextAlign(alignLR, alignTB);
        this.ch.glGetText2DBbox(text, x, y, z, (int)angle, this.box);
        out[0] = this.box.xmin;
        out[1] = this.box.ymin;
        out[2] = this.box.zmin;
        out[3] = this.box.xmax;
        out[4] = this.box.ymax;
        out[5] = this.box.zmax;
    }

    protected void drawLineSegment(int i, int isect1, int isect2, double z, String label, double[] labelBox, double labelAngle) {
        this.drawLineSegment(this.intersections[i][isect1][0], this.intersections[i][isect1][1], this.intersections[i][isect2][0], this.intersections[i][isect2][1], z, label, labelBox, labelAngle);
    }

    @Override
    protected void drawLineSegment(double x1, double y1, double x2, double y2, double z, String label, double[] labelBox, double labelAngle) {
        AffineTransform reverseRotate;
        boolean splitLineSeg = labelBox != null;
        int nSegs = 0;
        if (label == null && labelBox == null) {
            this.OnBeginPrimitive(1);
            this.DRAW(x1, y1, z);
            this.DRAW(x2, y2, z);
            this.OnEndPrimitive(1);
            return;
        }
        double lx = (x1 + x2) / 2.0;
        double ly = (y1 + y2) / 2.0;
        if (!splitLineSeg) {
            this.OnBeginPrimitive(1);
            this.DRAW(x1, y1, z);
            this.DRAW(x2, y2, z);
            this.OnEndPrimitive(1);
            if (this.labelColor != null) {
                this.ch.glPushAttrib(0);
                this.OnColor(this.labelColor);
            }
            this.OnText(label, lx, ly, z, 0, 0, labelAngle, null);
            if (this.labelColor != null) {
                this.ch.glPopAttrib();
            }
            return;
        }
        if (label != null) {
            if (this.labelColor != null) {
                this.ch.glPushAttrib(0);
                this.OnColor(this.labelColor);
            }
            this.OnText(label, lx, ly, z, 0, 0, labelAngle, null);
            if (this.labelColor != null) {
                this.ch.glPopAttrib();
            }
        }
        double[] linePts = new double[]{x1, y1, x2, y2};
        AffineTransform rotate = AffineTransform.getRotateInstance(-labelAngle / 57.29577951308232, labelBox[0] + (labelBox[3] - labelBox[0]) / 2.0, labelBox[1] + (labelBox[4] - labelBox[1]) / 2.0);
        rotate.transform(linePts, 0, linePts, 0, 2);
        try {
            reverseRotate = rotate.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            return;
        }
        nSegs = this.splitLineSegment(linePts[0], linePts[1], linePts[2], linePts[3], labelBox, this.segs);
        for (int iSeg = 0; iSeg < nSegs; ++iSeg) {
            linePts[0] = this.segs[2 * iSeg][0];
            linePts[1] = this.segs[2 * iSeg][1];
            linePts[2] = this.segs[2 * iSeg + 1][0];
            linePts[3] = this.segs[2 * iSeg + 1][1];
            reverseRotate.transform(linePts, 0, linePts, 0, 2);
            this.OnBeginPrimitive(1);
            this.DRAW(linePts[0], linePts[1], z);
            this.DRAW(linePts[2], linePts[3], z);
            this.OnEndPrimitive(1);
        }
    }

    @Override
    protected void drawLineLabel(String label, double x, double y, double z, double angle) {
        if (label != null) {
            if (this.labelColor != null) {
                this.ch.glPushAttrib(0);
                this.OnColor(this.labelColor);
            }
            this.OnText(label, x, y, z, 0, 0, angle, null);
            if (this.labelColor != null) {
                this.ch.glPopAttrib();
            }
        }
    }

    @Override
    protected Vector createLineSegments(double[] segments, int numSegs, double[] bbox) {
        Vector allSegments = new Vector();
        Vector<Point2D.Double> curSegment = null;
        for (int i = 0; i < numSegs; ++i) {
            double x1 = segments[i * 4];
            double y1 = segments[i * 4 + 1];
            double x2 = segments[i * 4 + 2];
            double y2 = segments[i * 4 + 3];
            if (bbox != null) {
                int numSplit = this.clipLineSegment(x1, y1, x2, y2, bbox, this.segs);
                if (numSplit == 0) {
                    if (curSegment == null) continue;
                    allSegments.add(curSegment);
                    curSegment = null;
                    continue;
                }
                if (numSplit == 1) {
                    if (this.segs[0][0] == x1 && this.segs[0][1] == y1) {
                        if (this.segs[1][0] == x2 && this.segs[1][1] == y2) {
                            if (curSegment == null) {
                                curSegment = new Vector();
                                curSegment.add(new Point2D.Double(x1, y1));
                            }
                            curSegment.add(new Point2D.Double(x2, y2));
                            continue;
                        }
                        if (curSegment == null) {
                            curSegment = new Vector();
                            curSegment.add(new Point2D.Double(this.segs[0][0], this.segs[0][1]));
                        }
                        curSegment.add(new Point2D.Double(this.segs[1][0], this.segs[1][1]));
                        allSegments.add(curSegment);
                        curSegment = null;
                        continue;
                    }
                    if (curSegment != null) {
                        allSegments.add(curSegment);
                        curSegment = null;
                    }
                    curSegment = new Vector();
                    curSegment.add(new Point2D.Double(this.segs[0][0], this.segs[0][1]));
                    curSegment.add(new Point2D.Double(this.segs[1][0], this.segs[1][1]));
                    continue;
                }
                if (curSegment == null) {
                    curSegment = new Vector();
                    curSegment.add(new Point2D.Double(this.segs[0][0], this.segs[0][1]));
                }
                curSegment.add(new Point2D.Double(this.segs[1][0], this.segs[1][1]));
                allSegments.add(curSegment);
                curSegment = new Vector();
                curSegment.add(new Point2D.Double(this.segs[2][0], this.segs[2][1]));
                curSegment.add(new Point2D.Double(this.segs[3][0], this.segs[3][1]));
                continue;
            }
            if (curSegment == null) {
                curSegment = new Vector<Point2D.Double>();
                curSegment.add(new Point2D.Double(x1, y1));
            }
            curSegment.add(new Point2D.Double(x2, y2));
        }
        if (curSegment != null) {
            allSegments.add(curSegment);
        }
        if (allSegments.size() > 1) {
            Vector firstVec = (Vector)allSegments.firstElement();
            Vector lastVec = (Vector)allSegments.lastElement();
            Point2D.Double firstPt = (Point2D.Double)firstVec.firstElement();
            Point2D.Double lastPt = (Point2D.Double)lastVec.lastElement();
            if (firstPt != null && lastPt != null && firstPt.equals(lastPt)) {
                lastVec.remove(lastVec.size() - 1);
                lastVec.addAll(firstVec);
                allSegments.remove(0);
            }
        }
        return allSegments;
    }

    protected int getOutCode(double xmin, double ymin, double xmax, double ymax, double x, double y) {
        int outCode = 0;
        if (y > ymax) {
            outCode |= 2;
        } else if (y < ymin) {
            outCode |= 8;
        }
        if (x > xmax) {
            outCode |= 4;
        } else if (x < xmin) {
            outCode |= 1;
        }
        return outCode;
    }

    protected int splitLineSegment(double x1, double y1, double x2, double y2, double[] rectBox, double[][] segOut) {
        int out;
        double y;
        double x;
        int count = 0;
        double xmin = rectBox[0];
        double ymin = rectBox[1];
        double xmax = rectBox[3];
        double ymax = rectBox[4];
        int out1 = this.getOutCode(xmin, ymin, xmax, ymax, x1, y1);
        int out2 = this.getOutCode(xmin, ymin, xmax, ymax, x2, y2);
        if (out1 == 0 && out2 == 0) {
            return 0;
        }
        if ((out1 & out2) != 0) {
            segOut[0][0] = x1;
            segOut[0][1] = y1;
            segOut[1][0] = x2;
            segOut[1][1] = y2;
            return 1;
        }
        if (out1 != 0) {
            x = x1;
            y = y1;
            out = out1;
            while (out > 0) {
                if ((out & 1) != 0) {
                    y = y1 + (y2 - y1) * (xmin - x1) / (x2 - x1);
                    x = xmin;
                } else if ((out & 4) != 0) {
                    y = y1 + (y2 - y1) * (xmax - x1) / (x2 - x1);
                    x = xmax;
                } else if ((out & 2) != 0) {
                    x = x1 + (x2 - x1) * (ymax - y1) / (y2 - y1);
                    y = ymax;
                } else if ((out & 8) != 0) {
                    x = x1 + (x2 - x1) * (ymin - y1) / (y2 - y1);
                    y = ymin;
                } else {
                    return 0;
                }
                if (((out = this.getOutCode(xmin, ymin, xmax, ymax, x, y)) & out2) == 0) continue;
                segOut[0][0] = x1;
                segOut[0][1] = y1;
                segOut[1][0] = x2;
                segOut[1][1] = y2;
                return 1;
            }
            segOut[2 * count][0] = x1;
            segOut[2 * count][1] = y1;
            segOut[2 * count + 1][0] = x;
            segOut[2 * count + 1][1] = y;
            ++count;
        }
        if (out2 != 0) {
            x = x2;
            y = y2;
            out = out2;
            while (out > 0) {
                if ((out & 1) != 0) {
                    y = y1 + (y2 - y1) * (xmin - x1) / (x2 - x1);
                    x = xmin;
                } else if ((out & 4) != 0) {
                    y = y1 + (y2 - y1) * (xmax - x1) / (x2 - x1);
                    x = xmax;
                } else if ((out & 2) != 0) {
                    x = x1 + (x2 - x1) * (ymax - y1) / (y2 - y1);
                    y = ymax;
                } else if ((out & 8) != 0) {
                    x = x1 + (x2 - x1) * (ymin - y1) / (y2 - y1);
                    y = ymin;
                } else {
                    return 0;
                }
                if (((out = this.getOutCode(xmin, ymin, xmax, ymax, x, y)) & out1) == 0) continue;
                segOut[0][0] = x1;
                segOut[0][1] = y1;
                segOut[1][0] = x2;
                segOut[1][1] = y2;
                return 1;
            }
            segOut[2 * count][0] = x2;
            segOut[2 * count][1] = y2;
            segOut[2 * count + 1][0] = x;
            segOut[2 * count + 1][1] = y;
            ++count;
        }
        return count;
    }

    protected int clipLineSegment(double x1, double y1, double x2, double y2, double[] boxPts, double[][] segOut) {
        double yMax;
        if (boxPts == null || boxPts.length != 8) {
            return 0;
        }
        double xMin = Math.min(boxPts[0], Math.min(boxPts[2], Math.min(boxPts[4], boxPts[6])));
        double xMax = Math.max(boxPts[0], Math.max(boxPts[2], Math.max(boxPts[4], boxPts[6])));
        Line2D.Double lineSegment = new Line2D.Double(x1, y1, x2, y2);
        double yMin = Math.min(boxPts[1], Math.min(boxPts[3], Math.min(boxPts[5], boxPts[7])));
        if (!lineSegment.intersects(xMin, yMin, xMax - xMin, (yMax = Math.max(boxPts[1], Math.max(boxPts[3], Math.max(boxPts[5], boxPts[7])))) - yMin)) {
            segOut[0][0] = x1;
            segOut[0][1] = y1;
            segOut[1][0] = x2;
            segOut[1][1] = y2;
            return 1;
        }
        GeneralPath path = new GeneralPath();
        path.moveTo((float)boxPts[0], (float)boxPts[1]);
        path.lineTo((float)boxPts[2], (float)boxPts[3]);
        path.lineTo((float)boxPts[4], (float)boxPts[5]);
        path.lineTo((float)boxPts[6], (float)boxPts[7]);
        path.closePath();
        boolean pt1Inside = path.contains(x1, y1);
        boolean pt2Inside = path.contains(x2, y2);
        if (pt1Inside && pt2Inside) {
            return 0;
        }
        Line2D[] lines = new Line2D[]{new Line2D.Double(boxPts[0], boxPts[1], boxPts[2], boxPts[3]), new Line2D.Double(boxPts[2], boxPts[3], boxPts[4], boxPts[5]), new Line2D.Double(boxPts[4], boxPts[5], boxPts[6], boxPts[7]), new Line2D.Double(boxPts[6], boxPts[7], boxPts[0], boxPts[1])};
        if (pt1Inside) {
            Point2D intersection = null;
            for (int i = 0; i < 4; ++i) {
                if (!lineSegment.intersectsLine(lines[i])) continue;
                intersection = this.getIntersection(lineSegment, lines[i]);
                break;
            }
            if (intersection != null) {
                segOut[0][0] = intersection.getX();
                segOut[0][1] = intersection.getY();
                segOut[1][0] = x2;
                segOut[1][1] = y2;
                return 1;
            }
        } else if (pt2Inside) {
            Point2D intersection = null;
            for (int i = 0; i < 4; ++i) {
                if (!lineSegment.intersectsLine(lines[i])) continue;
                intersection = this.getIntersection(lineSegment, lines[i]);
                break;
            }
            if (intersection != null) {
                segOut[0][0] = x1;
                segOut[0][1] = y1;
                segOut[1][0] = intersection.getX();
                segOut[1][1] = intersection.getY();
                return 1;
            }
        } else {
            double dist2;
            int i;
            Point2D intersection1 = null;
            for (i = 0; i < 4; ++i) {
                if (!lineSegment.intersectsLine(lines[i])) continue;
                intersection1 = this.getIntersection(lineSegment, lines[i]);
                ++i;
                break;
            }
            Point2D intersection2 = null;
            while (i < 4) {
                if (lineSegment.intersectsLine(lines[i])) {
                    intersection2 = this.getIntersection(lineSegment, lines[i]);
                    break;
                }
                ++i;
            }
            if (intersection1 == null || intersection2 == null) {
                segOut[0][0] = x1;
                segOut[0][1] = y1;
                segOut[1][0] = x2;
                segOut[1][1] = y2;
                return 1;
            }
            double dist1 = ((Line2D)lineSegment).getP1().distanceSq(intersection1);
            if (dist1 > (dist2 = ((Line2D)lineSegment).getP1().distanceSq(intersection2))) {
                Point2D temp = intersection1;
                intersection1 = intersection2;
                intersection2 = temp;
            }
            segOut[0][0] = x1;
            segOut[0][1] = y1;
            segOut[1][0] = intersection1.getX();
            segOut[1][1] = intersection1.getY();
            segOut[2][0] = intersection2.getX();
            segOut[2][1] = intersection2.getY();
            segOut[3][0] = x2;
            segOut[3][1] = y2;
            return 2;
        }
        return 0;
    }

    private Point2D getIntersection(Line2D line1, Line2D line2) {
        if (line1 == null || line2 == null) {
            return null;
        }
        Point2D pt1 = line1.getP1();
        Point2D pt2 = line1.getP2();
        Point2D pt3 = line2.getP1();
        Point2D pt4 = line2.getP2();
        if (pt1 == null || pt2 == null || pt3 == null || pt4 == null) {
            return null;
        }
        double n = (pt4.getX() - pt3.getX()) * (pt1.getY() - pt3.getY()) - (pt4.getY() - pt3.getY()) * (pt1.getX() - pt3.getX());
        double d = (pt4.getY() - pt3.getY()) * (pt2.getX() - pt1.getX()) - (pt4.getX() - pt3.getX()) * (pt2.getY() - pt1.getY());
        if (d == 0.0) {
            return null;
        }
        Point2D.Double intersection = new Point2D.Double(pt1.getX() + (pt2.getX() - pt1.getX()) * n / d, pt1.getY() + (pt2.getY() - pt1.getY()) * n / d);
        return intersection;
    }

    @Override
    protected void OnColor(double r, double g, double b) {
        Color c = new Color((float)r, (float)g, (float)b);
        this.OnColor(c);
    }

    @Override
    protected void OnColor(double r, double g, double b, double o) {
        this.OnColor(r, g, b);
    }

    @Override
    protected void OnColor(Color color) {
        if (color != null && this.ch != null) {
            this.ch.glColor(color);
        }
    }

    @Override
    protected void OnNameSegment(int name) {
        this.OnNameSegment(new Integer(name));
    }

    @Override
    protected void OnNameSegment(Object name) {
        if (this.ch == null) {
            return;
        }
        this.ch.glLoadName(name);
    }

    @Override
    protected void OnBeginPrimitive(int type) {
        switch (type) {
            case 2: 
            case 4: {
                this.glMode = 2;
                break;
            }
            case 1: {
                this.glMode = 1;
            }
        }
        this.ch.glBegin(this.glMode);
    }

    @Override
    protected void OnEndPrimitive(int type) {
        if (this.ch != null) {
            this.ch.glEnd();
        }
    }

    @Override
    protected void OnEdge(boolean edgeOn) {
        if (this.ch == null) {
            return;
        }
        this.ch.glEdgeFlag(edgeOn);
    }

    @Override
    protected void OnVertex(double x, double y, double z) {
        if (this.ch == null) {
            return;
        }
        this.ch.glVertex(x, y, z);
    }

    @Override
    protected void OnNormal(double u, double v, double w) {
        if (this.ch == null) {
            return;
        }
        this.ch.glNormal(u, v, w);
    }

    @Override
    protected void OnMarker(int type, double size, double x, double y, double z) {
    }

    @Override
    protected void applyFont(Font font) {
        if (this.ch == null) {
            return;
        }
        this.ch.glSelect2DFont(font);
    }

    @Override
    protected void applyLineStyle(int style) {
        if (this.ch == null) {
            return;
        }
        int factor = (int)Math.round(this.lineStippleFactor * (double)SASLinePatterns.getStippleFactor((int)style));
        int pattern = SASLinePatterns.getStipplePattern((int)style);
        if (style == 0) {
            this.ch.glDisable(6);
        } else {
            this.ch.glEnable(6);
        }
        this.ch.glLineStipple(factor, pattern);
    }

    @Override
    protected void OnText(String text, double x, double y, double z, int justLR, int justTB, double angle, Object obj) {
        int alignTB;
        int alignLR;
        if (text == null) {
            return;
        }
        switch (justLR) {
            default: {
                alignLR = 0;
                break;
            }
            case 0: {
                alignLR = 1;
                break;
            }
            case 1: {
                alignLR = 2;
            }
        }
        switch (justTB) {
            default: {
                alignTB = 3;
                break;
            }
            case 0: {
                alignTB = 1;
                break;
            }
            case 1: {
                alignTB = 0;
            }
        }
        this.ch.glTextAlign(alignLR, alignTB);
        this.ch.gl2DText(text, x, y, z, (int)angle);
        if (obj != null && obj instanceof double[]) {
            this.getTextBoundingBox(text, x, y, z, justLR, justTB, angle, (double[])obj);
        }
    }

    @Override
    public synchronized void Draw(Object p, boolean callHighlightDraw) {
        if (!this.visible || this.ch == null) {
            return;
        }
        int oldPolygonFillMode = this.ch.getPolygonMode();
        boolean isFillEdgesOn = this.ch.glIsEnabled(9);
        if (this.IsSubdivideOn()) {
            this.ch.glEnable(9);
        }
        switch (this.renderMode) {
            default: {
                if (this.GetOutlinesOn() || this.style == 3) {
                    this.ch.glPolygonMode(4);
                    break;
                }
                this.ch.glPolygonMode(3);
                break;
            }
            case 2: {
                this.ch.glPolygonMode(2);
                break;
            }
            case 0: {
                this.ch.glPolygonMode(1);
            }
        }
        boolean isLightingOn = this.ch.glIsEnabled(3);
        if (this.isLighted) {
            this.ch.glEnable(3);
        } else {
            this.ch.glDisable(3);
        }
        if (this.useDisplayList) {
            this.ch.glCallList(this.ctrId);
        } else {
            this.drawImmediateMode();
        }
        if (callHighlightDraw) {
            this.DrawHighlight(p);
        }
        if (isLightingOn) {
            this.ch.glEnable(3);
        } else {
            this.ch.glDisable(3);
        }
        if (!isFillEdgesOn) {
            this.ch.glDisable(9);
        }
        this.ch.glPolygonMode(oldPolygonFillMode);
    }

    @Override
    public void DrawHighlight(Object p) {
        if (this.ch == null || !this.highlightOn) {
            return;
        }
        if (this.highlightStyle != 2) {
            if (this.useDisplayList) {
                this.ch.glCallList(this.highlightId);
            } else {
                this.highlightBuild = true;
                this.drawImmediateMode();
                this.highlightBuild = false;
            }
        }
        switch (this.highlightStyle) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                if (this.highlightString == null) break;
                this.OnColor(this.highlightColor);
                this.OnText(this.highlightString.trim(), this.highlightX, this.highlightY, this.highlightZ, -1, -1, 0.0, null);
            }
        }
    }

    protected double[] UnProject(int pixelX, int pixelY, double pixelZ) {
        double[] win = new double[3];
        double[] out = new double[3];
        if (out == null || win == null || this.ch == null) {
            return null;
        }
        win[0] = pixelX;
        win[1] = pixelY;
        win[2] = pixelZ;
        this.ch.gluUnProject(win, out);
        return out;
    }

    @Override
    protected void drawErrorMessage(String msg) {
        this.ch.glPushAttrib(0);
        if (this.labelColor != null) {
            this.OnColor(this.labelColor);
        } else {
            this.OnColor(Color.BLACK);
        }
        double[] viewport = this.ch.glGetDoublev(0);
        double[] win = new double[]{viewport[0] + viewport[2] / 2.0, viewport[1] + viewport[3] / 2.0, 0.0};
        double[] obj = new double[3];
        this.ch.gluUnProject(win, obj);
        this.ch.glTextAlign(1, 1);
        this.ch.gl2DText(msg, obj[0], obj[1], 0.0);
        this.ch.glPopAttrib();
    }
}

