/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.ods.visual;

import com.sas.graphics.util.ods.data.BaseData;
import com.sas.graphics.util.ods.visual.IVIZColor;
import com.sas.graphics.util.ods.visual.IVIZColorValue;
import com.sas.graphics.util.ods.visual.IVIZData;
import com.sas.graphics.util.ods.visual.IVIZGeometry;
import com.sas.graphics.util.ods.visual.IVIZProbe;
import com.sas.graphics.util.ods.visual.IVIZRender;
import com.sas.graphics.util.ods.visual.IVIZTransform;
import java.awt.Color;
import java.awt.Dimension;

public abstract class Visual
implements IVIZColorValue,
IVIZData,
IVIZGeometry,
IVIZProbe,
IVIZRender {
    public static final int PointRender = 0;
    public static final int SolidRender = 1;
    public static final int WireFrameRender = 2;
    public static final int PlaneYZ = 0;
    public static final int PlaneXZ = 1;
    public static final int PlaneXY = 2;
    public static final int GLPoints = 0;
    public static final int GLLines = 1;
    public static final int GLTriangles = 2;
    public static final int GLQuads = 3;
    public static final int GLPolygons = 4;
    public static final int GLPolyline = 5;
    public static final int GLPolyloop = 6;
    public static final int GLMarkers = 7;
    public static final int GLLineStrip = 8;
    public static final int GLQuadStrip = 9;
    public static final int GLTriangleStrip = 10;
    protected Object data;
    protected boolean inBuild;
    protected boolean averageVertexColors;
    protected boolean edgeColorSupport;
    protected boolean visible;
    protected boolean isLighted;
    protected boolean useOpacity;
    protected boolean drawMissing;
    protected boolean drawNonMissing;
    protected boolean highlightOn;
    protected int maxWidth;
    protected int maxHeight;
    protected int drawPlane;
    protected int numprimitives;
    protected int renderMode;
    protected double opacity;
    protected double colorMin;
    protected double colorMax;
    protected IVIZColor colorRamp;
    protected IVIZTransform transObj;
    protected boolean useDisplayList = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Visual(Object transObjIn) {
        Visual visual = this;
        synchronized (visual) {
            this.inBuild = false;
        }
        this.SetTransformObject(transObjIn);
        this.visible = true;
        this.averageVertexColors = true;
        this.edgeColorSupport = false;
        this.data = null;
        this.opacity = 1.0;
        this.isLighted = false;
        this.useOpacity = false;
        this.drawMissing = false;
        this.drawNonMissing = true;
        this.maxWidth = -1;
        this.maxHeight = -1;
        this.renderMode = 1;
        this.drawPlane = 2;
        this.numprimitives = 0;
        this.highlightOn = false;
        this.colorMin = Double.NaN;
        this.colorMax = Double.NaN;
        this.colorRamp = null;
    }

    protected void DRAW(double x, double y, double z) {
        switch (this.drawPlane) {
            case 0: {
                this.OnVertex(z, y, x);
                break;
            }
            case 1: {
                this.OnVertex(x, z, y);
                break;
            }
            default: {
                this.OnVertex(x, y, z);
            }
        }
    }

    protected boolean GetColor(double value, double x, double y, double z, int index, long flags, boolean discrete, double[] colorOut) {
        double cLow = 0.0;
        double cHigh = 1.0;
        Color c = null;
        if (colorOut == null || colorOut.length < 3 || this.colorRamp == null) {
            return false;
        }
        if (!Double.isNaN(this.colorMin)) {
            cLow = this.colorMin;
        }
        if (!Double.isNaN(this.colorMax)) {
            cHigh = this.colorMax;
        }
        if ((c = this.colorRamp.Query(value, cLow, cHigh, discrete)) == null) {
            return false;
        }
        colorOut[0] = (double)c.getRed() / 255.0;
        colorOut[1] = (double)c.getGreen() / 255.0;
        colorOut[2] = (double)c.getBlue() / 255.0;
        return true;
    }

    public int GetNumberPrimitives() {
        return this.numprimitives;
    }

    public static double[][] BoundingBoxUnion(double[][] ext1, double[][] ext2) {
        double[][] te = new double[2][3];
        if (ext1 == null) {
            return ext2;
        }
        if (ext2 == null) {
            return ext1;
        }
        double xmin = Math.min(ext1[0][0], ext1[1][0]);
        xmin = Math.min(xmin, ext2[0][0]);
        xmin = Math.min(xmin, ext2[1][0]);
        double ymin = Math.min(ext1[0][1], ext1[1][1]);
        ymin = Math.min(ymin, ext2[0][1]);
        ymin = Math.min(ymin, ext2[1][1]);
        double zmin = Math.min(ext1[0][2], ext1[1][2]);
        zmin = Math.min(zmin, ext2[0][2]);
        zmin = Math.min(zmin, ext2[1][2]);
        double xmax = Math.max(ext1[0][0], ext1[1][0]);
        xmax = Math.max(xmax, ext2[0][0]);
        xmax = Math.max(xmax, ext2[1][0]);
        double ymax = Math.max(ext1[0][1], ext1[1][1]);
        ymax = Math.max(ymax, ext2[0][1]);
        ymax = Math.max(ymax, ext2[1][1]);
        double zmax = Math.max(ext1[0][2], ext1[1][2]);
        zmax = Math.max(zmax, ext2[0][2]);
        zmax = Math.max(zmax, ext2[1][2]);
        te[0][0] = xmin;
        te[0][1] = ymin;
        te[0][2] = zmin;
        te[1][0] = xmax;
        te[1][1] = ymax;
        te[1][2] = zmax;
        return te;
    }

    public boolean GetAverageVertexColors() {
        return this.averageVertexColors;
    }

    public boolean SetAverageVertexColors(boolean average) {
        return false;
    }

    @Override
    public double GetColorMin() {
        return this.colorMin;
    }

    @Override
    public void SetColorMin(double newmin) {
        this.colorMin = newmin;
    }

    @Override
    public double GetColorMax() {
        return this.colorMax;
    }

    @Override
    public void SetColorMax(double newmax) {
        this.colorMax = newmax;
    }

    @Override
    public IVIZColor GetColorRamp() {
        return this.colorRamp;
    }

    @Override
    public void SetColorRamp(IVIZColor newRamp) {
        this.colorRamp = newRamp;
    }

    @Override
    public Object GetDataSourceObject() {
        return this.data;
    }

    @Override
    public boolean SetDataSourceObject(Object dataIn) {
        if (dataIn == null) {
            this.data = null;
            return true;
        }
        if (!(dataIn instanceof BaseData)) {
            return false;
        }
        this.data = dataIn;
        return true;
    }

    @Override
    public boolean RequiresGriddedData() {
        return false;
    }

    @Override
    public double[][] GetBoundingBox() {
        return null;
    }

    @Override
    public Object GetTransformObject(Object transObjIn) {
        return this.transObj;
    }

    @Override
    public boolean SetTransformObject(Object transObjIn) {
        if (!(transObjIn instanceof IVIZTransform)) {
            return false;
        }
        this.transObj = (IVIZTransform)transObjIn;
        return true;
    }

    @Override
    public boolean IsHighlightOn() {
        return this.highlightOn;
    }

    @Override
    public void SetHighlightOn(boolean highlight) {
        this.highlightOn = highlight;
    }

    @Override
    public String GetHighlightStyle() {
        return null;
    }

    @Override
    public boolean SetHighlightStyle(String newstyle) {
        return false;
    }

    @Override
    public Object GetHighlightValues() {
        return null;
    }

    @Override
    public boolean SetHighlightValues(Object highlights) {
        return false;
    }

    @Override
    public Object GetHighLightLocation(boolean inMouseCoordinates) {
        return null;
    }

    @Override
    public boolean SetHighlightLocation(Object loc1, Object loc2) {
        return false;
    }

    @Override
    public boolean UpdateHighlight() {
        return false;
    }

    @Override
    public Color GetHighlightColor() {
        return null;
    }

    @Override
    public boolean SetHighlightColor(Color newColor) {
        return false;
    }

    @Override
    public String GetHighlightValueString() {
        return null;
    }

    @Override
    public boolean GetVisible() {
        return this.visible;
    }

    @Override
    public void SetVisible(boolean viz) {
        this.visible = viz;
    }

    @Override
    public boolean IsLighted() {
        return this.isLighted;
    }

    @Override
    public void SetLighted(boolean onoff) {
        this.isLighted = onoff;
    }

    @Override
    public boolean IsOpaque() {
        return !this.useOpacity || this.opacity <= 1.0;
    }

    @Override
    public boolean GetUseOpacity() {
        return this.useOpacity;
    }

    @Override
    public void SetUseOpacity(boolean useit) {
        this.useOpacity = useit;
    }

    @Override
    public double GetOpacityValue() {
        return this.opacity;
    }

    @Override
    public boolean SetOpacityValue(double newOpacity) {
        if (Double.isNaN(newOpacity) || newOpacity < 0.0 || newOpacity > 1.0) {
            return false;
        }
        this.opacity = newOpacity;
        return true;
    }

    @Override
    public boolean GetDrawMissing() {
        return this.drawMissing;
    }

    @Override
    public void SetDrawMissing(boolean drawem) {
        this.drawMissing = drawem;
    }

    @Override
    public boolean GetDrawNonMissing() {
        return this.drawNonMissing;
    }

    @Override
    public void SetDrawNonMissing(boolean drawem) {
        this.drawNonMissing = drawem;
    }

    public Dimension GetMaximumSize() {
        Dimension d = new Dimension(this.maxWidth, this.maxHeight);
        return d;
    }

    public void SetMaximumSize(int w, int h) {
        this.maxWidth = w;
        this.maxHeight = h;
    }

    @Override
    public String GetRenderMode() {
        String result = null;
        switch (this.renderMode) {
            case 0: {
                result = "Point";
                break;
            }
            case 1: {
                result = "Solid";
                break;
            }
            case 2: {
                result = "Wireframe";
            }
        }
        return result;
    }

    @Override
    public boolean SetRenderMode(String newMode) {
        if (newMode == null) {
            return false;
        }
        if (newMode.equalsIgnoreCase("Point")) {
            this.renderMode = 0;
        } else if (newMode.equalsIgnoreCase("Solid")) {
            this.renderMode = 1;
        } else if (newMode.equalsIgnoreCase("Wireframe")) {
            this.renderMode = 2;
        } else {
            return false;
        }
        return true;
    }

    @Override
    public int GetRenderModeEnum() {
        return this.renderMode;
    }

    @Override
    public boolean SetRenderModeEnum(int enumIn) {
        switch (enumIn) {
            case 0: 
            case 1: 
            case 2: {
                this.renderMode = enumIn;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static boolean FindDrawPlaneIntersection(int plane, double planeCoordinate, double[] point0, double[] point1, double[] intersection) {
        double t;
        if (point0 == null || point0.length < 3 || point1 == null || point1.length < 3 || intersection == null || intersection.length < 4) {
            return false;
        }
        switch (plane) {
            case 0: {
                if (point1[0] - point0[0] == 0.0) {
                    return false;
                }
                t = (planeCoordinate - point0[0]) / (point1[0] - point0[0]);
                break;
            }
            case 1: {
                if (point1[1] - point0[1] == 0.0) {
                    return false;
                }
                t = (planeCoordinate - point0[1]) / (point1[1] - point0[1]);
                break;
            }
            case 2: {
                if (point1[2] - point0[2] == 0.0) {
                    return false;
                }
                t = (planeCoordinate - point0[2]) / (point1[2] - point0[2]);
                break;
            }
            default: {
                return false;
            }
        }
        if (t < 0.0 || t > 1.0) {
            return false;
        }
        intersection[3] = t;
        intersection[0] = point0[0] + t * (point1[0] - point0[0]);
        intersection[1] = point0[1] + t * (point1[1] - point0[1]);
        intersection[2] = point0[2] + t * (point1[2] - point0[2]);
        return true;
    }

    public synchronized boolean GetInBuild() {
        return this.inBuild;
    }

    public abstract boolean Create();

    public boolean Build(Object bldPtr) {
        if (this.useDisplayList) {
            return this.BuildDisplayList(bldPtr);
        }
        return this.BuildImmediateMode(bldPtr);
    }

    protected abstract boolean BuildDisplayList(Object var1);

    protected abstract boolean BuildImmediateMode(Object var1);

    protected abstract boolean BuildSetup();

    protected abstract boolean BuildCleanup();

    protected abstract void BuildError();

    protected abstract boolean BuildSetup_immediateMode();

    protected abstract boolean BuildCleanup_immediateMode();

    protected abstract void BuildError_immediateMode();

    public void setUseDisplayList(boolean useList) {
        this.useDisplayList = useList;
    }

    public boolean getUseDisplayList() {
        return this.useDisplayList;
    }

    protected abstract void OnColor(Color var1);

    protected abstract void OnColor(double var1, double var3, double var5);

    protected abstract void OnColor(double var1, double var3, double var5, double var7);

    protected abstract void OnNameSegment(int var1);

    protected abstract void OnNameSegment(Object var1);

    protected abstract void OnBeginPrimitive(int var1);

    protected abstract void OnEndPrimitive(int var1);

    protected abstract void OnEdge(boolean var1);

    protected abstract void OnVertex(double var1, double var3, double var5);

    protected abstract void OnNormal(double var1, double var3, double var5);

    protected abstract void OnMarker(int var1, double var2, double var4, double var6, double var8);

    protected abstract void OnText(String var1, double var2, double var4, double var6, int var8, int var9, double var10, Object var12);

    public abstract void Draw(Object var1, boolean var2);

    public abstract void DrawHighlight(Object var1);
}

