/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.ods.visual;

import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.NumericFormat;
import com.sas.graphics.util.ods.data.DataVariableInterface;
import com.sas.graphics.util.ods.data.GriddedChartData;
import com.sas.graphics.util.ods.visual.ColorRamp;
import com.sas.graphics.util.ods.visual.DynamicDoubleArray;
import com.sas.graphics.util.ods.visual.IVIZColor;
import com.sas.graphics.util.ods.visual.Visual;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.BitSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class Contours
extends Visual {
    public static final int MAX_CONTOUR_RESP = 3;
    public static final int MaxCntrLevels = 100;
    public static final int MAX_SUBDIVIDE_DEPTH = 5;
    public static final int X_ROLE = 0;
    public static final int Y_ROLE = 1;
    public static final int RESPONSE_ROLE = 2;
    protected static double[] sCuts = new double[]{1.0, 2.0, 4.0, 5.0};
    protected static double[] iCuts = new double[]{1.0, 2.0, 2.5, 5.0};
    protected static double logTen = Math.log(10.0);
    public static final int Area = 0;
    public static final int Block = 1;
    public static final int Lines = 2;
    public static final int LinesAndAreas = 3;
    public static final int Smooth = 4;
    public static final int Surface = 5;
    public static final int ContourLine = 0;
    public static final int ContourLineLabel = 1;
    public static final int Label = 2;
    public static final int MARCHING_SQUARES_ALGORITHM = 0;
    public static final int CONTOUR_TRACKING_ALGORITHM = 1;
    public static final int LABELS_NONE = 0;
    public static final int LABELS_INSIDE = 1;
    public static final int LABELS_OUTSIDE = 2;
    public static final int LABELS_HORIZONTAL = 0;
    public static final int LABELS_ALONG = 1;
    public static final int LABELS_POSITION_BEGIN = 0;
    public static final int LABELS_POSITION_MIDDLE = 1;
    public static final int LABELS_POSITION_END = 2;
    protected static final int TOP_EDGE = 0;
    protected static final int RIGHT_EDGE = 1;
    protected static final int BOTTOM_EDGE = 2;
    protected static final int LEFT_EDGE = 3;
    protected static final int INSIDE = 4;
    protected static final double RAD2DEG = 57.29577951308232;
    protected static final int[] trackingList = new int[]{0, 1, 2, 3, 4};
    static final int XData = 0;
    static final int YData = 1;
    static final int ResponseData = 2;
    protected int curSegmentName = -1;
    protected int highlightStyle = 1;
    protected int contourAlgorithm = 0;
    protected boolean pickEnable = true;
    protected boolean highlightBuild = false;
    protected String highlightString = null;
    protected boolean useHighlightColor = true;
    protected boolean outlinesOn = false;
    protected double highlightValue;
    protected double highlightX;
    protected double highlightY;
    protected double highlightZ;
    protected double highlightAreaStartValue;
    protected double highlightAreaEndValue;
    protected int style = 1;
    protected int zoffset;
    protected double base;
    protected boolean drawSides = false;
    protected boolean stacked = false;
    protected boolean shadeMissing = true;
    protected double maxStack = 1.0;
    protected int selectedLevelIndex = -1;
    protected int numlevels = 0;
    protected int startLevel;
    protected int lastLevel;
    protected boolean subDivide = false;
    protected int subDivideDepth = 3;
    protected double subDivideAmount = 1.0;
    protected boolean useLOD = false;
    protected int lodCount = 2000;
    protected Area labelArea;
    protected Font font;
    protected static final Font defaultFont = FontManager.getFont((String)"sansserif", (int)0, (int)12);
    protected Color labelColor = null;
    protected SASFormat ggoodLabelFormat;
    protected SASFormat userLabelFormat;
    protected boolean ggood;
    protected int linestyle;
    protected double lineStippleFactor = 1.0;
    protected static final int solidLinestyle = 0;
    protected int lineWidth = 1;
    protected boolean thinLabels = true;
    protected boolean showLineOverlay = false;
    protected Color lineOverlayColor = Color.BLACK;
    protected int xLowLimit = -1;
    protected int xHighLimit = -1;
    protected int yLowLimit = -1;
    protected int yHighLimit = -1;
    protected int highlight_ix = -1;
    protected int highlight_iy = -1;
    protected int totalResp = 0;
    protected int labelStyle = 0;
    protected int labelPosition = 1;
    protected int labelOrientation = 0;
    protected DynamicDoubleArray segments;
    protected int[] numpairs;
    protected int[] cell_case;
    protected double[] outlineColor;
    protected Color highlightColor;
    protected double[] surfaceColor = null;
    protected Color surfaceSideColor = null;
    protected double[][] rgb;
    protected double[] levels;
    protected double[] height;
    protected double[][][] intersections;
    protected BitSet[][] found;
    protected Locale locale = null;

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    protected abstract double getTextWidth(String var1);

    protected abstract void getTextBoundingBox(String var1, double var2, double var4, double var6, int var8, int var9, double var10, double[] var12);

    protected abstract void getTextBBoxPts(String var1, double var2, double var4, double var6, int var8, int var9, double var10, double[] var12);

    protected abstract void drawLineSegment(double var1, double var3, double var5, double var7, double var9, String var11, double[] var12, double var13);

    protected abstract Vector createLineSegments(double[] var1, int var2, double[] var3);

    protected abstract void drawLineLabel(String var1, double var2, double var4, double var6, double var8);

    protected abstract double getLabelAngle(double var1, double var3, double var5, double var7);

    protected abstract void drawErrorMessage(String var1);

    public Contours(Object transObjIn) {
        super(transObjIn);
        int i;
        this.highlightValue = Double.NaN;
        this.highlightAreaStartValue = Double.NaN;
        this.highlightAreaEndValue = Double.NaN;
        this.highlightX = Double.NaN;
        this.highlightY = Double.NaN;
        this.highlightY = Double.NaN;
        this.highlightColor = SystemColor.windowText;
        this.outlineColor = new double[3];
        if (this.outlineColor != null) {
            this.outlineColor[0] = (double)SystemColor.windowText.getRed() / 255.0;
            this.outlineColor[1] = (double)SystemColor.windowText.getGreen() / 255.0;
            this.outlineColor[2] = (double)SystemColor.windowText.getBlue() / 255.0;
        }
        this.segments = new DynamicDoubleArray();
        this.numpairs = new int[101];
        this.cell_case = new int[101];
        this.rgb = new double[101][4];
        for (i = 0; i < this.rgb.length; ++i) {
            this.rgb[i][2] = 0.0;
            this.rgb[i][1] = 0.0;
            this.rgb[i][0] = 0.0;
        }
        this.levels = new double[100];
        this.height = new double[101];
        this.intersections = new double[101][4][2];
        for (i = 0; i < this.intersections.length; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.intersections[i][j][0] = 0.0;
                this.intersections[i][j][1] = 0.0;
            }
        }
        this.zoffset = 0;
        this.base = 0.0;
        this.ggood = true;
        this.GenerateLevels(6, 1.0, 10.0, false);
        this.startLevel = 0;
        this.lastLevel = 5;
        this.found = null;
        this.labelArea = new Area();
        this.font = defaultFont;
        this.linestyle = 0;
        this.ggood = true;
    }

    private double[] GetChartData(int type) {
        double[] out = null;
        if (this.data == null || !(this.data instanceof GriddedChartData)) {
            return null;
        }
        switch (type) {
            case 0: {
                out = ((GriddedChartData)this.data).GetXData();
                break;
            }
            case 1: {
                out = ((GriddedChartData)this.data).GetYData();
            }
        }
        return out;
    }

    private static int binarylookup(double val, double[] vec, int uselen) {
        int len = uselen;
        if (len < 0) {
            len = vec.length;
        }
        int ret = -1;
        int lo = 0;
        int mi = 0;
        int hi = len - 1;
        while (lo <= hi) {
            mi = (lo + hi) / 2;
            ret = val < vec[mi] ? -1 : (val > vec[mi] ? 1 : 0);
            switch (ret) {
                case -1: {
                    hi = mi - 1;
                    break;
                }
                case 0: {
                    return mi;
                }
                case 1: {
                    lo = mi + 1;
                }
            }
        }
        if (ret != 1) {
            ret = 0;
        }
        return -(mi + 1 + ret);
    }

    private double[] UnitCrossProduct(double u1, double v1, double w1, double u2, double v2, double w2) {
        double[] p = new double[3];
        if (p == null) {
            return null;
        }
        double u = v1 * w2 - w1 * v2;
        double v = w1 * u2 - u1 * w2;
        double w = u1 * v2 - v1 * u2;
        double len = Math.sqrt(u * u + v * v + w * w);
        if (len == 0.0) {
            return null;
        }
        p = new double[]{u / len, v / len, w / len};
        return p;
    }

    private void SET_NORMAL() {
        switch (this.drawPlane) {
            case 0: {
                this.OnNormal(1.0, 0.0, 0.0);
                break;
            }
            case 1: {
                this.OnNormal(0.0, 1.0, 0.0);
                break;
            }
            default: {
                this.OnNormal(0.0, 0.0, 1.0);
            }
        }
    }

    private void SET_NORMAL(double x, double y, double z) {
        switch (this.drawPlane) {
            case 0: {
                this.OnNormal(z, y, x);
                break;
            }
            case 1: {
                this.OnNormal(x, z, y);
                break;
            }
            default: {
                this.OnNormal(x, y, z);
            }
        }
    }

    private static int findcase(double isovalue, double[] cell) {
        int[] case_mask = new int[]{1, 2, 4, 8};
        int retval = 0;
        for (int i = 0; i < 4; ++i) {
            if (!(cell[i] >= isovalue)) continue;
            retval |= case_mask[i];
        }
        return retval;
    }

    private static double INTERP(double v, double r1, double x1, double r2, double x2) {
        return (x2 - x1) * (v - r1) / (r2 - r1) + x1;
    }

    private static int findintersections(double left, double right, double bottom, double top, double value, double[] cellccw, int cell_case, double[][] isects) {
        int numpairs = 0;
        int index = 0;
        switch (cell_case) {
            case 4: 
            case 5: 
            case 11: {
                index = cell_case == 5 ? 2 : 0;
                ++numpairs;
                isects[index][0] = right;
                isects[index++][1] = Contours.INTERP(value, cellccw[1], bottom, cellccw[2], top);
                isects[index][0] = Contours.INTERP(value, cellccw[2], right, cellccw[3], left);
                isects[index++][1] = top;
                if (cell_case != 5) break;
            }
            case 1: 
            case 14: {
                index = 0;
                ++numpairs;
                isects[index][0] = Contours.INTERP(value, cellccw[0], left, cellccw[1], right);
                isects[index++][1] = bottom;
                isects[index][0] = left;
                isects[index++][1] = Contours.INTERP(value, cellccw[3], top, cellccw[0], bottom);
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                index = cell_case == 10 ? 2 : 0;
                ++numpairs;
                isects[index][0] = Contours.INTERP(value, cellccw[2], right, cellccw[3], left);
                isects[index++][1] = top;
                isects[index][0] = left;
                isects[index++][1] = Contours.INTERP(value, cellccw[3], top, cellccw[0], bottom);
                if (cell_case != 10) break;
            }
            case 2: 
            case 13: {
                index = 0;
                ++numpairs;
                isects[index][0] = Contours.INTERP(value, cellccw[0], left, cellccw[1], right);
                isects[index++][1] = bottom;
                isects[index][0] = right;
                isects[index++][1] = Contours.INTERP(value, cellccw[1], bottom, cellccw[2], top);
                break;
            }
            case 6: 
            case 9: {
                index = 0;
                ++numpairs;
                isects[index][0] = Contours.INTERP(value, cellccw[0], left, cellccw[1], right);
                isects[index++][1] = bottom;
                isects[index][0] = Contours.INTERP(value, cellccw[2], right, cellccw[3], left);
                isects[index++][1] = top;
                break;
            }
            case 3: 
            case 12: {
                index = 0;
                ++numpairs;
                isects[index][0] = right;
                isects[index++][1] = Contours.INTERP(value, cellccw[1], bottom, cellccw[2], top);
                isects[index][0] = left;
                isects[index++][1] = Contours.INTERP(value, cellccw[3], top, cellccw[0], bottom);
                break;
            }
            default: {
                return numpairs;
            }
        }
        return numpairs;
    }

    private double[][] GetResponsePointers() {
        int count = 0;
        double[][] returnArray = null;
        if (this.data == null) {
            return null;
        }
        count = 0;
        while (((GriddedChartData)this.data).GetResponseData(count) != null) {
            ++count;
        }
        if (count == 0) {
            return null;
        }
        returnArray = new double[count][];
        if (returnArray == null) {
            return null;
        }
        for (int i = 0; i < count; ++i) {
            returnArray[i] = ((GriddedChartData)this.data).GetResponseData(i);
        }
        return returnArray;
    }

    private synchronized int DrawLines(int start, int stop, boolean outlineDraw) {
        int numlinesegments = 0;
        for (int i = start; i <= stop; ++i) {
            for (int j = 0; j < this.numpairs[i]; ++j) {
                double z;
                if (outlineDraw) {
                    this.OnColor(this.outlineColor[0], this.outlineColor[1], this.outlineColor[2]);
                    z = this.height[i] == 0.0 ? 0.001 : this.height[i] * 1.001;
                } else {
                    this.OnColor(this.rgb[i][0], this.rgb[i][1], this.rgb[i][2]);
                    z = this.height[i];
                }
                this.drawLineSegment(this.intersections[i][2 * j][0], this.intersections[i][2 * j][1], this.intersections[i][2 * j + 1][0], this.intersections[i][2 * j + 1][1], z, null, null, 0.0);
                ++numlinesegments;
            }
        }
        return numlinesegments;
    }

    protected void ApplyEdge(boolean edgeOn) {
        if (this.style != 0 && this.style != 3) {
            return;
        }
        this.OnEdge(edgeOn);
    }

    protected boolean DrawSides() {
        switch (this.style) {
            case 0: 
            case 3: {
                return this.drawSides && this.stacked;
            }
            case 5: {
                return this.drawSides;
            }
        }
        return false;
    }

    protected void SetCaseNormal(int caseid, int caseidx, boolean first, double prevZZ, double zz) {
        double[] p = null;
        switch (caseid) {
            default: {
                return;
            }
            case 1: {
                p = this.UnitCrossProduct(this.intersections[caseidx][1][0] - this.intersections[caseidx][0][0], this.intersections[caseidx][1][1] - this.intersections[caseidx][0][1], 0.0, 0.0, 0.0, zz - prevZZ);
                break;
            }
            case 2: {
                p = this.UnitCrossProduct(this.intersections[caseidx][1][0] - this.intersections[caseidx][0][0], this.intersections[caseidx][1][1] - this.intersections[caseidx][0][1], 0.0, 0.0, 0.0, prevZZ - zz);
                break;
            }
            case 3: {
                p = this.UnitCrossProduct(this.intersections[caseidx][1][0] - this.intersections[caseidx][0][0], this.intersections[caseidx][1][1] - this.intersections[caseidx][0][1], 0.0, 0.0, 0.0, zz - prevZZ);
                break;
            }
            case 4: {
                p = this.UnitCrossProduct(this.intersections[caseidx][1][0] - this.intersections[caseidx][0][0], this.intersections[caseidx][1][1] - this.intersections[caseidx][0][1], 0.0, 0.0, 0.0, prevZZ - zz);
                break;
            }
            case 5: {
                if (first) {
                    p = this.UnitCrossProduct(this.intersections[caseidx][1][0] - this.intersections[caseidx][0][0], this.intersections[caseidx][1][1] - this.intersections[caseidx][0][1], 0.0, 0.0, 0.0, zz - prevZZ);
                    break;
                }
                p = this.UnitCrossProduct(this.intersections[caseidx][3][0] - this.intersections[caseidx][2][0], this.intersections[caseidx][3][1] - this.intersections[caseidx][2][1], 0.0, 0.0, 0.0, prevZZ - zz);
                break;
            }
            case 6: {
                p = this.UnitCrossProduct(this.intersections[caseidx][1][0] - this.intersections[caseidx][0][0], this.intersections[caseidx][1][1] - this.intersections[caseidx][0][1], 0.0, 0.0, 0.0, prevZZ - zz);
                break;
            }
            case 7: {
                p = this.UnitCrossProduct(this.intersections[caseidx][1][0] - this.intersections[caseidx][0][0], this.intersections[caseidx][1][1] - this.intersections[caseidx][0][1], 0.0, 0.0, 0.0, zz - prevZZ);
                break;
            }
            case 8: {
                p = this.UnitCrossProduct(this.intersections[caseidx][1][0] - this.intersections[caseidx][0][0], this.intersections[caseidx][1][1] - this.intersections[caseidx][0][1], 0.0, 0.0, 0.0, prevZZ - zz);
                break;
            }
            case 9: {
                p = this.UnitCrossProduct(this.intersections[caseidx][1][0] - this.intersections[caseidx][0][0], this.intersections[caseidx][1][1] - this.intersections[caseidx][0][1], 0.0, 0.0, 0.0, zz - prevZZ);
                break;
            }
            case 10: {
                if (first) {
                    p = this.UnitCrossProduct(this.intersections[caseidx][1][0] - this.intersections[caseidx][0][0], this.intersections[caseidx][1][1] - this.intersections[caseidx][0][1], 0.0, 0.0, 0.0, prevZZ - zz);
                    break;
                }
                p = this.UnitCrossProduct(this.intersections[caseidx][3][0] - this.intersections[caseidx][2][0], this.intersections[caseidx][3][1] - this.intersections[caseidx][2][1], 0.0, 0.0, 0.0, prevZZ - zz);
                break;
            }
            case 11: {
                p = this.UnitCrossProduct(this.intersections[caseidx][1][0] - this.intersections[caseidx][0][0], this.intersections[caseidx][1][1] - this.intersections[caseidx][0][1], 0.0, 0.0, 0.0, zz - prevZZ);
                break;
            }
            case 12: {
                p = this.UnitCrossProduct(this.intersections[caseidx][1][0] - this.intersections[caseidx][0][0], this.intersections[caseidx][1][1] - this.intersections[caseidx][0][1], 0.0, 0.0, 0.0, prevZZ - zz);
                break;
            }
            case 13: {
                p = this.UnitCrossProduct(this.intersections[caseidx][1][0] - this.intersections[caseidx][0][0], this.intersections[caseidx][1][1] - this.intersections[caseidx][0][1], 0.0, 0.0, 0.0, zz - prevZZ);
                break;
            }
            case 14: {
                p = this.UnitCrossProduct(this.intersections[caseidx][1][0] - this.intersections[caseidx][0][0], this.intersections[caseidx][1][1] - this.intersections[caseidx][0][1], 0.0, 0.0, 0.0, prevZZ - zz);
            }
        }
        if (p != null) {
            this.SET_NORMAL(p[0], p[1], p[2]);
        }
    }

    protected synchronized int DoSides(int caseid, int caseidx, double prevZZ, double zz) {
        int numpolygons = 0;
        if (!this.DrawSides()) {
            return numpolygons;
        }
        switch (caseid) {
            default: {
                break;
            }
            case 1: {
                this.SetCaseNormal(caseid, caseidx, false, prevZZ, zz);
                if (this.pickEnable && this.stacked) {
                    this.OnNameSegment(null);
                }
                this.OnBeginPrimitive(4);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], zz);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], zz);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], prevZZ);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], prevZZ);
                this.OnEndPrimitive(4);
                ++numpolygons;
                break;
            }
            case 2: {
                this.SetCaseNormal(caseid, caseidx, false, prevZZ, zz);
                if (this.pickEnable && this.stacked) {
                    this.OnNameSegment(null);
                }
                this.OnBeginPrimitive(4);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], prevZZ);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], prevZZ);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], zz);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], zz);
                this.OnEndPrimitive(4);
                ++numpolygons;
                break;
            }
            case 3: {
                this.SetCaseNormal(caseid, caseidx, false, prevZZ, zz);
                if (this.pickEnable && this.stacked) {
                    this.OnNameSegment(null);
                }
                this.OnBeginPrimitive(4);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], zz);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], zz);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], prevZZ);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], prevZZ);
                this.OnEndPrimitive(4);
                ++numpolygons;
                break;
            }
            case 4: {
                this.SetCaseNormal(caseid, caseidx, false, prevZZ, zz);
                if (this.pickEnable && this.stacked) {
                    this.OnNameSegment(null);
                }
                this.OnBeginPrimitive(4);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], prevZZ);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], prevZZ);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], zz);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], zz);
                this.OnEndPrimitive(4);
                ++numpolygons;
                break;
            }
            case 5: {
                this.SetCaseNormal(caseid, caseidx, true, prevZZ, zz);
                if (this.pickEnable && this.stacked) {
                    this.OnNameSegment(null);
                }
                this.OnBeginPrimitive(4);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], zz);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], zz);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], prevZZ);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], prevZZ);
                this.OnEndPrimitive(4);
                this.SetCaseNormal(caseid, caseidx, false, prevZZ, zz);
                if (this.pickEnable && this.stacked) {
                    this.OnNameSegment(null);
                }
                this.OnBeginPrimitive(4);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][2][0], this.intersections[caseidx][2][1], prevZZ);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][3][0], this.intersections[caseidx][3][1], prevZZ);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][3][0], this.intersections[caseidx][3][1], zz);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][2][0], this.intersections[caseidx][2][1], zz);
                this.OnEndPrimitive(4);
                numpolygons += 2;
                break;
            }
            case 6: {
                this.SetCaseNormal(caseid, caseidx, false, prevZZ, zz);
                if (this.pickEnable && this.stacked) {
                    this.OnNameSegment(null);
                }
                this.OnBeginPrimitive(4);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], prevZZ);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], prevZZ);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], zz);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], zz);
                this.OnEndPrimitive(4);
                ++numpolygons;
                break;
            }
            case 7: {
                this.SetCaseNormal(caseid, caseidx, false, prevZZ, zz);
                if (this.pickEnable && this.stacked) {
                    this.OnNameSegment(null);
                }
                this.OnBeginPrimitive(4);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], zz);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], zz);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], prevZZ);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], prevZZ);
                this.OnEndPrimitive(4);
                ++numpolygons;
                break;
            }
            case 8: {
                this.SetCaseNormal(caseid, caseidx, false, prevZZ, zz);
                if (this.pickEnable && this.stacked) {
                    this.OnNameSegment(null);
                }
                this.OnBeginPrimitive(4);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], prevZZ);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], prevZZ);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], zz);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], zz);
                this.OnEndPrimitive(4);
                ++numpolygons;
                break;
            }
            case 9: {
                this.SetCaseNormal(caseid, caseidx, false, prevZZ, zz);
                if (this.pickEnable && this.stacked) {
                    this.OnNameSegment(null);
                }
                this.OnBeginPrimitive(4);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], zz);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], zz);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], prevZZ);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], prevZZ);
                this.OnEndPrimitive(4);
                ++numpolygons;
                break;
            }
            case 10: {
                this.SetCaseNormal(caseid, caseidx, false, prevZZ, zz);
                if (this.pickEnable && this.stacked) {
                    this.OnNameSegment(null);
                }
                this.OnBeginPrimitive(4);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], prevZZ);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], prevZZ);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], zz);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], zz);
                this.OnEndPrimitive(4);
                this.SetCaseNormal(caseid, caseidx, true, prevZZ, zz);
                if (this.pickEnable && this.stacked) {
                    this.OnNameSegment(null);
                }
                this.OnBeginPrimitive(4);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][2][0], this.intersections[caseidx][2][1], prevZZ);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][3][0], this.intersections[caseidx][3][1], prevZZ);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][3][0], this.intersections[caseidx][3][1], zz);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][2][0], this.intersections[caseidx][2][1], zz);
                this.OnEndPrimitive(4);
                numpolygons += 2;
                break;
            }
            case 11: {
                this.SetCaseNormal(caseid, caseidx, false, prevZZ, zz);
                if (this.pickEnable && this.stacked) {
                    this.OnNameSegment(null);
                }
                this.OnBeginPrimitive(4);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], zz);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], zz);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], prevZZ);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], prevZZ);
                this.OnEndPrimitive(4);
                ++numpolygons;
                break;
            }
            case 12: {
                this.SetCaseNormal(caseid, caseidx, false, prevZZ, zz);
                if (this.pickEnable && this.stacked) {
                    this.OnNameSegment(null);
                }
                this.OnBeginPrimitive(4);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], prevZZ);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], prevZZ);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], zz);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], zz);
                this.OnEndPrimitive(4);
                ++numpolygons;
                break;
            }
            case 13: {
                this.SetCaseNormal(caseid, caseidx, false, prevZZ, zz);
                if (this.pickEnable && this.stacked) {
                    this.OnNameSegment(null);
                }
                this.OnBeginPrimitive(4);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], zz);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], zz);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], prevZZ);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], prevZZ);
                this.OnEndPrimitive(4);
                ++numpolygons;
                break;
            }
            case 14: {
                this.SetCaseNormal(caseid, caseidx, false, prevZZ, zz);
                if (this.pickEnable && this.stacked) {
                    this.OnNameSegment(null);
                }
                this.OnBeginPrimitive(4);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], prevZZ);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], prevZZ);
                this.ApplyEdge(true);
                this.DRAW(this.intersections[caseidx][1][0], this.intersections[caseidx][1][1], zz);
                this.ApplyEdge(false);
                this.DRAW(this.intersections[caseidx][0][0], this.intersections[caseidx][0][1], zz);
                this.OnEndPrimitive(4);
                ++numpolygons;
            }
        }
        return numpolygons;
    }

    private synchronized int DrawPolygons(double left, double right, double bottom, double top) {
        int curcaseidx = this.startLevel;
        int prevcaseidx = this.startLevel - 1;
        int numpolygons = 0;
        while (this.cell_case[curcaseidx] == 15) {
            ++curcaseidx;
            ++prevcaseidx;
        }
        while (curcaseidx <= this.lastLevel) {
            double prevZZ;
            int prevcase;
            if (this.DrawSides()) {
                this.SET_NORMAL();
            }
            double zz = this.height[curcaseidx];
            int curcase = this.cell_case[curcaseidx];
            if (prevcaseidx < 0) {
                prevcase = 15;
                prevZZ = this.base;
            } else {
                prevcase = this.cell_case[prevcaseidx];
                prevZZ = this.height[prevcaseidx];
            }
            int prevnumpolygons = numpolygons;
            block0 : switch (curcase) {
                case 0: {
                    switch (prevcase) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 2: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.DRAW(right, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 3: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.DRAW(right, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 4: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.DRAW(right, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 5: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.OnEndPrimitive(4);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][2][0], this.intersections[prevcaseidx][2][1], zz);
                            this.DRAW(right, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][3][0], this.intersections[prevcaseidx][3][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            numpolygons += 2;
                            break block0;
                        }
                        case 6: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.DRAW(right, bottom, zz);
                            this.DRAW(right, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 7: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.DRAW(right, bottom, zz);
                            this.DRAW(right, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 8: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.DRAW(left, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 9: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.DRAW(left, top, zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 10: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.DRAW(right, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][2][0], this.intersections[prevcaseidx][2][1], zz);
                            this.DRAW(left, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][3][0], this.intersections[prevcaseidx][3][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            numpolygons += 2;
                            break block0;
                        }
                        case 11: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.DRAW(right, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.DRAW(left, top, zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 12: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.DRAW(right, top, zz);
                            this.DRAW(left, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 13: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.DRAW(right, top, zz);
                            this.DRAW(left, top, zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 14: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.DRAW(right, bottom, zz);
                            this.DRAW(right, top, zz);
                            this.DRAW(left, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 15: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.DRAW(right, bottom, zz);
                            this.DRAW(right, top, zz);
                            this.DRAW(left, top, zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (prevcase) {
                        case 1: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 3: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.DRAW(right, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 5: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][2][0], this.intersections[prevcaseidx][2][1], zz);
                            this.DRAW(right, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][3][0], this.intersections[prevcaseidx][3][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            numpolygons += 2;
                            break block0;
                        }
                        case 7: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.DRAW(right, bottom, zz);
                            this.DRAW(right, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 9: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.DRAW(left, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 11: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.DRAW(right, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.DRAW(left, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 13: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.DRAW(right, top, zz);
                            this.DRAW(left, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 15: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.DRAW(right, bottom, zz);
                            this.DRAW(right, top, zz);
                            this.DRAW(left, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (prevcase) {
                        case 2: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 3: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 6: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.DRAW(right, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 7: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.DRAW(right, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 10: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][2][0], this.intersections[prevcaseidx][2][1], zz);
                            this.DRAW(left, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][3][0], this.intersections[prevcaseidx][3][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            numpolygons += 2;
                            break block0;
                        }
                        case 11: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.DRAW(left, top, zz);
                            this.DRAW(left, bottom, zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 14: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.DRAW(right, top, zz);
                            this.DRAW(left, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 15: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.DRAW(right, top, zz);
                            this.DRAW(left, top, zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (prevcase) {
                        case 3: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 7: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.DRAW(right, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 11: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.DRAW(left, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 15: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.DRAW(right, top, zz);
                            this.DRAW(left, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (prevcase) {
                        case 4: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 5: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.OnEndPrimitive(4);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][2][0], this.intersections[prevcaseidx][2][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][3][0], this.intersections[prevcaseidx][3][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            numpolygons += 2;
                            break block0;
                        }
                        case 6: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.DRAW(right, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 7: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.DRAW(right, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 12: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.DRAW(left, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 13: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.DRAW(left, top, zz);
                            this.DRAW(left, bottom, zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 14: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.DRAW(right, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.DRAW(left, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 15: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.DRAW(right, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.DRAW(left, top, zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (prevcase) {
                        case 5: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][2][0], this.intersections[prevcaseidx][2][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][2][0], this.intersections[curcaseidx][2][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][3][0], this.intersections[curcaseidx][3][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][3][0], this.intersections[prevcaseidx][3][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            numpolygons += 2;
                            break block0;
                        }
                        case 7: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.DRAW(right, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][2][0], this.intersections[curcaseidx][2][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][3][0], this.intersections[curcaseidx][3][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 13: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][2][0], this.intersections[curcaseidx][2][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][3][0], this.intersections[curcaseidx][3][1], zz);
                            this.DRAW(left, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 15: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.DRAW(right, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][2][0], this.intersections[curcaseidx][2][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][3][0], this.intersections[curcaseidx][3][1], zz);
                            this.DRAW(left, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (prevcase) {
                        case 6: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 7: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 14: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.DRAW(left, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 15: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.DRAW(left, top, zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                    }
                    break;
                }
                case 7: {
                    switch (prevcase) {
                        case 7: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 15: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.DRAW(left, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                    }
                    break;
                }
                case 8: {
                    switch (prevcase) {
                        case 8: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 9: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.DRAW(left, bottom, zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 10: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.DRAW(right, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][2][0], this.intersections[prevcaseidx][2][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][3][0], this.intersections[prevcaseidx][3][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            numpolygons += 2;
                            break block0;
                        }
                        case 11: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.DRAW(right, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 12: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.DRAW(right, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 13: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.DRAW(right, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 14: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.DRAW(right, bottom, zz);
                            this.DRAW(right, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 15: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.DRAW(right, bottom, zz);
                            this.DRAW(right, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                    }
                    break;
                }
                case 9: {
                    switch (prevcase) {
                        case 9: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 11: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.DRAW(right, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 13: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.DRAW(right, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 15: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.DRAW(right, bottom, zz);
                            this.DRAW(right, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                    }
                    break;
                }
                case 10: {
                    switch (prevcase) {
                        case 10: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][2][0], this.intersections[prevcaseidx][2][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][2][0], this.intersections[curcaseidx][2][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][3][0], this.intersections[curcaseidx][3][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][3][0], this.intersections[prevcaseidx][3][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            numpolygons += 2;
                            break block0;
                        }
                        case 11: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.DRAW(this.intersections[curcaseidx][2][0], this.intersections[curcaseidx][2][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][3][0], this.intersections[curcaseidx][3][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 14: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.DRAW(right, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][2][0], this.intersections[curcaseidx][2][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][3][0], this.intersections[curcaseidx][3][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 15: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.DRAW(right, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][2][0], this.intersections[curcaseidx][2][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][3][0], this.intersections[curcaseidx][3][1], zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                    }
                    break;
                }
                case 11: {
                    switch (prevcase) {
                        case 11: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 15: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.DRAW(right, top, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                    }
                    break;
                }
                case 12: {
                    switch (prevcase) {
                        case 12: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 13: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 14: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.DRAW(right, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 15: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.DRAW(right, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                    }
                    break;
                }
                case 13: {
                    switch (prevcase) {
                        case 13: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 15: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.DRAW(right, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                    }
                    break;
                }
                case 14: {
                    switch (prevcase) {
                        case 14: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(this.intersections[prevcaseidx][0][0], this.intersections[prevcaseidx][0][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[prevcaseidx][1][0], this.intersections[prevcaseidx][1][1], zz);
                            this.ApplyEdge(false);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                        case 15: {
                            this.OnColor(this.rgb[curcaseidx][0], this.rgb[curcaseidx][1], this.rgb[curcaseidx][2]);
                            if (this.pickEnable && this.stacked) {
                                this.NameSegment(left, bottom, zz, right, bottom, zz, right, top, zz);
                            }
                            this.OnBeginPrimitive(4);
                            this.DRAW(left, bottom, zz);
                            this.ApplyEdge(true);
                            this.DRAW(this.intersections[curcaseidx][0][0], this.intersections[curcaseidx][0][1], zz);
                            this.ApplyEdge(false);
                            this.DRAW(this.intersections[curcaseidx][1][0], this.intersections[curcaseidx][1][1], zz);
                            this.OnEndPrimitive(4);
                            ++numpolygons;
                            break block0;
                        }
                    }
                    break;
                }
            }
            if (numpolygons > prevnumpolygons) {
                numpolygons += this.DoSides(prevcase, prevcaseidx, prevZZ, zz);
            }
            ++curcaseidx;
            ++prevcaseidx;
        }
        if (!this.edgeColorSupport && (this.GetOutlinesOn() || this.style == 3)) {
            this.DrawLines(this.startLevel, this.lastLevel, true);
        }
        return numpolygons;
    }

    private int FindTotalMissing(int[][][] missingarray, int count, int[][] allmissing) {
        int total = 0;
        if (allmissing == null || missingarray == null) {
            return -1;
        }
        allmissing[1][1] = 0;
        allmissing[1][0] = 0;
        allmissing[0][1] = 0;
        allmissing[0][0] = 0;
        for (int i = 0; i < count; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    if (allmissing[j][k] != 0 || missingarray[i][j][k] == 0) continue;
                    allmissing[j][k] = 1;
                    ++total;
                }
            }
        }
        return total;
    }

    private boolean AverageColors(int nColors, int m1, double[] c1, int m2, double[] c2, int m3, double[] c3, int m4, double[] c4, double[] colorOut) {
        int isMissing = 0;
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        double[] cPtr = null;
        if (nColors < 1 || nColors > 4) {
            return false;
        }
        for (int i = 0; i < nColors; ++i) {
            switch (i) {
                case 0: {
                    isMissing = m1;
                    cPtr = c1;
                    break;
                }
                case 1: {
                    isMissing = m2;
                    cPtr = c2;
                    break;
                }
                case 2: {
                    isMissing = m3;
                    cPtr = c3;
                    break;
                }
                case 3: {
                    isMissing = m4;
                    cPtr = c4;
                }
            }
            if (isMissing != 0) {
                return this.GetColor(Double.NaN, 0.0, 0.0, 0.0, 0, 0L, false, colorOut);
            }
            r += cPtr[0];
            g += cPtr[1];
            b += cPtr[2];
        }
        colorOut[0] = r /= (double)nColors;
        colorOut[1] = g /= (double)nColors;
        colorOut[2] = b /= (double)nColors;
        return true;
    }

    private int FindColors(double[][][] r, int nresp, int[][] tm, int totalnummiss, double[][] colors) {
        int numcolors = 0;
        double[] temp = new double[3];
        double[][] clrptr = null;
        double oneThird = 0.3333333333333333;
        if (temp == null) {
            return 0;
        }
        clrptr = nresp < 2 ? colors : this.rgb;
        block0 : switch (this.style) {
            case 4: 
            case 5: {
                int i;
                numcolors = 4;
                for (i = 0; i < nresp; ++i) {
                    this.GetColor(r[i][0][0], 0.0, 0.0, 0.0, i, 0L, false, clrptr[4 * i]);
                    this.GetColor(r[i][1][0], 0.0, 0.0, 0.0, i, 0L, false, clrptr[4 * i + 1]);
                    this.GetColor(r[i][1][1], 0.0, 0.0, 0.0, i, 0L, false, clrptr[4 * i + 2]);
                    this.GetColor(r[i][0][1], 0.0, 0.0, 0.0, i, 0L, false, clrptr[4 * i + 3]);
                }
                if (nresp < 2) break;
                for (i = 0; i < 4; ++i) {
                    colors[i][2] = 0.0;
                    colors[i][1] = 0.0;
                    colors[i][0] = 0.0;
                }
                for (i = 0; i < nresp; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        double[] dArray = colors[j];
                        dArray[0] = dArray[0] + clrptr[4 * i + j][0];
                        double[] dArray2 = colors[j];
                        dArray2[1] = dArray2[1] + clrptr[4 * i + j][1];
                        double[] dArray3 = colors[j];
                        dArray3[2] = dArray3[2] + clrptr[4 * i + j][2];
                        if (colors[j][0] > 1.0) {
                            colors[j][0] = 1.0;
                        }
                        if (colors[j][1] > 1.0) {
                            colors[j][1] = 1.0;
                        }
                        if (!(colors[j][2] > 1.0)) continue;
                        colors[j][2] = 1.0;
                    }
                }
                break;
            }
            case 1: {
                switch (totalnummiss) {
                    case 0: {
                        int i;
                        numcolors = 1;
                        for (i = 0; i < nresp; ++i) {
                            double value = (r[i][0][0] + r[i][1][0] + r[i][1][1] + r[i][0][1]) * 0.25;
                            this.GetColor(value, 0.0, 0.0, 0.0, i, 0L, false, clrptr[i]);
                        }
                        if (nresp < 2) break block0;
                        colors[0][2] = 0.0;
                        colors[0][1] = 0.0;
                        colors[0][0] = 0.0;
                        for (i = 0; i < nresp; ++i) {
                            double[] dArray = colors[0];
                            dArray[0] = dArray[0] + clrptr[i][0];
                            double[] dArray4 = colors[0];
                            dArray4[1] = dArray4[1] + clrptr[i][1];
                            double[] dArray5 = colors[0];
                            dArray5[2] = dArray5[2] + clrptr[i][2];
                            if (colors[0][0] > 1.0) {
                                colors[0][0] = 1.0;
                            }
                            if (colors[0][1] > 1.0) {
                                colors[0][1] = 1.0;
                            }
                            if (!(colors[0][2] > 1.0)) continue;
                            colors[0][2] = 1.0;
                        }
                        colors[0][3] = this.opacity;
                        break block0;
                    }
                    default: {
                        numcolors = 1;
                        this.GetColor(Double.NaN, 0.0, 0.0, 0.0, 0, 0L, false, colors[0]);
                        break block0;
                    }
                    case 1: {
                        int iy2;
                        int iy3;
                        int iy1;
                        int ix3;
                        int ix1;
                        int ix2;
                        numcolors = 2;
                        if (tm[0][0] != 0 || tm[1][1] != 0) {
                            if (tm[0][0] != 0) {
                                ix2 = 1;
                                ix1 = 1;
                                ix3 = 0;
                                iy1 = 0;
                                iy3 = 1;
                                iy2 = 1;
                            } else {
                                ix3 = 0;
                                ix1 = 0;
                                ix2 = 1;
                                iy2 = 0;
                                iy1 = 0;
                                iy3 = 1;
                            }
                        } else if (tm[0][1] != 0) {
                            ix1 = 0;
                            ix3 = 1;
                            ix2 = 1;
                            iy2 = 0;
                            iy1 = 0;
                            iy3 = 1;
                        } else {
                            ix3 = 0;
                            ix1 = 0;
                            ix2 = 1;
                            iy1 = 0;
                            iy3 = 1;
                            iy2 = 1;
                        }
                        this.GetColor(Double.NaN, 0.0, 0.0, 0.0, 0, 0L, false, colors[1]);
                        colors[0][2] = 0.0;
                        colors[0][1] = 0.0;
                        colors[0][0] = 0.0;
                        for (int i = 0; i < nresp; ++i) {
                            double value = (r[i][ix1][iy1] + r[i][ix2][iy2] + r[i][ix3][iy3]) * oneThird;
                            this.GetColor(value, 0.0, 0.0, 0.0, i, 0L, false, temp);
                            double[] dArray = colors[0];
                            dArray[0] = dArray[0] + temp[0];
                            double[] dArray6 = colors[0];
                            dArray6[1] = dArray6[1] + temp[1];
                            double[] dArray7 = colors[0];
                            dArray7[2] = dArray7[2] + temp[2];
                            if (colors[0][0] > 1.0) {
                                colors[0][0] = 1.0;
                            }
                            if (colors[0][1] > 1.0) {
                                colors[0][1] = 1.0;
                            }
                            if (!(colors[0][2] > 1.0)) continue;
                            colors[0][2] = 1.0;
                        }
                        double d = this.opacity;
                        colors[1][3] = d;
                        colors[0][3] = d;
                    }
                }
            }
        }
        return numcolors;
    }

    private boolean DoDivide(double r00, int m00, double r10, int m10, double r11, int m11, double r01, int m01, int depth) {
        if (this.style == 2 || this.style == 0 || this.totalResp > 1 || depth >= this.subDivideDepth || m00 != 0 || m10 != 0 || m11 != 0 || m01 != 0) {
            return false;
        }
        return Math.abs(r00 - r11) > this.subDivideAmount || Math.abs(r10 - r01) > this.subDivideAmount;
    }

    private synchronized void NameSegment(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3) {
        double[][] xyz = new double[3][3];
        if (xyz == null) {
            return;
        }
        xyz[0][0] = x1;
        xyz[0][1] = y1;
        xyz[0][2] = z1;
        xyz[1][0] = x2;
        xyz[1][1] = y2;
        xyz[1][2] = z2;
        xyz[2][0] = x3;
        xyz[2][1] = y3;
        xyz[2][2] = z3;
        this.OnNameSegment(xyz);
    }

    private double[] getSmoothColor(double[] orgColor, int m1, int m2, int m3, double[] cm1, double[] cm2, double[] cm3) {
        if (m1 > 0) {
            return cm1;
        }
        if (m2 > 0) {
            return cm2;
        }
        if (m3 > 0) {
            return cm3;
        }
        return orgColor;
    }

    private synchronized void DrawSmooth(double x1, double x2, double y1, double y2, double r00, int m00, double[] c00, double r10, int m10, double[] c10, double r11, int m11, double[] c11, double r01, int m01, double[] c01, int depth, double xLow, double yLow, double xHigh, double yHigh, double respDataMin, double respDataMax) {
        double hx2y2;
        double hx1y2;
        double hx2y1;
        double hx1y1;
        double[] p = new double[3];
        double[] cL = new double[3];
        double[] cB = new double[3];
        double[] cR = new double[3];
        double[] cT = new double[3];
        double[] cC = new double[3];
        double[] cAvg = new double[3];
        Color c = null;
        boolean localAverageColors = this.style == 5 && this.surfaceColor != null ? true : this.averageVertexColors;
        if (this.subDivide && this.DoDivide(r00, m00, r10, m10, r11, m11, r01, m01, depth) && cL != null && cB != null && cR != null && cT != null && cC != null) {
            double xC = 0.5 * (x1 + x2);
            double yC = 0.5 * (y1 + y2);
            double rB = 0.5 * (r10 - r00) + r00;
            double rT = 0.5 * (r11 - r01) + r01;
            double rL = 0.5 * (r01 - r00) + r00;
            double rR = 0.5 * (r11 - r10) + r10;
            double rC = 0.5 * (rT - rB) + rB;
            this.GetColor(rB, 0.0, 0.0, 0.0, 0, 0L, false, cB);
            this.GetColor(rT, 0.0, 0.0, 0.0, 0, 0L, false, cT);
            this.GetColor(rL, 0.0, 0.0, 0.0, 0, 0L, false, cL);
            this.GetColor(rR, 0.0, 0.0, 0.0, 0, 0L, false, cR);
            this.GetColor(rC, 0.0, 0.0, 0.0, 0, 0L, false, cC);
            this.DrawSmooth(x1, xC, y1, yC, r00, 0, c00, rB, 0, cB, rC, 0, cC, rL, 0, cL, depth + 1, xLow, yLow, xHigh, yHigh, respDataMin, respDataMax);
            this.DrawSmooth(xC, x2, y1, yC, rB, 0, cB, r10, 0, c10, rR, 0, cR, rC, 0, cC, depth + 1, xLow, yLow, xHigh, yHigh, respDataMin, respDataMax);
            this.DrawSmooth(xC, x2, yC, y2, rC, 0, cC, rR, 0, cR, r11, 0, c11, rT, 0, cT, depth + 1, xLow, yLow, xHigh, yHigh, respDataMin, respDataMax);
            this.DrawSmooth(x1, xC, yC, y2, rL, 0, cL, rC, 0, cC, rT, 0, cT, r01, 0, c01, depth + 1, xLow, yLow, xHigh, yHigh, respDataMin, respDataMax);
            return;
        }
        if (this.style == 5) {
            hx1y1 = Double.isNaN(r00) ? this.base : (r00 - respDataMin) / (respDataMax - respDataMin) * this.maxStack + this.base;
            hx2y1 = Double.isNaN(r10) ? this.base : (r10 - respDataMin) / (respDataMax - respDataMin) * this.maxStack + this.base;
            hx1y2 = Double.isNaN(r01) ? this.base : (r01 - respDataMin) / (respDataMax - respDataMin) * this.maxStack + this.base;
            hx2y2 = Double.isNaN(r11) ? this.base : (r11 - respDataMin) / (respDataMax - respDataMin) * this.maxStack + this.base;
        } else {
            hx2y1 = hx2y2 = this.base;
            hx1y2 = hx2y2;
            hx1y1 = hx2y2;
        }
        if (m00 != 0 || m11 != 0 || Math.abs(r01 - r10) < Math.abs(r00 - r11)) {
            if (this.drawMissing && (m00 > 0 || m10 > 0 || m01 > 0) || this.drawNonMissing && m00 == 0 && m10 == 0 && m01 == 0) {
                if (this.pickEnable && this.style == 5) {
                    this.NameSegment(x1, y1, hx1y1, x2, y1, hx2y1, x1, y2, hx1y2);
                }
                this.OnBeginPrimitive(2);
                if (this.style == 5 && (p = this.UnitCrossProduct(x2 - x1, 0.0, hx2y1 - hx1y1, 0.0, y2 - y1, hx1y2 - hx1y1)) != null) {
                    this.SET_NORMAL(p[0], p[1], p[2]);
                }
                if (this.style == 5 && this.surfaceColor != null) {
                    cAvg = this.surfaceColor;
                } else if (this.averageVertexColors) {
                    this.AverageColors(3, m00, c00, m10, c10, m01, c01, 0, null, cAvg);
                } else {
                    cAvg = !this.shadeMissing ? this.getSmoothColor(c00, m00, m10, m01, c00, c10, c01) : c00;
                }
                this.OnColor(cAvg[0], cAvg[1], cAvg[2]);
                this.DRAW(x1, y1, hx1y1);
                if (!localAverageColors) {
                    cAvg = c10;
                    if (!this.shadeMissing) {
                        cAvg = this.getSmoothColor(cAvg, m00, m10, m01, c00, c10, c01);
                    }
                    this.OnColor(cAvg[0], cAvg[1], cAvg[2]);
                }
                this.DRAW(x2, y1, hx2y1);
                if (!localAverageColors) {
                    cAvg = c01;
                    if (!this.shadeMissing) {
                        cAvg = this.getSmoothColor(cAvg, m00, m10, m01, c00, c10, c01);
                    }
                    this.OnColor(cAvg[0], cAvg[1], cAvg[2]);
                }
                this.DRAW(x1, y2, hx1y2);
                this.OnEndPrimitive(2);
                ++this.numprimitives;
            }
            if (this.drawMissing && (m10 > 0 || m11 > 0 || m01 > 0) || this.drawNonMissing && m10 == 0 && m11 == 0 && m01 == 0) {
                if (this.pickEnable && this.style == 5) {
                    this.NameSegment(x2, y1, hx2y1, x2, y2, hx2y2, x1, y2, hx1y2);
                }
                this.OnBeginPrimitive(2);
                if (this.style == 5 && (p = this.UnitCrossProduct(x1 - x2, 0.0, hx1y2 - hx2y2, 0.0, y1 - y2, hx2y1 - hx2y2)) != null) {
                    this.SET_NORMAL(p[0], p[1], p[2]);
                }
                if (this.style == 5 && this.surfaceColor != null) {
                    cAvg = this.surfaceColor;
                } else if (this.averageVertexColors) {
                    this.AverageColors(3, m10, c10, m11, c11, m01, c01, 0, null, cAvg);
                } else {
                    cAvg = !this.shadeMissing ? this.getSmoothColor(c10, m10, m11, m01, c10, c11, c01) : c10;
                }
                this.OnColor(cAvg[0], cAvg[1], cAvg[2]);
                this.DRAW(x2, y1, hx2y1);
                if (!localAverageColors) {
                    cAvg = c11;
                    if (!this.shadeMissing) {
                        cAvg = this.getSmoothColor(cAvg, m10, m11, m01, c10, c11, c01);
                    }
                    this.OnColor(cAvg[0], cAvg[1], cAvg[2]);
                }
                this.DRAW(x2, y2, hx2y2);
                if (!localAverageColors) {
                    cAvg = c01;
                    if (!this.shadeMissing) {
                        cAvg = this.getSmoothColor(cAvg, m10, m11, m01, c10, c11, c01);
                    }
                    this.OnColor(cAvg[0], cAvg[1], cAvg[2]);
                }
                this.DRAW(x1, y2, hx1y2);
                this.OnEndPrimitive(2);
                ++this.numprimitives;
            }
        } else {
            if (this.drawMissing && (m00 > 0 || m10 > 0 || m11 > 0) || this.drawNonMissing && m00 == 0 && m10 == 0 && m11 == 0) {
                if (this.pickEnable && this.style == 5) {
                    this.NameSegment(x1, y1, hx1y1, x2, y1, hx2y1, x2, y2, hx2y2);
                }
                this.OnBeginPrimitive(2);
                if (this.style == 5 && (p = this.UnitCrossProduct(0.0, y2 - y1, hx2y2 - hx2y1, x1 - x2, 0.0, hx1y1 - hx2y1)) != null) {
                    this.SET_NORMAL(p[0], p[1], p[2]);
                }
                if (this.style == 5 && this.surfaceColor != null) {
                    cAvg = this.surfaceColor;
                } else if (this.averageVertexColors) {
                    this.AverageColors(3, m00, c00, m10, c10, m11, c11, 0, null, cAvg);
                } else {
                    cAvg = !this.shadeMissing ? this.getSmoothColor(c00, m00, m10, m11, c00, c10, c11) : c00;
                }
                this.OnColor(cAvg[0], cAvg[1], cAvg[2]);
                this.DRAW(x1, y1, hx1y1);
                if (!localAverageColors) {
                    cAvg = c10;
                    if (!this.shadeMissing) {
                        cAvg = this.getSmoothColor(cAvg, m00, m10, m11, c00, c10, c11);
                    }
                    this.OnColor(cAvg[0], cAvg[1], cAvg[2]);
                }
                this.DRAW(x2, y1, hx2y1);
                if (!localAverageColors) {
                    cAvg = c11;
                    if (!this.shadeMissing) {
                        cAvg = this.getSmoothColor(cAvg, m00, m10, m11, c00, c10, c11);
                    }
                    this.OnColor(cAvg[0], cAvg[1], cAvg[2]);
                }
                this.DRAW(x2, y2, hx2y2);
                this.OnEndPrimitive(2);
                ++this.numprimitives;
            }
            if (this.drawMissing && (m00 > 0 || m11 > 0 || m01 > 0) || this.drawNonMissing && m00 == 0 && m11 == 0 && m01 == 0) {
                if (this.pickEnable && this.style == 5) {
                    this.NameSegment(x1, y1, hx1y1, x2, y2, hx2y2, x1, y2, hx1y2);
                }
                this.OnBeginPrimitive(2);
                if (this.style == 5 && (p = this.UnitCrossProduct(0.0, y1 - y2, hx1y1 - hx1y2, x2 - x1, 0.0, hx2y2 - hx1y2)) != null) {
                    this.SET_NORMAL(p[0], p[1], p[2]);
                }
                if (this.style == 5 && this.surfaceColor != null) {
                    cAvg = this.surfaceColor;
                } else if (this.averageVertexColors) {
                    this.AverageColors(3, m00, c00, m11, c11, m01, c01, 0, null, cAvg);
                } else {
                    cAvg = !this.shadeMissing ? this.getSmoothColor(c00, m00, m11, m01, c00, c11, c01) : c00;
                }
                this.OnColor(cAvg[0], cAvg[1], cAvg[2]);
                this.DRAW(x1, y1, hx1y1);
                if (!localAverageColors) {
                    cAvg = c11;
                    if (!this.shadeMissing) {
                        cAvg = this.getSmoothColor(cAvg, m00, m11, m01, c00, c11, c01);
                    }
                    this.OnColor(cAvg[0], cAvg[1], cAvg[2]);
                }
                this.DRAW(x2, y2, hx2y2);
                if (!localAverageColors) {
                    cAvg = c01;
                    if (!this.shadeMissing) {
                        cAvg = this.getSmoothColor(cAvg, m00, m11, m01, c00, c11, c01);
                    }
                    this.OnColor(cAvg[0], cAvg[1], cAvg[2]);
                }
                this.DRAW(x1, y2, hx1y2);
                this.OnEndPrimitive(2);
                ++this.numprimitives;
            }
        }
        if (this.DrawSides() && this.style == 5) {
            c = this.surfaceColor != null ? new Color((float)this.surfaceColor[0], (float)this.surfaceColor[1], (float)this.surfaceColor[2]) : (this.surfaceSideColor != null ? this.surfaceSideColor : (this.colorRamp != null ? this.colorRamp.Query(0, false) : Color.white));
            if (x1 == xLow) {
                this.SET_NORMAL(-1.0, 0.0, 0.0);
                this.OnColor(c);
                this.OnBeginPrimitive(4);
                this.OnVertex(x1, y2, this.base);
                this.OnVertex(x1, y1, this.base);
                this.OnVertex(x1, y1, hx1y1);
                this.OnVertex(x1, y2, hx1y2);
                this.OnEndPrimitive(4);
            }
            if (x2 == xHigh) {
                this.SET_NORMAL(1.0, 0.0, 0.0);
                this.OnColor(c);
                this.OnBeginPrimitive(4);
                this.OnVertex(x2, y1, this.base);
                this.OnVertex(x2, y2, this.base);
                this.OnVertex(x2, y2, hx2y2);
                this.OnVertex(x2, y1, hx2y1);
                this.OnEndPrimitive(4);
            }
            if (y1 == yLow) {
                this.SET_NORMAL(0.0, -1.0, 0.0);
                this.OnColor(c);
                this.OnBeginPrimitive(4);
                this.OnVertex(x1, y1, this.base);
                this.OnVertex(x2, y1, this.base);
                this.OnVertex(x2, y1, hx2y1);
                this.OnVertex(x1, y1, hx1y1);
                this.OnEndPrimitive(4);
            }
            if (y2 == yHigh) {
                this.SET_NORMAL(0.0, 1.0, 0.0);
                this.OnColor(c);
                this.OnBeginPrimitive(4);
                this.OnVertex(x2, y2, this.base);
                this.OnVertex(x1, y2, this.base);
                this.OnVertex(x1, y2, hx1y2);
                this.OnVertex(x2, y2, hx2y2);
                this.OnEndPrimitive(4);
            }
        }
    }

    private synchronized void DrawBlock(double x1, double x2, double y1, double y2, double r00, int m00, double r10, int m10, double r11, int m11, double r01, int m01, int totalnummiss, double[] c1, double[] c2, int depth, double min, double max, boolean isStacked) {
        double h2;
        double[] cq1 = new double[3];
        double[] cq2 = new double[3];
        double[] cq3 = new double[3];
        double[] cq4 = new double[3];
        double[] cp1 = null;
        double[] cp2 = null;
        double h1 = h2 = this.base;
        if (this.subDivide && this.DoDivide(r00, m00, r10, m10, r11, m11, r01, m01, depth) && cq1 != null && cq2 != null && cq3 != null && cq4 != null) {
            double xC = 0.5 * (x1 + x2);
            double yC = 0.5 * (y1 + y2);
            double rB = 0.5 * (r10 - r00) + r00;
            double rT = 0.5 * (r11 - r01) + r01;
            double rL = 0.5 * (r01 - r00) + r00;
            double rR = 0.5 * (r11 - r10) + r10;
            double rC = 0.5 * (rT - rB) + rB;
            this.GetColor((r00 + rB + rC + rL) * 0.25, 0.0, 0.0, 0.0, 0, 0L, false, cq1);
            this.GetColor((rB + r10 + rR + rC) * 0.25, 0.0, 0.0, 0.0, 0, 0L, false, cq2);
            this.GetColor((rC + rR + r11 + rT) * 0.25, 0.0, 0.0, 0.0, 0, 0L, false, cq3);
            this.GetColor((rL + rC + rT + r01) * 0.25, 0.0, 0.0, 0.0, 0, 0L, false, cq4);
            this.DrawBlock(x1, xC, y1, yC, r00, 0, rB, 0, rC, 0, rL, 0, 0, cq1, cq2, depth + 1, min, max, isStacked);
            this.DrawBlock(xC, x2, y1, yC, rB, 0, r10, 0, rR, 0, rC, 0, 0, cq2, cq1, depth + 1, min, max, isStacked);
            this.DrawBlock(xC, x2, yC, y2, rC, 0, rR, 0, r11, 0, rT, 0, 0, cq3, cq2, depth + 1, min, max, isStacked);
            this.DrawBlock(x1, xC, yC, y2, rL, 0, rC, 0, rT, 0, r01, 0, 0, cq4, cq2, depth + 1, min, max, isStacked);
            return;
        }
        switch (totalnummiss) {
            default: {
                if ((totalnummiss != 0 || !this.drawNonMissing) && (totalnummiss <= 0 || !this.drawMissing)) break;
                if (totalnummiss == 0 && isStacked && !Double.isNaN(min) && !Double.isNaN(max)) {
                    h1 = this.maxStack * (((r00 + r10 + r01 + r11) * 0.25 - min) / (max - min)) + this.base;
                }
                if (this.pickEnable && this.stacked) {
                    this.NameSegment(x1, y1, h1, x2, y1, h1, x2, y2, h1);
                }
                this.OnBeginPrimitive(4);
                this.OnColor(c1[0], c1[1], c1[2]);
                this.DRAW(x1, y1, h1);
                this.DRAW(x2, y1, h1);
                this.DRAW(x2, y2, h1);
                this.DRAW(x1, y2, h1);
                this.OnEndPrimitive(4);
                ++this.numprimitives;
                break;
            }
            case 1: {
                if (m00 != 0 || m11 != 0) {
                    if (m00 != 0) {
                        cp1 = c2;
                        cp2 = c1;
                        if (isStacked && !Double.isNaN(min) && !Double.isNaN(max)) {
                            h2 = this.maxStack * (((r10 + r01 + r11) * 0.33333333 - min) / (max - min)) + this.base;
                        }
                    } else {
                        cp1 = c1;
                        if (isStacked && !Double.isNaN(min) && !Double.isNaN(max)) {
                            h1 = this.maxStack * (((r00 + r10 + r01) * 0.33333333 - min) / (max - min)) + this.base;
                        }
                        cp2 = c2;
                    }
                    if (m00 == 0 && this.drawNonMissing || m00 > 0 && this.drawMissing) {
                        if (this.pickEnable && this.stacked) {
                            this.NameSegment(x1, y1, h1, x2, y1, h1, x1, y2, h1);
                        }
                        this.OnColor(cp1[0], cp1[1], cp1[2]);
                        this.OnBeginPrimitive(2);
                        this.DRAW(x1, y1, h1);
                        this.DRAW(x2, y1, h1);
                        this.DRAW(x1, y2, h1);
                        this.OnEndPrimitive(2);
                        ++this.numprimitives;
                    }
                    if ((m11 != 0 || !this.drawNonMissing) && (m11 <= 0 || !this.drawMissing)) break;
                    if (this.pickEnable && this.stacked) {
                        this.NameSegment(x2, y1, h2, x2, y2, h2, x1, y2, h2);
                    }
                    this.OnColor(cp2[0], cp2[1], cp2[2]);
                    this.OnBeginPrimitive(2);
                    this.DRAW(x2, y1, h2);
                    this.DRAW(x2, y2, h2);
                    this.DRAW(x1, y2, h2);
                    this.OnEndPrimitive(2);
                    ++this.numprimitives;
                    break;
                }
                if (m01 != 0) {
                    cp1 = c2;
                    cp2 = c1;
                    if (isStacked && !Double.isNaN(min) && !Double.isNaN(max)) {
                        h2 = this.maxStack * (((r00 + r10 + r11) * 0.33333333 - min) / (max - min)) + this.base;
                    }
                } else {
                    cp1 = c1;
                    if (isStacked && !Double.isNaN(min) && !Double.isNaN(max)) {
                        h1 = this.maxStack * (((r00 + r01 + r11) * 0.33333333 - min) / (max - min)) + this.base;
                    }
                    cp2 = c2;
                }
                if (m01 == 0 && this.drawNonMissing || m01 > 0 && this.drawMissing) {
                    if (this.pickEnable && this.stacked) {
                        this.NameSegment(x1, y1, h1, x2, y2, h1, x1, y2, h1);
                    }
                    this.OnColor(cp1[0], cp1[1], cp1[2]);
                    this.OnBeginPrimitive(2);
                    this.DRAW(x1, y1, h1);
                    this.DRAW(x2, y2, h1);
                    this.DRAW(x1, y2, h1);
                    this.OnEndPrimitive(2);
                    ++this.numprimitives;
                }
                if ((m10 != 0 || !this.drawNonMissing) && (m10 <= 0 || !this.drawMissing)) break;
                if (this.pickEnable && this.stacked) {
                    this.NameSegment(x1, y1, h2, x2, y1, h2, x2, y2, h2);
                }
                this.OnColor(cp2[0], cp2[1], cp2[2]);
                this.OnBeginPrimitive(2);
                this.DRAW(x1, y1, h2);
                this.DRAW(x2, y1, h2);
                this.DRAW(x2, y2, h2);
                this.OnEndPrimitive(2);
                ++this.numprimitives;
            }
        }
    }

    protected boolean growBitSetArray(int nx, int ny) {
        if (nx < 0 || ny < 0) {
            return false;
        }
        if (this.found != null && this.found.length >= nx && this.found[0].length >= ny) {
            return true;
        }
        this.found = new BitSet[nx][ny];
        if (this.found == null) {
            return false;
        }
        for (int ix = 0; ix < nx; ++ix) {
            for (int iy = 0; iy < ny; ++iy) {
                this.found[ix][iy] = new BitSet(16);
            }
        }
        return true;
    }

    protected void clearBitSetArray(int nx, int ny) {
        if (this.found == null) {
            return;
        }
        for (int ix = 0; ix < nx; ++ix) {
            for (int iy = 0; iy < ny; ++iy) {
                this.found[ix][iy].clear();
            }
        }
    }

    public int getContourAlgorithm() {
        return this.contourAlgorithm;
    }

    public boolean setContourAlgorithm(int algorithm) {
        switch (algorithm) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                return false;
            }
        }
        this.contourAlgorithm = algorithm;
        return true;
    }

    public Object getFont() {
        return this.font;
    }

    public void setFont(Font newFont) {
        this.font = newFont == null ? defaultFont : newFont;
    }

    public void setShowLineOverlay(boolean b) {
        this.showLineOverlay = b;
    }

    public boolean getShowLineOverlay() {
        return this.showLineOverlay;
    }

    public void setLineOverlayColor(Color c) {
        this.lineOverlayColor = c;
    }

    public Color getLineOverlayColor() {
        return this.lineOverlayColor;
    }

    public void setLabelColor(Color c) {
        this.labelColor = c;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelFormat(SASFormat format) {
        this.userLabelFormat = format;
        this.setDefaultLabelFormat();
    }

    public SASFormat getLabelFormat() {
        return this.userLabelFormat;
    }

    public void setLineStyle(int style) {
        this.linestyle = style;
    }

    public int getLineStyle() {
        return this.linestyle;
    }

    public void setLineStippleFactor(double factor) {
        if (factor >= 0.0) {
            this.lineStippleFactor = factor;
        }
    }

    public double getLineStippleFactor() {
        return this.lineStippleFactor;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setThinLabels(boolean thin) {
        this.thinLabels = thin;
    }

    public boolean getThinLabels() {
        return this.thinLabels;
    }

    protected abstract void applyFont(Font var1);

    protected abstract void applyLineStyle(int var1);

    public int getLabelStyle() {
        return this.labelStyle;
    }

    public boolean setLabelStyle(int style) {
        switch (style) {
            case 0: {
                this.setContourAlgorithm(0);
                break;
            }
            case 1: {
                this.setContourAlgorithm(1);
                break;
            }
            default: {
                return false;
            }
        }
        this.labelStyle = style;
        return true;
    }

    public int getLabelOrientation() {
        return this.labelOrientation;
    }

    public boolean setLabelOrientation(int orient) {
        switch (orient) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                return false;
            }
        }
        this.labelOrientation = orient;
        return true;
    }

    public int getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(int position) {
        if (position == 0 || position == 2 || position == 1) {
            this.labelPosition = position;
        }
    }

    public String GetVariableDescription(int role, boolean useOnlyName) {
        String strg = null;
        GriddedChartData gcd = (GriddedChartData)this.data;
        DataVariableInterface dv = null;
        if (gcd != null) {
            switch (role) {
                case 0: {
                    dv = (DataVariableInterface)gcd.GetXVariable();
                    break;
                }
                case 1: {
                    dv = (DataVariableInterface)gcd.GetYVariable();
                    break;
                }
                case 2: {
                    dv = (DataVariableInterface)gcd.GetResponseVariable(0);
                }
            }
        }
        if (dv == null) {
            return null;
        }
        strg = useOnlyName ? dv.GetName() : dv.GetDescription();
        return strg;
    }

    public String GetFormattedValue(int role, Object value) {
        String strg = null;
        GriddedChartData gcd = (GriddedChartData)this.data;
        DataVariableInterface dv = null;
        if (value == null || !(value instanceof Double)) {
            return null;
        }
        if (Double.isNaN((Double)value)) {
            return "missing value";
        }
        if (gcd != null) {
            switch (role) {
                case 0: {
                    dv = (DataVariableInterface)gcd.GetXVariable();
                    break;
                }
                case 1: {
                    dv = (DataVariableInterface)gcd.GetYVariable();
                    break;
                }
                case 2: {
                    dv = (DataVariableInterface)gcd.GetResponseVariable(0);
                }
            }
        }
        strg = dv != null ? dv.GetFormattedValue((Double)value) : String.valueOf(value);
        return strg;
    }

    public boolean GetPickingEnabled() {
        return this.pickEnable;
    }

    public void SetPickingEnabled(boolean enable) {
        this.pickEnable = enable;
    }

    public int GetNumberLevels() {
        return this.numlevels;
    }

    public double[] GetLevels() {
        double[] d = null;
        if (this.numlevels == 0) {
            return null;
        }
        d = new double[this.numlevels];
        if (d == null) {
            return null;
        }
        for (int i = 0; i < this.numlevels; ++i) {
            d[i] = this.levels[i];
        }
        return d;
    }

    public String[] GetLevelLabels() {
        String[] labels = new String[this.numlevels];
        if (labels == null) {
            return null;
        }
        this.setDefaultLabelFormat();
        for (int i = 0; i < this.numlevels; ++i) {
            labels[i] = this.ggood && this.ggoodLabelFormat != null ? this.ggoodLabelFormat.format((Object)new Double(this.levels[i])) : (this.userLabelFormat != null ? this.userLabelFormat.format((Object)new Double(this.levels[i])) : this.GetFormattedValue(2, new Double(this.levels[i])));
        }
        return labels;
    }

    public Color[] GetLevelColors() {
        double[] cout = new double[3];
        Color[] colors = new Color[this.numlevels];
        if (colors == null) {
            return null;
        }
        for (int i = 0; i < this.numlevels; ++i) {
            if (!this.GetColor(this.levels[i], 0.0, 0.0, 0.0, i, 0L, false, cout)) continue;
            colors[i] = new Color((float)cout[0], (float)cout[1], (float)cout[2]);
        }
        return colors;
    }

    public boolean IsLODOn() {
        return this.useLOD;
    }

    public synchronized void SetLODOn(boolean on) {
        this.useLOD = on;
    }

    public int GetLODCount() {
        return this.lodCount;
    }

    public synchronized boolean SetLODCount(int newCount) {
        if (newCount <= 4) {
            return false;
        }
        this.lodCount = newCount;
        return true;
    }

    public boolean IsSubdivideOn() {
        return this.subDivide;
    }

    public void SetSubdivideOn(boolean on) {
        this.subDivide = on;
    }

    public int GetSubdivideDepth() {
        return this.subDivideDepth;
    }

    public boolean SetSubdivideDepth(int newDepth) {
        if (newDepth < 1 || newDepth > 5) {
            return false;
        }
        this.subDivideDepth = newDepth;
        return true;
    }

    public double GetSubdivideAmount() {
        return this.subDivideAmount;
    }

    public boolean SetSubdivideAmount(double amount) {
        if (Double.isNaN(amount) || amount <= 0.0) {
            return false;
        }
        this.subDivideAmount = amount;
        return true;
    }

    public double GetSubdividePercent() {
        if (this.data == null || Double.isNaN(this.subDivideAmount)) {
            return Double.NaN;
        }
        double min = ((GriddedChartData)this.data).GetResponseMin(0);
        double max = ((GriddedChartData)this.data).GetResponseMax(0);
        if (Double.isNaN(min) || Double.isNaN(max) || max == min) {
            return Double.NaN;
        }
        return this.subDivideAmount / (max - min) * 100.0;
    }

    public boolean SetSubdividePercent(double percent) {
        if (this.data == null || Double.isNaN(percent) || percent <= 0.0 || percent > 100.0) {
            return false;
        }
        double min = ((GriddedChartData)this.data).GetResponseMin(0);
        double max = ((GriddedChartData)this.data).GetResponseMax(0);
        if (Double.isNaN(min) || Double.isNaN(max) || max == min) {
            return false;
        }
        this.subDivideAmount = (max - min) * (percent / 100.0);
        return true;
    }

    @Override
    public synchronized boolean BuildDisplayList(Object bldPtr) {
        boolean localStacked;
        int tempstyle;
        int start;
        int stop;
        double value = 0.0;
        int savePrimitives = 0;
        double[] xData = this.GetChartData(0);
        double[] yData = this.GetChartData(1);
        double[][] response = null;
        if (this.data == null) {
            return false;
        }
        response = this.GetResponsePointers();
        if (response == null) {
            return false;
        }
        this.totalResp = response.length;
        savePrimitives = this.numprimitives;
        this.numprimitives = 0;
        if (!this.BuildSetup()) {
            return false;
        }
        this.SET_NORMAL();
        double heightConstant = this.numlevels <= 1 || this.levels[this.numlevels - 1] == this.levels[0] ? 1.0 : this.maxStack / (this.levels[this.numlevels - 1] - this.levels[0]);
        if (this.highlightBuild) {
            if (Double.isNaN(this.highlightValue)) {
                this.BuildError();
                return false;
            }
            stop = 0;
            start = 0;
            tempstyle = 2;
            value = this.highlightValue;
            this.highlightString = this.highlightStyle == 1 || this.highlightStyle == 2 ? this.GetFormattedValue(2, new Double(value)) : null;
        } else {
            start = this.startLevel;
            stop = this.lastLevel;
            tempstyle = this.style;
        }
        switch (this.style) {
            case 4: {
                localStacked = false;
                break;
            }
            case 5: {
                localStacked = true;
                break;
            }
            default: {
                localStacked = this.stacked;
            }
        }
        if (((GriddedChartData)this.data).GetResponseMin(0) == ((GriddedChartData)this.data).GetResponseMax(0)) {
            this.drawFlatContourMessage();
        } else {
            switch (this.style) {
                case 2: {
                    this.processCellsCT(xData, yData, response, tempstyle, localStacked, start, stop, heightConstant);
                    break;
                }
                default: {
                    this.processCellsMS(xData, yData, response, tempstyle, localStacked, start, stop, heightConstant);
                }
            }
            if (this.showLineOverlay && !this.highlightBuild && tempstyle != 2) {
                IVIZColor oldRamp = this.colorRamp;
                Color lineColor = this.lineOverlayColor;
                if (lineColor == null) {
                    lineColor = Color.BLACK;
                }
                this.colorRamp = new ColorRamp(new Color[]{lineColor, lineColor}, null);
                this.processCellsCT(xData, yData, response, 2, localStacked, start, stop, heightConstant);
                this.colorRamp = oldRamp;
            }
        }
        this.BuildCleanup();
        if (this.highlightBuild) {
            this.numprimitives = savePrimitives;
        }
        return true;
    }

    @Override
    public boolean BuildImmediateMode(Object bldPtr) {
        return false;
    }

    public synchronized boolean drawImmediateMode() {
        boolean localStacked;
        int tempstyle;
        int start;
        int stop;
        double value = 0.0;
        int savePrimitives = 0;
        double[] xData = this.GetChartData(0);
        double[] yData = this.GetChartData(1);
        double[][] response = null;
        if (this.data == null) {
            return false;
        }
        response = this.GetResponsePointers();
        if (response == null) {
            return false;
        }
        this.totalResp = response.length;
        savePrimitives = this.numprimitives;
        this.numprimitives = 0;
        if (!this.BuildSetup_immediateMode()) {
            return false;
        }
        this.SET_NORMAL();
        double heightConstant = this.numlevels <= 1 || this.levels[this.numlevels - 1] == this.levels[0] ? 1.0 : this.maxStack / (this.levels[this.numlevels - 1] - this.levels[0]);
        if (this.highlightBuild) {
            if (Double.isNaN(this.highlightValue)) {
                this.BuildError_immediateMode();
                return false;
            }
            stop = 0;
            start = 0;
            tempstyle = 2;
            value = this.highlightValue;
            this.highlightString = this.highlightStyle == 1 || this.highlightStyle == 2 ? this.GetFormattedValue(2, new Double(value)) : null;
        } else {
            start = this.startLevel;
            stop = this.lastLevel;
            tempstyle = this.style;
        }
        switch (this.style) {
            case 4: {
                localStacked = false;
                break;
            }
            case 5: {
                localStacked = true;
                break;
            }
            default: {
                localStacked = this.stacked;
            }
        }
        if (((GriddedChartData)this.data).GetResponseMin(0) == ((GriddedChartData)this.data).GetResponseMax(0)) {
            this.drawFlatContourMessage();
        } else {
            switch (this.style) {
                case 2: {
                    this.processCellsCT(xData, yData, response, tempstyle, localStacked, start, stop, heightConstant);
                    break;
                }
                default: {
                    this.processCellsMS(xData, yData, response, tempstyle, localStacked, start, stop, heightConstant);
                }
            }
            if (this.showLineOverlay && !this.highlightBuild && tempstyle != 2) {
                IVIZColor oldRamp = this.colorRamp;
                Color lineColor = this.lineOverlayColor;
                if (lineColor == null) {
                    lineColor = Color.BLACK;
                }
                this.colorRamp = new ColorRamp(new Color[]{lineColor, lineColor}, null);
                this.processCellsCT(xData, yData, response, 2, localStacked, start, stop, heightConstant);
                this.colorRamp = oldRamp;
            }
        }
        this.BuildCleanup_immediateMode();
        if (this.highlightBuild) {
            this.numprimitives = savePrimitives;
        }
        return true;
    }

    private void drawFlatContourMessage() {
        String defaultString = "Flat Contour: value = {0}";
        String msg = null;
        try {
            ResourceBundle rb = ResourceBundle.getBundle("com.sas.graphics.util.ods.visual.contour_NLS");
            msg = rb.getString("Contour.FlatContour.fmt");
        }
        catch (MissingResourceException e) {
            System.err.println("Resource Contour.FlatContour.fmt not found. Using default value.");
            msg = defaultString;
        }
        MessageFormat message = new MessageFormat(msg);
        String errorMessage = message.format(new Object[]{Double.toString(((GriddedChartData)this.data).GetResponseMin(0))});
        this.drawErrorMessage(errorMessage);
    }

    public boolean drawHighlightArea(boolean drawOutline) {
        if (this.data == null) {
            return false;
        }
        double[] xData = this.GetChartData(0);
        double[] yData = this.GetChartData(1);
        double[][] response = this.GetResponsePointers();
        if (response == null) {
            return false;
        }
        this.totalResp = response.length;
        int savePrimitives = this.numprimitives;
        this.numprimitives = 0;
        if (!this.BuildSetup_immediateMode()) {
            return false;
        }
        this.SET_NORMAL();
        if (Double.isNaN(this.highlightAreaStartValue) || Double.isNaN(this.highlightAreaEndValue)) {
            return false;
        }
        int oldStart = this.startLevel;
        int oldLast = this.lastLevel;
        this.startLevel = 1;
        this.lastLevel = 1;
        this.processCellsMSHighlight(xData, yData, response, drawOutline);
        this.startLevel = oldStart;
        this.lastLevel = oldLast;
        this.highlightString = this.GetFormattedValue(2, new Double(this.highlightAreaEndValue));
        this.BuildCleanup_immediateMode();
        this.numprimitives = savePrimitives;
        return true;
    }

    protected boolean processCellsMSHighlight(double[] xData, double[] yData, double[][] response, boolean outline) {
        boolean localUseLOD;
        int nySteps;
        int nxSteps;
        int ixStart;
        int iyStart;
        double lowValue = 0.0;
        double highValue = 0.0;
        int[][] tm = new int[2][2];
        int[][][] m = new int[3][2][2];
        double[][][] r = new double[3][2][2];
        double[] corners = new double[4];
        if (tm == null || r == null || m == null || corners == null || xData == null || xData.length <= 1 || yData == null || yData.length <= 1 || response == null) {
            return false;
        }
        int nx = this.xHighLimit - this.xLowLimit + 1;
        int ny = this.yHighLimit - this.yLowLimit + 1;
        int nCells = nx * ny;
        int xStride = ((GriddedChartData)this.data).GetXStride();
        int yStride = ((GriddedChartData)this.data).GetYStride();
        if (this.useLOD && this.lodCount < nCells) {
            iyStart = 0;
            ixStart = 0;
            nxSteps = Math.min((int)Math.sqrt(this.lodCount), nx) - 1;
            nySteps = Math.min((int)Math.sqrt(this.lodCount), ny) - 1;
            localUseLOD = true;
        } else {
            ixStart = this.xLowLimit;
            nxSteps = this.xHighLimit;
            iyStart = this.yLowLimit;
            nySteps = this.yHighLimit;
            localUseLOD = false;
        }
        this.rgb[0][0] = (float)this.highlightColor.getRed() / 255.0f;
        this.rgb[0][1] = (float)this.highlightColor.getGreen() / 255.0f;
        this.rgb[0][2] = (float)this.highlightColor.getBlue() / 255.0f;
        this.rgb[0][3] = this.opacity;
        this.rgb[1][0] = this.rgb[0][0];
        this.rgb[1][1] = this.rgb[0][1];
        this.rgb[1][2] = this.rgb[0][2];
        this.rgb[1][3] = this.rgb[0][3];
        for (int ixStep = ixStart; ixStep < nxSteps; ++ixStep) {
            int ix2;
            int ix;
            if (localUseLOD) {
                ix = (int)((double)ixStep / (double)nxSteps * (double)(this.xHighLimit - this.xLowLimit) + (double)this.xLowLimit);
                ix2 = (int)((double)(ixStep + 1) / (double)nxSteps * (double)(this.xHighLimit - this.xLowLimit) + (double)this.xLowLimit);
            } else {
                ix = ixStep;
                ix2 = ixStep + 1;
            }
            int xoffset1 = ix * xStride;
            int xoffset2 = ix2 * xStride;
            double x1 = xData[ix];
            double x2 = xData[ix2];
            for (int iyStep = iyStart; iyStep < nySteps; ++iyStep) {
                int iy2;
                int iy;
                if (localUseLOD) {
                    iy = (int)((double)iyStep / (double)nySteps * (double)(this.yHighLimit - this.yLowLimit) + (double)this.yLowLimit);
                    iy2 = (int)((double)(iyStep + 1) / (double)nySteps * (double)(this.yHighLimit - this.yLowLimit) + (double)this.yLowLimit);
                } else {
                    iy = iyStep;
                    iy2 = iyStep + 1;
                }
                int yoffset1 = iy * yStride;
                int yoffset2 = iy2 * yStride;
                double y1 = yData[iy];
                double y2 = yData[iy2];
                this.curSegmentName = xoffset1 + yoffset1 + this.zoffset;
                for (int i = 0; i < this.totalResp; ++i) {
                    r[i][0][0] = response[i][xoffset1 + yoffset1 + this.zoffset];
                    m[i][0][0] = Double.isNaN(r[i][0][0]) ? 1 : 0;
                    r[i][1][0] = response[i][xoffset2 + yoffset1 + this.zoffset];
                    m[i][1][0] = Double.isNaN(r[i][1][0]) ? 1 : 0;
                    r[i][1][1] = response[i][xoffset2 + yoffset2 + this.zoffset];
                    m[i][1][1] = Double.isNaN(r[i][1][1]) ? 1 : 0;
                    r[i][0][1] = response[i][xoffset1 + yoffset2 + this.zoffset];
                    m[i][0][1] = Double.isNaN(r[i][0][1]) ? 1 : 0;
                }
                int totalnummiss = this.FindTotalMissing(m, this.totalResp, tm);
                if (totalnummiss > 0) continue;
                corners[0] = r[0][0][0];
                corners[1] = r[0][1][0];
                corners[2] = r[0][1][1];
                corners[3] = r[0][0][1];
                if (this.highlightAreaStartValue < this.highlightAreaEndValue) {
                    lowValue = this.highlightAreaStartValue;
                    highValue = this.highlightAreaEndValue;
                } else {
                    lowValue = this.highlightAreaEndValue;
                    highValue = this.highlightAreaStartValue;
                }
                this.height[0] = this.base;
                this.height[1] = this.base;
                this.cell_case[0] = Contours.findcase(lowValue, corners);
                this.cell_case[1] = Contours.findcase(highValue, corners);
                this.numpairs[0] = Contours.findintersections(x1, x2, y1, y2, lowValue, corners, this.cell_case[0], this.intersections[0]);
                this.numpairs[1] = Contours.findintersections(x1, x2, y1, y2, highValue, corners, this.cell_case[1], this.intersections[1]);
                if (lowValue != highValue) {
                    this.numprimitives += this.DrawPolygons(x1, x2, y1, y2);
                    if (!outline) continue;
                    this.numprimitives += this.DrawLines(0, 1, false);
                    continue;
                }
                this.numprimitives += this.DrawLines(0, 0, false);
            }
        }
        return true;
    }

    protected boolean processCellsMS(double[] xData, double[] yData, double[][] response, int drawStyle, boolean isStacked, int start, int stop, double heightConstant) {
        boolean localUseLOD;
        int nySteps;
        int nxSteps;
        int ixStart;
        int iyStart;
        double value = 0.0;
        int[][] tm = new int[2][2];
        int[][][] m = new int[3][2][2];
        double[][][] r = new double[3][2][2];
        double[][] colors = new double[4][4];
        double[] corners = new double[4];
        if (tm == null || r == null || m == null || colors == null || corners == null || xData == null || xData.length <= 1 || yData == null || yData.length <= 1 || response == null) {
            return false;
        }
        int nx = this.xHighLimit - this.xLowLimit + 1;
        int ny = this.yHighLimit - this.yLowLimit + 1;
        int nCells = nx * ny;
        int xStride = ((GriddedChartData)this.data).GetXStride();
        int yStride = ((GriddedChartData)this.data).GetYStride();
        double xLow = xData[this.xLowLimit];
        double yLow = yData[this.yLowLimit];
        double xHigh = xData[this.xHighLimit];
        double yHigh = yData[this.yHighLimit];
        double rmin = ((GriddedChartData)this.data).GetResponseMin(0);
        double rmax = ((GriddedChartData)this.data).GetResponseMax(0);
        double lastBboxZ = this.base;
        if (this.useLOD && this.lodCount < nCells) {
            iyStart = 0;
            ixStart = 0;
            nxSteps = Math.min((int)Math.sqrt(this.lodCount), nx) - 1;
            nySteps = Math.min((int)Math.sqrt(this.lodCount), ny) - 1;
            localUseLOD = true;
        } else {
            ixStart = this.xLowLimit;
            nxSteps = this.xHighLimit;
            iyStart = this.yLowLimit;
            nySteps = this.yHighLimit;
            localUseLOD = false;
        }
        for (int ixStep = ixStart; ixStep < nxSteps; ++ixStep) {
            int ix2;
            int ix;
            if (localUseLOD) {
                ix = (int)((double)ixStep / (double)nxSteps * (double)(this.xHighLimit - this.xLowLimit) + (double)this.xLowLimit);
                ix2 = (int)((double)(ixStep + 1) / (double)nxSteps * (double)(this.xHighLimit - this.xLowLimit) + (double)this.xLowLimit);
            } else {
                ix = ixStep;
                ix2 = ixStep + 1;
            }
            int xoffset1 = ix * xStride;
            int xoffset2 = ix2 * xStride;
            double x1 = xData[ix];
            double x2 = xData[ix2];
            block5: for (int iyStep = iyStart; iyStep < nySteps; ++iyStep) {
                int i;
                int iy2;
                int iy;
                if (localUseLOD) {
                    iy = (int)((double)iyStep / (double)nySteps * (double)(this.yHighLimit - this.yLowLimit) + (double)this.yLowLimit);
                    iy2 = (int)((double)(iyStep + 1) / (double)nySteps * (double)(this.yHighLimit - this.yLowLimit) + (double)this.yLowLimit);
                } else {
                    iy = iyStep;
                    iy2 = iyStep + 1;
                }
                int yoffset1 = iy * yStride;
                int yoffset2 = iy2 * yStride;
                double y1 = yData[iy];
                double y2 = yData[iy2];
                this.curSegmentName = xoffset1 + yoffset1 + this.zoffset;
                for (i = 0; i < this.totalResp; ++i) {
                    r[i][0][0] = response[i][xoffset1 + yoffset1 + this.zoffset];
                    m[i][0][0] = Double.isNaN(r[i][0][0]) ? 1 : 0;
                    r[i][1][0] = response[i][xoffset2 + yoffset1 + this.zoffset];
                    m[i][1][0] = Double.isNaN(r[i][1][0]) ? 1 : 0;
                    r[i][1][1] = response[i][xoffset2 + yoffset2 + this.zoffset];
                    m[i][1][1] = Double.isNaN(r[i][1][1]) ? 1 : 0;
                    r[i][0][1] = response[i][xoffset1 + yoffset2 + this.zoffset];
                    m[i][0][1] = Double.isNaN(r[i][0][1]) ? 1 : 0;
                }
                int totalnummiss = this.FindTotalMissing(m, this.totalResp, tm);
                switch (drawStyle) {
                    case 1: 
                    case 4: 
                    case 5: {
                        this.FindColors(r, this.totalResp, tm, totalnummiss, colors);
                        if (drawStyle == 1) {
                            this.DrawBlock(x1, x2, y1, y2, r[0][0][0], tm[0][0], r[0][1][0], tm[1][0], r[0][1][1], tm[1][1], r[0][0][1], tm[0][1], totalnummiss, colors[0], colors[1], 0, rmin, rmax, isStacked);
                            continue block5;
                        }
                        this.DrawSmooth(x1, x2, y1, y2, r[0][0][0], tm[0][0], colors[0], r[0][1][0], tm[1][0], colors[1], r[0][1][1], tm[1][1], colors[2], r[0][0][1], tm[0][1], colors[3], 0, xLow, yLow, xHigh, yHigh, rmin, rmax);
                        continue block5;
                    }
                    case 0: 
                    case 2: 
                    case 3: {
                        if (totalnummiss > 0) continue block5;
                        corners[0] = r[0][0][0];
                        corners[1] = r[0][1][0];
                        corners[2] = r[0][1][1];
                        corners[3] = r[0][0][1];
                        for (i = start; i <= stop; ++i) {
                            value = this.highlightBuild ? this.highlightValue : this.levels[i];
                            this.height[i] = this.highlightBuild && isStacked && (this.style == 0 || this.style == 3) ? this.highlightZ : (isStacked ? this.base + (value - this.levels[0]) * heightConstant : this.base);
                            this.cell_case[i] = Contours.findcase(value, corners);
                            if (this.highlightBuild && this.useHighlightColor && this.highlightColor != null) {
                                this.rgb[i][0] = (float)this.highlightColor.getRed() / 255.0f;
                                this.rgb[i][1] = (float)this.highlightColor.getGreen() / 255.0f;
                                this.rgb[i][2] = (float)this.highlightColor.getBlue() / 255.0f;
                                this.rgb[i][3] = this.opacity;
                            } else {
                                this.GetColor(value, 0.0, 0.0, 0.0, 0, 0L, false, this.rgb[i]);
                                if (i == this.selectedLevelIndex && this.outlineColor != null) {
                                    this.rgb[i][0] = this.outlineColor[0];
                                    this.rgb[i][1] = this.outlineColor[1];
                                    this.rgb[i][2] = this.outlineColor[2];
                                }
                            }
                            this.numpairs[i] = Contours.findintersections(x1, x2, y1, y2, value, corners, this.cell_case[i], this.intersections[i]);
                            if (this.numpairs[i] == 0 || !isStacked || !(this.height[i] > lastBboxZ)) continue;
                            lastBboxZ = this.height[i];
                        }
                        if (drawStyle == 2) {
                            this.numprimitives += this.DrawLines(start, stop, false);
                            continue block5;
                        }
                        this.numprimitives += this.DrawPolygons(x1, x2, y1, y2);
                    }
                }
            }
        }
        return true;
    }

    protected boolean processCellsCT(double[] xData, double[] yData, double[][] response, int drawStyle, boolean isStacked, int start, int stop, double heightConstant) {
        boolean localUseLOD;
        int nySteps;
        int nxSteps;
        int ixStart;
        int iyStart;
        String[] labels;
        double[] corners = new double[4];
        String[] stringArray = labels = this.labelStyle == 0 ? null : this.GetLevelLabels();
        if (corners == null) {
            return false;
        }
        this.labelArea.reset();
        int nx = this.xHighLimit - this.xLowLimit + 1;
        int ny = this.yHighLimit - this.yLowLimit + 1;
        if (!this.growBitSetArray(nx, ny)) {
            return false;
        }
        int nCells = nx * ny;
        int xStride = ((GriddedChartData)this.data).GetXStride();
        int yStride = ((GriddedChartData)this.data).GetYStride();
        if (this.useLOD && this.lodCount < nCells) {
            iyStart = 0;
            ixStart = 0;
            nxSteps = Math.min((int)Math.sqrt(this.lodCount), nx) - 1;
            nySteps = Math.min((int)Math.sqrt(this.lodCount), ny) - 1;
            localUseLOD = true;
        } else {
            ixStart = this.xLowLimit;
            nxSteps = this.xHighLimit;
            iyStart = this.yLowLimit;
            nySteps = this.yHighLimit;
            localUseLOD = false;
        }
        for (int i = start; i <= stop; ++i) {
            String label;
            double value;
            this.clearBitSetArray(nx, ny);
            if (this.highlightBuild) {
                value = this.highlightValue;
                label = null;
            } else {
                value = this.levels[i];
                String string = label = labels == null || i >= labels.length ? null : labels[i];
            }
            if (this.highlightBuild && this.useHighlightColor && this.highlightColor != null) {
                this.rgb[i][0] = (float)this.highlightColor.getRed() / 255.0f;
                this.rgb[i][1] = (float)this.highlightColor.getGreen() / 255.0f;
                this.rgb[i][2] = (float)this.highlightColor.getBlue() / 255.0f;
                this.rgb[i][3] = this.opacity;
            } else {
                this.GetColor(value, 0.0, 0.0, 0.0, 0, 0L, false, this.rgb[i]);
                if (i == this.selectedLevelIndex && this.outlineColor != null) {
                    this.rgb[i][0] = this.outlineColor[0];
                    this.rgb[i][1] = this.outlineColor[1];
                    this.rgb[i][2] = this.outlineColor[2];
                }
            }
            this.OnColor(this.rgb[i][0], this.rgb[i][1], this.rgb[i][2]);
            block8: for (int which = 0; which < trackingList.length; ++which) {
                double height = this.highlightBuild && isStacked && (this.style == 0 || this.style == 3) ? this.highlightZ : (isStacked ? this.base + (value - this.levels[0]) * heightConstant : this.base);
                switch (which) {
                    case 0: {
                        int ixStep;
                        for (ixStep = ixStart; ixStep < nxSteps; ++ixStep) {
                            this.trackContour(ixStep, nxSteps, iyStart + nySteps, nySteps, value, label, height, localUseLOD, which, xStride, yStride, xData, yData, response[0], corners);
                        }
                        continue block8;
                    }
                    case 1: {
                        int iyStep;
                        for (iyStep = nySteps; iyStep > iyStart; --iyStep) {
                            this.trackContour(ixStart + nxSteps, nxSteps, iyStep, nySteps, value, label, height, localUseLOD, which, xStride, yStride, xData, yData, response[0], corners);
                        }
                        continue block8;
                    }
                    case 2: {
                        int ixStep;
                        for (ixStep = nxSteps; ixStep > ixStart; --ixStep) {
                            this.trackContour(ixStep, nxSteps, iyStart, nySteps, value, label, height, localUseLOD, which, xStride, yStride, xData, yData, response[0], corners);
                        }
                        continue block8;
                    }
                    case 3: {
                        int iyStep;
                        for (iyStep = iyStart; iyStep < iyStart + nySteps; ++iyStep) {
                            this.trackContour(ixStart, nxSteps, iyStep, nySteps, value, label, height, localUseLOD, which, xStride, yStride, xData, yData, response[0], corners);
                        }
                        continue block8;
                    }
                    case 4: {
                        int iyStep;
                        int ixStep;
                        for (iyStep = iyStart; iyStep < iyStart + nySteps; ++iyStep) {
                            for (ixStep = ixStart; ixStep < ixStart + nxSteps; ++ixStep) {
                                this.trackContour(ixStep, nxSteps, iyStep, nySteps, value, label, height, localUseLOD, which, xStride, yStride, xData, yData, response[0], corners);
                            }
                        }
                        continue block8;
                    }
                }
            }
        }
        return true;
    }

    protected double storeLineSegment(int i, int isect1, int isect2) {
        double len = Double.NaN;
        double dx = this.intersections[i][isect2][0] - this.intersections[i][isect1][0];
        double dy = this.intersections[i][isect2][1] - this.intersections[i][isect1][1];
        len = Math.sqrt(dx * dx + dy * dy);
        this.segments.add(this.intersections[i][isect1][0]);
        this.segments.add(this.intersections[i][isect1][1]);
        this.segments.add(this.intersections[i][isect2][0]);
        this.segments.add(this.intersections[i][isect2][1]);
        return len;
    }

    protected void trackContour(int ixStart, int nxSteps, int iyStart, int nySteps, double value, String label, double z, boolean isLODOn, int which, int xStride, int yStride, double[] xData, double[] yData, double[] response, double[] corners) {
        Vector lines;
        double tw;
        int nSegs;
        int iyStep2;
        int iyStep1;
        int ixStep2;
        int ixStep1;
        boolean tracking = true;
        boolean began = false;
        int incX = 0;
        int incY = 0;
        double totalLen = 0.0;
        if (this.segments == null) {
            return;
        }
        this.segments.removeAll();
        switch (which) {
            case 0: {
                ixStep1 = ixStart;
                ixStep2 = ixStart + 1;
                iyStep1 = iyStart - 1;
                iyStep2 = iyStart;
                break;
            }
            case 1: {
                ixStep1 = ixStart - 1;
                ixStep2 = ixStart;
                iyStep1 = iyStart - 1;
                iyStep2 = iyStart;
                break;
            }
            case 2: {
                ixStep1 = ixStart - 1;
                ixStep2 = ixStart;
                iyStep1 = iyStart;
                iyStep2 = iyStart + 1;
                break;
            }
            case 3: {
                ixStep1 = ixStart;
                ixStep2 = ixStart + 1;
                iyStep1 = iyStart;
                iyStep2 = iyStart + 1;
                break;
            }
            case 4: {
                ixStep1 = ixStart;
                ixStep2 = ixStart + 1;
                iyStep1 = iyStart;
                iyStep2 = iyStart + 1;
                break;
            }
            default: {
                return;
            }
        }
        while (tracking) {
            int bit;
            int iy2;
            int iy;
            int ix2;
            int ix;
            if (isLODOn) {
                ix = (int)((double)ixStep1 / (double)nxSteps * (double)(this.xHighLimit - this.xLowLimit) + (double)this.xLowLimit);
                ix2 = (int)((double)ixStep2 / (double)nxSteps * (double)(this.xHighLimit - this.xLowLimit) + (double)this.xLowLimit);
                iy = (int)((double)iyStep1 / (double)nySteps * (double)(this.yHighLimit - this.yLowLimit) + (double)this.yLowLimit);
                iy2 = (int)((double)iyStep2 / (double)nySteps * (double)(this.yHighLimit - this.yLowLimit) + (double)this.yLowLimit);
            } else {
                ix = ixStep1;
                ix2 = ixStep2;
                iy = iyStep1;
                iy2 = iyStep2;
            }
            if (ix < this.xLowLimit || ix2 < this.xLowLimit || ix > this.xHighLimit || ix2 > this.xHighLimit || iy < this.yLowLimit || iy2 < this.yLowLimit || iy > this.yHighLimit || iy2 > this.yHighLimit) break;
            int xoffset1 = ix * xStride;
            int xoffset2 = ix2 * xStride;
            double x1 = xData[ix];
            double x2 = xData[ix2];
            int yoffset1 = iy * yStride;
            int yoffset2 = iy2 * yStride;
            double y1 = yData[iy];
            double y2 = yData[iy2];
            corners[0] = response[xoffset1 + yoffset1 + this.zoffset];
            corners[1] = response[xoffset2 + yoffset1 + this.zoffset];
            corners[2] = response[xoffset2 + yoffset2 + this.zoffset];
            corners[3] = response[xoffset1 + yoffset2 + this.zoffset];
            if (Double.isNaN(corners[0]) || Double.isNaN(corners[1]) || Double.isNaN(corners[2]) || Double.isNaN(corners[3])) {
                return;
            }
            int curCellCase = Contours.findcase(value, corners);
            if (curCellCase != 5 && curCellCase != 10) {
                bit = curCellCase;
                if (this.found[ix][iy].get(bit)) {
                    break;
                }
            } else {
                bit = -1;
            }
            if (began) {
                switch (curCellCase) {
                    default: {
                        tracking = false;
                        break;
                    }
                    case 1: 
                    case 14: {
                        if (incX == 1) {
                            incY = -1;
                            incX = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 1, 0);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        if (incY == 1) {
                            incX = -1;
                            incY = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 0, 1);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        tracking = false;
                        break;
                    }
                    case 2: 
                    case 13: {
                        if (incX == -1) {
                            incY = -1;
                            incX = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 1, 0);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        if (incY == 1) {
                            incX = 1;
                            incY = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 0, 1);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        tracking = false;
                        break;
                    }
                    case 3: 
                    case 12: {
                        if (incX == 1) {
                            incX = 1;
                            incY = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 1, 0);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        if (incX == -1) {
                            incX = -1;
                            incY = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 0, 1);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        tracking = false;
                        break;
                    }
                    case 4: 
                    case 11: {
                        if (incX == -1) {
                            incY = 1;
                            incX = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 0, 1);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        if (incY == -1) {
                            incX = 1;
                            incY = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 1, 0);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        tracking = false;
                        break;
                    }
                    case 5: {
                        if (incX == 1) {
                            bit = 5;
                            if (this.found[ix][iy].get(bit)) {
                                tracking = false;
                                break;
                            }
                            incY = -1;
                            incX = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 1, 0);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        if (incY == 1) {
                            bit = 5;
                            if (this.found[ix][iy].get(bit)) {
                                tracking = false;
                                break;
                            }
                            incX = -1;
                            incY = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 0, 1);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        if (incX == -1) {
                            bit = 0;
                            if (this.found[ix][iy].get(bit)) {
                                tracking = false;
                                break;
                            }
                            incY = 1;
                            incX = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 2, 3);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        if (incY == -1) {
                            bit = 0;
                            if (this.found[ix][iy].get(bit)) {
                                tracking = false;
                                break;
                            }
                            incX = 1;
                            incY = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 3, 2);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        tracking = false;
                        break;
                    }
                    case 6: 
                    case 9: {
                        if (incY == -1) {
                            incY = -1;
                            incX = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 1, 0);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        if (incY == 1) {
                            incY = 1;
                            incX = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 0, 1);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        tracking = false;
                        break;
                    }
                    case 7: 
                    case 8: {
                        if (incY == -1) {
                            incX = -1;
                            incY = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 0, 1);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        if (incX == 1) {
                            incY = 1;
                            incX = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 1, 0);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        tracking = false;
                        break;
                    }
                    case 10: {
                        if (incX == -1) {
                            bit = 10;
                            if (this.found[ix][iy].get(bit)) {
                                tracking = false;
                                break;
                            }
                            incY = -1;
                            incX = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 1, 0);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        if (incY == 1) {
                            bit = 10;
                            if (this.found[ix][iy].get(bit)) {
                                tracking = false;
                                break;
                            }
                            incX = 1;
                            incY = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 0, 1);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        if (incX == 1) {
                            bit = 15;
                            if (this.found[ix][iy].get(bit)) {
                                tracking = false;
                                break;
                            }
                            incY = 1;
                            incX = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 3, 2);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        if (incY == -1) {
                            bit = 15;
                            if (this.found[ix][iy].get(bit)) {
                                tracking = false;
                                break;
                            }
                            incX = -1;
                            incY = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 2, 3);
                            this.found[ix][iy].set(bit);
                            break;
                        }
                        tracking = false;
                        break;
                    }
                }
            } else {
                block17 : switch (which) {
                    case 0: {
                        switch (curCellCase) {
                            default: {
                                tracking = false;
                                break block17;
                            }
                            case 5: {
                                bit = 0;
                                if (this.found[ix][iy].get(bit)) {
                                    tracking = false;
                                    break block17;
                                }
                            }
                            case 4: 
                            case 11: {
                                incX = 1;
                                incY = 0;
                                began = true;
                                Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                                totalLen = curCellCase != 5 ? (totalLen += this.storeLineSegment(0, 1, 0)) : (totalLen += this.storeLineSegment(0, 3, 2));
                                this.found[ix][iy].set(bit);
                                break block17;
                            }
                            case 6: 
                            case 9: {
                                incY = -1;
                                incX = 0;
                                began = true;
                                Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                                totalLen += this.storeLineSegment(0, 1, 0);
                                this.found[ix][iy].set(bit);
                                break block17;
                            }
                            case 10: {
                                bit = 15;
                                if (!this.found[ix][iy].get(bit)) break;
                                tracking = false;
                                break block17;
                            }
                            case 7: 
                            case 8: 
                        }
                        incX = -1;
                        incY = 0;
                        began = true;
                        Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                        totalLen = curCellCase != 10 ? (totalLen += this.storeLineSegment(0, 0, 1)) : (totalLen += this.storeLineSegment(0, 2, 3));
                        this.found[ix][iy].set(bit);
                        break;
                    }
                    case 1: {
                        switch (curCellCase) {
                            default: {
                                tracking = false;
                                break block17;
                            }
                            case 10: {
                                bit = curCellCase;
                                if (this.found[ix][iy].get(bit)) {
                                    tracking = false;
                                    break block17;
                                }
                            }
                            case 2: 
                            case 13: {
                                incY = -1;
                                incX = 0;
                                began = true;
                                Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                                totalLen += this.storeLineSegment(0, 1, 0);
                                this.found[ix][iy].set(bit);
                                break block17;
                            }
                            case 3: 
                            case 12: {
                                incX = -1;
                                incY = 0;
                                began = true;
                                Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                                totalLen += this.storeLineSegment(0, 0, 1);
                                this.found[ix][iy].set(bit);
                                break block17;
                            }
                            case 5: {
                                bit = 0;
                                if (!this.found[ix][iy].get(bit)) break;
                                tracking = false;
                                break block17;
                            }
                            case 4: 
                            case 11: 
                        }
                        incY = 1;
                        incX = 0;
                        began = true;
                        Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                        totalLen = curCellCase != 5 ? (totalLen += this.storeLineSegment(0, 0, 1)) : (totalLen += this.storeLineSegment(0, 2, 3));
                        this.found[ix][iy].set(bit);
                        break;
                    }
                    case 2: {
                        switch (curCellCase) {
                            default: {
                                tracking = false;
                                break block17;
                            }
                            case 5: {
                                bit = curCellCase;
                                if (this.found[ix][iy].get(bit)) {
                                    tracking = false;
                                    break block17;
                                }
                            }
                            case 1: 
                            case 14: {
                                incX = -1;
                                incY = 0;
                                began = true;
                                Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                                totalLen += this.storeLineSegment(0, 0, 1);
                                this.found[ix][iy].set(bit);
                                break block17;
                            }
                            case 10: {
                                bit = curCellCase;
                                if (this.found[ix][iy].get(bit)) {
                                    tracking = false;
                                    break block17;
                                }
                            }
                            case 2: 
                            case 13: {
                                incX = 1;
                                incY = 0;
                                began = true;
                                Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                                totalLen += this.storeLineSegment(0, 0, 1);
                                this.found[ix][iy].set(bit);
                                break block17;
                            }
                            case 6: 
                            case 9: 
                        }
                        incY = 1;
                        incX = 0;
                        began = true;
                        Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                        totalLen += this.storeLineSegment(0, 0, 1);
                        this.found[ix][iy].set(bit);
                        break;
                    }
                    case 3: {
                        switch (curCellCase) {
                            default: {
                                tracking = false;
                                break block17;
                            }
                            case 5: {
                                bit = curCellCase;
                                if (this.found[ix][iy].get(bit)) {
                                    tracking = false;
                                    break block17;
                                }
                            }
                            case 1: 
                            case 14: {
                                incY = -1;
                                incX = 0;
                                began = true;
                                Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                                totalLen += this.storeLineSegment(0, 0, 1);
                                this.found[ix][iy].set(bit);
                                break block17;
                            }
                            case 3: 
                            case 12: {
                                incX = 1;
                                incY = 0;
                                began = true;
                                Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                                totalLen += this.storeLineSegment(0, 1, 0);
                                this.found[ix][iy].set(bit);
                                break block17;
                            }
                            case 10: {
                                bit = 15;
                                if (!this.found[ix][iy].get(bit)) break;
                                tracking = false;
                                break block17;
                            }
                            case 7: 
                            case 8: 
                        }
                        incY = 1;
                        incX = 0;
                        began = true;
                        Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                        totalLen = curCellCase != 10 ? (totalLen += this.storeLineSegment(0, 1, 0)) : (totalLen += this.storeLineSegment(0, 2, 3));
                        this.found[ix][iy].set(bit);
                        break;
                    }
                    case 4: {
                        switch (curCellCase) {
                            default: {
                                tracking = false;
                                break block17;
                            }
                            case 1: 
                            case 14: {
                                incX = -1;
                                incY = 0;
                                began = true;
                                Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                                totalLen += this.storeLineSegment(0, 0, 1);
                                this.found[ix][iy].set(bit);
                                break block17;
                            }
                            case 2: 
                            case 13: {
                                incY = -1;
                                incX = 0;
                                began = true;
                                Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                                totalLen += this.storeLineSegment(0, 1, 0);
                                this.found[ix][iy].set(bit);
                                break block17;
                            }
                            case 3: 
                            case 12: {
                                incX = -1;
                                incY = 0;
                                began = true;
                                Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                                totalLen += this.storeLineSegment(0, 0, 1);
                                this.found[ix][iy].set(bit);
                                break block17;
                            }
                            case 4: 
                            case 11: {
                                incY = 1;
                                incX = 0;
                                began = true;
                                Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                                totalLen += this.storeLineSegment(0, 0, 1);
                                this.found[ix][iy].set(bit);
                                break block17;
                            }
                            case 5: {
                                if (this.found[ix][iy].get(0) && this.found[ix][iy].get(5)) {
                                    tracking = false;
                                    break block17;
                                }
                                if (this.found[ix][iy].get(0)) {
                                    incX = -1;
                                    incY = 0;
                                    bit = curCellCase;
                                    Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                                    totalLen += this.storeLineSegment(0, 0, 1);
                                } else {
                                    bit = 0;
                                    incY = 1;
                                    incX = 0;
                                    Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                                    totalLen += this.storeLineSegment(0, 2, 3);
                                }
                                began = true;
                                this.found[ix][iy].set(bit);
                                break block17;
                            }
                            case 6: 
                            case 9: {
                                incY = 1;
                                incX = 0;
                                began = true;
                                Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                                totalLen += this.storeLineSegment(0, 0, 1);
                                this.found[ix][iy].set(bit);
                                break block17;
                            }
                            case 7: 
                            case 8: {
                                incX = 1;
                                incY = 0;
                                began = true;
                                Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                                totalLen += this.storeLineSegment(0, 1, 0);
                                this.found[ix][iy].set(bit);
                                break block17;
                            }
                            case 10: 
                        }
                        if (this.found[ix][iy].get(10) && this.found[ix][iy].get(15)) {
                            tracking = false;
                            break;
                        }
                        if (this.found[ix][iy].get(15)) {
                            incY = -1;
                            incX = 0;
                            bit = curCellCase;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 1, 0);
                        } else {
                            bit = 15;
                            incX = -1;
                            incY = 0;
                            Contours.findintersections(x1, x2, y1, y2, value, corners, curCellCase, this.intersections[0]);
                            totalLen += this.storeLineSegment(0, 2, 3);
                        }
                        began = true;
                        this.found[ix][iy].set(bit);
                    }
                }
            }
            ixStep1 += incX;
            ixStep2 += incX;
            iyStep1 += incY;
            iyStep2 += incY;
        }
        if ((nSegs = this.segments.getNumberElements()) <= 0 || nSegs % 4 != 0) {
            return;
        }
        nSegs /= 4;
        double[] segs = this.segments.getElements();
        if (segs == null) {
            return;
        }
        if (label != null) {
            label = " " + label.trim() + " ";
        }
        if ((tw = this.getTextWidth(label)) > totalLen) {
            label = null;
        }
        double angle = 0.0;
        double[] boxPts = null;
        double lx = 0.0;
        double ly = 0.0;
        if (label != null) {
            int labelSegment;
            double[] angledBBox = new double[6];
            boolean inside = false;
            if (this.labelPosition == 0) {
                labelSegment = 0;
                while (!inside && labelSegment < nSegs) {
                    lx = (segs[4 * labelSegment] + segs[4 * labelSegment + 2]) / 2.0;
                    ly = (segs[4 * labelSegment + 1] + segs[4 * labelSegment + 3]) / 2.0;
                    if (this.labelOrientation == 1) {
                        angle = this.getLabelAngle(segs[4 * labelSegment], segs[4 * labelSegment + 1], segs[4 * labelSegment + 2], segs[4 * labelSegment + 3]);
                    }
                    this.getTextBoundingBox(label, lx, ly, z, 0, 0, angle, angledBBox);
                    if (angledBBox[0] >= xData[this.xLowLimit] && angledBBox[3] <= xData[this.xHighLimit] && angledBBox[1] >= yData[this.yLowLimit] && angledBBox[4] <= yData[this.yHighLimit]) {
                        inside = true;
                        continue;
                    }
                    ++labelSegment;
                }
            } else if (this.labelPosition == 2) {
                labelSegment = nSegs - 1;
                while (!inside && labelSegment >= 0) {
                    lx = (segs[4 * labelSegment] + segs[4 * labelSegment + 2]) / 2.0;
                    ly = (segs[4 * labelSegment + 1] + segs[4 * labelSegment + 3]) / 2.0;
                    if (this.labelOrientation == 1) {
                        angle = this.getLabelAngle(segs[4 * labelSegment], segs[4 * labelSegment + 1], segs[4 * labelSegment + 2], segs[4 * labelSegment + 3]);
                    }
                    this.getTextBoundingBox(label, lx, ly, z, 0, 0, angle, angledBBox);
                    if (angledBBox[0] >= xData[this.xLowLimit] && angledBBox[3] <= xData[this.xHighLimit] && angledBBox[1] >= yData[this.yLowLimit] && angledBBox[4] <= yData[this.yHighLimit]) {
                        inside = true;
                        continue;
                    }
                    --labelSegment;
                }
            } else {
                labelSegment = nSegs / 2;
                lx = (segs[4 * labelSegment] + segs[4 * labelSegment + 2]) / 2.0;
                ly = (segs[4 * labelSegment + 1] + segs[4 * labelSegment + 3]) / 2.0;
                if (this.labelOrientation == 1) {
                    angle = this.getLabelAngle(segs[4 * labelSegment], segs[4 * labelSegment + 1], segs[4 * labelSegment + 2], segs[4 * labelSegment + 3]);
                }
                this.getTextBoundingBox(label, lx, ly, z, 0, 0, angle, angledBBox);
                if (angledBBox[0] >= xData[this.xLowLimit] && angledBBox[3] <= xData[this.xHighLimit] && angledBBox[1] >= yData[this.yLowLimit] && angledBBox[4] <= yData[this.yHighLimit]) {
                    inside = true;
                }
            }
            if (inside) {
                boxPts = new double[8];
                this.getTextBBoxPts(label, lx, ly, z, 0, 0, angle, boxPts);
                if (this.thinLabels && !this.isGoodLabelPlacement(boxPts)) {
                    label = null;
                    boxPts = null;
                }
            } else {
                label = null;
                boxPts = null;
            }
        }
        if ((lines = this.createLineSegments(segs, nSegs, boxPts)) != null) {
            for (int j = 0; j < lines.size(); ++j) {
                Vector segment = (Vector)lines.get(j);
                if (segment == null || segment.isEmpty()) continue;
                this.OnBeginPrimitive(1);
                for (int k = 0; k < segment.size(); ++k) {
                    Point2D.Double pt = (Point2D.Double)segment.get(k);
                    this.DRAW(pt.x, pt.y, z);
                }
                this.OnEndPrimitive(1);
            }
        }
        if (label != null) {
            this.drawLineLabel(label, lx, ly, z, angle);
        }
    }

    protected boolean isGoodLabelPlacement(double[] pts) {
        if (pts == null || pts.length != 8) {
            return false;
        }
        GeneralPath path = new GeneralPath();
        path.moveTo((float)pts[0], (float)pts[1]);
        path.lineTo((float)pts[2], (float)pts[3]);
        path.lineTo((float)pts[4], (float)pts[5]);
        path.lineTo((float)pts[6], (float)pts[7]);
        path.closePath();
        Area rectArea = new Area(path);
        Area testArea = new Area(this.labelArea);
        testArea.intersect(rectArea);
        if (testArea.isEmpty()) {
            this.labelArea.add(rectArea);
            return true;
        }
        return false;
    }

    protected double[] getShapePoints(Shape shape) {
        if (shape == null) {
            return null;
        }
        double[] out = new double[8];
        double[] pt = new double[2];
        PathIterator pi = shape.getPathIterator(null);
        pi.currentSegment(pt);
        out[0] = pt[0];
        out[1] = pt[1];
        pi.next();
        pi.currentSegment(pt);
        out[2] = pt[0];
        out[3] = pt[1];
        pi.next();
        pi.currentSegment(pt);
        out[4] = pt[0];
        out[5] = pt[1];
        pi.next();
        pi.currentSegment(pt);
        out[6] = pt[0];
        out[7] = pt[1];
        return out;
    }

    protected void drawShape(Shape shape) {
        if (shape == null) {
            return;
        }
        PathIterator pi = shape.getPathIterator(null);
        double[] pt1 = new double[2];
        double[] pt2 = new double[2];
        double[] pt3 = new double[2];
        double[] pt4 = new double[2];
        pi.currentSegment(pt1);
        pi.next();
        pi.currentSegment(pt2);
        pi.next();
        pi.currentSegment(pt3);
        pi.next();
        pi.currentSegment(pt4);
        this.OnBeginPrimitive(1);
        this.DRAW(pt1[0], pt1[1], 0.0);
        this.DRAW(pt2[0], pt2[1], 0.0);
        this.DRAW(pt3[0], pt3[1], 0.0);
        this.DRAW(pt4[0], pt4[1], 0.0);
        this.DRAW(pt1[0], pt1[1], 0.0);
        this.OnEndPrimitive(1);
    }

    protected boolean AutoSetDataValues() {
        GriddedChartData gcd = (GriddedChartData)this.data;
        if (gcd == null) {
            return false;
        }
        this.ClearLimits();
        this.SetColorMin(gcd.GetResponseMin(0));
        this.SetColorMax(gcd.GetResponseMax(0));
        this.GenerateLevels(this.numlevels, Double.NaN, Double.NaN, false);
        return true;
    }

    public synchronized boolean ClearLimits() {
        GriddedChartData gcd = (GriddedChartData)this.data;
        double[] x = null;
        double[] y = null;
        if (gcd == null) {
            return false;
        }
        x = gcd.GetXData();
        if (x == null) {
            return false;
        }
        y = gcd.GetYData();
        if (y == null) {
            return false;
        }
        this.xLowLimit = 0;
        this.yLowLimit = 0;
        this.xHighLimit = x.length - 1;
        this.yHighLimit = y.length - 1;
        return true;
    }

    public synchronized boolean SetLimits(int xlow, int ylow, int xhigh, int yhigh) {
        GriddedChartData gcd = (GriddedChartData)this.data;
        double[] x = null;
        double[] y = null;
        if (gcd == null) {
            return false;
        }
        x = gcd.GetXData();
        if (x == null) {
            return false;
        }
        y = gcd.GetYData();
        if (y == null) {
            return false;
        }
        if (xlow < 0 || ylow < 0 || xlow >= xhigh || ylow >= yhigh || xhigh >= x.length || yhigh >= y.length) {
            return false;
        }
        this.xLowLimit = xlow;
        this.yLowLimit = ylow;
        this.xHighLimit = xhigh;
        this.yHighLimit = yhigh;
        return true;
    }

    public double GetBase() {
        return this.base;
    }

    public boolean SetBase(double newBase) {
        if (!Double.isNaN(newBase)) {
            this.base = newBase;
            return true;
        }
        return false;
    }

    public boolean SetSurfaceColor(Color c) {
        if (c == null) {
            this.surfaceColor = null;
            return true;
        }
        if (this.surfaceColor == null && (this.surfaceColor = new double[3]) == null) {
            return false;
        }
        this.surfaceColor[0] = (float)c.getRed() / 255.0f;
        this.surfaceColor[1] = (float)c.getGreen() / 255.0f;
        this.surfaceColor[2] = (float)c.getBlue() / 255.0f;
        return true;
    }

    public Color GetSurfaceColor() {
        if (this.surfaceColor == null) {
            return null;
        }
        return new Color((float)this.surfaceColor[0], (float)this.surfaceColor[1], (float)this.surfaceColor[2]);
    }

    public boolean SetSurfaceSideColor(Color c) {
        this.surfaceSideColor = c;
        return true;
    }

    public Color GetSurfaceSideColor() {
        return this.surfaceSideColor;
    }

    public boolean GetStacked() {
        return this.stacked;
    }

    public void SetStacked(boolean status) {
        this.stacked = status;
    }

    public boolean GetDrawSides() {
        return this.drawSides;
    }

    public void SetDrawSides(boolean draw) {
        this.drawSides = draw;
    }

    public boolean GetSmoothShadeMissing() {
        return this.shadeMissing;
    }

    public void SetSmoothShadeMissing(boolean shade) {
        this.shadeMissing = shade;
    }

    public double GetMaxStack() {
        return this.maxStack;
    }

    public boolean SetMaxStack(double newmaxStack) {
        if (Double.isNaN(newmaxStack)) {
            return false;
        }
        this.maxStack = newmaxStack;
        return true;
    }

    public int GetZOffset() {
        return this.zoffset;
    }

    public boolean SetZOffset(int newOffset) {
        if (newOffset < 0) {
            return false;
        }
        this.zoffset = newOffset;
        return true;
    }

    public double GetContourLevel(int idx) {
        if (idx < 0 || idx >= this.levels.length || idx >= this.numlevels) {
            return Double.NaN;
        }
        return this.levels[idx];
    }

    public boolean SetSelectLevel(double level, boolean exactMatch) {
        return this.SetSelectLevel(this.GetContourLevelIndex(level, exactMatch));
    }

    public int GetSelectLevel() {
        return this.selectedLevelIndex;
    }

    public boolean SetSelectLevel(int level) {
        if (level > this.numlevels) {
            return false;
        }
        this.selectedLevelIndex = level < 0 ? -1 : level;
        return true;
    }

    public boolean DeleteSelectedLevel() {
        boolean status = this.DeleteContourLevel(this.selectedLevelIndex);
        if (status) {
            this.selectedLevelIndex = -1;
        }
        return status;
    }

    public int GetContourLevelIndex(double level, boolean exactMatch) {
        int idx = -1;
        if (Double.isNaN(level) || this.levels == null || this.numlevels <= 0) {
            return -1;
        }
        idx = Contours.binarylookup(level, this.levels, this.numlevels);
        if (idx < 0 && exactMatch) {
            return -1;
        }
        if (idx < 0) {
            idx = idx == -1 ? 0 : (idx == -1 - this.numlevels ? this.numlevels - 1 : (level < (this.levels[-idx - 2] + this.levels[-idx - 1]) / 2.0 ? -idx - 2 : -idx - 1));
        }
        return idx;
    }

    public int AddContourLevel(double newLevel) {
        int idx = -1;
        if (this.numlevels >= 100) {
            return -1;
        }
        idx = Contours.binarylookup(newLevel, this.levels, this.numlevels);
        if (idx >= 0) {
            return idx;
        }
        idx = -idx - 1;
        for (int i = this.numlevels - 1; i >= idx; --i) {
            this.levels[i + 1] = this.levels[i];
        }
        this.levels[idx] = newLevel;
        ++this.numlevels;
        this.startLevel = 0;
        this.lastLevel = this.numlevels - 1;
        return idx;
    }

    public boolean DeleteContourLevel(int oldLevelIndex) {
        if (this.numlevels <= 0 || oldLevelIndex < 0 || oldLevelIndex >= 100) {
            return false;
        }
        for (int i = oldLevelIndex + 1; i < this.numlevels; ++i) {
            this.levels[i - 1] = this.levels[i];
        }
        --this.numlevels;
        this.startLevel = 0;
        this.lastLevel = this.numlevels - 1;
        return true;
    }

    public boolean DefineContourLevels(double[] newLevels) {
        if (newLevels == null || newLevels.length == 0) {
            this.lastLevel = 0;
            this.startLevel = 0;
            this.numlevels = 0;
            return true;
        }
        if (newLevels.length < 0 || this.levels == null || newLevels.length > this.levels.length || newLevels.length > 100) {
            return false;
        }
        if (Double.isNaN(newLevels[0])) {
            return false;
        }
        double lastDefined = this.levels[0] = newLevels[0];
        for (int i = 1; i < newLevels.length; ++i) {
            if (Double.isNaN(newLevels[i]) || newLevels[i] <= lastDefined) {
                this.lastLevel = 0;
                this.startLevel = 0;
                this.numlevels = 0;
                return false;
            }
            this.levels[i] = newLevels[i];
            lastDefined = newLevels[i];
        }
        this.numlevels = newLevels.length;
        this.startLevel = 0;
        this.lastLevel = this.numlevels - 1;
        this.ggood = false;
        return true;
    }

    public boolean SetFirstContourLevel(int firstLevelIdx) {
        if (firstLevelIdx < 0 || firstLevelIdx >= this.numlevels) {
            return false;
        }
        this.startLevel = firstLevelIdx;
        return true;
    }

    public boolean SetLastContourLevel(int lastLevelIdx) {
        if (lastLevelIdx < 0 || lastLevelIdx >= this.numlevels) {
            return false;
        }
        this.lastLevel = lastLevelIdx;
        return true;
    }

    protected static double[] noRange(double low, double high, int maxLevels) {
        double[] result = new double[3];
        if (result == null) {
            return null;
        }
        result[0] = low;
        result[1] = 0.0;
        result[2] = 1.0;
        return result;
    }

    protected static double[] znaxis(double low, double high, boolean zeroflag, int maxLevels, double minCover, double targetCover) {
        int i;
        double maxabs;
        double dataRange;
        boolean found = false;
        int numberOfLevels = 0;
        double lowTick = 0.0;
        double highTick = 0.0;
        double axisRange = 0.0;
        double[] result = new double[3];
        if (result == null) {
            return null;
        }
        if (minCover < 0.25 || minCover > 0.9) {
            minCover = 0.6;
        }
        if (targetCover < 0.5 || targetCover > 0.9) {
            targetCover = 0.8;
        }
        if (high < low) {
            double temp = low;
            low = high;
            high = temp;
        } else if (high == low) {
            result[0] = low;
            result[1] = 0.0;
            result[2] = 1.0;
            return result;
        }
        if (zeroflag) {
            if (low > 0.0) {
                low = 0.0;
            } else if (high < 0.0) {
                high = 0.0;
            }
        }
        if ((dataRange = high - low) < Math.max(1.0E-6 * (maxabs = Math.max(Math.abs(low), Math.abs(high))), Math.sqrt(Double.MIN_VALUE))) {
            return Contours.noRange(low, high, maxLevels);
        }
        double logscale = Math.floor(Math.log(maxabs) / logTen);
        double scale10 = Math.pow(10.0, logscale);
        while (true) {
            for (i = 0; i < sCuts.length; ++i) {
                double scale = scale10 / sCuts[i];
                lowTick = Math.floor(low / scale + 1.0E-6) * scale;
                highTick = Math.ceil(high / scale - 1.0E-6) * scale;
                axisRange = highTick - lowTick;
                if (axisRange / dataRange < 0.9999 || dataRange / axisRange < targetCover) continue;
                found = true;
                break;
            }
            if (found) break;
            scale10 /= 10.0;
        }
        double increment10 = scale10 / 10.0;
        double tickOne = lowTick;
        double tickTwo = highTick;
        double increment = 0.0;
        if (found) {
            found = false;
            block2: do {
                for (i = 0; i < iCuts.length; ++i) {
                    increment = increment10 * iCuts[i];
                    lowTick = Math.floor(tickOne / increment + 1.0E-6) * increment;
                    highTick = Math.ceil(tickTwo / increment - 1.0E-6) * increment;
                    double x = lowTick + increment;
                    if (low > x && (!zeroflag || x <= 1.0E-6 * increment)) {
                        lowTick = x;
                    }
                    if (high < (x = highTick - increment) && (!zeroflag || x >= 1.0E-6 * increment)) {
                        highTick = x;
                    }
                    if ((numberOfLevels = (int)Math.floor((axisRange = highTick - lowTick) / increment + 1.0E-6) + 1) > maxLevels || dataRange / axisRange < minCover) continue;
                    if (numberOfLevels < 3) continue block2;
                    if (zeroflag && (x = tickOne / increment + 1.0E-6) - Math.floor(x) > 1.0E-4) continue;
                    found = true;
                    continue block2;
                }
            } while (!found && !((increment10 *= 10.0) > dataRange));
        }
        if (!found) {
            if (maxLevels == 2 && highTick > lowTick) {
                result[0] = lowTick;
                result[1] = highTick - lowTick;
                result[2] = maxLevels;
                return result;
            }
            lowTick = low;
            axisRange = high - low;
            numberOfLevels = Math.min(6, Math.max(maxLevels, 2));
            increment = axisRange / (double)(numberOfLevels - 1);
        } else {
            numberOfLevels = (int)Math.floor(axisRange / increment + 1.0E-6) + 1;
        }
        result[0] = lowTick;
        result[1] = increment;
        result[2] = numberOfLevels;
        return result;
    }

    protected static int getMinusExponent(String s) {
        int extra = 0;
        if (s == null) {
            return 0;
        }
        try {
            extra = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            extra = 0;
        }
        if (extra >= 0) {
            return 0;
        }
        return -extra;
    }

    protected static int getNumberDecimals(String s) {
        int n;
        int extra = 0;
        if (s == null || (n = s.length()) <= 0) {
            return -1;
        }
        int i = s.indexOf(46);
        if (i < 0) {
            return 0;
        }
        int i2 = s.indexOf(69);
        if (i2 >= 0) {
            extra = Contours.getMinusExponent(s.substring(i2 + 1));
            n = i2;
        } else {
            i2 = s.indexOf(101);
            if (i2 >= 0) {
                extra = Contours.getMinusExponent(s.substring(i2 + 1));
                n = i2;
            }
        }
        while (s.charAt(n - 1) == '0') {
            --n;
        }
        return n - i - 1 + extra;
    }

    protected static int getNumberPower(String s) {
        int n;
        if (s == null || (n = s.length()) <= 0) {
            return -1;
        }
        int i = s.indexOf(69);
        if (i < 0 && (i = s.indexOf(101)) < 0) {
            return 0;
        }
        return n - i;
    }

    protected static int getNumberDecimals(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return -1;
        }
        String s = Double.toString(d);
        return Contours.getNumberDecimals(s);
    }

    protected static double roundDecimals(double value, int ndecimals) {
        long mult = 1L;
        if (Double.isInfinite(value) || Double.isNaN(value) || ndecimals < 0) {
            return value;
        }
        for (long i = 0L; i < (long)ndecimals; ++i) {
            mult *= 10L;
        }
        long v = Math.round(value * (double)mult);
        return (double)v / (double)mult;
    }

    public boolean GenerateLevels(int nlevels, double first, double last, boolean autoCalc) {
        int ndec = -1;
        double low = first;
        double high = last;
        double minCover = 0.5;
        double targetCover = 0.9;
        if (nlevels == 0) {
            this.numlevels = 0;
            this.ggood = false;
            return true;
        }
        if (Double.isNaN(low) && this.data != null) {
            low = ((GriddedChartData)this.data).GetResponseMin(0);
        }
        if (Double.isNaN(high) && this.data != null) {
            high = ((GriddedChartData)this.data).GetResponseMax(0);
        }
        if (nlevels == 1) {
            if (this.levels == null || this.levels.length < 1 || Double.isNaN(high)) {
                return false;
            }
            this.levels[0] = high;
            this.numlevels = 1;
            this.startLevel = 0;
            this.lastLevel = 0;
            return true;
        }
        if (this.levels == null || nlevels > this.levels.length || nlevels > 100 || Double.isNaN(low) || Double.isNaN(high) || low >= high) {
            return false;
        }
        if (!this.ggood) {
            return true;
        }
        if (autoCalc) {
            int i;
            double[] zn = Contours.znaxis(low, high, false, nlevels, minCover, targetCover);
            if (zn == null) {
                return false;
            }
            first = zn[0];
            double inc = zn[1];
            nlevels = (int)zn[2];
            if (nlevels <= 0) {
                return false;
            }
            double[] rawLevels = new double[nlevels];
            for (i = 0; i < nlevels; ++i) {
                rawLevels[i] = first + inc * (double)i;
            }
            rawLevels = NumericFormat.processValues((double[])rawLevels, (double)inc);
            for (i = 0; i < nlevels; ++i) {
                this.levels[i] = rawLevels[i];
            }
            if (this.style == 0 || this.style == 3) {
                this.SetColorMin(this.levels[0]);
                this.SetColorMax(this.levels[nlevels - 1]);
            }
        } else {
            for (int i = 0; i < nlevels; ++i) {
                this.levels[i] = i == 0 ? low : (i == nlevels - 1 ? high : (double)i * (high - low) / (double)(nlevels - 1) + low);
            }
        }
        this.numlevels = nlevels;
        this.startLevel = 0;
        this.lastLevel = this.numlevels - 1;
        this.ggood = true;
        this.setDefaultLabelFormat();
        return true;
    }

    protected void setDefaultLabelFormat() {
        String formatString;
        DataVariableInterface dv;
        this.ggoodLabelFormat = null;
        if (this.numlevels == 0 || this.levels.length < this.numlevels) {
            return;
        }
        double minVal = this.levels[this.startLevel];
        double maxVal = this.levels[this.lastLevel];
        double interval = 0.0;
        if (this.numlevels > 1) {
            interval = this.levels[1] - this.levels[0];
        }
        GriddedChartData gcd = (GriddedChartData)this.data;
        SASFormat fmt = this.userLabelFormat;
        if (this.userLabelFormat == null && gcd != null && (dv = (DataVariableInterface)gcd.GetResponseVariable(0)) != null && (formatString = dv.GetFormat()) != null) {
            fmt = SASFormat.getInstance((String)formatString, (Locale)this.locale);
        }
        if (fmt == null) {
            Object[] gGoodFormat = NumericFormat.getGGoodFormat((SASFormat)fmt, (double)minVal, (double)maxVal, (double)interval, (int)-1, (int)-1, (int)-1, (boolean)false);
            if (gGoodFormat != null && gGoodFormat.length == 2 && gGoodFormat[0] instanceof SASFormat) {
                this.ggoodLabelFormat = (SASFormat)gGoodFormat[0];
            }
        } else {
            this.ggoodLabelFormat = fmt;
        }
    }

    public boolean SetNumberLevels(int n, boolean autoCalc) {
        return this.GenerateLevels(n, Double.NaN, Double.NaN, autoCalc);
    }

    public boolean SetNumberLevels(int n) {
        return this.SetNumberLevels(n, false);
    }

    public boolean QueryStyle(int graphicStyle) {
        switch (graphicStyle) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public int GetStyle() {
        return this.style;
    }

    public String GetStyle(int style) {
        String s = null;
        switch (style) {
            case 0: {
                s = "Areas";
                break;
            }
            case 1: {
                s = "Block";
                break;
            }
            case 2: {
                s = "Lines";
                break;
            }
            case 3: {
                s = "LinesAndAreas";
                break;
            }
            case 4: {
                s = "Smooth";
                break;
            }
            case 5: {
                s = "Surface";
            }
        }
        return s;
    }

    public boolean SetStyle(String newStyle) {
        if (newStyle == null) {
            return false;
        }
        if (newStyle.equalsIgnoreCase("Area") || newStyle.equalsIgnoreCase("Areas")) {
            this.style = 0;
        } else if (newStyle.equalsIgnoreCase("Block")) {
            this.style = 1;
        } else if (newStyle.equalsIgnoreCase("Lines")) {
            this.style = 2;
        } else if (newStyle.equalsIgnoreCase("LinesAndAreas")) {
            this.style = 3;
        } else if (newStyle.equalsIgnoreCase("Smooth")) {
            this.style = 4;
        } else if (newStyle.equalsIgnoreCase("Surface")) {
            this.style = 5;
        } else {
            return false;
        }
        return true;
    }

    protected boolean SetHighLightLocation(double x, double y, double z) {
        Double value = null;
        value = this.GetValueAtLocation(x, y, z);
        if (value == null || Double.isNaN(value)) {
            return false;
        }
        this.highlightValue = value;
        this.highlightX = x;
        this.highlightY = y;
        this.highlightZ = z;
        return true;
    }

    protected boolean SetHighlightArea(double startX, double startY, double startZ, double endX, double endY, double endZ) {
        Double start = null;
        Double end = null;
        start = this.GetValueAtLocation(startX, startY, startZ);
        end = this.GetValueAtLocation(endX, endY, endZ);
        if (start == null || Double.isNaN(start) || end == null || Double.isNaN(end)) {
            return false;
        }
        this.highlightAreaStartValue = start;
        this.highlightAreaEndValue = end;
        return true;
    }

    public boolean setHighlightAreaValues(double start, double end) {
        this.highlightAreaStartValue = start;
        this.highlightAreaEndValue = end;
        return true;
    }

    public int[] GetNearestLocation(int x, int y) {
        return null;
    }

    public int[] GetNearestLocation(double[] p0, double[] p1) {
        int iy;
        double[] xData = this.GetChartData(0);
        double[] yData = this.GetChartData(1);
        int[] retValue = new int[3];
        double[] intersection = new double[4];
        if (xData == null || yData == null || retValue == null || intersection == null) {
            return null;
        }
        if (!Contours.FindDrawPlaneIntersection(this.drawPlane, this.base, p0, p1, intersection)) {
            return null;
        }
        switch (this.drawPlane) {
            case 0: {
                double temp = intersection[0];
                intersection[0] = intersection[2];
                intersection[2] = temp;
                break;
            }
            case 1: {
                double temp = intersection[1];
                intersection[1] = intersection[2];
                intersection[2] = temp;
                break;
            }
        }
        int ix = Contours.binarylookup(intersection[0], xData, -1);
        if (ix < 0) {
            if (ix == -1) {
                ix = 0;
            } else if (ix == -1 - xData.length) {
                ix = xData.length - 1;
            } else {
                int n = ix = intersection[0] < (xData[-ix - 2] + xData[-ix - 1]) / 2.0 ? -ix - 2 : -ix - 1;
            }
        }
        if ((iy = Contours.binarylookup(intersection[1], yData, -1)) < 0) {
            iy = iy == -1 ? 0 : (iy == -1 - yData.length ? yData.length - 1 : (intersection[1] < (yData[-iy - 2] + yData[-iy - 1]) / 2.0 ? -iy - 2 : -iy - 1));
        }
        retValue[0] = ix;
        retValue[1] = iy;
        retValue[2] = 0;
        return retValue;
    }

    public double[] FindLocation(int x, int y, boolean clampToData) {
        return null;
    }

    public double[] FindLocation(double[] p0, double[] p1, boolean clampToData) {
        double[] out = this.FindLocation(p0, p1);
        double[] xData = null;
        double[] yData = null;
        if (!clampToData) {
            return out;
        }
        xData = this.GetChartData(0);
        yData = this.GetChartData(1);
        if (out == null || xData == null) {
            return null;
        }
        if (out[0] < xData[this.xLowLimit]) {
            out[0] = xData[this.xLowLimit];
        } else if (out[0] > xData[this.xHighLimit]) {
            out[0] = xData[this.xHighLimit];
        }
        if (out[1] < yData[this.yLowLimit]) {
            out[1] = yData[this.yLowLimit];
        } else if (out[1] > yData[this.yHighLimit]) {
            out[1] = yData[this.yHighLimit];
        }
        return out;
    }

    public double[] FindLocation(double[] p0, double[] p1) {
        double[] intersection = new double[4];
        double[] retValue = new double[3];
        if (!Contours.FindDrawPlaneIntersection(this.drawPlane, this.base, p0, p1, intersection)) {
            return null;
        }
        switch (this.drawPlane) {
            case 0: {
                double temp = intersection[0];
                intersection[0] = intersection[2];
                intersection[2] = temp;
                break;
            }
            case 1: {
                double temp = intersection[1];
                intersection[1] = intersection[2];
                intersection[2] = temp;
                break;
            }
        }
        retValue[0] = intersection[0];
        retValue[1] = intersection[1];
        retValue[2] = intersection[2];
        return retValue;
    }

    public Double GetValueAtLocation(int x, int y) {
        return null;
    }

    public Double GetValueAtLocation(double[] p0, double[] p1) {
        double[] intersection = this.FindLocation(p0, p1);
        if (intersection == null) {
            return null;
        }
        return this.GetValueAtLocation(intersection[0], intersection[1], intersection[2]);
    }

    public Double GetValueAtLocation(double x, double y, double z) {
        double rul;
        int yoffset1;
        int yoffset2;
        double y1;
        double y2;
        boolean exactY;
        int xoffset1;
        int xoffset2;
        double x1;
        double x2;
        boolean exactX;
        double[] xData = this.GetChartData(0);
        double[] yData = this.GetChartData(1);
        double[][] response = this.GetResponsePointers();
        if (this.data == null || xData == null || yData == null || response == null) {
            return null;
        }
        int xStride = ((GriddedChartData)this.data).GetXStride();
        int yStride = ((GriddedChartData)this.data).GetYStride();
        int ix = Contours.binarylookup(x, xData, -1);
        if (ix < 0) {
            exactX = false;
            ix = -(ix + 2);
        } else {
            exactX = true;
        }
        if (ix < this.xLowLimit || ix > this.xHighLimit) {
            return null;
        }
        if (ix == this.xHighLimit) {
            if (!exactX) {
                return null;
            }
            x1 = x2 = xData[this.xHighLimit];
            xoffset1 = xoffset2 = ix * xStride;
        } else {
            x1 = xData[ix];
            x2 = xData[ix + 1];
            xoffset1 = ix * xStride;
            xoffset2 = xoffset1 + xStride;
        }
        int iy = Contours.binarylookup(y, yData, -1);
        if (iy < 0) {
            exactY = false;
            iy = -(iy + 2);
        } else {
            exactY = true;
        }
        if (iy < this.yLowLimit || iy > this.yHighLimit) {
            return null;
        }
        if (iy == this.yHighLimit) {
            if (!exactY) {
                return null;
            }
            y1 = y2 = yData[iy];
            yoffset1 = yoffset2 = iy * yStride;
        } else {
            y1 = yData[iy];
            y2 = yData[iy + 1];
            yoffset1 = iy * yStride;
            yoffset2 = yoffset1 + yStride;
        }
        int nmiss = 0;
        double rll = response[0][xoffset1 + yoffset1 + this.zoffset];
        boolean mll = false;
        if (Double.isNaN(rll)) {
            mll = true;
            ++nmiss;
        }
        double rlr = response[0][xoffset2 + yoffset1 + this.zoffset];
        boolean mlr = false;
        if (Double.isNaN(rlr)) {
            mlr = true;
            ++nmiss;
        }
        double rur = response[0][xoffset2 + yoffset2 + this.zoffset];
        boolean mur = false;
        if (Double.isNaN(rur)) {
            mur = true;
            ++nmiss;
        }
        if (Double.isNaN(rul = response[0][xoffset1 + yoffset2 + this.zoffset])) {
            ++nmiss;
        }
        double value = 0.0;
        switch (nmiss) {
            case 0: {
                if (xoffset1 == xoffset2 && yoffset1 == yoffset2) {
                    value = rul;
                    break;
                }
                if (xoffset1 == xoffset2) {
                    value = (y - y1) / (y2 - y1) * (rul - rll) + rll;
                    break;
                }
                if (yoffset1 == yoffset2) {
                    value = (x - x1) / (x2 - x1) * (rlr - rll) + rll;
                    break;
                }
                value = this.interpolateCell(x, y, x1, y1, x2, y2, rll, rlr, rur, rul);
                break;
            }
            case 1: {
                if (mll || mur) {
                    double distLower = (x - x1) * (x - x1) + (y - y1) * (y - y1);
                    double distUpper = (x2 - x) * (x2 - x) + (y2 - y) * (y2 - y);
                    if (mll) {
                        if (distLower < distUpper) {
                            value = Double.NaN;
                            break;
                        }
                        value = (rlr + rur + rul) / 3.0;
                        break;
                    }
                    if (distUpper < distLower) {
                        value = Double.NaN;
                        break;
                    }
                    value = (rll + rlr + rul) / 3.0;
                    break;
                }
                double distLower = (x2 - x) * (x2 - x) + (y - y1) * (y - y1);
                double distUpper = (x - x1) * (x - x1) + (y2 - y) * (y2 - y);
                if (mlr) {
                    if (distLower < distUpper) {
                        value = Double.NaN;
                        break;
                    }
                    value = (rll + rul + rur) / 3.0;
                    break;
                }
                if (distUpper < distLower) {
                    value = Double.NaN;
                    break;
                }
                value = (rll + rlr + rur) / 3.0;
                break;
            }
            default: {
                value = Double.NaN;
            }
        }
        return new Double(value);
    }

    private double interpolateCell(double x, double y, double x1, double y1, double x2, double y2, double rll, double rlr, double rur, double rul) {
        double value = Double.NaN;
        double[] sortedResp = new double[]{rll, rlr, rur, rul};
        this.sortArray(sortedResp);
        boolean complexCase = false;
        if (sortedResp[0] == sortedResp[3]) {
            value = rll;
        } else if (sortedResp[0] == sortedResp[2] || sortedResp[1] == sortedResp[3]) {
            if (rll == rur) {
                value = this.interpolateTriangle(x, y, x1, y1, rll, x2, y1, rlr, x2, y2, rur);
                if (Double.isNaN(value)) {
                    value = this.interpolateTriangle(x, y, x1, y1, rll, x1, y2, rul, x2, y2, rur);
                }
            } else {
                value = this.interpolateTriangle(x, y, x1, y2, rul, x1, y1, rll, x2, y1, rlr);
                if (Double.isNaN(value)) {
                    value = this.interpolateTriangle(x, y, x1, y2, rul, x2, y2, rur, x2, y1, rlr);
                }
            }
        } else if (sortedResp[0] == sortedResp[1] && sortedResp[2] == sortedResp[3]) {
            if (rll == rur) {
                if (rll < rlr) {
                    value = this.interpolateTriangle(x, y, x1, y1, rll, x2, y1, rlr, x2, y2, rur);
                    if (Double.isNaN(value)) {
                        value = this.interpolateTriangle(x, y, x1, y1, rll, x1, y2, rul, x2, y2, rur);
                    }
                } else {
                    value = this.interpolateTriangle(x, y, x1, y2, rul, x1, y1, rll, x2, y1, rlr);
                    if (Double.isNaN(value)) {
                        value = this.interpolateTriangle(x, y, x1, y2, rul, x2, y2, rur, x2, y1, rlr);
                    }
                }
            } else {
                double rml = Contours.INTERP(y, y1, rll, y2, rul);
                double rmr = Contours.INTERP(y, y1, rlr, y2, rur);
                value = Contours.INTERP(x, x1, rml, x2, rmr);
            }
        } else if (sortedResp[0] == sortedResp[1] || sortedResp[1] == sortedResp[2] || sortedResp[2] == sortedResp[3]) {
            if (rll == rur) {
                if (rll < rlr || rll < rul) {
                    value = this.interpolateTriangle(x, y, x1, y1, rll, x2, y1, rlr, x2, y2, rur);
                    if (Double.isNaN(value)) {
                        value = this.interpolateTriangle(x, y, x1, y1, rll, x1, y2, rul, x2, y2, rur);
                    }
                } else {
                    complexCase = true;
                }
            } else if (rul == rlr) {
                if (rul < rll || rul < rur) {
                    value = this.interpolateTriangle(x, y, x1, y2, rul, x1, y1, rll, x2, y1, rlr);
                    if (Double.isNaN(value)) {
                        value = this.interpolateTriangle(x, y, x1, y2, rul, x2, y2, rur, x2, y1, rlr);
                    }
                } else {
                    complexCase = true;
                }
            } else {
                complexCase = true;
            }
        } else {
            complexCase = true;
        }
        if (complexCase) {
            double middleAvg = (sortedResp[1] + sortedResp[2]) / 2.0;
            int msCase = Contours.findcase(middleAvg, new double[]{rll, rlr, rur, rul});
            switch (msCase) {
                case 3: 
                case 6: 
                case 9: 
                case 12: {
                    double[] lowPts = this.getTrianglePoints(x1, y1, x2, y2, rll, rlr, rur, rul, sortedResp[1]);
                    double[] highPts = this.getTrianglePoints(x1, y1, x2, y2, rll, rlr, rur, rul, sortedResp[2]);
                    if (lowPts != null && lowPts.length == 9) {
                        value = this.interpolateTriangle(x, y, lowPts[0], lowPts[1], lowPts[2], lowPts[3], lowPts[4], lowPts[5], lowPts[6], lowPts[7], lowPts[8]);
                    }
                    if (Double.isNaN(value) && highPts != null && highPts.length == 9) {
                        value = this.interpolateTriangle(x, y, highPts[0], highPts[1], highPts[2], highPts[3], highPts[4], highPts[5], highPts[6], highPts[7], highPts[8]);
                    }
                    if (!Double.isNaN(value) || lowPts == null || lowPts.length != 9 || highPts == null || highPts.length != 9) break;
                    value = this.interpolateQuad(x, y, lowPts[3], lowPts[4], lowPts[6], lowPts[7], lowPts[8], highPts[3], highPts[4], highPts[6], highPts[7], highPts[8]);
                    break;
                }
                case 5: 
                case 7: 
                case 10: 
                case 11: 
                case 13: 
                case 14: {
                    double intersectLower = Contours.INTERP(sortedResp[1], rll, x1, rlr, x2);
                    double intersectRight = Contours.INTERP(sortedResp[1], rlr, y1, rur, y2);
                    double intersectUpper = Contours.INTERP(sortedResp[1], rur, x2, rul, x1);
                    double intersectLeft = Contours.INTERP(sortedResp[1], rul, y2, rll, y1);
                    double interpValue = Double.NaN;
                    interpValue = this.interpolateTriangle(x, y, x1, y1, rll, x1, intersectLeft, sortedResp[1], intersectLower, y1, sortedResp[1]);
                    if (!Double.isNaN(interpValue)) {
                        value = interpValue;
                        break;
                    }
                    interpValue = this.interpolateTriangle(x, y, x2, y1, rlr, intersectLower, y1, sortedResp[1], x2, intersectRight, sortedResp[1]);
                    if (!Double.isNaN(interpValue)) {
                        value = interpValue;
                        break;
                    }
                    interpValue = this.interpolateTriangle(x, y, x2, y2, rur, x2, intersectRight, sortedResp[1], intersectUpper, y2, sortedResp[1]);
                    if (!Double.isNaN(interpValue)) {
                        value = interpValue;
                        break;
                    }
                    interpValue = this.interpolateTriangle(x, y, x1, y2, rul, x1, intersectLeft, sortedResp[1], intersectUpper, y2, sortedResp[1]);
                    if (!Double.isNaN(interpValue)) {
                        value = interpValue;
                        break;
                    }
                    value = sortedResp[1];
                    break;
                }
                default: {
                    value = Double.NaN;
                }
            }
        }
        return value;
    }

    private void sortArray(double[] in) {
        for (int i = 0; i < in.length - 1; ++i) {
            for (int j = 0; j < in.length - 1 - i; ++j) {
                if (!(in[j + 1] < in[j])) continue;
                double temp = in[j];
                in[j] = in[j + 1];
                in[j + 1] = temp;
            }
        }
    }

    private double[] getTrianglePoints(double x1, double y1, double x2, double y2, double rll, double rlr, double rur, double rul, double ctrValue) {
        double[] corners = new double[]{rll, rlr, rur, rul};
        int msCase = Contours.findcase(ctrValue, corners);
        double[] pts = new double[9];
        switch (msCase) {
            case 3: {
                if (ctrValue == rll) {
                    pts[0] = x2;
                    pts[1] = y1;
                    pts[2] = rlr;
                    pts[3] = x1;
                    pts[4] = y1;
                    pts[5] = rll;
                    pts[6] = x2;
                    pts[7] = Contours.INTERP(ctrValue, rlr, y1, rur, y2);
                    pts[8] = ctrValue;
                    break;
                }
                if (ctrValue == rlr) {
                    pts[0] = x1;
                    pts[1] = y1;
                    pts[2] = rll;
                    pts[3] = x1;
                    pts[4] = Contours.INTERP(ctrValue, rll, y1, rul, y2);
                    pts[5] = ctrValue;
                    pts[6] = x2;
                    pts[7] = y1;
                    pts[8] = rlr;
                    break;
                }
                pts = null;
                break;
            }
            case 6: {
                if (ctrValue == rlr) {
                    pts[0] = x2;
                    pts[1] = y2;
                    pts[2] = rur;
                    pts[3] = x2;
                    pts[4] = y1;
                    pts[5] = rlr;
                    pts[6] = Contours.INTERP(ctrValue, rul, x1, rur, x2);
                    pts[7] = y2;
                    pts[8] = ctrValue;
                    break;
                }
                if (ctrValue == rur) {
                    pts[0] = x2;
                    pts[1] = y1;
                    pts[2] = rlr;
                    pts[3] = Contours.INTERP(ctrValue, rll, x1, rlr, x2);
                    pts[4] = y1;
                    pts[5] = ctrValue;
                    pts[6] = x2;
                    pts[7] = y2;
                    pts[8] = rur;
                    break;
                }
                pts = null;
                break;
            }
            case 7: {
                pts[0] = x1;
                pts[1] = y2;
                pts[2] = rul;
                if (ctrValue == rll) {
                    pts[3] = x1;
                    pts[4] = y1;
                    pts[5] = ctrValue;
                    pts[6] = Contours.INTERP(ctrValue, rul, x1, rur, x2);
                    pts[7] = y2;
                    pts[8] = ctrValue;
                    break;
                }
                if (ctrValue == rur) {
                    pts[3] = x1;
                    pts[4] = Contours.INTERP(ctrValue, rll, y1, rul, y2);
                    pts[5] = ctrValue;
                    pts[6] = x2;
                    pts[7] = y2;
                    pts[8] = ctrValue;
                    break;
                }
                pts = null;
                break;
            }
            case 9: {
                if (ctrValue == rll) {
                    pts[0] = x1;
                    pts[1] = y2;
                    pts[2] = rul;
                    pts[3] = x1;
                    pts[4] = y1;
                    pts[5] = rll;
                    pts[6] = Contours.INTERP(ctrValue, rul, x1, rur, x2);
                    pts[7] = y2;
                    pts[8] = ctrValue;
                    break;
                }
                if (ctrValue == rul) {
                    pts[0] = x1;
                    pts[1] = y1;
                    pts[2] = rll;
                    pts[3] = Contours.INTERP(ctrValue, rll, x1, rlr, x2);
                    pts[4] = y1;
                    pts[5] = ctrValue;
                    pts[6] = x1;
                    pts[7] = y2;
                    pts[8] = rul;
                    break;
                }
                pts = null;
                break;
            }
            case 11: {
                pts[0] = x2;
                pts[1] = y2;
                pts[2] = rur;
                if (ctrValue == rlr) {
                    pts[3] = x2;
                    pts[4] = y1;
                    pts[5] = ctrValue;
                    pts[6] = Contours.INTERP(ctrValue, rul, x1, rur, x2);
                    pts[7] = y2;
                    pts[8] = ctrValue;
                    break;
                }
                if (ctrValue == rul) {
                    pts[3] = x1;
                    pts[4] = y2;
                    pts[5] = ctrValue;
                    pts[6] = x2;
                    pts[7] = Contours.INTERP(ctrValue, rlr, y1, rur, y2);
                    pts[8] = ctrValue;
                    break;
                }
                pts = null;
                break;
            }
            case 12: {
                if (ctrValue == rul) {
                    pts[0] = x2;
                    pts[1] = y2;
                    pts[2] = rur;
                    pts[3] = x1;
                    pts[4] = y2;
                    pts[5] = rul;
                    pts[6] = x2;
                    pts[7] = Contours.INTERP(ctrValue, rlr, y1, rur, y2);
                    pts[8] = ctrValue;
                    break;
                }
                if (ctrValue == rur) {
                    pts[0] = x1;
                    pts[1] = y2;
                    pts[2] = rul;
                    pts[3] = x1;
                    pts[4] = Contours.INTERP(ctrValue, rll, y1, rul, y2);
                    pts[5] = ctrValue;
                    pts[6] = x2;
                    pts[7] = y2;
                    pts[8] = rur;
                    break;
                }
                pts = null;
                break;
            }
            case 13: {
                pts[0] = x2;
                pts[1] = y1;
                pts[2] = rlr;
                if (ctrValue == rur) {
                    pts[3] = Contours.INTERP(ctrValue, rll, x1, rlr, x2);
                    pts[4] = y1;
                    pts[5] = ctrValue;
                    pts[6] = x2;
                    pts[7] = y2;
                    pts[8] = ctrValue;
                    break;
                }
                if (ctrValue == rll) {
                    pts[3] = x1;
                    pts[4] = y1;
                    pts[5] = ctrValue;
                    pts[6] = x2;
                    pts[7] = Contours.INTERP(ctrValue, rlr, y1, rur, y2);
                    pts[8] = ctrValue;
                    break;
                }
                pts = null;
                break;
            }
            case 14: {
                pts[0] = x1;
                pts[1] = y1;
                pts[2] = rll;
                if (ctrValue == rul) {
                    pts[3] = Contours.INTERP(ctrValue, rll, x1, rlr, x2);
                    pts[4] = y1;
                    pts[5] = ctrValue;
                    pts[6] = x1;
                    pts[7] = y2;
                    pts[8] = ctrValue;
                    break;
                }
                if (ctrValue == rlr) {
                    pts[3] = x1;
                    pts[4] = Contours.INTERP(ctrValue, rll, y1, rul, y2);
                    pts[5] = ctrValue;
                    pts[6] = x2;
                    pts[7] = y1;
                    pts[8] = ctrValue;
                    break;
                }
                pts = null;
                break;
            }
            case 15: {
                pts[0] = 0.0;
                pts[1] = 0.0;
                pts[2] = 0.0;
                pts[5] = ctrValue;
                pts[8] = ctrValue;
                if (ctrValue == rll) {
                    pts[3] = x1;
                    pts[4] = y1;
                    if (ctrValue == rul) {
                        pts[6] = x1;
                        pts[7] = y2;
                        break;
                    }
                    if (ctrValue == rlr) {
                        pts[6] = x2;
                        pts[7] = y1;
                        break;
                    }
                    pts = null;
                    break;
                }
                if (ctrValue == rur) {
                    pts[6] = x2;
                    pts[7] = y2;
                    if (ctrValue == rul) {
                        pts[3] = x1;
                        pts[4] = y2;
                        break;
                    }
                    if (ctrValue == rlr) {
                        pts[3] = x2;
                        pts[4] = y1;
                        break;
                    }
                    pts = null;
                    break;
                }
                pts = null;
                break;
            }
            default: {
                pts = null;
            }
        }
        return pts;
    }

    private double interpolateQuad(double x, double y, double lowX1, double lowY1, double lowX2, double lowY2, double lowResp, double highX1, double highY1, double highX2, double highY2, double highResp) {
        double lowDX = lowX2 - lowX1;
        double lowDY = lowY2 - lowY1;
        double highDX = highX2 - highX1;
        double highDY = highY2 - highY1;
        double value = Double.NaN;
        if (lowX1 == highX1) {
            double lowY = lowY1 + (x - lowX1) * (lowDY / lowDX);
            double highY = highY1 + (x - highX1) * (highDY / highDX);
            value = Contours.INTERP(y, lowY, lowResp, highY, highResp);
        } else if (lowY1 == highY1) {
            double lowX = lowX1 + (y - lowY1) * (lowDX / lowDY);
            double highX = highX1 + (y - highY1) * (highDX / highDY);
            value = Contours.INTERP(x, lowX, lowResp, highX, highResp);
        }
        return value;
    }

    private double interpolateTriangle(double x, double y, double x1, double y1, double resp1, double x2, double y2, double resp2, double x3, double y3, double resp3) {
        double t;
        double u;
        double dx2 = x2 - x1;
        double dx3 = x3 - x1;
        double dy2 = y2 - y1;
        double dy3 = y3 - y1;
        if (dx2 == 0.0) {
            if (dx3 == 0.0 || dy2 == 0.0) {
                return Double.NaN;
            }
            u = (x - x1) / dx3;
            t = (y - y1 - u * dy3) / dy2;
        } else if (dx3 == 0.0) {
            if (dx2 == 0.0 || dy3 == 0.0) {
                return Double.NaN;
            }
            t = (x - x1) / dx2;
            u = (y - y1 - t * dy2) / dy3;
        } else if (dy2 == 0.0) {
            if (dy3 == 0.0) {
                return Double.NaN;
            }
            u = (y - y1) / dy3;
            t = (x - x1 - u * dx3) / dx2;
        } else if (dy3 == 0.0) {
            t = (y - y1) / dy2;
            u = (x - x1 - t * dx2) / dx3;
        } else {
            return Double.NaN;
        }
        if (t < 0.0 || u < 0.0 || t + u > 1.0) {
            return Double.NaN;
        }
        double resp = resp1 + t * (resp2 - resp1) + u * (resp3 - resp1);
        return resp;
    }

    public void UseHighLightColor(boolean useit) {
        this.useHighlightColor = useit;
    }

    public boolean GetOutlinesOn() {
        return this.outlinesOn;
    }

    public void SetOutlinesOn(boolean on) {
        this.outlinesOn = on;
    }

    public Color GetOutlineColor() {
        if (this.outlineColor == null) {
            return null;
        }
        return new Color((float)this.outlineColor[0], (float)this.outlineColor[1], (float)this.outlineColor[2]);
    }

    public boolean SetOutlineColor(Color newColor) {
        Color c = SystemColor.windowText;
        if (this.outlineColor == null) {
            return false;
        }
        if (newColor != null) {
            c = newColor;
        }
        this.outlineColor[0] = (double)c.getRed() / 255.0;
        this.outlineColor[1] = (double)c.getGreen() / 255.0;
        this.outlineColor[2] = (double)c.getBlue() / 255.0;
        return true;
    }

    @Override
    public Object GetDataSourceObject() {
        return this.data;
    }

    @Override
    public boolean SetDataSourceObject(Object dataIn) {
        if (dataIn == null) {
            this.data = null;
            return true;
        }
        if (!(dataIn instanceof GriddedChartData)) {
            return false;
        }
        this.data = dataIn;
        this.AutoSetDataValues();
        return true;
    }

    @Override
    public boolean RequiresGriddedData() {
        return true;
    }

    @Override
    public double[][] GetBoundingBox() {
        double[] x = null;
        double[] y = null;
        double[][] ret = null;
        GriddedChartData gcd = (GriddedChartData)this.data;
        if (gcd != null && (x = gcd.GetXData()) != null && (y = gcd.GetYData()) != null && (ret = new double[2][3]) != null) {
            ret[0][0] = x[this.xLowLimit];
            ret[0][1] = y[this.yLowLimit];
            ret[0][2] = this.base;
            ret[1][0] = x[this.xHighLimit];
            ret[1][1] = y[this.yHighLimit];
            ret[1][2] = this.base + this.maxStack;
        }
        return ret;
    }

    @Override
    public void SetHighlightOn(boolean highlight) {
        super.SetHighlightOn(highlight);
    }

    @Override
    public String GetHighlightStyle() {
        String s = null;
        switch (this.highlightStyle) {
            case 0: {
                s = "Contour Line";
                break;
            }
            case 1: {
                s = "Contour Line w/Label";
                break;
            }
            case 2: {
                s = "Label";
            }
        }
        return s;
    }

    @Override
    public boolean SetHighlightStyle(String newstyle) {
        if (newstyle == null) {
            return false;
        }
        if (newstyle.equalsIgnoreCase("Contour Line")) {
            this.highlightStyle = 0;
        } else if (newstyle.equalsIgnoreCase("Contour Line w/Label")) {
            this.highlightStyle = 1;
        } else if (newstyle.equalsIgnoreCase("Label")) {
            this.highlightStyle = 2;
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Object GetHighlightValues() {
        return new Double(this.highlightValue);
    }

    @Override
    public boolean SetHighlightValues(Object highlights) {
        return false;
    }

    @Override
    public Object GetHighLightLocation(boolean inMouseCoordinates) {
        return null;
    }

    public boolean SetHighlightLocation(int x, int y) {
        return false;
    }

    @Override
    public boolean SetHighlightLocation(Object loc1, Object loc2) {
        double[] p0 = null;
        double[] p1 = null;
        double[] intersection = null;
        if (loc1 == null || !(loc1 instanceof double[])) {
            return false;
        }
        p0 = (double[])loc1;
        if (loc2 == null) {
            return this.SetHighLightLocation(p0[0], p0[1], p0[2]);
        }
        if (!(loc2 instanceof double[])) {
            return false;
        }
        p1 = (double[])loc2;
        intersection = this.FindLocation(p0, p1);
        if (intersection == null) {
            return false;
        }
        return this.SetHighLightLocation(intersection[0], intersection[1], intersection[2]);
    }

    @Override
    public boolean UpdateHighlight() {
        if (!this.highlightOn) {
            return false;
        }
        this.highlightBuild = true;
        this.Build(null);
        this.highlightBuild = false;
        return true;
    }

    @Override
    public Color GetHighlightColor() {
        return this.highlightColor;
    }

    @Override
    public boolean SetHighlightColor(Color newColor) {
        this.highlightColor = newColor;
        return true;
    }

    @Override
    public String GetHighlightValueString() {
        return this.highlightString;
    }
}

