/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.ods.visual;

import com.sas.graphics.util.ods.visual.ColorBreakPoint;
import com.sas.graphics.util.ods.visual.IVIZColor;
import java.awt.Color;
import java.util.Vector;

public class ColorRamp
implements IVIZColor {
    protected Color missingColor;
    protected Color underflowColor;
    protected Color overflowColor;
    protected Vector colorList = new Vector();
    private static Color[] defaultColors = new Color[]{new Color(1.0f, 0.0f, 1.0f), new Color(0.78f, 0.39f, 0.39f), new Color(0.0f, 0.0f, 1.0f), new Color(0.0f, 1.0f, 0.0f), new Color(1.0f, 1.0f, 0.0f), new Color(1.0f, 0.39f, 0.0f), new Color(1.0f, 0.0f, 0.0f)};

    public ColorRamp(Object colors, double[] breaks) {
        this.missingColor = Color.black;
        this.underflowColor = Color.white;
        this.overflowColor = Color.cyan;
        this.SetColors(colors, breaks);
    }

    public ColorRamp() {
        this(defaultColors, null);
    }

    private static int Compare(ColorBreakPoint bp1, ColorBreakPoint bp2) {
        if (bp1 == null) {
            if (bp2 == null) {
                return 0;
            }
            return -1;
        }
        if (bp2 == null) {
            return 1;
        }
        if (Double.isNaN(bp1.value)) {
            if (Double.isNaN(bp2.value)) {
                return 0;
            }
            return -1;
        }
        if (Double.isNaN(bp2.value)) {
            return 1;
        }
        if (bp1.value < bp2.value) {
            return -1;
        }
        if (bp1.value > bp2.value) {
            return 1;
        }
        return 0;
    }

    private int find(double val) {
        int len = this.GetNumberColors();
        ColorBreakPoint temp = new ColorBreakPoint(val, null);
        int ret = -1;
        int lo = 0;
        int mi = 0;
        int hi = len - 1;
        while (lo <= hi) {
            mi = (lo + hi) / 2;
            ret = ColorRamp.Compare(temp, (ColorBreakPoint)this.colorList.elementAt(mi));
            switch (ret) {
                case -1: {
                    hi = mi - 1;
                    break;
                }
                case 0: {
                    return mi;
                }
                case 1: {
                    lo = mi + 1;
                }
            }
        }
        if (ret != 1) {
            ret = 0;
        }
        return -(mi + 1 + ret);
    }

    private int find(double val, boolean discrete) {
        int idx = this.find(val);
        int numColors = this.GetNumberColors();
        ColorBreakPoint bp1 = null;
        ColorBreakPoint bp2 = null;
        if (!discrete || idx >= 0 || idx == -1 || idx == -1 - numColors) {
            return idx;
        }
        bp1 = (ColorBreakPoint)this.colorList.elementAt(-idx - 2);
        bp2 = (ColorBreakPoint)this.colorList.elementAt(-idx - 1);
        if (bp1 == null || bp2 == null) {
            return idx;
        }
        idx = val < (bp1.value + bp2.value) / 2.0 ? -idx - 2 : -idx - 1;
        return idx;
    }

    private static float ClampColor(int component) {
        float cval = (float)component / 255.0f;
        if (cval < 0.0f) {
            cval = 0.0f;
        } else if (cval > 1.0f) {
            cval = 1.0f;
        }
        return cval;
    }

    @Override
    public int SetColors(Object colors, Object breaks) {
        int i;
        boolean noZero = true;
        boolean noOne = true;
        int ndone = 0;
        int count = 0;
        double lastValue = Double.NaN;
        double[] breakValues = null;
        Object obj = null;
        ColorBreakPoint cbp = null;
        if (this.colorList == null || colors == null) {
            return ndone;
        }
        if (colors instanceof Color[]) {
            count = ((Color[])colors).length;
        } else if (colors instanceof Vector) {
            count = ((Vector)colors).size();
        } else {
            return ndone;
        }
        if (breaks != null) {
            int itemp;
            if (breaks instanceof double[]) {
                breakValues = (double[])breaks;
            } else if ((breaks instanceof Vector || breaks instanceof Double[]) && (breakValues = new double[itemp = breaks instanceof Vector ? ((Vector)breaks).size() : ((Double[])breaks).length]) != null) {
                for (i = 0; i < breakValues.length; ++i) {
                    Object e = ((Vector)breaks).elementAt(i);
                    obj = e;
                    if (e == null) {
                        breakValues = null;
                        break;
                    }
                    if (!(obj instanceof Double)) {
                        breakValues = null;
                        break;
                    }
                    breakValues[i] = obj;
                }
            }
        } else {
            breakValues = null;
        }
        if (breakValues != null && breakValues.length < count) {
            count = breakValues.length;
        }
        this.colorList.removeAllElements();
        for (i = 0; i < count; ++i) {
            double v;
            Color c;
            if (colors instanceof Color[]) {
                c = ((Color[])colors)[i];
            } else {
                if (!(colors instanceof Vector)) continue;
                c = (Color)((Vector)colors).elementAt(i);
            }
            if (c == null || Double.isNaN(v = breakValues != null ? breakValues[i] : (double)i / (double)(count - 1)) || v < 0.0 || v > 1.0) continue;
            if (Double.isNaN(lastValue)) {
                lastValue = v;
            } else if (v <= lastValue) break;
            if (v == 0.0) {
                noZero = false;
            }
            if (v == 1.0) {
                noOne = false;
            }
            if ((cbp = new ColorBreakPoint(v, c)) == null) continue;
            this.colorList.addElement(cbp);
            ++ndone;
        }
        count = this.GetNumberColors();
        if (noZero && count > 0 && (cbp = (ColorBreakPoint)this.colorList.elementAt(0)) != null) {
            cbp.value = 0.0;
        }
        if (noOne && count > 1 && (cbp = (ColorBreakPoint)this.colorList.elementAt(count - 1)) != null) {
            cbp.value = 1.0;
        }
        return ndone;
    }

    @Override
    public Color Query(int index, boolean wrap) {
        int idx = index;
        int numColors = this.GetNumberColors();
        ColorBreakPoint cbp = null;
        if (wrap) {
            idx = index % numColors;
        }
        if (idx < 0 || idx >= numColors) {
            return null;
        }
        cbp = (ColorBreakPoint)this.colorList.elementAt(idx);
        if (cbp == null) {
            return null;
        }
        return cbp.color;
    }

    @Override
    public Color Query(double breakValue, boolean discrete) {
        int numColors = this.GetNumberColors();
        Color c = null;
        Object c1 = null;
        Object c2 = null;
        ColorBreakPoint bp1 = null;
        ColorBreakPoint bp2 = null;
        if (numColors <= 0) {
            c = this.overflowColor;
        } else if (Double.isNaN(breakValue)) {
            c = this.missingColor;
        } else if (Double.isInfinite(breakValue)) {
            c = breakValue == Double.NEGATIVE_INFINITY ? this.underflowColor : this.overflowColor;
        } else {
            int idx = this.find(breakValue, discrete);
            if (idx >= 0) {
                bp1 = (ColorBreakPoint)this.colorList.elementAt(idx);
                c = bp1 == null ? null : bp1.color;
            } else if (idx == -1) {
                c = this.underflowColor;
            } else if (idx == -1 - numColors) {
                c = this.overflowColor;
            } else {
                bp1 = (ColorBreakPoint)this.colorList.elementAt(-idx - 2);
                bp2 = (ColorBreakPoint)this.colorList.elementAt(-idx - 1);
                float r1 = ColorRamp.ClampColor(bp1.color.getRed());
                float g1 = ColorRamp.ClampColor(bp1.color.getGreen());
                float b1 = ColorRamp.ClampColor(bp1.color.getBlue());
                float r2 = ColorRamp.ClampColor(bp2.color.getRed());
                float g2 = ColorRamp.ClampColor(bp2.color.getGreen());
                float b2 = ColorRamp.ClampColor(bp2.color.getBlue());
                double fraction = (breakValue - bp1.value) / (bp2.value - bp1.value);
                float r = (float)((double)(r2 - r1) * fraction + (double)r1);
                float g = (float)((double)(g2 - g1) * fraction + (double)g1);
                float b = (float)((double)(b2 - b1) * fraction + (double)b1);
                c = new Color(r, g, b);
            }
        }
        return c;
    }

    @Override
    public Color Query(double response, double low, double high, boolean discrete) {
        if (Double.isNaN(response) || Double.isNaN(low) || Double.isNaN(high) || high <= low) {
            return this.Query(Double.NaN, discrete);
        }
        return this.Query((response - low) / (high - low), discrete);
    }

    @Override
    public int GetNumberColors() {
        if (this.colorList == null || this.colorList.size() <= 0) {
            return 0;
        }
        return this.colorList.size();
    }

    @Override
    public Color[] GetColorsAsArray(boolean includeMissing, boolean includeUnderflow, boolean includeOverflow) {
        int totalCount = this.GetNumberColors();
        Object[] array = null;
        int allocCount = totalCount;
        if (includeMissing) {
            ++allocCount;
        }
        if (includeUnderflow) {
            ++allocCount;
        }
        if (includeOverflow) {
            ++allocCount;
        }
        if (allocCount == 0) {
            return null;
        }
        array = new Color[allocCount];
        if (array == null) {
            return null;
        }
        this.colorList.copyInto(array);
        if (includeMissing) {
            array[totalCount++] = this.missingColor == null ? null : this.missingColor;
        }
        if (includeUnderflow) {
            array[totalCount++] = this.underflowColor == null ? null : this.underflowColor;
        }
        if (includeOverflow) {
            array[totalCount++] = this.overflowColor == null ? null : this.overflowColor;
        }
        return array;
    }

    @Override
    public Color[] GetColorsAsArray() {
        return this.GetColorsAsArray(false, false, false);
    }

    @Override
    public boolean SetBreakPoint(double value, Color c) {
        int numColors = this.GetNumberColors();
        ColorBreakPoint cbp = null;
        if (c == null) {
            return false;
        }
        if (Double.isNaN(value)) {
            this.missingColor = new Color(c.getRed(), c.getGreen(), c.getBlue());
        } else if (Double.isInfinite(value)) {
            if (value == Double.NEGATIVE_INFINITY) {
                this.underflowColor = new Color(c.getRed(), c.getGreen(), c.getBlue());
            } else {
                this.overflowColor = new Color(c.getRed(), c.getGreen(), c.getBlue());
            }
        } else if (value < 0.0) {
            this.underflowColor = new Color(c.getRed(), c.getGreen(), c.getBlue());
        } else if (value > 1.0) {
            this.overflowColor = new Color(c.getRed(), c.getGreen(), c.getBlue());
        } else {
            if (this.colorList == null) {
                return false;
            }
            switch (numColors) {
                case 0: {
                    cbp = new ColorBreakPoint(0.0, c);
                    if (cbp == null) {
                        return false;
                    }
                    this.colorList.addElement(cbp);
                    break;
                }
                case 1: {
                    if (value == 0.0) {
                        cbp = new ColorBreakPoint(0.0, c);
                        if (cbp == null) {
                            return false;
                        }
                        this.colorList.setElementAt(cbp, 0);
                        break;
                    }
                    cbp = new ColorBreakPoint(1.0, c);
                    if (cbp == null) {
                        return false;
                    }
                    this.colorList.addElement(cbp);
                    break;
                }
                default: {
                    int idx = this.find(value);
                    if (idx == -1 || idx == -1 - numColors) {
                        return false;
                    }
                    cbp = new ColorBreakPoint(value, c);
                    if (cbp == null) {
                        return false;
                    }
                    if (idx >= 0) {
                        this.colorList.setElementAt(cbp, idx);
                        break;
                    }
                    idx = -idx - 1;
                    this.colorList.insertElementAt(cbp, idx);
                }
            }
        }
        return true;
    }

    @Override
    public boolean RemoveBreakPoint(int idx) {
        int numColors = this.GetNumberColors();
        if (this.colorList == null || idx < 0 || idx >= numColors) {
            return false;
        }
        switch (idx) {
            case 0: {
                if (numColors > 1) {
                    return false;
                }
                this.colorList.removeAllElements();
                break;
            }
            default: {
                if (idx == numColors - 1 && numColors < 2) {
                    return false;
                }
                this.colorList.removeElementAt(idx);
            }
        }
        return true;
    }

    @Override
    public boolean RemoveBreakPoint(double value, boolean nearest) {
        if (Double.isNaN(value) || Double.isInfinite(value) || value < 0.0 || value > 1.0 || this.colorList == null) {
            return false;
        }
        return this.RemoveBreakPoint(this.find(value, nearest));
    }
}

