/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.ods.data;

import com.sas.MissingValues;
import com.sas.graphics.util.Barnes74;
import com.sas.graphics.util.ods.data.BaseData;
import com.sas.graphics.util.ods.data.DataVariableInterface;
import java.util.Vector;

public class GriddedChartData {
    public static final int X_BINS = 0;
    public static final int Y_BINS = 1;
    public static final int DUPLICATE_COUNT = 0;
    public static final int DUPLICATE_FIRST = 1;
    public static final int DUPLICATE_LAST = 2;
    public static final int DUPLICATE_MAX = 3;
    public static final int DUPLICATE_MEAN = 4;
    public static final int DUPLICATE_MIN = 5;
    public static final int DUPLICATE_NMISS = 6;
    public static final int DUPLICATE_RANGE = 7;
    public static final int DUPLICATE_SUM = 8;
    public static final int INTERPOLATION_SCHEME_SMART = 0;
    public static final int INTERPOLATION_SCHEME_ALWAYS = 1;
    public static final int INTERPOLATION_SCHEME_NEVER = 2;
    protected int resolveDups = 4;
    protected int interpScheme = 2;
    protected int xStride = 0;
    protected int yStride = 0;
    protected int interpXCount = -20;
    protected int interpYCount = -20;
    protected double respMin;
    protected double respMax;
    protected double interpRatio = 2.0;
    protected double[] x = null;
    protected double[] y = null;
    protected double[] resp = null;
    protected Object xbins = null;
    protected Object ybins = null;
    protected DataVariableInterface xvar = null;
    protected DataVariableInterface yvar = null;
    protected DataVariableInterface respvar = null;
    protected BaseData data = null;
    private int xMaxUniqueValueCount = Integer.MAX_VALUE;
    private int yMaxUniqueValueCount = Integer.MAX_VALUE;

    public GriddedChartData() {
        this.respMin = Double.NaN;
        this.respMax = Double.NaN;
    }

    protected void FillArray(double[] array, double fillvalue) {
        if (array == null) {
            return;
        }
        int len = array.length;
        for (int idx = 0; idx < len; ++idx) {
            array[idx] = fillvalue;
        }
    }

    protected int Find(double val, double[] vec, double[] bins) {
        if (bins == null) {
            return this.Find(val, vec);
        }
        int len = bins.length;
        int idx = this.Find(val, bins);
        switch (idx) {
            case -1: 
            case 0: {
                break;
            }
            default: {
                if (idx == -1 - len) break;
                if (idx > 0) {
                    --idx;
                    break;
                }
                idx = -idx - 2;
            }
        }
        return idx;
    }

    protected int Find(double val, double[] vec) {
        int len = vec.length;
        int ret = -1;
        int lo = 0;
        int mi = 0;
        int hi = len - 1;
        while (lo <= hi) {
            mi = (lo + hi) / 2;
            ret = val < vec[mi] ? -1 : (val > vec[mi] ? 1 : 0);
            switch (ret) {
                case -1: {
                    hi = mi - 1;
                    break;
                }
                case 0: {
                    return mi;
                }
                case 1: {
                    lo = mi + 1;
                }
            }
        }
        if (ret != 1) {
            ret = 0;
        }
        return -(mi + 1 + ret);
    }

    protected int Find(double val, Vector vec) {
        int len = vec.size();
        Double vecEntry = null;
        int ret = -1;
        int lo = 0;
        int mi = 0;
        int hi = len - 1;
        while (lo <= hi) {
            mi = (lo + hi) / 2;
            vecEntry = (Double)vec.elementAt(mi);
            ret = val < vecEntry ? -1 : (val > vecEntry ? 1 : 0);
            switch (ret) {
                case -1: {
                    hi = mi - 1;
                    break;
                }
                case 0: {
                    return mi;
                }
                case 1: {
                    lo = mi + 1;
                }
            }
        }
        if (ret != 1) {
            ret = 0;
        }
        return -(mi + 1 + ret);
    }

    protected int Add(Vector vec, Double value) {
        int idx = this.Find((double)value, vec);
        if (idx >= 0) {
            return idx;
        }
        if (idx == -1 - vec.size()) {
            vec.addElement(value);
            idx = vec.size() - 1;
        } else {
            idx = -idx - 1;
            vec.insertElementAt(value, idx);
        }
        return idx;
    }

    protected boolean VerifyBins(Object bins) {
        if (bins == null) {
            return false;
        }
        if (bins instanceof Integer) {
            return (Integer)bins > 2;
        }
        if (!(bins instanceof double[])) {
            return false;
        }
        for (int i = 1; i < ((double[])bins).length; ++i) {
            if (!(((double[])bins)[i] <= ((double[])bins)[i - 1])) continue;
            return false;
        }
        return true;
    }

    protected double[] GetBins(Object binsIn, DataVariableInterface v) {
        Object min = null;
        Object max = null;
        double[] bins = null;
        if (binsIn == null) {
            return null;
        }
        if (binsIn instanceof double[]) {
            return (double[])binsIn;
        }
        if (v == null) {
            return null;
        }
        if (binsIn instanceof Integer) {
            int nbins = (Integer)binsIn;
            if (nbins <= 2) {
                return null;
            }
            bins = new double[nbins + 1];
            if (bins == null) {
                return null;
            }
            min = v.GetMinimumValue();
            if (min == null || !(min instanceof Double) || ((Double)min).isNaN()) {
                return null;
            }
            max = v.GetMaximumValue();
            if (max == null || !(max instanceof Double) || ((Double)max).isNaN()) {
                return null;
            }
            bins[0] = (Double)min;
            bins[nbins] = (Double)max;
            for (int i = 1; i < nbins; ++i) {
                bins[i] = (bins[nbins] - bins[0]) / (double)nbins * (double)i + bins[0];
            }
        }
        return bins;
    }

    public boolean SetBins(int which, Object bins) {
        if (bins != null && !this.VerifyBins(bins)) {
            return false;
        }
        switch (which) {
            case 0: {
                this.xbins = bins;
                break;
            }
            case 1: {
                this.ybins = bins;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public int getInterpolationScheme() {
        return this.interpScheme;
    }

    public boolean setInterpolationScheme(int scheme) {
        switch (scheme) {
            case 0: 
            case 1: 
            case 2: {
                this.interpScheme = scheme;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public double getInterpolationRatio() {
        return this.interpRatio;
    }

    public boolean setInterpolationRatio(double ratio) {
        if (Double.isInfinite(ratio) || Double.isNaN(ratio) || ratio <= 0.0) {
            return false;
        }
        this.interpRatio = ratio;
        return true;
    }

    public int[] getInterpolationCounts() {
        int[] out = new int[2];
        if (out == null) {
            return null;
        }
        out[0] = this.interpXCount;
        out[1] = this.interpYCount;
        return out;
    }

    public void setInterpolationCounts(int xc, int yc) {
        if (xc != 0) {
            this.interpXCount = xc < 0 ? Math.min(xc, -2) : Math.max(xc, 2);
        }
        if (yc != 0) {
            this.interpYCount = yc < 0 ? Math.min(yc, -2) : Math.max(yc, 2);
        }
    }

    public boolean IsXCategorized() {
        return this.xbins != null;
    }

    public boolean IsYCategorized() {
        return this.ybins != null;
    }

    public Object GetDataSource() {
        return this.data;
    }

    public boolean SetDataSource(Object dataIn) {
        if (!(dataIn instanceof BaseData)) {
            return false;
        }
        this.data = (BaseData)dataIn;
        return true;
    }

    public boolean BuildGriddedData(Object xVarIn, Object yVarIn, Object respVarIn) {
        return this.BuildGriddedData(xVarIn, yVarIn, respVarIn, this.xbins, this.ybins);
    }

    public boolean BuildGriddedData(Object xVarIn, Object yVarIn, Object respVarIn, Object xbinsIn, Object ybinsIn) {
        int iy;
        int ix;
        double d;
        double r;
        int i;
        boolean interpolate = false;
        int nx = 0;
        int ny = 0;
        int numObs = 0;
        int nUsed = 0;
        int localInterpScheme = this.interpScheme;
        int localResolve = this.resolveDups;
        double xmin = Double.NaN;
        double xmax = Double.NaN;
        double ymin = Double.NaN;
        double ymax = Double.NaN;
        Object xvalue = null;
        Object yvalue = null;
        Object respValue = null;
        Double dvalue = null;
        DataVariableInterface xv = null;
        DataVariableInterface yv = null;
        DataVariableInterface respv = null;
        Vector uniqueXValues = new Vector();
        Vector uniqueYValues = new Vector();
        double[] temp = null;
        double[] xbins = null;
        double[] ybins = null;
        double[] dataX = null;
        double[] dataY = null;
        double[] dataResp = null;
        double missingMin = Double.NaN;
        double missingMax = Double.NaN;
        if (this.data == null || uniqueXValues == null || uniqueYValues == null || xVarIn == null || yVarIn == null || respVarIn == null) {
            return false;
        }
        if (xbinsIn != null && !this.VerifyBins(xbinsIn) || ybinsIn != null && !this.VerifyBins(ybinsIn)) {
            return false;
        }
        if (xVarIn instanceof DataVariableInterface) {
            xv = (DataVariableInterface)xVarIn;
        } else if (xVarIn instanceof Integer) {
            xv = this.data.GetColumn((Integer)xVarIn);
        } else if (xVarIn instanceof String) {
            xv = this.data.GetColumn((String)xVarIn);
        } else {
            return false;
        }
        if (yVarIn instanceof DataVariableInterface) {
            yv = (DataVariableInterface)yVarIn;
        } else if (yVarIn instanceof Integer) {
            yv = this.data.GetColumn((Integer)yVarIn);
        } else if (yVarIn instanceof String) {
            yv = this.data.GetColumn((String)yVarIn);
        } else {
            return false;
        }
        if (respVarIn instanceof DataVariableInterface) {
            respv = (DataVariableInterface)respVarIn;
        } else if (respVarIn instanceof Integer) {
            respv = this.data.GetColumn((Integer)respVarIn);
        } else if (respVarIn instanceof String) {
            respv = this.data.GetColumn((String)respVarIn);
        } else {
            return false;
        }
        if (xv == null || xv.GetObjectClass() != Double.class || yv == null || yv.GetObjectClass() != Double.class || respv == null || respv.GetObjectClass() != Double.class) {
            return false;
        }
        xbins = this.GetBins(xbinsIn, xv);
        ybins = this.GetBins(ybinsIn, yv);
        if (xbins != null || ybins != null) {
            localInterpScheme = 2;
        }
        this.resp = null;
        this.y = null;
        this.x = null;
        this.respvar = null;
        this.yvar = null;
        this.xvar = null;
        this.yStride = 0;
        this.xStride = 0;
        this.respMin = Double.NaN;
        this.respMax = Double.NaN;
        numObs = this.data.GetNumberRows();
        if (xbins == null || ybins == null) {
            for (i = 0; i < numObs; ++i) {
                if (xbins == null && (xvalue = xv.GetValue(i)) == null || ybins == null && (yvalue = yv.GetValue(i)) == null) continue;
                if (xbins == null && this.isMissingValue(xvalue) || ybins == null && this.isMissingValue(yvalue)) {
                    respValue = respv.GetValue(i);
                    if (this.isMissingValue(respValue)) continue;
                    double v = (Double)respValue;
                    if (Double.isNaN(missingMin)) {
                        missingMin = v;
                    } else if (v < missingMin) {
                        missingMin = v;
                    }
                    if (Double.isNaN(missingMax)) {
                        missingMax = v;
                        continue;
                    }
                    if (!(v > missingMax)) continue;
                    missingMax = v;
                    continue;
                }
                if (xbins == null) {
                    this.Add(uniqueXValues, (Double)xvalue);
                }
                if (ybins == null) {
                    this.Add(uniqueYValues, (Double)yvalue);
                }
                if (Double.isNaN(xmin)) {
                    xmin = (Double)xvalue;
                } else if ((Double)xvalue < xmin) {
                    xmin = (Double)xvalue;
                }
                if (Double.isNaN(xmax)) {
                    xmax = (Double)xvalue;
                } else if ((Double)xvalue > xmax) {
                    xmax = (Double)xvalue;
                }
                if (Double.isNaN(ymin)) {
                    ymin = (Double)yvalue;
                } else if ((Double)yvalue < ymin) {
                    ymin = (Double)yvalue;
                }
                if (Double.isNaN(ymax)) {
                    ymax = (Double)yvalue;
                } else if ((Double)yvalue > ymax) {
                    ymax = (Double)yvalue;
                }
                ++nUsed;
            }
        }
        if (xbins == null && uniqueXValues.size() > this.xMaxUniqueValueCount) {
            xbins = this.GetBins(new Integer(this.xMaxUniqueValueCount), xv);
        }
        if (ybins == null && uniqueYValues.size() > this.yMaxUniqueValueCount) {
            ybins = this.GetBins(new Integer(this.yMaxUniqueValueCount), yv);
        }
        nx = xbins == null ? uniqueXValues.size() : xbins.length - 1;
        ny = ybins == null ? uniqueYValues.size() : ybins.length - 1;
        if (nx == 0 || ny == 0) {
            return false;
        }
        int size = nx * ny;
        switch (localInterpScheme) {
            default: {
                break;
            }
            case 1: {
                interpolate = true;
                break;
            }
            case 0: {
                boolean bl = interpolate = (double)size / (double)nUsed > this.interpRatio;
            }
        }
        if (interpolate) {
            dataX = new double[numObs];
            dataY = new double[numObs];
            dataResp = new double[numObs];
            if (dataX == null || dataY == null || dataResp == null) {
                interpolate = false;
                dataResp = null;
                dataY = null;
                dataX = null;
            }
        }
        if (interpolate) {
            int limit;
            localResolve = 2;
            if (this.interpXCount > 0) {
                nx = this.interpXCount;
            } else {
                limit = -this.interpXCount;
                nx = (int)Math.ceil(Math.sqrt(nUsed));
                nx = Math.min(nx, limit);
            }
            if (this.interpYCount > 0) {
                ny = this.interpYCount;
            } else {
                limit = -this.interpYCount;
                ny = (int)Math.ceil(Math.sqrt(nUsed));
                ny = Math.min(ny, limit);
            }
        }
        if ((this.x = new double[nx]) == null) {
            return false;
        }
        this.y = new double[ny];
        if (this.y == null) {
            return false;
        }
        this.resp = new double[nx * ny];
        if (this.resp == null) {
            return false;
        }
        switch (localResolve) {
            case 0: {
                r = 0.0;
                d = 0.0;
                break;
            }
            case 1: {
                r = Double.NaN;
                d = Double.NaN;
                break;
            }
            case 2: {
                r = Double.NaN;
                d = Double.NaN;
                break;
            }
            case 3: {
                r = Double.NaN;
                d = Double.NaN;
                break;
            }
            case 4: {
                d = Double.NaN;
                r = 0.0;
                temp = new double[nx * ny];
                if (temp != null) break;
                return false;
            }
            case 5: {
                r = Double.NaN;
                d = Double.NaN;
                break;
            }
            case 6: {
                r = 0.0;
                d = 0.0;
                break;
            }
            case 7: {
                d = Double.NaN;
                r = Double.NaN;
                temp = new double[nx * ny];
                if (temp != null) break;
                return false;
            }
            case 8: {
                r = Double.NaN;
                d = Double.NaN;
                break;
            }
            default: {
                r = Double.NaN;
                d = Double.NaN;
            }
        }
        this.xStride = 1;
        this.yStride = nx;
        this.FillArray(this.resp, d);
        if (temp != null) {
            this.FillArray(temp, r);
        }
        if (interpolate) {
            this.x[0] = xmin;
            this.x[nx - 1] = xmax;
            for (i = 0; i < nx - 1; ++i) {
                this.x[i] = (double)i / (double)(nx - 1) * (xmax - xmin) + xmin;
            }
            this.y[0] = ymin;
            this.y[ny - 1] = ymax;
            for (i = 0; i < ny - 1; ++i) {
                this.y[i] = (double)i / (double)(ny - 1) * (ymax - ymin) + ymin;
            }
        } else {
            for (i = 0; i < nx; ++i) {
                if (xbins != null) {
                    this.x[i] = (xbins[i] + xbins[i + 1]) / 2.0;
                    continue;
                }
                dvalue = (Double)uniqueXValues.elementAt(i);
                if (dvalue == null) {
                    return false;
                }
                this.x[i] = dvalue;
            }
            for (i = 0; i < ny; ++i) {
                if (ybins != null) {
                    this.y[i] = (ybins[i] + ybins[i + 1]) / 2.0;
                    continue;
                }
                dvalue = (Double)uniqueYValues.elementAt(i);
                if (dvalue == null) {
                    return false;
                }
                this.y[i] = dvalue;
            }
        }
        nUsed = 0;
        block35: for (i = 0; i < numObs; ++i) {
            xvalue = xv.GetValue(i);
            if (xvalue == null || (yvalue = yv.GetValue(i)) == null || this.isMissingValue(xvalue) || this.isMissingValue(yvalue) || (respValue = respv.GetValue(i)) == null) continue;
            r = this.isMissingValue(respValue) ? Double.NaN : (Double)respValue;
            if (interpolate) {
                dataX[nUsed] = (Double)xvalue;
                dataY[nUsed] = (Double)yvalue;
                dataResp[nUsed] = r;
                ++nUsed;
                continue;
            }
            d = (Double)xvalue;
            ix = this.Find(d, this.x, xbins);
            d = (Double)yvalue;
            iy = this.Find(d, this.y, ybins);
            if (ix < 0 || iy < 0) continue;
            switch (localResolve) {
                case 0: {
                    if (Double.isNaN(r)) continue block35;
                    int n = ix * this.xStride + iy * this.yStride;
                    this.resp[n] = this.resp[n] + 1.0;
                    continue block35;
                }
                case 1: {
                    if (Double.isNaN(r) || !Double.isNaN(this.resp[ix * this.xStride + iy * this.yStride])) continue block35;
                    this.resp[ix * this.xStride + iy * this.yStride] = r;
                    continue block35;
                }
                case 2: {
                    if (Double.isNaN(r)) continue block35;
                    this.resp[ix * this.xStride + iy * this.yStride] = r;
                    continue block35;
                }
                case 3: {
                    if (Double.isNaN(r)) continue block35;
                    if (Double.isNaN(this.resp[ix * this.xStride + iy * this.yStride])) {
                        this.resp[ix * this.xStride + iy * this.yStride] = r;
                        continue block35;
                    }
                    if (!(r > this.resp[ix * this.xStride + iy * this.yStride])) continue block35;
                    this.resp[ix * this.xStride + iy * this.yStride] = r;
                    continue block35;
                }
                case 4: {
                    if (Double.isNaN(r)) continue block35;
                    if (Double.isNaN(this.resp[ix * this.xStride + iy * this.yStride])) {
                        this.resp[ix * this.xStride + iy * this.yStride] = r;
                    } else {
                        int n = ix * this.xStride + iy * this.yStride;
                        this.resp[n] = this.resp[n] + r;
                    }
                    int n = ix * this.xStride + iy * this.yStride;
                    temp[n] = temp[n] + 1.0;
                    continue block35;
                }
                case 5: {
                    if (Double.isNaN(r)) continue block35;
                    if (Double.isNaN(this.resp[ix * this.xStride + iy * this.yStride])) {
                        this.resp[ix * this.xStride + iy * this.yStride] = r;
                        continue block35;
                    }
                    if (!(r < this.resp[ix * this.xStride + iy * this.yStride])) continue block35;
                    this.resp[ix * this.xStride + iy * this.yStride] = r;
                    continue block35;
                }
                case 6: {
                    if (!Double.isNaN(r)) continue block35;
                    int n = ix * this.xStride + iy * this.yStride;
                    this.resp[n] = this.resp[n] + 1.0;
                    continue block35;
                }
                case 7: {
                    if (Double.isNaN(r)) continue block35;
                    if (Double.isNaN(this.resp[ix * this.xStride + iy * this.yStride])) {
                        this.resp[ix * this.xStride + iy * this.yStride] = r;
                        temp[ix * this.xStride + iy * this.yStride] = r;
                        continue block35;
                    }
                    if (r > this.resp[ix * this.xStride + iy * this.yStride]) {
                        this.resp[ix * this.xStride + iy * this.yStride] = r;
                        continue block35;
                    }
                    if (!(r < temp[ix * this.xStride + iy * this.yStride])) continue block35;
                    temp[ix * this.xStride + iy * this.yStride] = r;
                    continue block35;
                }
                case 8: {
                    if (Double.isNaN(r)) continue block35;
                    if (Double.isNaN(this.resp[ix * this.xStride + iy * this.yStride])) {
                        this.resp[ix * this.xStride + iy * this.yStride] = r;
                        continue block35;
                    }
                    int n = ix * this.xStride + iy * this.yStride;
                    this.resp[n] = this.resp[n] + r;
                }
            }
        }
        if (interpolate && Barnes74.grid((double[])dataX, (double[])dataY, (double[])dataResp, (int)nUsed, (double[])this.resp, (double[])this.x, (int)nx, (double[])this.y, (int)ny, (int)0, (int)0, (double)0.3, (double)0.8, (double)0.5, (boolean)true) < 0) {
            return false;
        }
        this.respMin = missingMin;
        this.respMax = missingMax;
        for (ix = 0; ix < nx; ++ix) {
            for (iy = 0; iy < ny; ++iy) {
                if (Double.isNaN(this.resp[ix * this.xStride + iy * this.yStride])) continue;
                switch (localResolve) {
                    case 4: {
                        this.resp[ix * this.xStride + iy * this.yStride] = this.resp[ix * this.xStride + iy * this.yStride] / temp[ix * this.xStride + iy * this.yStride];
                        break;
                    }
                    case 7: {
                        this.resp[ix * this.xStride + iy * this.yStride] = this.resp[ix * this.xStride + iy * this.yStride] - temp[ix * this.xStride + iy * this.yStride];
                    }
                }
                if (Double.isNaN(this.respMin)) {
                    this.respMin = this.resp[ix * this.xStride + iy * this.yStride];
                } else if (this.resp[ix * this.xStride + iy * this.yStride] < this.respMin) {
                    this.respMin = this.resp[ix * this.xStride + iy * this.yStride];
                }
                if (Double.isNaN(this.respMax)) {
                    this.respMax = this.resp[ix * this.xStride + iy * this.yStride];
                    continue;
                }
                if (!(this.resp[ix * this.xStride + iy * this.yStride] > this.respMax)) continue;
                this.respMax = this.resp[ix * this.xStride + iy * this.yStride];
            }
        }
        this.xvar = xv;
        this.yvar = yv;
        this.respvar = respv;
        return true;
    }

    public boolean SetResolveDuplicates(String method) {
        if (method == null) {
            return false;
        }
        if (method.equalsIgnoreCase("COUNT")) {
            this.resolveDups = 0;
        } else if (method.equalsIgnoreCase("FIRST")) {
            this.resolveDups = 1;
        } else if (method.equalsIgnoreCase("LAST")) {
            this.resolveDups = 2;
        } else if (method.equalsIgnoreCase("MAX")) {
            this.resolveDups = 3;
        } else if (method.equalsIgnoreCase("MEAN")) {
            this.resolveDups = 4;
        } else if (method.equalsIgnoreCase("MIN")) {
            this.resolveDups = 5;
        } else if (method.equalsIgnoreCase("NMISS")) {
            this.resolveDups = 6;
        } else if (method.equalsIgnoreCase("RANGE")) {
            this.resolveDups = 7;
        } else if (method.equalsIgnoreCase("SUM")) {
            this.resolveDups = 8;
        } else {
            return false;
        }
        return true;
    }

    public String GetResolveDuplicates() {
        String strg = null;
        switch (this.resolveDups) {
            case 0: {
                strg = "COUNT";
                break;
            }
            case 1: {
                strg = "FIRST";
                break;
            }
            case 2: {
                strg = "LAST";
                break;
            }
            case 3: {
                strg = "MAX";
                break;
            }
            case 4: {
                strg = "MEAN";
                break;
            }
            case 5: {
                strg = "MIN";
                break;
            }
            case 6: {
                strg = "NMISS";
                break;
            }
            case 7: {
                strg = "RANGE";
                break;
            }
            case 8: {
                strg = "SUM";
            }
        }
        return strg;
    }

    public int GetXStride() {
        return this.xStride;
    }

    public int GetYStride() {
        return this.yStride;
    }

    public double[] GetXData() {
        return this.x;
    }

    public double[] GetYData() {
        return this.y;
    }

    public double GetXMin() {
        if (this.x == null || this.x.length <= 0) {
            return Double.NaN;
        }
        return this.x[0];
    }

    public double GetYMin() {
        if (this.y == null || this.y.length <= 0) {
            return Double.NaN;
        }
        return this.y[0];
    }

    public double GetXMax() {
        if (this.x == null || this.x.length <= 0) {
            return Double.NaN;
        }
        return this.x[this.x.length - 1];
    }

    public double GetYMax() {
        if (this.y == null || this.y.length <= 0) {
            return Double.NaN;
        }
        return this.y[this.y.length - 1];
    }

    public Object GetXVariable() {
        return this.xvar;
    }

    public Object GetYVariable() {
        return this.yvar;
    }

    public Object GetResponseVariable(int idx) {
        if (idx != 0) {
            return null;
        }
        return this.respvar;
    }

    public double[] GetResponseData(int index) {
        if (index != 0) {
            return null;
        }
        return this.resp;
    }

    public double GetResponseMin(int index) {
        if (index != 0) {
            return Double.NaN;
        }
        return this.respMin;
    }

    public double GetResponseMax(int index) {
        if (index != 0) {
            return Double.NaN;
        }
        return this.respMax;
    }

    protected boolean isMissingValue(Object o) {
        return o == null || o instanceof MissingValues || o instanceof Double && ((Double)o).isNaN();
    }

    public void setXMaxUniqueValueCount(int maxNum) {
        this.xMaxUniqueValueCount = maxNum;
    }

    public int getXMaxUniqueValueCount() {
        return this.xMaxUniqueValueCount;
    }

    public void setYMaxUniqueValueCount(int maxNum) {
        this.yMaxUniqueValueCount = maxNum;
    }

    public int getYMaxUniqueValueCount() {
        return this.yMaxUniqueValueCount;
    }
}

