/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.CompareInterface;
import com.sas.graphics.util.StringCompare;
import java.util.Vector;

public class Search {
    protected static final int NUMERIC = 0;
    protected static final int STRING = 1;

    public static int binarylookup(int val, int[] vec, int uselen) {
        int len = uselen;
        if (len < 0) {
            len = vec.length;
        }
        int ret = -1;
        int lo = 0;
        int mi = 0;
        int hi = len - 1;
        while (lo <= hi) {
            mi = (lo + hi) / 2;
            ret = val < vec[mi] ? -1 : (val > vec[mi] ? 1 : 0);
            switch (ret) {
                case -1: {
                    hi = mi - 1;
                    break;
                }
                case 0: {
                    return mi;
                }
                case 1: {
                    lo = mi + 1;
                }
            }
        }
        if (ret != 1) {
            ret = 0;
        }
        return -(mi + 1 + ret);
    }

    protected static int binarylookup(String val, String[] vec, int uselen, boolean ignoreCase) {
        int len = uselen;
        String compareValue = null;
        String vecEntry = null;
        if (len < 0) {
            len = vec.length;
        }
        if (val == null) {
            return -1;
        }
        compareValue = ignoreCase ? val.toUpperCase() : val;
        int ret = -1;
        int lo = 0;
        int mi = 0;
        int hi = len - 1;
        while (lo <= hi) {
            mi = (lo + hi) / 2;
            vecEntry = ignoreCase ? vec[mi].toUpperCase() : vec[mi];
            ret = Search.compare(compareValue, vecEntry);
            switch (ret) {
                case -1: {
                    hi = mi - 1;
                    break;
                }
                case 0: {
                    return mi;
                }
                case 1: {
                    lo = mi + 1;
                }
            }
        }
        if (ret != 1) {
            ret = 0;
        }
        return -(mi + 1 + ret);
    }

    public static int compare(int type, CompareInterface ci, Object value, Object vecEntry) {
        switch (type) {
            default: {
                return Search.compare(((Number)value).doubleValue(), ci.getNumericElement(vecEntry));
            }
            case 1: 
        }
        return Search.compare((String)value, ci.getStringElement(vecEntry));
    }

    public static int compare(String value, String vecEntry) {
        int compare = StringCompare.compareTo(value, vecEntry);
        if (compare < 0) {
            return -1;
        }
        if (compare > 0) {
            return 1;
        }
        return 0;
    }

    public static int compare(double value, double vecEntry) {
        boolean valMiss = Double.isNaN(value);
        boolean vecMiss = Double.isNaN(vecEntry);
        if (valMiss || vecMiss) {
            if (valMiss && !vecMiss) {
                return -1;
            }
            if (vecMiss && !valMiss) {
                return 1;
            }
            return 0;
        }
        if (value < vecEntry) {
            return -1;
        }
        if (value > vecEntry) {
            return 1;
        }
        return 0;
    }

    public static int binarylookup(Object val, Vector vec, Vector indicies, boolean ignoreCase, int uselen, CompareInterface ci) {
        int type = 0;
        int len = uselen;
        Object vecEntry = null;
        if (val == null) {
            return -1;
        }
        if (val instanceof String) {
            type = 1;
        }
        switch (type) {
            default: {
                break;
            }
            case 1: {
                String s = (String)val;
                if (!ignoreCase) break;
                s = s.toUpperCase();
            }
        }
        if (len < 0) {
            len = vec.size();
        }
        int ret = -1;
        int lo = 0;
        int mi = 0;
        int hi = len - 1;
        while (lo <= hi) {
            mi = (lo + hi) / 2;
            vecEntry = indicies == null ? vec.elementAt(mi) : vec.elementAt((Integer)indicies.elementAt(mi));
            ret = Search.compare(type, ci, val, vecEntry);
            switch (ret) {
                case -1: {
                    hi = mi - 1;
                    break;
                }
                case 0: {
                    return mi;
                }
                case 1: {
                    lo = mi + 1;
                }
            }
        }
        if (ret != 1) {
            ret = 0;
        }
        return -(mi + 1 + ret);
    }

    public static int binarylookup(Object val, Vector vec, int[] indicies, boolean ignoreCase, int uselen, CompareInterface ci) {
        int type = 0;
        int len = uselen;
        Object vecEntry = null;
        if (val == null) {
            return -1;
        }
        if (val instanceof String) {
            type = 1;
        }
        switch (type) {
            default: {
                break;
            }
            case 1: {
                String s = (String)val;
                if (!ignoreCase) break;
                s = s.toUpperCase();
            }
        }
        if (len < 0) {
            len = vec.size();
        }
        int ret = -1;
        int lo = 0;
        int mi = 0;
        int hi = len - 1;
        while (lo <= hi) {
            mi = (lo + hi) / 2;
            vecEntry = indicies == null ? vec.elementAt(mi) : vec.elementAt(indicies[mi]);
            ret = Search.compare(type, ci, val, vecEntry);
            switch (ret) {
                case -1: {
                    hi = mi - 1;
                    break;
                }
                case 0: {
                    return mi;
                }
                case 1: {
                    lo = mi + 1;
                }
            }
        }
        if (ret != 1) {
            ret = 0;
        }
        return -(mi + 1 + ret);
    }
}

