/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import java.util.Hashtable;
import java.util.LinkedHashMap;

public class RangeInfoModel {
    private Hashtable variables = new Hashtable();
    private DataFilterReadInterface dataFilter = null;

    public RangeInfoModel(DataFilterReadInterface filter) {
        this.dataFilter = filter;
    }

    public double getMinimum(Object variableId) {
        Object obj;
        if (this.dataFilter == null) {
            return Double.NaN;
        }
        if (!this.variables.containsKey(variableId)) {
            this.computeMinMax(variableId);
        }
        if ((obj = this.variables.get(variableId)) instanceof VarInfo) {
            return ((VarInfo)obj).getMinimum();
        }
        return Double.NaN;
    }

    public double getMaximum(Object variableId) {
        Object obj;
        if (this.dataFilter == null) {
            return Double.NaN;
        }
        if (!this.variables.containsKey(variableId)) {
            this.computeMinMax(variableId);
        }
        if ((obj = this.variables.get(variableId)) instanceof VarInfo) {
            return ((VarInfo)obj).getMaximum();
        }
        return Double.NaN;
    }

    public double getGraphedMinimum(Object variableId) {
        Object obj;
        if (this.dataFilter == null) {
            return Double.NaN;
        }
        if (!this.variables.containsKey(variableId)) {
            this.computeMinMax(variableId);
        }
        if ((obj = this.variables.get(variableId)) instanceof VarInfo) {
            return ((VarInfo)obj).getGraphedMinimum();
        }
        return Double.NaN;
    }

    public double getGraphedMaximum(Object variableId) {
        Object obj;
        if (this.dataFilter == null) {
            return Double.NaN;
        }
        if (!this.variables.containsKey(variableId)) {
            this.computeMinMax(variableId);
        }
        if ((obj = this.variables.get(variableId)) instanceof VarInfo) {
            return ((VarInfo)obj).getGraphedMaximum();
        }
        return Double.NaN;
    }

    private void computeMinMax(Object variableId) {
        if (this.dataFilter == null) {
            return;
        }
        int index = this.dataFilter.getVariableIndex(variableId);
        if (index < 0 || !this.dataFilter.isNumericVariable(variableId)) {
            return;
        }
        VarInfo vi = new VarInfo();
        for (int i = 0; i < this.dataFilter.getNumberObservations(index); ++i) {
            double d = this.dataFilter.getNumericValue(index, (long)i);
            if (Double.isNaN(d)) continue;
            vi.setMinimum(Math.min(vi.getMinimum(), d));
            vi.setMaximum(Math.max(vi.getMaximum(), d));
            if (!this.dataFilter.isGraphed(i)) continue;
            vi.setGraphedMinimum(Math.min(vi.getGraphedMinimum(), d));
            vi.setGraphedMaximum(Math.max(vi.getGraphedMaximum(), d));
        }
        if (vi.getMinimum() > vi.getMaximum()) {
            vi.setMinimum(Double.NaN);
            vi.setMaximum(Double.NaN);
        }
        this.variables.put(variableId, vi);
    }

    public OrdinalRange getOrdinalRange(Object variableId) {
        return this.getOrdinalRange(variableId, true);
    }

    public OrdinalRange getOrdinalRange(Object variableId, boolean includeMissing) {
        VarInfo vInfo;
        if (this.dataFilter == null) {
            return null;
        }
        int index = this.dataFilter.getVariableIndex(variableId);
        if (index < 0 || !this.dataFilter.isNumericVariable(variableId)) {
            return null;
        }
        if (!this.variables.containsKey(variableId)) {
            this.computeMinMax(variableId);
        }
        if ((vInfo = (VarInfo)this.variables.get(variableId)).getOrdinalRange() == null) {
            LinkedHashMap<String, Object> unformatted = new LinkedHashMap<String, Object>();
            for (int i = 0; i < this.dataFilter.getNumberObservations(-1); ++i) {
                String f;
                Object d = this.dataFilter.getValue(index, (long)i);
                if (!includeMissing && this.dataFilter.isMissing(index, d) || unformatted.containsKey(f = this.dataFilter.getFormattedValue(variableId, i, (Object)null))) continue;
                unformatted.put(f, d);
            }
            Object[] fvalues = unformatted.values().toArray();
            Object[] uvalues = unformatted.keySet().toArray();
            vInfo.setOrdinalRange(new OrdinalRange(uvalues, fvalues));
        }
        return vInfo.getOrdinalRange();
    }

    public void invalidate() {
        this.variables.clear();
    }

    public void dispose() {
        this.invalidate();
        this.variables = null;
        this.dataFilter = null;
    }

    class VarInfo {
        double _minimum = Double.POSITIVE_INFINITY;
        double _maximum = Double.NEGATIVE_INFINITY;
        double _graphedMinimum = Double.POSITIVE_INFINITY;
        double _graphedMaximum = Double.NEGATIVE_INFINITY;
        OrdinalRange ordinalRange = null;

        VarInfo() {
        }

        public double getMaximum() {
            return this._maximum;
        }

        public void setMaximum(double maximum) {
            this._maximum = maximum;
        }

        public double getMinimum() {
            return this._minimum;
        }

        public void setMinimum(double minimum) {
            this._minimum = minimum;
        }

        public double getGraphedMaximum() {
            return this._graphedMaximum;
        }

        public void setGraphedMaximum(double maximum) {
            this._graphedMaximum = maximum;
        }

        public double getGraphedMinimum() {
            return this._graphedMinimum;
        }

        public void setGraphedMinimum(double minimum) {
            this._graphedMinimum = minimum;
        }

        public OrdinalRange getOrdinalRange() {
            return this.ordinalRange;
        }

        public void setOrdinalRange(OrdinalRange ordinalRange) {
            this.ordinalRange = ordinalRange;
        }
    }
}

