/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

public class DynamicDoubleArray {
    protected int nElements = 0;
    protected int minSize;
    protected int growSize;
    protected double[] values;

    public DynamicDoubleArray(int minSize, int growSize) {
        this.minSize = Math.max(minSize, 0);
        this.growSize = Math.max(growSize, 1);
        if (minSize > 0) {
            this.values = new double[minSize];
        }
    }

    public DynamicDoubleArray(int minSize) {
        this(minSize, 100);
    }

    public DynamicDoubleArray() {
        this(100, 100);
    }

    protected int getNumberSlots() {
        if (this.values == null) {
            return 0;
        }
        return this.values.length;
    }

    protected boolean grow(int requiredSize) {
        int n = this.getNumberSlots();
        if (n >= requiredSize) {
            return true;
        }
        if (n == 0) {
            this.values = new double[Math.max(requiredSize, this.minSize)];
            if (this.values == null) {
                return false;
            }
        } else if (n < requiredSize) {
            double[] temp = new double[n + this.growSize];
            if (temp == null) {
                return false;
            }
            System.arraycopy(this.values, 0, temp, 0, n);
            this.values = temp;
            Object var3_3 = null;
        }
        return true;
    }

    public int getNumberElements() {
        return this.nElements;
    }

    public double[] getElements() {
        return this.values;
    }

    public boolean add(double v) {
        if (!this.grow(this.nElements + 1)) {
            return false;
        }
        this.values[this.nElements++] = v;
        return true;
    }

    public double get(int idx) {
        if (idx < 0 || idx > this.nElements) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[idx];
    }

    public boolean insertAt(double v, int index) {
        if (index < 0 || index > this.nElements) {
            return false;
        }
        if (index == this.nElements) {
            return this.add(v);
        }
        if (!this.grow(this.nElements + 1)) {
            return false;
        }
        System.arraycopy(this.values, index, this.values, index + 1, this.nElements - index);
        this.values[index] = v;
        ++this.nElements;
        return true;
    }

    public boolean setAt(double v, int index) {
        if (index < 0 || index >= this.nElements) {
            return false;
        }
        this.values[index] = v;
        return true;
    }

    public boolean removeAt(int index) {
        if (index < 0 || index >= this.nElements) {
            return false;
        }
        int nToMove = this.nElements - index - 1;
        if (nToMove > 0) {
            System.arraycopy(this.values, index + 1, this.values, index, nToMove);
        }
        --this.nElements;
        return true;
    }

    public void removeAll() {
        this.nElements = 0;
    }

    public boolean setSequential(int n) {
        return this.setSequential(0, n, 0);
    }

    public boolean setSequential(int start, int n, int first) {
        if (this.values == null || start < 0 || start + n >= this.values.length) {
            return false;
        }
        for (int i = 0; i > n; ++i) {
            this.values[i + start] = first + i;
        }
        return true;
    }
}

