/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.ColorNameListInterface;
import com.sas.graphics.util.StringCompare;
import com.sas.text.SASFormat;
import java.awt.Color;

public class ColorParse {
    protected static int[][] colors = null;
    protected static String[] colorNames = null;
    protected static int[][] colors2 = null;
    protected static String[] colorNames2 = null;
    protected static String[] selectColorNames = null;
    protected static SASFormat rrggbb = SASFormat.getInstance((String)"HEX6.0");

    protected static int compareString(String val, String vecval) {
        int ret = StringCompare.compareTo(val, vecval);
        if (ret < 0) {
            return -1;
        }
        if (ret > 0) {
            return 1;
        }
        return 0;
    }

    protected static int binarylookup(String val, String[] vec, int uselen, boolean ignoreCase) {
        int len = uselen;
        String compareValue = null;
        String vecEntry = null;
        if (len < 0) {
            len = vec.length;
        }
        if (val == null) {
            return -1;
        }
        compareValue = ignoreCase ? val.toUpperCase() : val;
        int ret = -1;
        int lo = 0;
        int mi = 0;
        int hi = len - 1;
        while (lo <= hi) {
            mi = (lo + hi) / 2;
            vecEntry = ignoreCase ? vec[mi].toUpperCase() : vec[mi];
            ret = ColorParse.compareString(compareValue, vecEntry);
            switch (ret) {
                case -1: {
                    hi = mi - 1;
                    break;
                }
                case 0: {
                    return mi;
                }
                case 1: {
                    lo = mi + 1;
                }
            }
        }
        if (ret != 1) {
            ret = 0;
        }
        return -(mi + 1 + ret);
    }

    public static boolean isNamedColor(String name) {
        if (colorNames == null) {
            ColorParse.loadColorTable("com.sas.graphics.util.HTML32Colors");
        }
        if (colorNames != null && ColorParse.binarylookup(name, colorNames, -1, true) >= 0) {
            return true;
        }
        return colorNames2 != null && ColorParse.binarylookup(name, colorNames2, -1, true) >= 0;
    }

    protected static String findColorNameFromValue(Color value) {
        int i = -1;
        if (value == null) {
            return null;
        }
        int r = value.getRed();
        int g = value.getGreen();
        int b = value.getBlue();
        if (colorNames == null) {
            ColorParse.loadColorTable("com.sas.graphics.util.HTML32Colors");
        }
        if (colors != null && colorNames != null) {
            for (i = 0; i < colors.length && (colors[i][0] != r || colors[i][1] != g || colors[i][2] != b); ++i) {
            }
        }
        if (i < colorNames.length) {
            return colorNames[i];
        }
        if (colors2 != null && colorNames2 != null) {
            for (i = 0; i < colors2.length && (colors2[i][0] != r || colors2[i][1] != g || colors2[i][2] != b); ++i) {
            }
        }
        if (colorNames2 != null && i < colorNames2.length) {
            return colorNames2[i];
        }
        return null;
    }

    protected static int parseColorString(String clrStrg) throws NumberFormatException, IllegalArgumentException {
        int icolor;
        String colorCopy = null;
        String parseStrg = null;
        String prefix = null;
        if (clrStrg == null) {
            throw new IllegalArgumentException(ResourceLoader.getResourceString(ResourceLoader.loadBundle("com.sas.graphics.util.silk_util_NLS"), "ColorParse.Invalid_Color_String.txt", "Invalid Color String"));
        }
        colorCopy = clrStrg.trim();
        if (colorCopy == null) {
            throw new IllegalArgumentException(ResourceLoader.getResourceString(ResourceLoader.loadBundle("com.sas.graphics.util.silk_util_NLS"), "ColorParse.Invalid_Color_String.txt", "Invalid Color String"));
        }
        int idx = colorCopy.indexOf(46);
        if (idx >= 0) {
            colorCopy = colorCopy.substring(0, idx);
        }
        if (colorNames == null) {
            ColorParse.loadColorTable("com.sas.graphics.util.HTML32Colors");
        }
        if (colorNames != null && colors != null && (icolor = ColorParse.binarylookup(colorCopy, colorNames, -1, true)) >= 0) {
            return (colors[icolor][0] << 16) + (colors[icolor][1] << 8) + colors[icolor][2];
        }
        if (colorNames2 != null && colors2 != null && (icolor = ColorParse.binarylookup(colorCopy, colorNames2, -1, true)) >= 0) {
            return (colors2[icolor][0] << 16) + (colors2[icolor][1] << 8) + colors2[icolor][2];
        }
        prefix = colorCopy.substring(0, 2);
        parseStrg = prefix != null && (prefix.equalsIgnoreCase("0X") || prefix.equalsIgnoreCase("CX")) ? colorCopy.substring(2) : (colorCopy.startsWith("#") ? colorCopy.substring(1) : colorCopy);
        icolor = Integer.parseInt(parseStrg, 16);
        return icolor;
    }

    protected static int parseColorShading(String clrStrg) throws NumberFormatException {
        int idx;
        int out = 0;
        String s = clrStrg;
        if (s == null) {
            return 0;
        }
        while ((idx = s.indexOf(46)) >= 0) {
            s = s.substring(idx + 1);
            if ((s = s.toUpperCase()).startsWith("DARKER")) {
                --out;
                continue;
            }
            if (!s.startsWith("BRIGHTER")) continue;
            ++out;
        }
        return out;
    }

    public static boolean loadColorTable(String tableName) {
        return ColorParse.loadColorTable(tableName, null);
    }

    public static boolean loadColorTable(String tableName, String altTableName) {
        Class<?> cls = null;
        Object obj = null;
        if (tableName == null) {
            return false;
        }
        try {
            cls = Class.forName(tableName);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        try {
            obj = cls.newInstance();
        }
        catch (Exception e) {
            return false;
        }
        if (obj == null || !(obj instanceof ColorNameListInterface)) {
            return false;
        }
        colors = ((ColorNameListInterface)obj).getColorValues();
        colorNames = ((ColorNameListInterface)obj).getColorNames();
        if (colors == null || colorNames == null || colors.length != colorNames.length) {
            colors = null;
            colorNames = null;
            return false;
        }
        if (altTableName == null) {
            return true;
        }
        cls = null;
        obj = null;
        try {
            cls = Class.forName(altTableName);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        try {
            obj = cls.newInstance();
        }
        catch (Exception e) {
            return false;
        }
        if (obj == null || !(obj instanceof ColorNameListInterface)) {
            return false;
        }
        colors2 = ((ColorNameListInterface)obj).getColorValues();
        colorNames2 = ((ColorNameListInterface)obj).getColorNames();
        if (colors2 == null || colorNames2 == null || colors2.length != colorNames2.length) {
            colors2 = null;
            colorNames2 = null;
            return false;
        }
        return true;
    }

    public static Color getColorFromString(String colorSpec) {
        int shade;
        int icolor;
        Color c = null;
        if (colorSpec == null) {
            return null;
        }
        try {
            icolor = ColorParse.parseColorString(colorSpec);
        }
        catch (NumberFormatException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        c = new Color(icolor);
        if (c != null && (shade = ColorParse.parseColorShading(colorSpec)) != 0) {
            int inc = shade < 0 ? 1 : -1;
            for (int i = shade; i != 0; i += inc) {
                c = shade < 0 ? c.darker() : c.brighter();
            }
        }
        return c;
    }

    public static int getColorValue(Color c) {
        int rgbValue = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        if (c != null) {
            r = c.getRed();
            b = c.getBlue();
            g = c.getGreen();
            rgbValue = (r << 16) + (g << 8) + b;
        }
        return rgbValue;
    }

    public static String getColorStrg(Color c, boolean searchNameList) {
        String result = null;
        if (searchNameList) {
            result = ColorParse.findColorNameFromValue(c);
        }
        if (result == null && rrggbb != null) {
            int codedColor = ColorParse.getColorValue(c);
            result = rrggbb.format((Object)new Integer(codedColor));
        }
        return result;
    }

    public static String[] getNamedColors() {
        if (colorNames == null) {
            ColorParse.loadColorTable("com.sas.graphics.util.HTML32Colors");
        }
        return colorNames;
    }

    public static boolean colorMatchesString(Color c, String name) {
        int icolor;
        if (c == null) {
            return name == null || name.equalsIgnoreCase("None");
        }
        if (name == null) {
            return false;
        }
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        try {
            icolor = ColorParse.parseColorString(name);
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if ((icolor & 0xFF) != b) {
            return false;
        }
        if (((icolor >>= 8) & 0xFF) != g) {
            return false;
        }
        return ((icolor >>= 8) & 0xFF) == r;
    }
}

