/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles.ui.swatch;

import com.sas.graphics.styles.ui.Messages;
import com.sas.graphics.styles.ui.swatch.ColorGrabber;
import com.sas.graphics.styles.ui.swatch.SwatchActionEvent;
import com.sas.graphics.styles.ui.swatch.SwatchLabel;
import com.sas.graphics.styles.ui.swatch.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class SwatchFrame
extends JPanel
implements MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private int cols = 8;
    private int rows = 4;
    JPanel swatchPanel;
    Object[] items;
    SwatchLabel more;
    SwatchLabel automatic;
    SwatchLabel colorGrabberLabel;
    ColorGrabber colorGrabber;
    Dimension preferredSize = new Dimension(144 * UIUtil.DLU, 100 * UIUtil.DLU);
    boolean pickingDone = false;
    protected EventListenerList listenerList = new EventListenerList();
    private SwatchLabel curLabel = null;
    boolean modified = true;

    public SwatchFrame() {
        this(null, 6, 6, null, null, null, null);
    }

    public SwatchFrame(Object[] items, int cols, int rows) {
        this(null, cols, rows, null, null, null, null);
    }

    public SwatchFrame(Object[] items, int cols, int rows, ColorGrabber cg) {
        this(null, cols, rows, cg, null, null, null);
    }

    public SwatchFrame(Object[] items, int cols, int rows, ColorGrabber cg, String auto, Object value, String moreLabel) {
        this.setBorder(BorderFactory.createEmptyBorder(UIUtil.DLU * 2, UIUtil.DLU * 2, UIUtil.DLU * 2, UIUtil.DLU * 2));
        this.items = items;
        this.cols = cols;
        this.rows = rows;
        this.colorGrabber = cg;
        if (moreLabel != null) {
            this.more = new SwatchLabel((Object)moreLabel);
            this.more.setHorizontalAlignment(0);
            this.more.setIndex(Integer.MAX_VALUE);
        }
        if (auto != null && auto.length() > 0) {
            this.automatic = new SwatchLabel((Object)null);
            this.automatic.setText(auto);
            this.automatic.value = value;
            this.automatic.setIndex(0x7FFFFFFE);
        }
        if (this.colorGrabber != null) {
            this.colorGrabberLabel = new SwatchLabel((Object)Messages.getString("colorPickerDots.txt"));
            this.colorGrabberLabel.setIcon(new ImageIcon(UIUtil.getImage(null, "colorPicker.gif")));
            this.colorGrabberLabel.setHorizontalAlignment(0);
            this.colorGrabberLabel.setHorizontalTextPosition(4);
            this.colorGrabberLabel.setIndex(0x7FFFFFFD);
        }
        if (items != null) {
            this.addComponents();
        }
    }

    public void setGrid(int cols, int rows) {
        this.cols = cols;
        this.rows = rows;
        if (this.items != null) {
            this.removeAll();
            this.addComponents();
        }
    }

    private void addComponents() {
        Dimension md;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        if (this.automatic != null) {
            gridbag.setConstraints(this.automatic, c);
            this.add(this.automatic);
        }
        int index = 0;
        int cursize = this.items.length;
        for (int i = 0; i < this.rows; ++i) {
            c.gridwidth = 1;
            for (int j = 0; j < this.cols; ++j) {
                SwatchLabel label;
                if (index < cursize) {
                    label = new SwatchLabel(this.items[index]);
                    label.setIndex(index);
                } else {
                    label = new SwatchLabel(SwatchLabel.backColor);
                }
                if (j == this.cols - 1) {
                    c.gridwidth = 0;
                }
                gridbag.setConstraints(label, c);
                this.add(label);
                ++index;
            }
        }
        if (this.more != null) {
            c.gridwidth = 0;
            this.more.setHorizontalAlignment(0);
            gridbag.setConstraints(this.more, c);
            this.add(this.more);
        }
        if (this.colorGrabberLabel != null) {
            c.gridwidth = 0;
            this.colorGrabberLabel.setHorizontalAlignment(0);
            gridbag.setConstraints(this.colorGrabberLabel, c);
            this.add(this.colorGrabberLabel);
        }
        Box box = Box.createVerticalBox();
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.gridheight = 0;
        gridbag.setConstraints(box, c);
        Component cc = this.getComponent(1);
        Dimension d = cc.getPreferredSize();
        Insets insets = this.getInsets();
        int pwidth = (int)((double)this.cols * d.getWidth()) + insets.left + insets.right;
        int pheight = (int)((double)this.rows * d.getHeight()) + insets.top + insets.bottom;
        if (this.more != null) {
            md = this.more.getPreferredSize();
            pwidth = (int)Math.max((double)this.cols * d.getWidth(), md.getWidth()) + insets.left + insets.right;
            pheight += (int)md.getHeight();
        }
        if (this.automatic != null) {
            pheight += this.automatic.getPreferredSize().height;
        }
        if (this.colorGrabberLabel != null) {
            md = this.colorGrabberLabel.getPreferredSize();
            pwidth = (int)Math.max((double)pwidth, md.getWidth()) + insets.left + insets.right;
            pheight += (int)md.getHeight();
        }
        this.preferredSize.width = Math.max(this.preferredSize.width, pwidth);
        this.preferredSize.height = pheight;
        this.setSize(this.preferredSize);
    }

    public void setAutomatic(String label, Object obj) {
        if (this.automatic != null) {
            if (label != null && label.length() > 0) {
                if (obj != null) {
                    this.automatic.setText(label);
                    this.automatic.value = obj;
                    this.automatic.setIconTextGap(12);
                } else {
                    this.automatic.setValue(null);
                    this.automatic.setHorizontalAlignment(0);
                }
            } else {
                this.automatic = null;
                this.addComponents();
            }
        } else if (label != null && label.length() > 0) {
            this.automatic = new SwatchLabel((Object)null);
            this.automatic.setText(label);
            this.automatic.value = obj;
            this.automatic.setIconTextGap(12);
            this.addComponents();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void setList(Object[] list) {
        this.removeAll();
        this.items = list;
        this.addComponents();
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof ActionListener)) continue;
            ((ActionListener)listeners[i]).actionPerformed(event);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.pickingDone) {
            this.pickElement(e);
        }
    }

    public Object getCurrentValue() {
        if (this.curLabel == null) {
            return null;
        }
        return this.curLabel.getValue();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.pickingDone) {
            this.pickElement(e);
            this.createAndFireEvent();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void pickElement(MouseEvent e) {
        Component c = this.getComponentAt(e.getX(), e.getY());
        if (c instanceof SwatchLabel) {
            if (this.curLabel != null) {
                this.curLabel.setHilite(false);
                this.curLabel.repaint();
            }
            if (((SwatchLabel)c).getIndex() != -1) {
                this.curLabel = (SwatchLabel)c;
                this.curLabel.setHilite(true);
                this.curLabel.repaint();
            }
        }
    }

    void createAndFireEvent() {
        if (this.curLabel == null) {
            return;
        }
        this.modified = false;
        SwatchActionEvent ae = this.curLabel == this.more ? new SwatchActionEvent((Object)this, 2, "update", null) : (this.curLabel == this.automatic ? new SwatchActionEvent((Object)this, 3, "update", null) : (this.curLabel == this.colorGrabberLabel ? new SwatchActionEvent((Object)this, 4, "update", null) : new SwatchActionEvent((Object)this, 1, "update", this.curLabel.getValue())));
        this.pickingDone = this.curLabel != this.colorGrabberLabel;
        this.fireActionPerformed(ae);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!(this.curLabel == null || this.curLabel == this.colorGrabberLabel && this.pickingDone)) {
            this.curLabel.setHilite(false);
            this.curLabel.repaint();
            this.curLabel = null;
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        Dimension ps = this.getPreferredSize();
        if (width < ps.width) {
            width = ps.width;
        }
        if (height < ps.height) {
            height = ps.height;
        }
        super.setBounds(x, y, width, height);
    }

    void setSelectedLabel(int index) {
        if (this.curLabel != null) {
            this.curLabel.setHilite(false);
        }
        this.curLabel = index >= 0 && index < this.items.length ? (this.automatic == null ? (SwatchLabel)this.getComponent(index) : (SwatchLabel)this.getComponent(index + 1)) : null;
        if (this.curLabel != null) {
            this.curLabel.setHilite(true);
            this.curLabel.repaint();
        }
    }

    void setAutomaticSelected() {
        if (this.curLabel != null) {
            this.curLabel.setHilite(false);
        }
        this.curLabel = this.automatic;
        if (this.curLabel != null) {
            this.curLabel.setHilite(true);
            this.curLabel.repaint();
        }
    }

    boolean isColorGrabberSelected() {
        return this.colorGrabber != null && this.curLabel == this.colorGrabberLabel;
    }

    boolean isMoreSelected() {
        return this.curLabel == this.more;
    }

    boolean isAutomaticSelected() {
        return this.automatic != null && this.curLabel == this.automatic;
    }
}

