/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles.ui.swatch;

import com.sas.graphics.styles.ui.Messages;
import com.sas.graphics.styles.ui.swatch.SGDialog;
import com.sas.graphics.styles.ui.swatch.SwatchActionEvent;
import com.sas.graphics.styles.ui.swatch.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;

public class ColorGrabber
implements MouseListener,
MouseMotionListener {
    public static Cursor colorPickerCursor = UIUtil.createCursor("ColorPicker", new Point(8, 8), "colorPickerCursor.gif");
    JComponent grabComponent;
    Container parent = null;
    JComponent mouseEventGenerator = null;
    Color currentColor = Color.WHITE;
    Object startColor = Color.WHITE;
    Image buffer = null;
    int[] pixels = new int[9];
    boolean colorPicked = true;
    private ModalListener mouseListner = new ModalListener();
    protected EventListenerList listenerList = new EventListenerList();
    private ActionListener lastListener = null;
    MouseListener[] mouseListeners = null;
    MouseMotionListener[] mouseMotionListeners = null;
    boolean needToPick = true;
    boolean mouseMoveEnabled = false;

    public ColorGrabber(JComponent component) {
        this.grabComponent = component;
        if (component != null) {
            this.parent = component.getParent();
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    public ActionListener[] getAllActionListener() {
        EventListener[] elist = this.listenerList.getListeners(ActionListener.class);
        ActionListener[] list = new ActionListener[elist.length];
        System.arraycopy(elist, 0, list, 0, elist.length);
        return list;
    }

    public void setLastListener(ActionListener listener) {
        this.lastListener = listener;
    }

    protected void fireActionPerformed(ActionEvent event) {
        EventListener[] listeners = this.listenerList.getListeners(ActionListener.class);
        boolean hasLast = false;
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] == this.lastListener) {
                hasLast = true;
                continue;
            }
            ((ActionListener)listeners[i]).actionPerformed(event);
        }
        if (hasLast) {
            this.lastListener.actionPerformed(event);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.currentColor = this.pickColor(e);
        this.needToPick = false;
        SwatchActionEvent ae = new SwatchActionEvent((Object)this, 4, "colorpicker:done", this.currentColor == null ? this.startColor : this.currentColor);
        this.fireActionPerformed(ae);
        this.colorPicked = true;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private Color pickColor(MouseEvent e) {
        if (e.getX() == Integer.MAX_VALUE || e.getY() == Integer.MAX_VALUE) {
            return null;
        }
        if (this.colorPicked) {
            if (this.buffer == null || this.buffer.getWidth(null) < this.grabComponent.getWidth() || this.buffer.getHeight(null) < this.grabComponent.getHeight()) {
                this.buffer = new BufferedImage(this.grabComponent.getWidth(), this.grabComponent.getHeight(), 1);
            }
            Graphics2D g = (Graphics2D)this.buffer.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.grabComponent.paint(g);
            this.colorPicked = false;
        }
        int[] pixels = new int[9];
        Point org = new Point(e.getX(), e.getY());
        Point annop = SwingUtilities.convertPoint((JComponent)e.getSource(), org, this.grabComponent);
        PixelGrabber pg = new PixelGrabber(this.buffer, annop.x - 1, annop.y - 1, 3, 3, pixels, 0, 3);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException ee) {
            return null;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            return null;
        }
        return new Color(pixels[4]);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void setMouseEventListener() {
        Container container;
        int i;
        this.mouseListeners = this.mouseEventGenerator.getMouseListeners();
        for (i = 0; i < this.mouseListeners.length; ++i) {
            this.mouseEventGenerator.removeMouseListener(this.mouseListeners[i]);
        }
        this.mouseMotionListeners = this.mouseEventGenerator.getMouseMotionListeners();
        for (i = 0; i < this.mouseMotionListeners.length; ++i) {
            this.mouseEventGenerator.removeMouseMotionListener(this.mouseMotionListeners[i]);
        }
        this.mouseEventGenerator.addMouseListener(this);
        this.mouseEventGenerator.addMouseMotionListener(this);
        this.mouseEventGenerator.setCursor(colorPickerCursor);
        if (this.buffer == null || this.buffer.getWidth(null) < this.grabComponent.getWidth() || this.buffer.getHeight(null) < this.grabComponent.getHeight()) {
            this.buffer = new BufferedImage(this.grabComponent.getWidth(), this.grabComponent.getHeight(), 1);
        }
        if ((container = this.grabComponent.getTopLevelAncestor()) instanceof JRootPane) {
            Component glass = ((JRootPane)container).getRootPane().getGlassPane();
            glass.addMouseListener(this.mouseListner);
            glass.addMouseMotionListener(this.mouseListner);
            glass.setVisible(true);
            glass.setCursor(colorPickerCursor);
        }
    }

    public void removeMouseEventListener() {
        int i;
        this.mouseEventGenerator.removeMouseListener(this);
        for (i = 0; i < this.mouseListeners.length; ++i) {
            this.mouseEventGenerator.addMouseListener(this.mouseListeners[i]);
        }
        this.mouseEventGenerator.removeMouseMotionListener(this);
        for (i = 0; i < this.mouseMotionListeners.length; ++i) {
            this.mouseEventGenerator.addMouseMotionListener(this.mouseMotionListeners[i]);
        }
        this.mouseEventGenerator.setCursor(Cursor.getDefaultCursor());
        Container container = this.grabComponent.getTopLevelAncestor();
        if (container instanceof JRootPane) {
            Component glass = ((JRootPane)container).getRootPane().getGlassPane();
            glass.removeMouseListener(this.mouseListner);
            glass.removeMouseMotionListener(this.mouseListner);
            glass.setVisible(false);
        }
    }

    public Component getMouseEventGenerator() {
        return this.mouseEventGenerator;
    }

    public void setMouseEventGenerator(JComponent mouseEventGenerator) {
        this.mouseEventGenerator = mouseEventGenerator;
    }

    public boolean isColorPicked() {
        return !this.needToPick;
    }

    public JComponent getComponent() {
        return this.grabComponent;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Color c = this.pickColor(e);
        if (c == null) {
            return;
        }
        this.currentColor = c;
        SwatchActionEvent ae = new SwatchActionEvent((Object)this, 4, "colorpicker:updating", this.currentColor);
        this.fireActionPerformed(ae);
    }

    public Object getStartColor() {
        return this.startColor;
    }

    public void setStartColor(Object startColor) {
        this.startColor = startColor;
        if (startColor instanceof Color) {
            this.currentColor = (Color)startColor;
        }
    }

    public boolean isMouseMoveEnabled() {
        return this.mouseMoveEnabled;
    }

    public void setMouseMoveEnabled(boolean mouseMoveEnabled) {
        this.mouseMoveEnabled = mouseMoveEnabled;
    }

    class ModalListener
    extends MouseInputAdapter {
        @Override
        public void mouseMoved(MouseEvent e) {
            if (!ColorGrabber.this.mouseMoveEnabled) {
                return;
            }
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        private void redispatchMouseEvent(MouseEvent e) {
            Point orgp = e.getPoint();
            Container container = ColorGrabber.this.mouseEventGenerator.getTopLevelAncestor();
            if (container instanceof JRootPane) {
                Component glass = ((JRootPane)container).getRootPane().getGlassPane();
                Point annop = SwingUtilities.convertPoint(glass, orgp, ColorGrabber.this.mouseEventGenerator);
                if (ColorGrabber.this.mouseEventGenerator.contains(annop)) {
                    ColorGrabber.this.mouseEventGenerator.dispatchEvent(new MouseEvent(ColorGrabber.this.mouseEventGenerator, e.getID(), e.getWhen(), e.getModifiers(), annop.x, annop.y, e.getClickCount(), e.isPopupTrigger()));
                    glass.setCursor(colorPickerCursor);
                } else {
                    if (e.getID() == 500) {
                        String title;
                        String message = Messages.getString("pickerwarning.txt");
                        int returnVal = JOptionPane.showConfirmDialog(null, message, title = Messages.getString("colorPicker.txt"), 0, 2);
                        if (returnVal != 0) {
                            ColorGrabber.this.mouseEventGenerator.dispatchEvent(new MouseEvent(ColorGrabber.this.mouseEventGenerator, e.getID(), e.getWhen(), e.getModifiers(), Integer.MAX_VALUE, Integer.MAX_VALUE, e.getClickCount(), e.isPopupTrigger()));
                        } else {
                            Object[] ll = ColorGrabber.this.listenerList.getListenerList();
                            for (int i = 0; i < ll.length; ++i) {
                                Container c;
                                if (!(ll[i] instanceof JPanel) || !((c = ((JPanel)ll[i]).getTopLevelAncestor()) instanceof SGDialog)) continue;
                                ((SGDialog)c).toFront();
                                break;
                            }
                        }
                    }
                    glass.setCursor(Cursor.getDefaultCursor());
                }
                e.consume();
            }
        }
    }
}

