/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles.ui;

import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.styles.ui.DefaultHistogramPreview;
import com.sas.graphics.styles.ui.Messages;
import com.sas.graphics.util.FontManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class StyleSelectorCombo
extends JComboBox
implements ListCellRenderer,
PropertyChangeListener {
    private static final long serialVersionUID = 5952205359119389075L;
    StyleCollection styles = null;
    DefaultListCellRenderer defaultRenderer = null;
    DefaultHistogramPreview stylePreview = new DefaultHistogramPreview();
    JPanel borderedPanel = new JPanel(new BorderLayout());

    public StyleSelectorCombo() {
        this(new StyleCollection(true));
    }

    public StyleSelectorCombo(StyleCollection styleCollection) {
        this.styles = styleCollection;
        this.styles.addChangeListener((PropertyChangeListener)this);
        for (int i = 0; i < this.styles.getNumberStyles(); ++i) {
            this.addItem(this.styles.getStyleAt(i));
        }
        this.setSelectedItem(this.styles.getCurrentStyle());
        this.setMaximumRowCount(5);
        this.setPreferredSize(new Dimension(175, 25));
        this.setBackground(Color.WHITE);
        this.defaultRenderer = new DefaultListCellRenderer();
        this.defaultRenderer.setFont(FontManager.getFont((String)Messages.getString("DialogFont.fnt"), (int)0, (int)12));
        this.defaultRenderer.putClientProperty(new StringBuffer("AATextPropertyKey"), Boolean.TRUE);
        this.stylePreview.setDrawMarkers(true);
        this.stylePreview.setDrawXAxisLabel(false);
        this.stylePreview.setDrawYAxisLabel(false);
        this.stylePreview.setUseStyleNameAsTitle(true);
        this.borderedPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.borderedPanel.add("Center", this.stylePreview);
        this.borderedPanel.setOpaque(true);
        this.setRenderer(this);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel defaultReturn = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (index < 0) {
            return defaultReturn;
        }
        this.borderedPanel.setBackground(defaultReturn.getBackground());
        if (value instanceof Style) {
            this.stylePreview.setStyle((Style)value);
        }
        this.borderedPanel.setPreferredSize(new Dimension(list.getWidth(), 100));
        return this.borderedPanel;
    }

    public void setSelectedStyleByName(String styleName) {
        if (styleName == null) {
            return;
        }
        Style s = this.styles.getStyle(styleName);
        if (s == null) {
            return;
        }
        this.setSelectedItem(s);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int i;
        if (evt.getSource() == this) {
            return;
        }
        String prop = evt.getPropertyName();
        ActionListener[] al = this.getActionListeners();
        ItemListener[] il = this.getItemListeners();
        for (i = 0; i < al.length; ++i) {
            this.removeActionListener(al[i]);
        }
        for (i = 0; i < il.length; ++i) {
            this.removeItemListener(il[i]);
        }
        if ("currentStyleChanged".equals(prop)) {
            this.setSelectedItem(this.styles.getCurrentStyle());
        } else if ("styleAdded".equals(prop) || "styleRemoved".equals(prop)) {
            this.removeAllItems();
            for (i = 0; i < this.styles.getNumberStyles(); ++i) {
                this.addItem(this.styles.getStyleAt(i));
            }
        }
        for (i = 0; i < al.length; ++i) {
            this.addActionListener(al[i]);
        }
        for (i = 0; i < il.length; ++i) {
            this.addItemListener(il[i]);
        }
    }

    public Style getSelectedStyle() {
        return (Style)this.getSelectedItem();
    }
}

