/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles.ui;

import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.styles.ui.DefaultStylePreview;
import com.sas.graphics.styles.ui.EditorPanel;
import com.sas.graphics.styles.ui.Messages;
import com.sas.graphics.styles.ui.StyleSelectorCombo;
import com.sas.graphics.util.FontManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class EditorDialog
extends JDialog
implements TableModelListener,
MouseListener,
PropertyChangeListener {
    private static final long serialVersionUID = 3222914322045126991L;
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JButton okButton = null;
    private JButton saveButton = null;
    private JPanel editorPanel = null;
    private JPanel jPanel1 = null;
    private JButton loadButton = null;
    private EditorPanel editorPanel1 = null;
    private StyleCollection styleCollection = null;
    private JPanel jPanel2 = null;
    private JPanel jPanel3 = null;
    private JLabel jLabel = null;
    private boolean showSaveButton = true;
    private boolean showLoadButton = true;
    private boolean showTopPane = false;
    private JFileChooser fileChooser = null;
    private JPanel jPanel4 = null;
    private JButton newButton = null;
    private JDialog newStyleDialog = null;
    private JPanel newStylePanel = null;
    private JPanel jPanel5 = null;
    private JLabel jLabel1 = null;
    private JTextField jTextField = null;
    private JPanel jPanel6 = null;
    private JRadioButton jRadioButton = null;
    private JRadioButton jRadioButton1 = null;
    private JComboBox jComboBox = null;
    private JPanel jPanel7 = null;
    private JPanel jPanel8 = null;
    private JPanel jPanel9 = null;
    private JButton jButton = null;
    private JButton jButton1 = null;
    private JPanel jPanel10 = null;
    private DefaultStylePreview defaultStylePreview = null;
    private JPanel jPanel11 = null;
    private StyleSelectorCombo styleSelectorCombo = null;

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        return this.fileChooser;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BoxLayout(this.jPanel, 0));
            this.jPanel.add((Component)this.getJPanel2(), null);
            this.jPanel.add((Component)this.getJPanel3(), null);
        }
        return this.jPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText(Messages.getString("EditorDialog.0.txt"));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditorDialog.this.setVisible(false);
                }
            });
            this.okButton.setFont(FontManager.getFont((String)"Arial", (int)0, (int)12));
        }
        return this.okButton;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton();
            this.saveButton.setText("");
            this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/com/sas/graphics/styles/ui/Save.gif")));
            this.saveButton.setToolTipText(Messages.getString("EditorDialog.4.txt"));
            this.saveButton.setMargin(new Insets(4, 4, 4, 4));
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int result = EditorDialog.this.getFileChooser().showSaveDialog(EditorDialog.this.saveButton);
                    if (result == 0) {
                        File f = EditorDialog.this.getFileChooser().getSelectedFile();
                        try {
                            FileOutputStream out = new FileOutputStream(f);
                            EditorDialog.this.styleCollection.getCurrentStyle().toOutputStream((OutputStream)out);
                            out.close();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            this.saveButton.setFont(FontManager.getFont((String)"Arial", (int)0, (int)12));
        }
        return this.saveButton;
    }

    private JPanel getEditorPanel() {
        if (this.editorPanel == null) {
            this.editorPanel = new JPanel();
            this.editorPanel.setLayout(new BorderLayout());
            this.editorPanel.add((Component)this.getEditorPanel1(), "Center");
        }
        return this.editorPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            FlowLayout flowLayout3 = new FlowLayout();
            flowLayout3.setAlignment(0);
            this.jLabel = new JLabel();
            this.jLabel.setText("Style: ");
            this.jLabel.setFont(FontManager.getFont((String)"Arial", (int)0, (int)12));
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(flowLayout3);
            this.jPanel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 3, 5));
            this.jPanel1.add((Component)this.jLabel, null);
            this.jPanel1.add((Component)this.getJPanel11(), null);
            this.jPanel1.add((Component)this.getJPanel4(), null);
        }
        return this.jPanel1;
    }

    private JButton getLoadButton() {
        if (this.loadButton == null) {
            this.loadButton = new JButton();
            this.loadButton.setText("");
            this.loadButton.setIcon(new ImageIcon(this.getClass().getResource("/com/sas/graphics/styles/ui/FolderOpen.gif")));
            this.loadButton.setToolTipText(Messages.getString("EditorDialog.11.txt"));
            this.loadButton.setMargin(new Insets(4, 4, 4, 4));
            this.loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int result = EditorDialog.this.getFileChooser().showOpenDialog(EditorDialog.this.loadButton);
                    if (result == 0) {
                        File f = EditorDialog.this.getFileChooser().getSelectedFile();
                        try {
                            Style s = Style.getStyle((InputStream)new FileInputStream(f));
                            EditorDialog.this.styleCollection.addStyle(s, (Object)f);
                            EditorDialog.this.styleSelectorCombo.setSelectedItem(s);
                        }
                        catch (Exception e1) {
                            JOptionPane.showMessageDialog(EditorDialog.this.loadButton, Messages.getString("EditorDialog.12.txt"), Messages.getString("EditorDialog.13.txt"), 0);
                        }
                    }
                }
            });
            this.loadButton.setFont(FontManager.getFont((String)"Arial", (int)0, (int)12));
        }
        return this.loadButton;
    }

    private EditorPanel getEditorPanel1() {
        if (this.editorPanel1 == null) {
            this.editorPanel1 = new EditorPanel();
        }
        return this.editorPanel1;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setAlignment(0);
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(flowLayout1);
        }
        return this.jPanel2;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(flowLayout);
            this.jPanel3.add((Component)this.getOkButton(), null);
        }
        return this.jPanel3;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jPanel4 = new JPanel();
            this.jPanel4.add((Component)this.getSaveButton(), null);
            this.jPanel4.add((Component)this.getLoadButton(), null);
            this.jPanel4.add((Component)this.getNewButton(), null);
        }
        return this.jPanel4;
    }

    private JButton getNewButton() {
        if (this.newButton == null) {
            this.newButton = new JButton();
            this.newButton.setIcon(new ImageIcon(this.getClass().getResource("/com/sas/graphics/styles/ui/New.gif")));
            this.newButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditorDialog.this.newStyle();
                }
            });
            this.newButton.setMargin(new Insets(4, 4, 4, 4));
        }
        return this.newButton;
    }

    private JDialog getNewStyleDialog() {
        if (this.newStyleDialog == null) {
            this.newStyleDialog = new JDialog(this);
            this.newStyleDialog.setSize(369, 193);
            this.newStyleDialog.setModal(true);
            this.newStyleDialog.setResizable(false);
            this.newStyleDialog.setTitle(Messages.getString("EditorDialog.16.txt"));
            this.newStyleDialog.setContentPane(this.getNewStylePanel());
            this.newStyleDialog.setLocationRelativeTo(this);
        }
        return this.newStyleDialog;
    }

    private JPanel getNewStylePanel() {
        if (this.newStylePanel == null) {
            this.newStylePanel = new JPanel();
            this.newStylePanel.setLayout(new BorderLayout());
            this.newStylePanel.add((Component)this.getJPanel5(), "North");
            this.newStylePanel.add((Component)this.getJPanel6(), "Center");
            this.newStylePanel.add((Component)this.getJPanel9(), "South");
        }
        return this.newStylePanel;
    }

    private JPanel getJPanel5() {
        if (this.jPanel5 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(Messages.getString("EditorDialog.17.txt"));
            this.jLabel1.setFont(FontManager.getFont((String)"Arial", (int)0, (int)12));
            this.jPanel5 = new JPanel();
            this.jPanel5.setLayout(new BorderLayout());
            this.jPanel5.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.jPanel5.add((Component)this.jLabel1, "West");
            this.jPanel5.add((Component)this.getJTextField(), "Center");
        }
        return this.jPanel5;
    }

    private JTextField getJTextField() {
        if (this.jTextField == null) {
            this.jTextField = new JTextField();
            this.jTextField.setText(Messages.getString("EditorDialog.19.txt"));
        }
        return this.jTextField;
    }

    private JPanel getJPanel6() {
        if (this.jPanel6 == null) {
            this.jPanel6 = new JPanel();
            this.jPanel6.setLayout(new BoxLayout(this.jPanel6, 1));
            this.jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 5));
            this.jPanel6.add((Component)this.getJRadioButton(), null);
            this.jPanel6.add((Component)this.getJRadioButton1(), null);
            this.jPanel6.add((Component)this.getJPanel7(), null);
        }
        return this.jPanel6;
    }

    private JRadioButton getJRadioButton() {
        if (this.jRadioButton == null) {
            this.jRadioButton = new JRadioButton();
            this.jRadioButton.setText(Messages.getString("EditorDialog.20.txt"));
            this.jRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    EditorDialog.this.getJComboBox().setEnabled(false);
                }
            });
            this.jRadioButton.setFont(FontManager.getFont((String)"Arial", (int)0, (int)12));
        }
        return this.jRadioButton;
    }

    private JRadioButton getJRadioButton1() {
        if (this.jRadioButton1 == null) {
            this.jRadioButton1 = new JRadioButton();
            this.jRadioButton1.setText(Messages.getString("EditorDialog.22.txt"));
            this.jRadioButton1.setSelected(true);
            this.jRadioButton1.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    EditorDialog.this.getJComboBox().setEnabled(true);
                }
            });
            this.jRadioButton1.setFont(FontManager.getFont((String)"Arial", (int)0, (int)12));
        }
        return this.jRadioButton1;
    }

    private JComboBox getJComboBox() {
        if (this.jComboBox == null) {
            this.jComboBox = new JComboBox();
            this.jComboBox.setMaximumSize(new Dimension(350, 25));
            this.jComboBox.setFont(FontManager.getFont((String)"Arial", (int)0, (int)12));
            this.jComboBox.setBackground(Color.white);
        }
        return this.jComboBox;
    }

    private JPanel getJPanel7() {
        if (this.jPanel7 == null) {
            this.jPanel7 = new JPanel();
            this.jPanel7.setLayout(new BoxLayout(this.jPanel7, 0));
            this.jPanel7.add((Component)this.getJPanel8(), null);
            this.jPanel7.add((Component)this.getJComboBox(), null);
        }
        return this.jPanel7;
    }

    private JPanel getJPanel8() {
        if (this.jPanel8 == null) {
            this.jPanel8 = new JPanel();
            this.jPanel8.setMaximumSize(new Dimension(100, 25));
            this.jPanel8.setPreferredSize(new Dimension(100, 25));
        }
        return this.jPanel8;
    }

    private JPanel getJPanel9() {
        if (this.jPanel9 == null) {
            FlowLayout flowLayout2 = new FlowLayout();
            flowLayout2.setAlignment(2);
            this.jPanel9 = new JPanel();
            this.jPanel9.setLayout(flowLayout2);
            this.jPanel9.add((Component)this.getJButton(), null);
            this.jPanel9.add((Component)this.getJButton1(), null);
        }
        return this.jPanel9;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText(Messages.getString("EditorDialog.0.txt"));
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String name = EditorDialog.this.getJTextField().getText();
                    if (name == null || name.trim().length() == 0) {
                        JOptionPane.showMessageDialog(EditorDialog.this.jButton, Messages.getString("EditorDialog.26.txt"), Messages.getString("EditorDialog.27.txt"), 0);
                        return;
                    }
                    Style style = null;
                    if (EditorDialog.this.getJRadioButton().isSelected()) {
                        style = new Style(name);
                    } else if (EditorDialog.this.getJRadioButton1().isSelected()) {
                        style = new Style(EditorDialog.this.styleCollection.getStyle(EditorDialog.this.jComboBox.getSelectedItem().toString().toUpperCase()));
                        style.setSchemeName(name);
                    }
                    EditorDialog.this.styleCollection.addStyle(style);
                    EditorDialog.this.getStyleSelectorCombo().setSelectedItem(style);
                    EditorDialog.this.getNewStyleDialog().setVisible(false);
                }
            });
        }
        return this.jButton;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setText(Messages.getString("EditorDialog.28.txt"));
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditorDialog.this.getNewStyleDialog().setVisible(false);
                }
            });
        }
        return this.jButton1;
    }

    private JPanel getJPanel10() {
        if (this.jPanel10 == null) {
            this.jPanel10 = new JPanel();
            this.jPanel10.setLayout(new BorderLayout());
            this.jPanel10.add((Component)this.getDefaultStylePreview(), "Center");
        }
        return this.jPanel10;
    }

    private DefaultStylePreview getDefaultStylePreview() {
        if (this.defaultStylePreview == null) {
            this.defaultStylePreview = new DefaultStylePreview();
            this.defaultStylePreview.setRampPreviewVisible(false);
        }
        return this.defaultStylePreview;
    }

    private JPanel getJPanel11() {
        if (this.jPanel11 == null) {
            this.jPanel11 = new JPanel();
            this.jPanel11.setLayout(new BorderLayout());
            this.jPanel11.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.jPanel11.setPreferredSize(new Dimension(250, 45));
            this.jPanel11.add((Component)this.getStyleSelectorCombo(), "Center");
        }
        return this.jPanel11;
    }

    public StyleSelectorCombo getStyleSelectorCombo() {
        if (this.styleSelectorCombo == null) {
            this.styleSelectorCombo = new StyleSelectorCombo(this.styleCollection);
            this.styleSelectorCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    EditorDialog.this.setStyle(EditorDialog.this.styleSelectorCombo.getSelectedItem());
                }
            });
        }
        return this.styleSelectorCombo;
    }

    public static void main(String[] args) {
        EditorDialog ed = new EditorDialog();
        ed.setDefaultCloseOperation(3);
        ed.setVisible(true);
    }

    public EditorDialog() {
        this(new StyleCollection(true));
    }

    public EditorDialog(StyleCollection collection) {
        this.init(collection);
    }

    public EditorDialog(StyleCollection collection, Frame frame) {
        super(frame);
        this.init(collection);
    }

    public EditorDialog(StyleCollection collection, Dialog frame) {
        super(frame);
        this.init(collection);
    }

    private void init(StyleCollection collection) {
        this.styleCollection = collection;
        this.styleCollection.addChangeListener((PropertyChangeListener)this);
        this.initialize();
        this.setLocationRelativeTo(null);
        this.setStyle(this.styleCollection.getCurrentStyle());
    }

    private void initialize() {
        this.setSize(600, 400);
        this.setModal(true);
        this.setContentPane(this.getJContentPane());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.getJRadioButton());
        bg.add(this.getJRadioButton1());
        this.defaultStylePreview.getBarPreview().addMouseListener(this);
        this.defaultStylePreview.getHistogramPreview().addMouseListener(this);
        this.defaultStylePreview.getRampPreview().addMouseListener(this);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel(), "South");
            this.jContentPane.add((Component)this.getEditorPanel(), "West");
            this.jContentPane.add((Component)this.getJPanel10(), "Center");
            if (this.showTopPane) {
                this.jContentPane.add((Component)this.getJPanel1(), "North");
            }
        }
        return this.jContentPane;
    }

    private void setStyle(Object style) {
        if (style == null) {
            return;
        }
        this.defaultStylePreview.setStyle((Style)this.getStyleSelectorCombo().getSelectedItem());
        this.editorPanel1.setStyle((Style)this.getStyleSelectorCombo().getSelectedItem());
        this.repaint();
    }

    @Override
    public void tableChanged(TableModelEvent arg0) {
        if (this.defaultStylePreview != null) {
            this.defaultStylePreview.repaint();
        }
    }

    public boolean isShowLoadButton() {
        return this.showLoadButton;
    }

    public void setShowLoadButton(boolean showLoadButton) {
        this.showLoadButton = showLoadButton;
        if (showLoadButton) {
            this.jPanel4.add((Component)this.getLoadButton(), null);
        } else {
            this.jPanel4.remove(this.getLoadButton());
        }
        this.jPanel4.revalidate();
    }

    public boolean isShowSaveButton() {
        return this.showSaveButton;
    }

    public void setShowSaveButton(boolean showSaveButton) {
        this.showSaveButton = showSaveButton;
        if (showSaveButton) {
            this.jPanel4.add((Component)this.getSaveButton(), null);
        } else {
            this.jPanel4.remove(this.getSaveButton());
        }
        this.jPanel4.revalidate();
    }

    private void newStyle() {
        this.getJComboBox().removeAllItems();
        for (int i = 0; i < this.styleCollection.getNumberStyles(); ++i) {
            this.getJComboBox().addItem(this.styleCollection.getStyleAt(i));
        }
        this.getNewStyleDialog().setVisible(true);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        Component c = arg0.getComponent();
        if (!(c instanceof JComponent)) {
            return;
        }
        String s = ((JComponent)c).getToolTipText(arg0);
        if (s == null) {
            return;
        }
        this.editorPanel1.setElement(s);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.styleSelectorCombo.setSelectedItem(this.styleCollection.getCurrentStyle());
    }
}

