/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles.ui;

import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.LineStyleElement;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.styles.ui.AbstractStylePreview;
import com.sas.graphics.styles.ui.Messages;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.SASLinePatterns;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class DefaultBarPreview
extends AbstractStylePreview {
    private static final long serialVersionUID = 1L;
    Rectangle wallRect = new Rectangle();
    Rectangle[] bars = null;
    Rectangle titleRect = new Rectangle();
    Rectangle yAxisRect = new Rectangle();
    Rectangle xAxisRect = new Rectangle();
    private static double[] barValues = new double[]{0.75, 0.5, 0.65, 0.25, 0.74, 0.35, 0.46, 0.69, 0.75, 0.64, 0.21, 0.45};

    @Override
    public String getStyleElementAt(Point arg0) {
        if (this.bars != null) {
            for (int i = 0; i < this.bars.length; ++i) {
                if (this.bars[i] == null || !this.bars[i].contains(arg0)) continue;
                return "GraphDataStyle" + (i + 1);
            }
        }
        if (this.wallRect != null && this.wallRect.contains(arg0)) {
            return "WallFill";
        }
        if (this.titleRect != null && this.titleRect.contains(arg0)) {
            return "TitleText";
        }
        if (this.xAxisRect != null && this.xAxisRect.contains(arg0)) {
            return "LabelText";
        }
        if (this.yAxisRect != null && this.yAxisRect.contains(arg0)) {
            return "LabelText";
        }
        return "Backfill";
    }

    @Override
    protected void paintComponent(Graphics g) {
        int fontSize;
        if (this.style == null) {
            return;
        }
        StyleElement se = null;
        BasicStroke selStroke = SASLinePatterns.getStroke((int)2, (int)1);
        Stroke defStroke = ((Graphics2D)g).getStroke();
        se = this.style.getStyleElement("Backfill");
        if (se != null) {
            FillStyleElement bg = se.getAsFillStyle();
            g.setColor(bg.getFillColor());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.rolloverEnabled && "Backfill".equalsIgnoreCase(this.highlightArea)) {
            g.setColor(Color.black);
            ((Graphics2D)g).setStroke(selStroke);
            g.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            ((Graphics2D)g).setStroke(defStroke);
        }
        Rectangle r = new Rectangle(5, 5, this.getWidth() - 10, this.getHeight() - 10);
        se = this.style.getStyleElement("TitleText");
        if (se != null) {
            TextStyleElement title = se.getAsTextStyle();
            g.setColor(title.getTextColor());
            fontSize = title.getFontSize().getSizeValue();
            g.setFont(FontManager.getFont((String)title.getFontFamily(), (int)(title.getFontWeight() + title.getFontStyle()), (int)fontSize));
            Rectangle2D bounds = g.getFont().getStringBounds(Messages.getString("DefaultStylePreview.11.txt"), ((Graphics2D)g).getFontRenderContext());
            this.titleRect.setBounds(r.x + r.width / 2 - (int)(bounds.getWidth() / 2.0), r.y, (int)bounds.getWidth(), (int)bounds.getHeight());
            g.drawString(Messages.getString("DefaultStylePreview.11.txt"), (int)this.titleRect.getX(), r.y + fontSize);
            r.y += 10 + fontSize;
            r.height -= 10 + fontSize;
        }
        if (this.rolloverEnabled && "TitleText".equalsIgnoreCase(this.highlightArea)) {
            g.setColor(Color.black);
            ((Graphics2D)g).setStroke(selStroke);
            g.drawRect(this.titleRect.x, this.titleRect.y, this.titleRect.width, this.titleRect.height);
            ((Graphics2D)g).setStroke(defStroke);
        }
        if ((se = this.style.getStyleElement("LabelText")) != null) {
            TextStyleElement axisText = se.getAsTextStyle();
            g.setColor(axisText.getTextColor());
            fontSize = axisText.getFontSize().getSizeValue();
            g.setFont(FontManager.getFont((String)axisText.getFontFamily(), (int)(axisText.getFontStyle() + axisText.getFontWeight()), (int)fontSize));
            Rectangle2D rect = g.getFont().getStringBounds(Messages.getString("DefaultStylePreview.13.txt"), ((Graphics2D)g).getFontRenderContext());
            if (this.rolloverEnabled && "LabelText".equalsIgnoreCase(this.highlightArea)) {
                g.setColor(Color.black);
                ((Graphics2D)g).setStroke(selStroke);
                g.drawRect(r.x + r.width / 2 - (int)rect.getWidth() / 2, r.y + r.height - (int)rect.getHeight(), (int)rect.getWidth(), (int)rect.getHeight());
                ((Graphics2D)g).setStroke(defStroke);
            }
            g.drawString(Messages.getString("DefaultStylePreview.13.txt"), r.x + r.width / 2 - (int)rect.getWidth() / 2, r.y + r.height);
            r.height -= 10 + fontSize;
            rect = g.getFont().getStringBounds(Messages.getString("DefaultStylePreview.15.txt"), ((Graphics2D)g).getFontRenderContext());
            ((Graphics2D)g).rotate(-1.5707963267948966, r.x + (int)rect.getHeight(), r.y + r.height / 2 + (int)rect.getWidth() / 2);
            g.drawString(Messages.getString("DefaultStylePreview.15.txt"), r.x + (int)rect.getHeight(), r.y + r.height / 2 + (int)rect.getWidth() / 2);
            if (this.rolloverEnabled && "LabelText".equalsIgnoreCase(this.highlightArea)) {
                g.setColor(Color.black);
                ((Graphics2D)g).setStroke(selStroke);
                g.drawRect(r.x + (int)rect.getHeight(), r.y + r.height / 2 + (int)rect.getWidth() / 2 - (int)rect.getHeight(), (int)rect.getWidth(), (int)rect.getHeight());
                ((Graphics2D)g).setStroke(defStroke);
            }
            ((Graphics2D)g).rotate(1.5707963267948966, r.x + (int)rect.getHeight(), r.y + r.height / 2 + (int)rect.getWidth() / 2);
            r.x += fontSize + 10;
            r.width -= fontSize + 10;
            this.yAxisRect.setBounds(0, r.y, r.x, r.height);
            this.xAxisRect.setBounds(r.x, r.y + r.height, r.width, this.getHeight() - (r.y + r.height));
        }
        if ((se = this.style.getStyleElement("WallFill")) != null) {
            FillStyleElement wall = se.getAsFillStyle();
            g.setColor(wall.getFillColor());
            g.fillRect(r.x, r.y, r.width, r.height);
            this.wallRect.setBounds(r.x, r.y, r.width, r.height);
            if (this.rolloverEnabled && "WallFill".equalsIgnoreCase(this.highlightArea)) {
                g.setColor(Color.black);
                ((Graphics2D)g).setStroke(selStroke);
                g.drawRect(this.wallRect.x + 2, this.wallRect.y + 2, this.wallRect.width - 4, this.wallRect.height - 4);
                ((Graphics2D)g).setStroke(defStroke);
            }
            if (wall.getBooleanAttribute("frameBorder", false)) {
                Stroke s = g instanceof Graphics2D ? ((Graphics2D)g).getStroke() : null;
                LineStyleElement lse = wall.getAsLineStyle();
                if (g instanceof Graphics2D) {
                    ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)lse.getLineStyle(), (int)lse.getLineThickness().getSizeValue()));
                }
                g.setColor(lse.getLineColor());
                g.drawLine(r.x, r.y, r.x + r.width, r.y);
                g.drawLine(r.x + r.width, r.y, r.x + r.width, r.y + r.height);
                if (g instanceof Graphics2D) {
                    ((Graphics2D)g).setStroke(s);
                }
            }
        }
        if ((se = this.style.getStyleElement("AxisLines")) != null) {
            Stroke s = g instanceof Graphics2D ? ((Graphics2D)g).getStroke() : null;
            LineStyleElement axisLine = se.getAsLineStyle();
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)axisLine.getLineStyle(), (int)axisLine.getLineThickness().getSizeValue()));
            }
            g.setColor(axisLine.getLineColor());
            g.drawLine(r.x, r.y, r.x, r.y + r.height);
            g.drawLine(r.x, r.y + r.height, r.x + r.width, r.y + r.height);
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setStroke(s);
            }
        }
        Color[] colors = this.style.getDataFillColors();
        Color[] contrastColors = this.style.getDataLineColors();
        int[] markers = this.style.getDataMarkerSymbols();
        Color outlineColor = Color.BLACK;
        se = this.style.getStyleElement("Outlines");
        if (se != null) {
            outlineColor = se.getAsLineStyle().getLineColor();
        }
        if (colors != null && colors.length > 0) {
            this.bars = new Rectangle[colors.length];
            int width = (r.width - 10 - 3 * colors.length) / colors.length;
            int x = r.x + 5;
            for (int i = 0; i < colors.length; ++i) {
                int height = (int)((double)(r.height - 5) * barValues[i % barValues.length]);
                g.setColor(colors[i]);
                g.fillRect(x, r.y + (r.height - height), width, height);
                this.bars[i] = new Rectangle(x, r.y + (r.height - height), width, height);
                String data = "GraphDataStyle" + (i + 1);
                if (this.rolloverEnabled && data.equalsIgnoreCase(this.highlightArea)) {
                    g.setColor(Color.black);
                    ((Graphics2D)g).setStroke(selStroke);
                    g.drawRect(x + 2, r.y + (r.height - height) + 2, width - 4, height - 4);
                    ((Graphics2D)g).setStroke(defStroke);
                }
                if (outlineColor != null) {
                    g.setColor(outlineColor);
                    g.drawRect(x, r.y + (r.height - height), width, height);
                }
                if (markers != null && markers.length > i) {
                    Markers.draw((Graphics)g, (Color)contrastColors[i], null, (int)markers[i], (int)10, (int)(x + width / 2), (int)(r.y + 10));
                    Markers.draw((Graphics)g, (Color)contrastColors[i], null, (int)markers[i], (int)10, (int)(x + width / 2), (int)(r.y + (r.height - height) + 10));
                }
                x += width + 3;
            }
        }
    }
}

