/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.data;

import com.sas.graphics.data.AbstractDataFilter;
import com.sas.graphics.data.CustomModelManagerInterface;
import com.sas.graphics.data.IOBSInterface;
import com.sas.graphics.data.UniqueValueInterface;
import com.sas.graphics.silk.data.SelectionIterator;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterUpdateInterface;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.RangeInfoModel;
import com.sas.graphics.util.Search;
import com.sas.sg.datamodel.DataModel;
import com.sas.sg.datamodel.DataModelEvent;
import com.sas.sg.datamodel.DataModelListener;
import com.sas.sg.datamodel.DataPropertyModel;
import com.sas.sg.datamodel.ObsDataEvent;
import com.sas.sg.datamodel.ObsPropertyEvent;
import com.sas.sg.datamodel.ObsPropertyListener;
import com.sas.sg.datamodel.ObsPropertyModel;
import com.sas.sg.datamodel.ValueDataEvent;
import com.sas.sg.datamodel.VarDataEvent;
import com.sas.sg.datamodel.impl.SgObsBooleanProp;
import com.sas.sg.datamodel.impl.SgObsIntegerProp;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Timer;

public class SGDataFilter
extends AbstractDataFilter
implements DataFilterUpdateInterface,
DataFilterInfoInterface,
DataModelListener,
CustomModelManagerInterface,
UniqueValueInterface {
    protected boolean holdEvents = false;
    protected boolean shortCutSelection = false;
    protected boolean shortCutGraph = false;
    protected boolean shortCutColor = false;
    protected DataModel model;
    protected SelectionListener selections;
    protected SelectionListener graphs;
    protected SelectionListener colors;
    protected ObsPropertyModel selectionModel = null;
    protected ObsPropertyModel graphedModel = null;
    protected ObsPropertyModel colorModel = null;
    protected SILKBooleanObsPropertyModel mirrorSelectionModel = null;
    protected UniqueValuePropertyModel uniqueValueModel = null;
    protected int[] remappedObsIndicies;
    protected static final String obsSelectName = "Obs Selection";
    protected static final String obsGraphName = "Obs Graphed";
    protected static final String obsColorName = "Obs Color";
    protected static final String mirrorSelectName = "SILK Obs Selection";
    protected static final String uniqueValueModelName = "SILK Unique Value Model";
    protected Hashtable variableIndices = new Hashtable();
    public static final int BATCH_EVENTS_NONE = 0;
    public static final int BATCH_EVENTS_TIME_INTERVAL_AND_OBSERVATION_BOUNDARY = 2;
    private static int eventBatching = 0;
    private static String EVENT_BATCH_TIME_INTERVAL = "EVENT_BATCH_TIME_INTERVAL";
    private static int minEventTime_forLastObsUpdate = 250;
    private DataModelEventAccumulator dmea = new DataModelEventAccumulator(minEventTime_forLastObsUpdate);
    private Timer dataModelEventTimer = new Timer(100, this.dmea);
    private int obsInsertedIndex = -1;
    private boolean pendingEvents = false;
    private static int minEventTime_forAnyObsUpdate = 1000;

    public SGDataFilter(Object modelIn, Locale localeIn) {
        this.subsetted = false;
        this.subsetList = null;
        this.rangeInfoModel = new RangeInfoModel(this);
        this.remappedObsIndicies = null;
        this.selections = new SelectionListener(0);
        this.graphs = new SelectionListener(1);
        this.colors = new SelectionListener(2);
        this.setSource(modelIn, localeIn);
    }

    public SGDataFilter() {
        this(null, null);
    }

    protected int getVariableIdIndex(Object id) {
        String varId;
        if (this.model == null || id == null) {
            return -1;
        }
        if (this.variableIndices.size() == 0) {
            for (int i = 0; i < this.getNumberVariables(); ++i) {
                this.variableIndices.put(this.getVariableId(i).toString().toUpperCase(), i);
            }
        }
        if (!this.variableIndices.containsKey(varId = id.toString().toUpperCase())) {
            return -1;
        }
        return ((Number)this.variableIndices.get(varId)).intValue();
    }

    protected String getFormattedValueByIndex(int idx, Object value, Object format) {
        if (value == null) {
            return null;
        }
        if (format == null) {
            Object fv;
            if (this.uniqueValueModel == null) {
                return null;
            }
            LinkedHashMap fvvl = this.uniqueValueModel.getFormattedValues(this.getVariableId(idx));
            if (fvvl != null && (fv = fvvl.get(value)) != null) {
                return fv.toString();
            }
        }
        return this.computeFormattedValueByIndex(idx, value, format);
    }

    @Override
    public Object getSource() {
        return this.model;
    }

    @Override
    public boolean setSource(Object source) {
        DataModel oldModel = this.model;
        ObsPropertyModel oldSelectionModel = this.selectionModel;
        ObsPropertyModel oldGraphedModel = this.graphedModel;
        ObsPropertyModel oldColorModel = this.colorModel;
        if (source == null || !(source instanceof DataModel)) {
            return false;
        }
        this.model = (DataModel)source;
        this.selectionModel = this.model.getObsPropertyModel(obsSelectName);
        if (this.selectionModel != null) {
            this.shortCutSelection = this.selectionModel instanceof SgObsBooleanProp;
        }
        if (!this.model.isCustomPropertyModelExist(uniqueValueModelName)) {
            this.uniqueValueModel = new UniqueValuePropertyModel(this.model);
            this.model.addCustomPropertyModel(uniqueValueModelName, (DataPropertyModel)this.uniqueValueModel);
            SGDataFilter uvmFilter = new SGDataFilter();
            uvmFilter.setSource(this.getSource());
            this.uniqueValueModel.setFilter(uvmFilter);
        } else {
            this.uniqueValueModel = (UniqueValuePropertyModel)this.model.getCustomPropertyModel(uniqueValueModelName);
        }
        if (this.rangeInfoModel != null) {
            this.rangeInfoModel.invalidate();
        }
        if ((this.mirrorSelectionModel = (SILKBooleanObsPropertyModel)this.model.getCustomPropertyModel(mirrorSelectName)) == null) {
            this.mirrorSelectionModel = new SILKBooleanObsPropertyModel(this.model);
            this.model.addCustomPropertyModel(mirrorSelectName, (DataPropertyModel)this.mirrorSelectionModel);
        }
        if ((this.graphedModel = this.model.getObsPropertyModel(obsGraphName)) != null) {
            this.shortCutGraph = this.graphedModel instanceof SgObsBooleanProp;
        }
        if (this.variableIndices != null) {
            this.variableIndices.clear();
        }
        for (int i = 0; i < this.getNumberObservations(-1); ++i) {
            if (this.isSelected(i)) {
                this.localSelectionModel.set(i);
            } else {
                this.localSelectionModel.clear(i);
            }
            if (this.isGraphed(i)) {
                this.localGraphedModel.set(i);
                continue;
            }
            this.localGraphedModel.clear(i);
        }
        this.colorModel = this.model.getObsPropertyModel(obsColorName);
        if (this.colorModel != null) {
            this.shortCutColor = this.colorModel instanceof SgObsIntegerProp;
        }
        if (this.listeners.getListenerCount(DataFilterListenerInterface.class) > 0) {
            if (oldModel != null) {
                oldModel.removeDataModelListener((DataModelListener)this);
            }
            if (oldSelectionModel != null) {
                oldSelectionModel.removeObsPropertyListener((ObsPropertyListener)this.selections);
            }
            if (oldGraphedModel != null) {
                oldGraphedModel.removeObsPropertyListener((ObsPropertyListener)this.graphs);
            }
            if (oldColorModel != null) {
                oldColorModel.removeObsPropertyListener((ObsPropertyListener)this.colors);
            }
            this.model.addDataModelListener((DataModelListener)this);
            if (this.selectionModel != null) {
                this.selectionModel.addObsPropertyListener((ObsPropertyListener)this.selections);
            }
            if (this.graphedModel != null) {
                this.graphedModel.addObsPropertyListener((ObsPropertyListener)this.graphs);
            }
            if (this.colorModel != null) {
                this.colorModel.addObsPropertyListener((ObsPropertyListener)this.colors);
            }
        }
        this.setSubsetList(null);
        this.throwEvent(1, -1, -1, -1, -1, oldModel, this.model, false);
        return true;
    }

    @Override
    public boolean removeSource() {
        DataModel oldModel = this.model;
        if (this.model == null) {
            return false;
        }
        if (this.listeners.getListenerCount(DataFilterListenerInterface.class) > 0) {
            this.model.removeDataModelListener((DataModelListener)this);
            if (this.selectionModel != null) {
                this.selectionModel.removeObsPropertyListener((ObsPropertyListener)this.selections);
            }
            if (this.graphedModel != null) {
                this.graphedModel.removeObsPropertyListener((ObsPropertyListener)this.graphs);
            }
            if (this.colorModel != null) {
                this.colorModel.removeObsPropertyListener((ObsPropertyListener)this.colors);
            }
        }
        this.setSubsetList(null);
        this.selections = null;
        this.graphs = null;
        this.colors = null;
        this.model = null;
        this.selectionModel = null;
        this.mirrorSelectionModel = null;
        this.uniqueValueModel = null;
        this.remappedObsIndicies = null;
        this.graphedModel = null;
        this.colorModel = null;
        if (this.variableIndices != null) {
            this.variableIndices.clear();
        }
        this.variableIndices = null;
        this.throwEvent(1, -1, -1, -1, -1, oldModel, null, false);
        super.removeSource();
        return true;
    }

    @Override
    public int getNumberVariables() {
        if (this.model == null) {
            return 0;
        }
        return this.model.getNumVars();
    }

    @Override
    public boolean verifyVariable(Object id) {
        if (this.model == null) {
            return false;
        }
        return this.getVariableIdIndex(id) >= 0;
    }

    @Override
    public Object getVariableId(int idx) {
        int n = this.getNumberVariables();
        if (this.model == null || idx < 0 || idx >= n) {
            return null;
        }
        return this.model.getVarName(idx);
    }

    @Override
    public int getVariableIndex(Object id) {
        return this.getVariableIdIndex(id);
    }

    @Override
    public Object getVariableDescription(int idx) {
        String s2;
        String s = null;
        if (this.model == null || idx < 0) {
            return null;
        }
        s = this.model.getVarLabel(idx);
        if (s == null || s.length() <= 0) {
            s = this.model.getVarName(idx);
        }
        if ((s2 = s.trim()) != null && s2.length() <= 0) {
            return this.model.getVarName(idx);
        }
        return s;
    }

    @Override
    public Class getVariableClass(int idx) {
        if (this.model == null) {
            return Object.class;
        }
        if (idx < 0 || idx >= this.getNumberVariables()) {
            return Object.class;
        }
        if (this.model.isVarNumeric(idx)) {
            return Double.class;
        }
        if (this.model.isVarCharacter(idx)) {
            return String.class;
        }
        return Object.class;
    }

    @Override
    public int getNumberObservations(int idx) {
        if (this.model == null) {
            return 0;
        }
        if (this.subsetted) {
            if (this.subsetList == null) {
                return 0;
            }
            return this.subsetList.length;
        }
        return this.model.getNumObs();
    }

    @Override
    public boolean isMissing(int idx, Object value) {
        if (this.model == null || value == null || idx < 0) {
            return true;
        }
        return value.equals(this.model.getVarMissingValue(idx));
    }

    @Override
    public Object getValue(int idx, long iobs) {
        int nobs = this.getNumberObservations(null);
        int nvars = this.getNumberVariables();
        if (idx < 0 || idx >= nvars || iobs < 0L || iobs >= (long)nobs) {
            return null;
        }
        if (this.subsetList != null) {
            iobs = this.subsetList[(int)iobs];
        }
        return this.model.getValue(idx, (int)iobs);
    }

    @Override
    public boolean isNumericVariable(int idx) {
        if (this.model == null || idx < 0) {
            return false;
        }
        return this.model.isVarNumeric(idx);
    }

    @Override
    public double getNumericValue(int idx, long iobs) {
        if (idx < 0 || iobs < 0L) {
            return Double.NaN;
        }
        if (this.subsetted) {
            if (this.subsetList == null) {
                return Double.NaN;
            }
            iobs = this.subsetList[(int)iobs];
        }
        return this.model.getDoubleValue(idx, (int)iobs);
    }

    @Override
    public int getRowValues(long iobs, Object[] outValues) {
        return -1;
    }

    @Override
    public Object getFormat(Object variableId, Class returnType) {
        int idx = this.getVariableIdIndex(variableId);
        if (this.model == null || idx < 0 || idx >= this.model.getNumVars()) {
            return null;
        }
        Object fmt = this.model.getVarFormat(idx);
        if (fmt == null || fmt instanceof String && ((String)fmt).length() <= 0) {
            return null;
        }
        if (returnType == null) {
            return fmt;
        }
        if (fmt instanceof String) {
            if (returnType == String.class) {
                return fmt;
            }
            if (returnType == SASFormat.class) {
                return SASFormat.getInstance((String)((String)fmt));
            }
        } else if (fmt instanceof SASFormat) {
            if (returnType == String.class) {
                return ((SASFormat)fmt).getName();
            }
            if (returnType == SASFormat.class) {
                return fmt;
            }
        }
        return null;
    }

    @Override
    public String getFormattedValue(Object variableId, Object value, Object format) {
        return this.getFormattedValueByIndex(this.getVariableIdIndex(variableId), value, format);
    }

    @Override
    public boolean isSelected(long iobs) {
        if (!this.isGraphed(iobs) && !FilterFactory.areCroppedObservationsSelectable()) {
            return false;
        }
        if (this.localSelections) {
            if (this.subsetList != null && this.subsetList.length > 0) {
                iobs = this.subsetList[(int)iobs];
            }
            return this.localSelectionModel.get((int)iobs);
        }
        if (this.selectionModel == null) {
            return false;
        }
        if (this.subsetList != null && this.subsetList.length > 0) {
            iobs = this.subsetList[(int)iobs];
        }
        if (this.shortCutSelection) {
            return ((SgObsBooleanProp)this.selectionModel).get((int)iobs);
        }
        Object o = this.selectionModel.getValue((int)iobs);
        if (o == null) {
            return false;
        }
        if (!(o instanceof Boolean)) {
            return false;
        }
        return (Boolean)o;
    }

    @Override
    public void setSelected(long iobs, boolean selected) {
        int obs;
        if (!this.isGraphed(iobs) && !FilterFactory.areCroppedObservationsSelectable()) {
            return;
        }
        int n = obs = this.subsetList == null ? (int)iobs : this.subsetList[(int)iobs];
        if (selected) {
            this.localSelectionModel.set(obs);
        } else {
            this.localSelectionModel.clear(obs);
        }
        if (this.localSelections) {
            SelectionIterator si = new SelectionIterator(this.localSelectionModel, this);
            int[] outList = new int[si.cardinality()];
            for (int i = 0; i < outList.length; ++i) {
                outList[i] = si.nextSelectedIndex();
            }
            this.throwEvent(2, 0, this.getNumberVariables() - 1, -1, -1, outList, new Integer(outList.length), false);
        }
        if (this.selectionModel == null || this.localSelections) {
            return;
        }
        if (this.shortCutSelection) {
            if (selected) {
                ((SgObsBooleanProp)this.selectionModel).set(obs);
            } else {
                ((SgObsBooleanProp)this.selectionModel).clear(obs);
            }
        } else {
            this.selectionModel.setValue(obs, (Object)new Boolean(selected));
        }
    }

    @Override
    public void setSelected(Object list, boolean selected, IOBSInterface operator) {
        this.setSelected(list, selected ? 1 : 2, operator);
    }

    @Override
    public void setSelected(Object list, int state, IOBSInterface operator) {
        int i;
        ArrayList<Boolean> values = null;
        int type = Extract.getSourceType(list);
        int n = Extract.getNumberItems(list, type);
        if (n <= 0) {
            return;
        }
        int[] obsList = new int[n];
        if (obsList == null) {
            return;
        }
        if (!this.shortCutSelection && (values = new ArrayList<Boolean>()) == null) {
            return;
        }
        for (i = 0; i < n; ++i) {
            obsList[i] = operator != null ? (int)operator.getObservationIndex(Extract.getObject(list, i, type)) : Extract.getInteger(list, i, type);
            boolean selected = false;
            switch (state) {
                case 1: {
                    selected = true;
                    break;
                }
                case 2: {
                    selected = false;
                    break;
                }
                case 3: {
                    boolean bl = selected = !this.isSelected(obsList[i]);
                }
            }
            if (this.shortCutSelection || !this.isGraphed(obsList[i]) && !FilterFactory.areCroppedObservationsSelectable()) continue;
            values.add(new Boolean(selected));
        }
        block21: for (i = 0; i < n; ++i) {
            if (!this.isGraphed(obsList[i]) && !FilterFactory.areCroppedObservationsSelectable()) continue;
            int obs = this.subsetList == null ? obsList[i] : this.subsetList[obsList[i]];
            switch (state) {
                case 1: {
                    this.localSelectionModel.set(obs);
                    continue block21;
                }
                case 2: {
                    this.localSelectionModel.clear(obs);
                    continue block21;
                }
                case 3: {
                    this.localSelectionModel.flip(obs);
                }
            }
        }
        if (this.localSelections) {
            SelectionIterator si = new SelectionIterator(this.localSelectionModel, this);
            int[] outList = new int[si.cardinality()];
            for (i = 0; i < outList.length; ++i) {
                outList[i] = si.nextSelectedIndex();
            }
            this.throwEvent(2, 0, this.getNumberVariables() - 1, -1, -1, outList, new Integer(outList.length), false);
        }
        if (this.selectionModel == null || this.localSelections) {
            return;
        }
        if (this.shortCutSelection) {
            if (FilterFactory.areCroppedObservationsSelectable()) {
                if (this.subsetList != null) {
                    for (i = 0; i < n; ++i) {
                        obsList[i] = this.subsetList[obsList[i]];
                    }
                }
                switch (state) {
                    case 1: {
                        ((SgObsBooleanProp)this.selectionModel).set(obsList);
                        break;
                    }
                    case 2: {
                        ((SgObsBooleanProp)this.selectionModel).clear(obsList);
                        break;
                    }
                    case 3: {
                        ((SgObsBooleanProp)this.selectionModel).toggle(obsList);
                    }
                }
            } else {
                Vector<Integer> graphedObs = new Vector<Integer>();
                for (i = 0; i < n; ++i) {
                    if (!this.isGraphed(obsList[i])) continue;
                    if (this.subsetList != null) {
                        graphedObs.add(this.subsetList[obsList[i]]);
                        continue;
                    }
                    graphedObs.add(obsList[i]);
                }
                if (graphedObs.size() > 0) {
                    int[] graphedObsList = new int[graphedObs.size()];
                    for (i = 0; i < graphedObs.size(); ++i) {
                        graphedObsList[i] = ((Number)graphedObs.elementAt(i)).intValue();
                    }
                    switch (state) {
                        case 1: {
                            ((SgObsBooleanProp)this.selectionModel).set(graphedObsList);
                            break;
                        }
                        case 2: {
                            ((SgObsBooleanProp)this.selectionModel).clear(graphedObsList);
                            break;
                        }
                        case 3: {
                            ((SgObsBooleanProp)this.selectionModel).toggle(graphedObsList);
                        }
                    }
                }
            }
        } else {
            this.selectionModel.setValues(obsList, values);
        }
    }

    @Override
    public void unselectAll() {
        if (this.localSelectionModel != null) {
            this.localSelectionModel.clear();
        }
        if (this.selectionModel == null || this.localSelections) {
            return;
        }
        if (this.shortCutSelection) {
            ((SgObsBooleanProp)this.selectionModel).clearAll();
        } else {
            this.selectionModel.setAllValues((Object)new Boolean(false));
        }
    }

    @Override
    public void setAllGraphed(boolean graph) {
        if (!graph) {
            this.localGraphedModel.clear();
        } else {
            this.localGraphedModel.set(0, this.getNumberObservations(-1), true);
        }
        if (this.localGraphed) {
            this.fireGraphedEvent();
        }
        if (this.graphedModel == null || this.localGraphed) {
            return;
        }
        this.graphedModel.setAllValues((Object)new Boolean(graph));
    }

    @Override
    public boolean isGraphed(long iobs) {
        if (this.localGraphed) {
            if (this.subsetList != null) {
                iobs = this.subsetList[(int)iobs];
            }
            return this.localGraphedModel.get((int)iobs);
        }
        if (this.graphedModel == null || iobs < 0L) {
            return false;
        }
        if (this.subsetList != null) {
            iobs = this.subsetList[(int)iobs];
        }
        if (this.shortCutGraph) {
            return ((SgObsBooleanProp)this.graphedModel).get((int)iobs);
        }
        Object o = this.graphedModel.getValue((int)iobs);
        if (o == null) {
            return false;
        }
        if (!(o instanceof Boolean)) {
            return false;
        }
        return (Boolean)o;
    }

    @Override
    public void setGraphed(long iobs, boolean graphed) {
        int obs;
        int n = obs = this.subsetList == null ? (int)iobs : this.subsetList[(int)iobs];
        if (graphed) {
            this.localGraphedModel.set(obs);
        } else {
            this.localGraphedModel.clear(obs);
        }
        if (this.localGraphed) {
            this.fireGraphedEvent();
            return;
        }
        if (this.graphedModel == null || iobs < 0L) {
            return;
        }
        if (this.shortCutGraph) {
            if (graphed) {
                ((SgObsBooleanProp)this.graphedModel).set((int)iobs);
            } else {
                ((SgObsBooleanProp)this.graphedModel).clear((int)iobs);
            }
        } else {
            this.graphedModel.setValue((int)iobs, (Object)new Boolean(graphed));
        }
    }

    @Override
    public void setGraphed(Object list, boolean graphed, IOBSInterface operator) {
        this.setGraphed(list, graphed ? 1 : 2, operator);
    }

    @Override
    public void setGraphed(Object list, int state, IOBSInterface operator) {
        int i;
        ArrayList<Boolean> values = null;
        if (this.graphedModel == null) {
            return;
        }
        int type = Extract.getSourceType(list);
        int n = Extract.getNumberItems(list, type);
        if (n <= 0) {
            return;
        }
        int[] obsList = new int[n];
        if (obsList == null) {
            return;
        }
        if (!this.shortCutGraph && (values = new ArrayList<Boolean>()) == null) {
            return;
        }
        for (i = 0; i < n; ++i) {
            obsList[i] = operator != null ? (int)operator.getObservationIndex(Extract.getObject(list, i, type)) : Extract.getInteger(list, i, type);
            boolean graphed = false;
            switch (state) {
                case 1: {
                    graphed = true;
                    break;
                }
                case 2: {
                    graphed = false;
                    break;
                }
                case 3: {
                    boolean bl = graphed = !this.isGraphed(obsList[i]);
                }
            }
            if (this.shortCutGraph) continue;
            values.add(new Boolean(graphed));
        }
        block16: for (i = 0; i < n; ++i) {
            int obs = this.subsetList == null ? obsList[i] : this.subsetList[obsList[i]];
            switch (state) {
                case 1: {
                    this.localGraphedModel.set(obs);
                    continue block16;
                }
                case 2: {
                    this.localGraphedModel.clear(obs);
                    continue block16;
                }
                case 3: {
                    this.localGraphedModel.flip(obs);
                }
            }
        }
        if (this.localGraphed) {
            this.fireGraphedEvent();
            return;
        }
        if (this.shortCutGraph) {
            if (this.subsetList != null) {
                for (i = 0; i < n; ++i) {
                    obsList[i] = this.subsetList[obsList[i]];
                }
            }
            switch (state) {
                case 1: {
                    ((SgObsBooleanProp)this.graphedModel).set(obsList);
                    break;
                }
                case 2: {
                    ((SgObsBooleanProp)this.graphedModel).clear(obsList);
                    break;
                }
                case 3: {
                    ((SgObsBooleanProp)this.graphedModel).toggle(obsList);
                }
            }
        } else {
            this.graphedModel.setValues(obsList, values);
        }
    }

    private void fireGraphedEvent() {
        SelectionIterator si = new SelectionIterator(this.localGraphedModel, this);
        int[] outList = new int[si.cardinality()];
        for (int i = 0; i < outList.length; ++i) {
            outList[i] = si.nextSelectedIndex();
        }
        this.rangeInfoModel.invalidate();
        this.throwEvent(8, 0, this.getNumberVariables() - 1, -1, -1, outList, new Integer(outList.length), false);
    }

    @Override
    public Color getObservationColor(long iobs) {
        int ic;
        if (this.colorModel == null) {
            return null;
        }
        if (this.subsetList != null) {
            iobs = this.subsetList[(int)iobs];
        }
        if (this.shortCutColor) {
            ic = ((SgObsIntegerProp)this.colorModel).getIntegerValue((int)iobs);
        } else {
            Object o = this.colorModel.getValue((int)iobs);
            if (o == null) {
                return null;
            }
            if (!(o instanceof Number)) {
                return null;
            }
            ic = ((Number)o).intValue();
        }
        if (ic == 0) {
            return null;
        }
        int r = 0xFF & ic >> 16;
        int g = 0xFF & ic >> 8;
        int b = 0xFF & ic;
        int a = 0xFF & ic >> 24;
        return new Color(r, g, b, a);
    }

    @Override
    public boolean setObservationColor(long iobs, Color c) {
        int ic;
        if (this.colorModel == null) {
            return false;
        }
        if (c == null) {
            ic = 0;
        } else {
            int a = 255;
            int r = c.getRed();
            int g = c.getGreen();
            int b = c.getBlue();
            ic = (a << 24) + (r << 16) + (g << 8) + b;
        }
        if (this.shortCutColor) {
            ((SgObsIntegerProp)this.colorModel).setValue((int)iobs, ic);
        } else {
            this.colorModel.setValue((int)iobs, (Object)new Integer(ic));
        }
        return true;
    }

    @Override
    public void setObservationColor(Object list, Color c, IOBSInterface operator) {
        int i;
        int ic;
        ArrayList<Integer> values = null;
        if (this.colorModel == null) {
            return;
        }
        int type = Extract.getSourceType(list);
        int n = Extract.getNumberItems(list, type);
        if (n <= 0) {
            return;
        }
        int[] obsList = new int[n];
        if (obsList == null) {
            return;
        }
        int[] icl = new int[n];
        if (icl == null) {
            return;
        }
        if (c == null) {
            ic = 0;
        } else {
            int a = 255;
            int r = c.getRed();
            int g = c.getGreen();
            int b = c.getBlue();
            ic = (a << 24) + (r << 16) + (g << 8) + b;
        }
        if (!this.shortCutColor && (values = new ArrayList<Integer>()) == null) {
            return;
        }
        for (i = 0; i < n; ++i) {
            icl[i] = ic;
            obsList[i] = operator != null ? (int)operator.getObservationIndex(Extract.getObject(list, i, type)) : Extract.getInteger(list, i, type);
            if (this.shortCutColor) continue;
            values.add(new Integer(ic));
        }
        if (this.shortCutColor) {
            if (this.subsetList != null) {
                for (i = 0; i < n; ++i) {
                    obsList[i] = this.subsetList[obsList[i]];
                }
            }
            ((SgObsIntegerProp)this.colorModel).setValues(obsList, icl);
        } else {
            this.colorModel.setValues(obsList, values);
        }
    }

    @Override
    public SelectionIterator getSelections() {
        return new SelectionIterator(this.localSelectionModel, this);
    }

    @Override
    public boolean isMinimumValueValid(Object variableId) {
        int varIdx = this.getVariableIdIndex(variableId);
        return varIdx >= 0 && this.model.isVarNumeric(varIdx);
    }

    @Override
    public Object getMaximumValue(Object variableId) {
        return this.getMaximumValue(variableId, true);
    }

    @Override
    public Object getMaximumValue(Object variableId, boolean useSubset) {
        int varIdx;
        if (this.subsetList == null) {
            useSubset = false;
        }
        if ((varIdx = this.getVariableIdIndex(variableId)) < 0) {
            return null;
        }
        if (this.model.isVarNumeric(varIdx)) {
            if (this.rangeInfoModel == null || !useSubset) {
                return new Double(this.model.getMaxValue(varIdx));
            }
            return new Double(this.rangeInfoModel.getMaximum(variableId));
        }
        return null;
    }

    @Override
    public boolean isMaximumValueValid(Object variableId) {
        int varIdx = this.getVariableIdIndex(variableId);
        return varIdx >= 0 && this.model.isVarNumeric(varIdx);
    }

    @Override
    public Object getMinimumValue(Object variableId) {
        return this.getMinimumValue(variableId, true);
    }

    @Override
    public Object getMinimumValue(Object variableId, boolean useSubset) {
        int varIdx;
        if (this.subsetList == null) {
            useSubset = false;
        }
        if ((varIdx = this.getVariableIdIndex(variableId)) < 0) {
            return null;
        }
        if (this.model.isVarNumeric(varIdx)) {
            if (this.rangeInfoModel == null || !useSubset) {
                return new Double(this.model.getMinValue(varIdx));
            }
            return new Double(this.rangeInfoModel.getMinimum(variableId));
        }
        return null;
    }

    @Override
    public boolean rerunStatistics() {
        return true;
    }

    @Override
    public Object[] getUniqueValues(Object variableId, boolean useSubset) {
        if (this.uniqueValueModel == null) {
            return null;
        }
        return this.getUniqueValues(variableId, useSubset, this.uniqueValueModel.maxValues);
    }

    @Override
    public Object[] getUniqueValues(Object variableId, boolean useSubset, int maxSize) {
        return this.getUniqueValues(variableId, useSubset, maxSize, true);
    }

    @Override
    public Object[] getUniqueValues(Object variableId, boolean useSubset, int maxSize, boolean includeMissing) {
        if (this.uniqueValueModel == null) {
            return null;
        }
        if (useSubset && this.subsetList != null) {
            Object o = this.buildVariableValueList(variableId, this.subsetList, maxSize, includeMissing);
            if ("OVERFLOW".equals(o)) {
                return null;
            }
            if (o instanceof LinkedHashMap) {
                return ((LinkedHashMap)o).values().toArray();
            }
        }
        return this.uniqueValueModel.getUniqueValues(variableId, maxSize, includeMissing);
    }

    private boolean isAddedObsEvent(int obs) {
        return this.obsInsertedIndex == obs;
    }

    public void varChanged(DataModelEvent e) {
        VarDataEvent vde;
        if (e instanceof VarDataEvent && 2 == (vde = (VarDataEvent)e).getType() && this.model != null) {
            this.throwEvent(3, 0, this.model.getNumVars() - 1, vde.getFromIndex(), vde.getToIndex(), null, null, false);
            return;
        }
    }

    public void valueChanged(DataModelEvent e) {
        int start = 0;
        int count = 0;
        Object oldValues = null;
        if (e == null || !(e instanceof ValueDataEvent)) {
            return;
        }
        ValueDataEvent vde = (ValueDataEvent)e;
        count = vde.getCount();
        oldValues = vde.getValues();
        start = vde.getObsIndex();
        int idx = vde.getVarIndex();
        this.localGraphedModel.set(start, start + count, true);
        this.rangeInfoModel.invalidate();
        switch (eventBatching) {
            case 2: {
                this.pendingEvents = true;
                this.dmea.updateMetaData(vde, this.isAddedObsEvent(start));
                if (this.dataModelEventTimer.isRunning()) {
                    this.dataModelEventTimer.restart();
                    break;
                }
                this.dataModelEventTimer.start();
                break;
            }
            default: {
                this.throwEvent(3, idx, idx, start, start + count - 1, oldValues, null, false);
            }
        }
    }

    public void obsChanged(DataModelEvent e) {
        if (e instanceof ObsDataEvent && (e.getType() == 2 || e.getType() == 5)) {
            if (this.localSelectionModel != null) {
                this.localSelectionModel.clear();
            }
            if (this.localGraphedModel != null) {
                this.localGraphedModel.clear();
            }
            ObsDataEvent ode = (ObsDataEvent)e;
            if (this.model != null) {
                this.throwEvent(3, 0, this.model.getNumVars() - 1, ode.getFromIndex(), ode.getToIndex(), null, null, false);
                return;
            }
        }
        switch (eventBatching) {
            case 2: {
                this.obsInsertedIndex = -1;
                if (!(e instanceof ObsDataEvent)) break;
                ObsDataEvent oe = (ObsDataEvent)e;
                if (e.getType() == 1) {
                    this.obsInsertedIndex = oe.getToIndex();
                }
                this.pendingEvents = true;
                this.dmea.updateMetaData(oe);
                break;
            }
        }
    }

    @Override
    public boolean setFormat(Object variableId, Object fmtId) {
        int index = this.getVariableIdIndex(variableId);
        if (index < 0) {
            return false;
        }
        this.model.setVarFormat(index, fmtId);
        this.throwEvent(6, index, index, -1, -1, null, fmtId, false);
        return true;
    }

    @Override
    public boolean setValue(int idx, long iobs, double value) {
        return this.setValue(idx, iobs, (Object)new Double(value));
    }

    @Override
    public boolean setValue(int idx, long iobs, Object value) {
        if (idx < 0 || idx > this.getNumberVariables() || iobs < 0L || iobs >= (long)this.getNumberObservations(-1)) {
            return false;
        }
        int type = Extract.getSourceType(value);
        int num = Extract.getNumberItems(value, type);
        if (num == 1) {
            this.model.setValue(idx, (int)iobs, Extract.getObject(value, 0, type));
            this.throwEvent(3, idx, idx, (int)iobs, (int)iobs, null, Extract.getObject(value, 0, type), false);
        } else {
            Object[] arr = new Object[num];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = Extract.getObject(value, i, type);
            }
            this.model.setValue(idx, (int)iobs, (int)iobs + num - 1, arr);
            this.throwEvent(3, idx, idx, (int)iobs, (int)iobs + num - 1, null, arr, false);
        }
        return true;
    }

    @Override
    public boolean setValue(Object variableId, long iobs, double value) {
        return this.setValue(this.getVariableIdIndex(variableId), iobs, (Object)new Double(value));
    }

    @Override
    public boolean setValue(Object variableId, long iobs, Object value) {
        int i;
        int type = Extract.getSourceType(variableId);
        int numVariables = Extract.getNumberItems(variableId, type);
        if (numVariables == 1) {
            return this.setValue(this.getVariableIdIndex(variableId), iobs, value);
        }
        boolean rc = true;
        int valueType = Extract.getSourceType(value);
        int numCols = Extract.getNumberItems(value, type);
        if (numCols != numVariables) {
            return false;
        }
        int numObs = -1;
        for (i = 0; i < numCols; ++i) {
            Object column = Extract.getObject(value, i, valueType);
            int numInCol = Extract.getNumberItems(column, Extract.getSourceType(column));
            if (numObs < 0) {
                numObs = numInCol;
                continue;
            }
            if (numObs == numInCol) continue;
            return false;
        }
        if ((long)this.getNumberObservations(-1) < iobs + (long)numObs - 1L) {
            return false;
        }
        for (i = 0; i < numCols; ++i) {
            rc |= this.setValue(this.getVariableIdIndex(Extract.getObject(variableId, i, type)), iobs, Extract.getObject(value, i, valueType));
        }
        return rc;
    }

    @Override
    public boolean isModelUpdatable(int varIdx, long iobs) {
        return true;
    }

    @Override
    public boolean addDataFilterListener(Object listener) {
        if (this.model == null || listener == null || !super.addDataFilterListener(listener)) {
            return false;
        }
        if (this.listeners.getListenerCount(DataFilterListenerInterface.class) == 1) {
            this.model.addDataModelListener((DataModelListener)this);
            if (this.selectionModel != null) {
                this.selectionModel.addObsPropertyListener((ObsPropertyListener)this.selections);
            }
            if (this.graphedModel != null) {
                this.graphedModel.addObsPropertyListener((ObsPropertyListener)this.graphs);
            }
            if (this.colorModel != null) {
                this.colorModel.addObsPropertyListener((ObsPropertyListener)this.colors);
            }
        }
        return true;
    }

    @Override
    public boolean removeDataFilterListener(Object listener) {
        if (this.model == null || listener == null || !super.removeDataFilterListener(listener)) {
            return false;
        }
        if (this.listeners.getListenerCount(DataFilterListenerInterface.class) <= 0) {
            this.model.removeDataModelListener((DataModelListener)this);
            if (this.selectionModel != null) {
                this.selectionModel.removeObsPropertyListener((ObsPropertyListener)this.selections);
            }
            if (this.graphedModel != null) {
                this.graphedModel.removeObsPropertyListener((ObsPropertyListener)this.graphs);
            }
            if (this.colorModel != null) {
                this.colorModel.removeObsPropertyListener((ObsPropertyListener)this.colors);
            }
        }
        return true;
    }

    @Override
    protected int getNumberOfObservationsOnModel() {
        return this.model.getNumObs();
    }

    @Override
    protected Object getModelValue(int idx, long iobs) {
        int nobs = this.model.getNumObs();
        int nvars = this.model.getNumVars();
        if (nobs == 0 || nvars == 0 || idx < 0 || idx > nvars || iobs < 0L || iobs > (long)nobs) {
            return null;
        }
        return this.model.getValue(idx, (int)iobs);
    }

    @Override
    public Object getAdapter(Class type) {
        if (type == CustomModelManagerInterface.class) {
            return this;
        }
        if (type == UniqueValueInterface.class) {
            return this;
        }
        return super.getAdapter(type);
    }

    @Override
    public void detachCustomModels() {
        SILKBooleanObsPropertyModel obj;
        UniqueValuePropertyModel uvm = (UniqueValuePropertyModel)this.model.getCustomPropertyModel(uniqueValueModelName);
        if (uvm != null) {
            this.model.removeCustomPropertyModel(uniqueValueModelName);
            uvm.dispose();
        }
        if ((obj = (SILKBooleanObsPropertyModel)this.model.getCustomPropertyModel(mirrorSelectName)) != null) {
            this.model.removeCustomPropertyModel(mirrorSelectName);
            obj.dispose();
        }
    }

    public static int getEventBatching() {
        return eventBatching;
    }

    public static void setEventBatching(int eventBatching) {
        SGDataFilter.eventBatching = eventBatching;
    }

    public static void setEventBatchingProperty(String property, Object value) {
        if (EVENT_BATCH_TIME_INTERVAL.equalsIgnoreCase(property) && value instanceof Number) {
            minEventTime_forLastObsUpdate = ((Number)value).intValue();
        }
    }

    private class DataModelEventAccumulator
    implements ActionListener {
        private int firstVarIdx = 0;
        private int lastVarIdx = 0;
        private int firstObs = 0;
        private int lastObs = 0;
        boolean validValues = false;
        private int minEventTimeInterval = 0;
        private long lastEventTime = 0L;

        DataModelEventAccumulator(int minEventTimeInterval) {
            this.minEventTimeInterval = minEventTimeInterval;
        }

        public void updateMetaData(ValueDataEvent vde, boolean addedObsEvent) {
            if (addedObsEvent) {
                if (this.validValues) {
                    this.firstObs = Math.min(this.firstObs, vde.getObsIndex());
                    this.lastObs = Math.max(this.lastObs, vde.getObsIndex() + vde.getCount() - 1);
                    this.firstVarIdx = Math.min(this.firstVarIdx, vde.getVarIndex());
                    this.lastVarIdx = Math.max(this.lastVarIdx, vde.getVarIndex());
                } else {
                    this.firstObs = vde.getObsIndex();
                    this.lastObs = vde.getObsIndex() + vde.getCount() - 1;
                    this.firstVarIdx = this.lastVarIdx = vde.getVarIndex();
                    this.validValues = true;
                }
            } else {
                long time = System.currentTimeMillis();
                this.validValues = true;
                this.firstObs = vde.getObsIndex();
                if (time - this.lastEventTime >= (long)minEventTime_forAnyObsUpdate) {
                    this.lastEventTime = time;
                    this.fireEvent();
                }
            }
        }

        public void updateMetaData(ObsDataEvent ode) {
            long time;
            if (ode == null) {
                return;
            }
            if (eventBatching == 2 && ode.getType() == 1 && (time = System.currentTimeMillis()) - this.lastEventTime >= (long)this.minEventTimeInterval) {
                this.lastEventTime = time;
                this.fireEvent();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.lastEventTime = System.currentTimeMillis();
            this.fireEvent();
        }

        private void fireEvent() {
            if (!this.validValues || !SGDataFilter.this.pendingEvents) {
                return;
            }
            SGDataFilter.this.pendingEvents = false;
            this.validValues = false;
            long t1 = System.currentTimeMillis();
            SGDataFilter.this.throwEvent(3, this.firstVarIdx, this.lastVarIdx, this.firstObs, this.lastObs, null, null, false);
            long t2 = System.currentTimeMillis();
        }
    }

    class UniqueValuePropertyModel
    implements DataPropertyModel,
    DataModelListener {
        DataModel model = null;
        Hashtable variables = new Hashtable();
        Hashtable formattedVariableValues = new Hashtable();
        Hashtable formattedNonMissingVariableValues = new Hashtable();
        SGDataFilter dataFilter = null;
        private int numToMany = -1;
        private int maxValues = Integer.MAX_VALUE;

        public UniqueValuePropertyModel(DataModel model) {
            this.model = model;
            model.addDataModelListener((DataModelListener)this);
        }

        public DataModel getDataModel() {
            return this.model;
        }

        public int getNumListeners() {
            return 0;
        }

        public Object[] getUniqueValues(Object variableId) {
            return this.getUniqueValues(variableId, this.maxValues);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LinkedHashMap getFormattedValues(Object variableId) {
            if (variableId == null) {
                return null;
            }
            if (!this.formattedVariableValues.containsKey(variableId)) {
                Hashtable hashtable = this.variables;
                synchronized (hashtable) {
                    if (!this.variables.containsKey(variableId)) {
                        this.getUniqueValues(variableId);
                    }
                    LinkedHashMap fvvl = this.dataFilter.buildFormattedVariableValueList(variableId, (LinkedHashMap)this.variables.get(variableId));
                    this.formattedVariableValues.put(variableId, fvvl);
                    this.updateNonMissingValues(variableId, fvvl);
                }
            }
            return (LinkedHashMap)this.formattedVariableValues.get(variableId);
        }

        private void updateNonMissingValues(Object variableId, LinkedHashMap fvvl) {
            Object[] rawValues = fvvl.keySet().toArray();
            if (rawValues != null) {
                int varIndex = this.dataFilter.getVariableIdIndex(variableId);
                LinkedHashMap nonMissingValues = new LinkedHashMap();
                for (int i = 0; i < rawValues.length; ++i) {
                    if (this.dataFilter.isMissing(varIndex, rawValues[i])) continue;
                    nonMissingValues.put(rawValues[i], fvvl.get(rawValues[i]));
                }
                this.formattedNonMissingVariableValues.put(variableId, nonMissingValues);
            }
        }

        public Object[] getUniqueValues(Object variableId, int maxSize) {
            return this.getUniqueValues(variableId, maxSize, false);
        }

        public Object[] getUniqueValues(Object variableId, int maxSize, boolean includeMissing) {
            Object obj;
            if (variableId == null) {
                return null;
            }
            if (!this.variables.containsKey(variableId)) {
                Object uniqueValues = this.dataFilter.buildVariableValueList(variableId, maxSize);
                if (uniqueValues == null) {
                    return null;
                }
                this.variables.put(variableId, uniqueValues);
            }
            if ("OVERFLOW".equals(obj = this.variables.get(variableId))) {
                if (this.numToMany < maxSize) {
                    this.dataFilter.buildVariableValueList(variableId, maxSize);
                    obj = this.variables.get(variableId);
                }
                if ("OVERFLOW".equals(obj)) {
                    return null;
                }
            }
            this.numToMany = Math.max(this.numToMany, maxSize);
            LinkedHashMap values = (LinkedHashMap)obj;
            if (!includeMissing) {
                if (!this.formattedNonMissingVariableValues.contains(variableId) && !this.formattedVariableValues.contains(variableId)) {
                    this.getFormattedValues(variableId);
                }
                if (this.formattedNonMissingVariableValues.containsKey(variableId)) {
                    LinkedHashMap lhm = (LinkedHashMap)this.formattedNonMissingVariableValues.get(variableId);
                    Object[] fv = lhm.values().toArray();
                    if (fv != null && fv.length > 0) {
                        LinkedHashMap<Object, Object> uv = new LinkedHashMap<Object, Object>();
                        for (int i = 0; i < fv.length; ++i) {
                            if (uv.containsKey(fv[i]) || !values.containsKey(fv[i])) continue;
                            uv.put(fv[i], fv[i]);
                        }
                        return uv.values().toArray();
                    }
                    return fv;
                }
            }
            return values.values().toArray();
        }

        public void obsChanged(DataModelEvent arg0) {
            ObsDataEvent oe;
            if (arg0 instanceof ObsDataEvent && (oe = (ObsDataEvent)arg0).getType() == 1) {
                return;
            }
            this.clearCachedInformation();
        }

        public void clearCachedInformation() {
            this.formattedVariableValues.clear();
            this.variables.clear();
        }

        public void varChanged(DataModelEvent arg0) {
            this.clearCachedInformation();
        }

        public void valueChanged(DataModelEvent arg0) {
            if (!(arg0 instanceof ValueDataEvent)) {
                this.clearCachedInformation();
                return;
            }
            ValueDataEvent vde = (ValueDataEvent)arg0;
            if (!this.dataFilter.isAddedObsEvent(vde.getObsIndex())) {
                Object variable = this.dataFilter.getVariableId(vde.getVarIndex());
                if (this.variables.containsKey(variable)) {
                    this.variables.remove(variable);
                }
                if (this.formattedVariableValues.containsKey(variable)) {
                    this.formattedVariableValues.remove(variable);
                }
            } else {
                Object variable = this.dataFilter.getVariableId(vde.getVarIndex());
                LinkedHashMap items = (LinkedHashMap)this.variables.get(variable);
                LinkedHashMap fvvl = (LinkedHashMap)this.formattedVariableValues.get(variable);
                if (items != null) {
                    Object obj = this.dataFilter.updateVariableValueList(variable, this.maxValues, items, vde.getObsIndex(), fvvl);
                    if (obj == null || "OVERFLOW".equals(obj)) {
                        this.variables.remove(variable);
                    } else {
                        this.updateNonMissingValues(variable, fvvl);
                    }
                }
            }
        }

        public void dispose() {
            if (this.dataFilter != null) {
                this.dataFilter.removeSource();
            }
            this.dataFilter = null;
            if (this.model != null) {
                this.model.removeDataModelListener((DataModelListener)this);
            }
            this.model = null;
            if (this.variables != null) {
                this.variables.clear();
            }
            this.variables = null;
            if (this.formattedVariableValues != null) {
                this.formattedVariableValues.clear();
            }
            this.formattedVariableValues = null;
        }

        void setFilter(SGDataFilter df) {
            this.dataFilter = df;
        }
    }

    class SILKBooleanObsPropertyModel
    extends SgObsBooleanProp
    implements ObsPropertyListener {
        private SgObsBooleanProp selectionModel;

        public SILKBooleanObsPropertyModel(DataModel model) {
            super(model, false);
            this.selectionModel = null;
            this.selectionModel = (SgObsBooleanProp)model.getObsPropertyModel(SGDataFilter.obsSelectName);
            for (int i = 0; i < this.m_numObs; ++i) {
                if (!this.selectionModel.get(i)) continue;
                this.set(i);
            }
            this.selectionModel.addObsPropertyListener((ObsPropertyListener)this);
        }

        public BitSet getBitSet() {
            return this.m_bits;
        }

        public void obsPropertyChanged(ObsPropertyEvent arg0) {
            if (arg0.getObsIndices() == null) {
                this.clearAll();
                return;
            }
            int[] list = arg0.getObsIndices();
            for (int i = 0; i < arg0.getNumObs(); ++i) {
                if (this.selectionModel.get(list[i])) {
                    this.set(list[i]);
                    continue;
                }
                this.clear(list[i]);
            }
        }

        public void dispose() {
            if (this.selectionModel != null) {
                this.selectionModel.removeObsPropertyListener((ObsPropertyListener)this);
            }
            this.selectionModel = null;
        }
    }

    class SelectionListener
    implements ObsPropertyListener {
        public static final int SELECTION = 0;
        public static final int GRAPHED = 1;
        public static final int COLOR = 2;
        protected int propType;

        public SelectionListener(int type) {
            this.propType = type;
        }

        public void obsPropertyChanged(ObsPropertyEvent event) {
            int i;
            int type;
            int[] obsIndicies;
            int n = SGDataFilter.this.getNumberVariables();
            int[] outList = obsIndicies = event.getObsIndices();
            switch (this.propType) {
                case 0: {
                    type = 2;
                    break;
                }
                case 1: {
                    type = 8;
                    break;
                }
                case 2: {
                    type = 9;
                    break;
                }
                default: {
                    return;
                }
            }
            if (type == 8 && SGDataFilter.this.rangeInfoModel != null) {
                SGDataFilter.this.rangeInfoModel.invalidate();
            }
            int nn = obsIndicies == null ? SGDataFilter.this.getNumberObservations(null) : obsIndicies.length;
            if (obsIndicies != null && SGDataFilter.this.subsetted) {
                if (SGDataFilter.this.subsetList == null) {
                    return;
                }
                if (SGDataFilter.this.rangeInfoModel != null) {
                    SGDataFilter.this.rangeInfoModel.invalidate();
                }
                if ((SGDataFilter.this.remappedObsIndicies == null || SGDataFilter.this.remappedObsIndicies.length < nn) && (SGDataFilter.this.remappedObsIndicies = new int[nn]) == null) {
                    return;
                }
                int count = 0;
                for (i = 0; i < nn; ++i) {
                    int iobs = Search.binarylookup(obsIndicies[i], SGDataFilter.this.subsetList, -1);
                    if (iobs < 0) continue;
                    SGDataFilter.this.remappedObsIndicies[count] = iobs;
                    ++count;
                }
                nn = count;
                outList = SGDataFilter.this.remappedObsIndicies;
            }
            if (!SGDataFilter.this.localSelections) {
                if (outList == null) {
                    SGDataFilter.this.localSelectionModel.clear();
                } else {
                    for (i = 0; i < nn; ++i) {
                        int obs;
                        int n2 = obs = SGDataFilter.this.subsetList == null ? outList[i] : SGDataFilter.this.subsetList[outList[i]];
                        if (SGDataFilter.this.isSelected(outList[i])) {
                            SGDataFilter.this.localSelectionModel.set(obs);
                            continue;
                        }
                        SGDataFilter.this.localSelectionModel.clear(obs);
                    }
                }
            }
            if (!(type == 2 && SGDataFilter.this.localSelections || type == 8 && SGDataFilter.this.localGraphed)) {
                SGDataFilter.this.throwEvent(type, 0, n - 1, -1, -1, outList, new Integer(nn), false);
            }
        }
    }
}

