/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.data;

import com.sas.MissingValues;
import com.sas.graphics.data.AbstractDataFilter;
import com.sas.graphics.data.IOBSInterface;
import com.sas.graphics.silk.data.SelectionIterator;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterUpdateInterface;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.RangeInfoModel;
import com.sas.graphics.util.StringCompare;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class JTableDataFilter
extends AbstractDataFilter
implements DataFilterUpdateInterface,
ListSelectionListener,
TableModelListener,
DataFilterInfoInterface {
    protected Object table;
    protected ListSelectionModel listSelectionModel = null;
    protected static Hashtable listSelectionModelCache = null;
    protected BitSet selections = null;
    protected Hashtable variableInfo = new Hashtable();

    public JTableDataFilter(Object tableIn, Locale localeIn) {
        this.subsetted = false;
        this.table = null;
        this.whereClauses = new Vector();
        this.subsetList = null;
        this.selections = new BitSet();
        this.evt = new DvrDataFilterEvent();
        this.rangeInfoModel = new RangeInfoModel(this);
        this.setSource(tableIn, localeIn);
    }

    public JTableDataFilter() {
        this(null, null);
    }

    protected TableModel getTableModel(Object src) {
        if (src == null) {
            return null;
        }
        if (src instanceof TableModel) {
            return (TableModel)src;
        }
        if (src instanceof JTable) {
            return ((JTable)src).getModel();
        }
        return null;
    }

    public ListSelectionModel getListSelectionModel() {
        return this.getListSelectionModel(this.table);
    }

    public boolean setListSelectionModel(ListSelectionModel model) {
        if (this.table instanceof JTable) {
            return false;
        }
        this.listSelectionModel = model;
        this.addUsAsListener(model);
        return true;
    }

    protected ListSelectionModel getListSelectionModel(Object src) {
        if (src == null) {
            return this.listSelectionModel;
        }
        if (src instanceof JTable) {
            return ((JTable)src).getSelectionModel();
        }
        if (src instanceof ListSelectionModel) {
            return (ListSelectionModel)src;
        }
        return this.listSelectionModel;
    }

    protected boolean isValidSource(Object newSrc) {
        if (newSrc == null) {
            return false;
        }
        if (newSrc instanceof JTable) {
            return true;
        }
        return newSrc instanceof TableModel;
    }

    protected int getColumn(Object id) {
        int n = this.getNumberVariables();
        TableModel tableModel = this.getTableModel(this.table);
        if (tableModel == null || id == null || !(id instanceof String) || n <= 0) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            if (!StringCompare.equals((String)id, tableModel.getColumnName(i))) continue;
            return i;
        }
        return -1;
    }

    protected void addUsAsListener(Object src) {
        TableModel tm = this.getTableModel(src);
        ListSelectionModel lsm = this.getListSelectionModel(src);
        if (tm != null) {
            tm.addTableModelListener(this);
        }
        if (lsm != null) {
            lsm.addListSelectionListener(this);
        }
    }

    protected void removeUsAsListener(Object src) {
        TableModel tm = this.getTableModel(src);
        ListSelectionModel lsm = this.getListSelectionModel(src);
        if (tm != null) {
            tm.removeTableModelListener(this);
        }
        if (lsm != null) {
            lsm.removeListSelectionListener(this);
        }
    }

    public boolean addDataFilterListener(TableModel tm, Object listener) {
        if (!this.addDataFilterListener(listener)) {
            return false;
        }
        if (tm != null && this.listeners.getListenerCount(DataFilterListenerInterface.class) == 1) {
            tm.addTableModelListener(this);
        }
        return true;
    }

    @Override
    public Object getSource() {
        return this.table;
    }

    @Override
    public boolean setSource(Object source) {
        Object oldTable = this.table;
        if (!this.isValidSource(source)) {
            return false;
        }
        this.table = source;
        if (this.listeners.getListenerCount(DataFilterListenerInterface.class) > 0) {
            this.removeUsAsListener(oldTable);
            this.addUsAsListener(this.table);
        }
        this.subsetted = false;
        this.subsetList = null;
        if (this.rangeInfoModel != null) {
            this.rangeInfoModel.invalidate();
        }
        if (source instanceof TableModel && this.listSelectionModel == null) {
            Integer hash;
            if (listSelectionModelCache == null) {
                listSelectionModelCache = new Hashtable();
            }
            if (listSelectionModelCache.containsKey(hash = new Integer(source.hashCode()))) {
                this.listSelectionModel = (ListSelectionModel)listSelectionModelCache.get(hash);
                for (int i = 0; i < this.getNumberObservations(-1); ++i) {
                    if (this.listSelectionModel.isSelectedIndex(i)) {
                        this.selections.set(i);
                        continue;
                    }
                    this.selections.clear(i);
                }
            } else {
                this.listSelectionModel = new DefaultListSelectionModel();
                listSelectionModelCache.put(hash, this.listSelectionModel);
            }
        } else if (source instanceof JTable) {
            this.listSelectionModel = ((JTable)source).getSelectionModel();
        }
        this.throwEvent(1, -1, -1, -1, -1, oldTable, this.table, false);
        return true;
    }

    @Override
    public boolean removeSource() {
        Object oldTable = this.table;
        TableModel tm = this.getTableModel(this.table);
        if (this.table == null) {
            return false;
        }
        super.removeSource();
        if (tm != null) {
            this.removeUsAsListener(tm);
        }
        this.subsetted = false;
        this.listSelectionModel = null;
        this.selections = null;
        if (this.variableInfo != null) {
            this.variableInfo.clear();
        }
        this.variableInfo = null;
        this.subsetList = null;
        this.table = null;
        this.throwEvent(1, -1, -1, -1, -1, oldTable, null, false);
        return true;
    }

    @Override
    public int getNumberVariables() {
        TableModel tableModel = this.getTableModel(this.table);
        if (tableModel == null) {
            return 0;
        }
        return tableModel.getColumnCount();
    }

    @Override
    public boolean verifyVariable(Object id) {
        return this.getColumn(id) >= 0;
    }

    @Override
    public Object getVariableId(int idx) {
        int n = this.getNumberVariables();
        TableModel tableModel = this.getTableModel(this.table);
        if (idx < 0 || idx >= n) {
            return null;
        }
        return tableModel.getColumnName(idx);
    }

    @Override
    public Object getVariableDescription(int idx) {
        TableModel tModel = this.getTableModel(this.table);
        if (tModel == null || idx < 0) {
            return null;
        }
        return tModel.getColumnName(idx);
    }

    @Override
    public int getVariableIndex(Object id) {
        return this.getColumn(id);
    }

    @Override
    public int getNumberObservations(int idx) {
        TableModel tableModel = this.getTableModel(this.table);
        if (tableModel == null) {
            return 0;
        }
        if (this.subsetted) {
            if (this.subsetList == null) {
                return 0;
            }
            return this.subsetList.length;
        }
        return tableModel.getRowCount();
    }

    @Override
    public Object getValue(int idx, long iobs) {
        int nrows = this.getNumberObservations(null);
        int nvars = this.getNumberVariables();
        if (nrows == 0 || nvars == 0) {
            return null;
        }
        TableModel tableModel = this.getTableModel(this.table);
        if (tableModel == null || idx < 0 || iobs < 0L || idx >= nvars || iobs >= (long)nrows) {
            return null;
        }
        if (this.subsetList != null) {
            iobs = this.subsetList[(int)iobs];
        }
        return tableModel.getValueAt((int)iobs, idx);
    }

    @Override
    protected Object getModelValue(int idx, long iobs) {
        TableModel tableModel = this.getTableModel(this.table);
        if (tableModel == null) {
            return null;
        }
        int nrows = tableModel.getRowCount();
        int nvars = tableModel.getColumnCount();
        if (nrows == 0 || nvars == 0 || idx < 0 || iobs < 0L || idx >= nvars || iobs >= (long)nrows) {
            return null;
        }
        return tableModel.getValueAt((int)iobs, idx);
    }

    @Override
    protected int getNumberOfObservationsOnModel() {
        TableModel tableModel = this.getTableModel(this.table);
        if (tableModel == null) {
            return 0;
        }
        return tableModel.getRowCount();
    }

    @Override
    public boolean isNumericVariable(int idx) {
        Object o;
        TableModel tm = this.getTableModel(this.table);
        Class<?> cls = null;
        Class<?> superCls = null;
        if (tm == null) {
            return false;
        }
        if (idx < 0 || idx >= tm.getColumnCount()) {
            return false;
        }
        if (tm.getColumnCount() == 0) {
            return false;
        }
        cls = tm.getColumnClass(idx);
        if (cls != null) {
            superCls = cls.getSuperclass();
        }
        if (cls == Number.class) {
            return true;
        }
        if (superCls != null && superCls == Number.class) {
            return true;
        }
        if (cls == String.class) {
            return false;
        }
        if (tm.getRowCount() > 0 && (o = tm.getValueAt(0, idx)) != null) {
            return o instanceof Number;
        }
        return false;
    }

    @Override
    public double getNumericValue(int idx, long iobs) {
        Object v = null;
        v = this.getValue(idx, iobs);
        if (v == null || !(v instanceof Number)) {
            return Double.NaN;
        }
        return ((Number)v).doubleValue();
    }

    @Override
    public boolean isMissing(int idx, Object value) {
        return value == null || value instanceof MissingValues || value instanceof Double && ((Double)value).isNaN();
    }

    @Override
    public Class getVariableClass(int idx) {
        TableModel tableModel = this.getTableModel(this.table);
        if (tableModel == null) {
            return null;
        }
        return tableModel.getColumnClass(idx);
    }

    @Override
    public Object getFormat(Object variableId, Class returnType) {
        return null;
    }

    @Override
    public String getFormattedValue(Object variableId, Object value, Object format) {
        if (value == null) {
            return null;
        }
        SASFormat fmt = null;
        if (fmt == null && value instanceof Number && this.defFmt != null) {
            fmt = this.defFmt;
        }
        if (fmt == null) {
            return value.toString();
        }
        return fmt.format(value);
    }

    @Override
    public boolean addDataFilterListener(Object listener) {
        if (!super.addDataFilterListener(listener)) {
            return false;
        }
        if (this.listeners.getListenerCount(DataFilterListenerInterface.class) == 1) {
            this.addUsAsListener(this.table);
        }
        return true;
    }

    @Override
    public boolean removeDataFilterListener(Object listener) {
        if (this.table == null || !super.removeDataFilterListener(listener)) {
            return false;
        }
        if (this.listeners.getListenerCount(DataFilterListenerInterface.class) <= 0) {
            this.removeUsAsListener(this.table);
        }
        return true;
    }

    public boolean defineVariable(Object id, Object descIn, Object data) {
        return false;
    }

    public boolean removeVariable(Object id) {
        return false;
    }

    public boolean removeVariable(int idx) {
        return false;
    }

    @Override
    public boolean setValue(Object variableId, long iobs, Object value) {
        return this.setValue(this.getColumn(variableId), iobs, value);
    }

    @Override
    public boolean setValue(int idx, long iobs, Object value) {
        int nrows = this.getNumberObservations(null);
        int nvars = this.getNumberVariables();
        TableModel tableModel = this.getTableModel(this.table);
        if (tableModel == null || idx < 0 || iobs < 0L || idx >= nvars || iobs >= (long)nrows) {
            return false;
        }
        if (this.subsetList != null) {
            iobs = this.subsetList[(int)iobs];
        }
        tableModel.setValueAt(value, (int)iobs, idx);
        return true;
    }

    @Override
    public boolean setValue(Object variableId, long iobs, double value) {
        return this.setValue(variableId, iobs, (Object)new Double(value));
    }

    @Override
    public boolean setValue(int idx, long iobs, double value) {
        return this.setValue(idx, iobs, (Object)new Double(value));
    }

    @Override
    public boolean setFormat(Object variableId, Object fmtId) {
        return false;
    }

    @Override
    public boolean isModelUpdatable(int varIdx, long iobs) {
        TableModel tableModel = this.getTableModel(this.table);
        if (tableModel != null) {
            return tableModel.isCellEditable((int)iobs, varIdx);
        }
        return false;
    }

    @Override
    public int getRowValues(long iobs, Object[] outValues) {
        return 0;
    }

    @Override
    public boolean isSelected(long iobs) {
        ListSelectionModel lsm = this.getListSelectionModel(this.table);
        if (lsm != null) {
            return lsm.isSelectedIndex((int)iobs);
        }
        return false;
    }

    @Override
    public void setSelected(long iobs, boolean selected) {
        ListSelectionModel lsm = this.getListSelectionModel(this.table);
        if (lsm != null) {
            if (selected) {
                lsm.addSelectionInterval((int)iobs, (int)iobs);
            } else {
                lsm.removeSelectionInterval((int)iobs, (int)iobs);
            }
        }
    }

    @Override
    public void setSelected(Object list, boolean selected, IOBSInterface operator) {
        this.setSelected(list, selected ? 1 : 2, operator);
    }

    @Override
    public void setSelected(Object list, int state, IOBSInterface operator) {
        int i;
        ListSelectionModel lsm = this.getListSelectionModel(this.table);
        if (lsm == null) {
            return;
        }
        int type = Extract.getSourceType(list);
        int n = Extract.getNumberItems(list, type);
        if (n <= 0) {
            return;
        }
        Object[] arr = new Object[n];
        for (i = 0; i < n; ++i) {
            arr[i] = Extract.getObject(list, i, type);
        }
        lsm.setValueIsAdjusting(true);
        for (i = 0; i < n; ++i) {
            if (i == n - 1) {
                lsm.setValueIsAdjusting(false);
            }
            int obsIndex = -1;
            obsIndex = operator != null ? (int)operator.getObservationIndex(arr[i]) : Extract.getInteger(list, i, type);
            boolean selected = false;
            switch (state) {
                case 1: {
                    selected = true;
                    break;
                }
                case 2: {
                    selected = false;
                    break;
                }
                case 3: {
                    selected = !this.isSelected(obsIndex);
                }
            }
            this.setSelected(obsIndex, selected);
        }
    }

    @Override
    public void unselectAll() {
        ListSelectionModel lsm = this.getListSelectionModel(this.table);
        if (lsm != null) {
            lsm.clearSelection();
        }
        this.selections.clear();
        this.throwEvent(2, 0, this.getNumberVariables(), -1, -1, null, null, false);
    }

    @Override
    public boolean isGraphed(long iobs) {
        return true;
    }

    @Override
    public void setAllGraphed(boolean graph) {
    }

    @Override
    public void setGraphed(long iobs, boolean graphed) {
    }

    @Override
    public void setGraphed(Object list, boolean graphed, IOBSInterface operator) {
        this.setGraphed(list, graphed ? 1 : 2, operator);
    }

    @Override
    public void setGraphed(Object list, int state, IOBSInterface operator) {
    }

    @Override
    public Color getObservationColor(long iobs) {
        return null;
    }

    @Override
    public boolean setObservationColor(long iobs, Color c) {
        return false;
    }

    @Override
    public void setObservationColor(Object list, Color c, IOBSInterface operator) {
    }

    @Override
    public SelectionIterator getSelections() {
        return new SelectionIterator(this.selections, this);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int lastCol;
        if (e == null) {
            return;
        }
        int type = e.getType();
        int firstCol = lastCol = e.getColumn();
        if (lastCol == -1) {
            firstCol = 0;
            lastCol = this.getNumberVariables() - 1;
            this.variableInfo.clear();
        } else {
            for (int i = firstCol; i <= lastCol; ++i) {
                this.variableInfo.remove(this.getVariableId(i));
            }
        }
        int firstRow = e.getFirstRow();
        if (firstRow == -1) {
            return;
        }
        int lastRow = e.getLastRow();
        if (this.rangeInfoModel != null) {
            this.rangeInfoModel.invalidate();
        }
        switch (type) {
            case 0: {
                this.throwEvent(3, firstCol, lastCol, firstRow, lastRow, null, null, false);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Integer length = new Integer(e.getLastIndex() - e.getFirstIndex() + 1);
        int[] indexList = new int[length.intValue()];
        Vector<Integer> changes = new Vector<Integer>();
        int i = e.getFirstIndex();
        int j = 0;
        while (i <= e.getLastIndex()) {
            indexList[j] = i;
            if (this.listSelectionModel.isSelectedIndex(i)) {
                if (!this.selections.get(i)) {
                    changes.add(new Integer(i));
                }
                this.selections.set(i);
            } else {
                if (this.selections.get(i)) {
                    changes.add(new Integer(i));
                }
                this.selections.clear(i);
            }
            ++i;
            ++j;
        }
        int[] idxList = null;
        if (changes.size() > 0) {
            idxList = new int[changes.size()];
            for (int i2 = 0; i2 < changes.size(); ++i2) {
                idxList[i2] = (Integer)changes.elementAt(i2);
            }
            this.throwEvent(2, 0, this.getNumberVariables(), -1, -1, idxList, new Integer(idxList.length), e.getValueIsAdjusting());
        }
    }

    @Override
    public Object getMaximumValue(Object variableId) {
        return this.getMaximumValue(variableId, true);
    }

    @Override
    public Object getMaximumValue(Object variableId, boolean useSubset) {
        VarInfo info = this.getVariableInfo(variableId);
        if (this.rangeInfoModel == null || !useSubset) {
            if (info == null || info.maxValue == null) {
                return null;
            }
            return info.maxValue;
        }
        return new Double(this.rangeInfoModel.getMaximum(variableId));
    }

    @Override
    public Object getMinimumValue(Object variableId) {
        return this.getMinimumValue(variableId, true);
    }

    @Override
    public Object getMinimumValue(Object variableId, boolean useSubset) {
        VarInfo info = this.getVariableInfo(variableId);
        if (this.rangeInfoModel == null || !useSubset) {
            if (info == null || info.minValue == null) {
                return null;
            }
            return info.minValue;
        }
        return new Double(this.rangeInfoModel.getMinimum(variableId));
    }

    @Override
    public boolean isMaximumValueValid(Object variableId) {
        return true;
    }

    @Override
    public boolean isMinimumValueValid(Object variableId) {
        return true;
    }

    @Override
    public boolean rerunStatistics() {
        return false;
    }

    @Override
    public Object[] getUniqueValues(Object variableId, boolean useSubset, int max) {
        VarInfo info = this.getVariableInfo(variableId);
        if (info == null || info.uniqueValues == null) {
            return null;
        }
        return info.getUniqueValues(max);
    }

    @Override
    public Object[] getUniqueValues(Object variableId, boolean useSubset) {
        return this.getUniqueValues(variableId, useSubset, 100);
    }

    protected VarInfo getVariableInfo(Object var) {
        if (var == null) {
            return null;
        }
        if (!this.variableInfo.containsKey(var)) {
            VarInfo info = new VarInfo();
            info.build(var);
            this.variableInfo.put(var, info);
        }
        return (VarInfo)this.variableInfo.get(var);
    }

    class VarInfo {
        LinkedHashMap uniqueValues = null;
        Number minValue = null;
        Number maxValue = null;
        public static final int maxUnique = Integer.MAX_VALUE;
        private Object var = null;

        VarInfo() {
        }

        public Object[] getUniqueValues(int max) {
            return this.getUniqueValues(this.var, max);
        }

        public Object[] getUniqueValues(Object var, int max) {
            if (this.uniqueValues == null || this.uniqueValues.size() < max) {
                this.build(var, max);
            }
            if (this.uniqueValues != null) {
                return this.uniqueValues.values().toArray();
            }
            return null;
        }

        public void build(Object var) {
            this.build(var, Integer.MAX_VALUE);
        }

        private void build(Object var, int max) {
            if (!JTableDataFilter.this.verifyVariable(var)) {
                return;
            }
            this.var = var;
            int index = JTableDataFilter.this.getVariableIndex(var);
            boolean isNumeric = JTableDataFilter.this.isNumericVariable(index);
            Object o = JTableDataFilter.this.buildVariableValueList(var, Integer.MAX_VALUE);
            this.uniqueValues = o instanceof LinkedHashMap ? (LinkedHashMap)o : null;
            if (isNumeric) {
                this.minValue = new Double(Double.MAX_VALUE);
                this.maxValue = new Double(Double.MIN_VALUE);
            }
            for (int i = 0; i < JTableDataFilter.this.getNumberObservations(index); ++i) {
                Object value = JTableDataFilter.this.getValue(index, (long)i);
                if (value == null || !isNumeric) continue;
                if (this.minValue.doubleValue() > ((Number)value).doubleValue()) {
                    this.minValue = (Number)value;
                }
                if (!(this.maxValue.doubleValue() < ((Number)value).doubleValue())) continue;
                this.maxValue = (Number)value;
            }
        }
    }
}

