/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data.where;

import com.sas.graphics.data.where.Operator;
import com.sas.graphics.data.where.ParseInfoInterface;
import com.sas.graphics.data.where.Token;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.StringCompare;
import java.lang.constant.Constable;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;

public class Parser {
    protected Token lastToken = null;
    protected ParseInfoInterface infoObj = null;
    protected Operator[] ops = new Operator[]{new Operator(true, 0, 2, 1, "&"), new Operator(true, 1, 6, 2, "*"), new Operator(false, 2, 7, 2, "**"), new Operator(true, 3, 5, 2, "+"), new Operator(true, 4, 5, 2, "-"), new Operator(true, 5, 6, 2, "/"), new Operator(true, 6, 3, 1, "<"), new Operator(true, 7, 3, 1, "<="), new Operator(false, 8, 7, 2, "<>"), new Operator(true, 9, 3, 1, "="), new Operator(true, 10, 3, 1, ">"), new Operator(false, 11, 7, 2, "><"), new Operator(true, 12, 3, 1, ">="), new Operator(true, 13, 3, 1, "^="), new Operator(true, 14, 1, 1, "|"), new Operator(true, 15, 0, 0, "("), new Operator(true, 16, 3, 1, "?"), new Operator(true, 17, 3, 1, "^?")};
    ResourceBundle rb = ResourceLoader.loadBundle("com.sas.graphics.data.Resources_SGCommon");

    protected String getString(int start, int end, String sb) {
        String s = null;
        try {
            s = sb.substring(start, end + 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            return null;
        }
        catch (NullPointerException e2) {
            return null;
        }
        return s;
    }

    protected int eatWhiteSpace(String s, int startIndex) {
        int i = startIndex;
        try {
            char c = s.charAt(i);
            while (c == ' ' || c == '\t') {
                c = s.charAt(++i);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            return i;
        }
        return i;
    }

    protected int getTokenPriority(Token token) {
        int out = 0;
        if (token.type == 7) {
            out = token.id == 26 ? 7 : 8;
        } else if (token.id >= 0 && token.id < 18) {
            out = this.ops[token.id].priority;
        }
        return out;
    }

    protected boolean isLeftRightAssociativity(Token token) {
        if (token.type == 7) {
            return false;
        }
        if (token.id >= 0 && token.id < 18) {
            return this.ops[token.id].assoc;
        }
        return false;
    }

    int comparePriority(Token token1, Token token2) {
        int token1Priority = this.getTokenPriority(token1);
        int token2Priority = this.getTokenPriority(token2);
        return token1Priority - token2Priority;
    }

    protected Token isReserved(String strg, int startIndex) {
        int i = startIndex;
        int rsrv_word = 0;
        int id = -1;
        String func = null;
        Token token = null;
        try {
            char c;
            i = this.eatWhiteSpace(strg, i);
            switch (strg.charAt(i)) {
                case 'A': 
                case 'a': {
                    c = strg.charAt(++i);
                    if (c != 'b' && c != 'B' || (c = strg.charAt(++i)) != 's' && c != 'S') break;
                    rsrv_word = 3;
                    func = "abs";
                    id = 19;
                    break;
                }
                case 'C': 
                case 'c': {
                    c = strg.charAt(++i);
                    if (c != 'o' && c != 'O' || (c = strg.charAt(++i)) != 's' && c != 'S') break;
                    rsrv_word = 3;
                    func = "cos";
                    id = 10;
                    break;
                }
                case 'E': 
                case 'e': {
                    c = strg.charAt(++i);
                    if (c != 'x' && c != 'X' || (c = strg.charAt(++i)) != 'p' && c != 'P') break;
                    rsrv_word = 3;
                    func = "exp";
                    id = 20;
                    break;
                }
                case 'L': 
                case 'l': {
                    c = strg.charAt(++i);
                    if (c != 'o' && c != 'O' || (c = strg.charAt(++i)) != 'g' && c != 'G') break;
                    if (strg.charAt(++i) != '1') {
                        rsrv_word = 3;
                        func = "log";
                        id = 21;
                        break;
                    }
                    if (strg.charAt(++i) != '0') break;
                    rsrv_word = 5;
                    func = "log10";
                    id = 22;
                    break;
                }
                case 'S': 
                case 's': {
                    c = strg.charAt(++i);
                    if (c == 'i' || c == 'I') {
                        if ((c = strg.charAt(++i)) != 'n' && c != 'N') break;
                        rsrv_word = 3;
                        func = "sin";
                        id = 23;
                        break;
                    }
                    if (c != 'q' && c != 'Q' || (c = strg.charAt(++i)) != 'r' && c != 'R' || (c = strg.charAt(++i)) != 't' && c != 'T') break;
                    rsrv_word = 4;
                    func = "sqrt";
                    id = 24;
                    break;
                }
                case 'T': 
                case 't': {
                    c = strg.charAt(++i);
                    if (c != 'a' && c != 'A' || (c = strg.charAt(++i)) != 'n' && c != 'N') break;
                    rsrv_word = 3;
                    func = "tan";
                    id = 25;
                    break;
                }
            }
            if (rsrv_word == 0) {
                return null;
            }
            if (strg.charAt(i = this.eatWhiteSpace(strg, i)) != '(') {
                return null;
            }
            ++i;
            int paren_level = 1;
            while (paren_level != 0) {
                c = strg.charAt(i);
                if (c == ')') {
                    --paren_level;
                } else if (c == '(') {
                    ++paren_level;
                }
                ++i;
            }
            token = new Token();
            token.type = 7;
            token.id = id;
            token.len = i - startIndex;
            token.value = func;
        }
        catch (StringIndexOutOfBoundsException e) {
            return null;
        }
        return token;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Token isConstant(String strg, int startIndex) {
        int first;
        boolean numeric = true;
        int digits = 0;
        Double d = null;
        String s = null;
        Token token = null;
        int i = first = startIndex;
        try {
            first = i = this.eatWhiteSpace(strg, i);
            char c = strg.charAt(i);
            if (c == '+') {
                if (this.lastToken != null && (this.lastToken.type == 5 || this.lastToken.type == 2 || this.lastToken.type == 6)) return null;
                ++i;
            } else if (c == '\"' || c == '\'') {
                numeric = false;
                char quote = c;
                ++i;
                while (strg.charAt(i) != quote) {
                    ++i;
                }
                token = new Token();
                token.type = 2;
                token.len = i - startIndex + 1;
                token.value = this.getString(first + 1, i - 1, strg);
                return token;
            }
            c = strg.charAt(i);
            if (!Character.isDigit(c) && c != '.') {
                return null;
            }
            while (Character.isDigit(strg.charAt(i))) {
                ++i;
                ++digits;
            }
            if (strg.charAt(i) == '.') {
                ++i;
            }
            while (i < strg.length() && Character.isDigit(strg.charAt(i))) {
                ++i;
                ++digits;
            }
            if (digits == 0) {
                if (c != '.') return null;
                token = new Token();
                token.type = 2;
                token.len = i - startIndex;
                token.value = new Double(Double.NaN);
                return token;
            }
            c = strg.charAt(i);
            if (c == 'e' || c == 'E') {
                if ((c = strg.charAt(++i)) == '+' || c == '-') {
                    ++i;
                }
                while (Character.isDigit(strg.charAt(i))) {
                    ++i;
                }
                if (!Character.isDigit(strg.charAt(i - 1))) {
                    return null;
                }
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            if (!numeric || digits <= 0) {
                return null;
            }
            int len = i - startIndex;
            try {
                s = this.getString(first, i - 1, strg);
                d = Double.valueOf(s);
            }
            catch (NumberFormatException e1) {
                return null;
            }
            token = new Token();
            token.type = 2;
            token.len = len;
            token.value = d;
            return token;
        }
        int len = i - startIndex;
        try {
            s = this.getString(first, i - 1, strg);
            d = Double.valueOf(s);
        }
        catch (NumberFormatException e2) {
            return null;
        }
        token = new Token();
        token.type = 2;
        token.len = len;
        token.value = d;
        return token;
    }

    protected Token getName(String srcstr, int startIndex) {
        int i = startIndex;
        int size = 0;
        String s = null;
        Token token = null;
        int first = i = this.eatWhiteSpace(srcstr, i);
        try {
            char c = srcstr.charAt(i);
            if (!Character.isLetter(c) && c != '_') {
                return null;
            }
            c = srcstr.charAt(++i);
            while (Character.isLetterOrDigit(c) || c == '_') {
                c = srcstr.charAt(++i);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        size = i - startIndex;
        token = new Token();
        token.type = 5;
        token.len = size;
        s = this.getString(first, i - 1, srcstr);
        token.value = s;
        return token;
    }

    protected Token isOperation(String srcstr, int startIndex) {
        Token token = null;
        int i = this.eatWhiteSpace(srcstr, startIndex);
        try {
            char c = srcstr.charAt(i);
            switch (c) {
                case '<': {
                    if (srcstr.charAt(i + 1) == '>') {
                        token = new Token();
                        token.type = 1;
                        token.len = i - startIndex + 2;
                        token.id = 8;
                        token.value = "<>";
                        break;
                    }
                    if (srcstr.charAt(i + 1) == '=') {
                        token = new Token();
                        token.type = 1;
                        token.len = i - startIndex + 2;
                        token.id = 7;
                        token.value = "<=";
                        break;
                    }
                    token = new Token();
                    token.type = 1;
                    token.len = i - startIndex + 1;
                    token.id = 6;
                    token.value = "<";
                    break;
                }
                case '>': {
                    if (srcstr.charAt(i + 1) == '<') {
                        token = new Token();
                        token.type = 1;
                        token.len = i - startIndex + 2;
                        token.id = 11;
                        token.value = "><";
                        break;
                    }
                    if (srcstr.charAt(i + 1) == '=') {
                        token = new Token();
                        token.type = 1;
                        token.len = i - startIndex + 2;
                        token.id = 12;
                        token.value = ">=";
                        break;
                    }
                    token = new Token();
                    token.type = 1;
                    token.len = i - startIndex + 1;
                    token.id = 10;
                    token.value = ">";
                    break;
                }
                case '*': {
                    if (srcstr.charAt(i + 1) == '*') {
                        token = new Token();
                        token.type = 1;
                        token.len = ++i - startIndex + 1;
                        token.id = 2;
                        token.value = "**";
                        break;
                    }
                    token = new Token();
                    token.type = 1;
                    token.len = i - startIndex + 1;
                    token.id = 1;
                    token.value = "*";
                    break;
                }
                case '+': {
                    token = new Token();
                    token.type = 1;
                    token.len = i - startIndex + 1;
                    token.value = "+";
                    token.id = 3;
                    break;
                }
                case '/': {
                    token = new Token();
                    token.type = 1;
                    token.len = i - startIndex + 1;
                    token.value = "/";
                    token.id = 5;
                    break;
                }
                case '?': {
                    token = new Token();
                    token.type = 1;
                    token.len = i - startIndex + 1;
                    token.value = "?";
                    token.id = 16;
                    break;
                }
                case '=': {
                    token = new Token();
                    token.type = 1;
                    token.len = i - startIndex + 1;
                    token.value = "=";
                    token.id = 9;
                    break;
                }
                case '^': {
                    if (srcstr.charAt(i + 1) == '=') {
                        token = new Token();
                        token.type = 1;
                        token.len = i - startIndex + 2;
                        token.value = "^=";
                        token.id = 13;
                        break;
                    }
                    if (srcstr.charAt(i + 1) != '?') break;
                    token = new Token();
                    token.type = 1;
                    token.len = i - startIndex + 2;
                    token.value = "^?";
                    token.id = 17;
                    break;
                }
                case '&': {
                    token = new Token();
                    token.type = 1;
                    token.len = i - startIndex + 1;
                    token.id = 0;
                    token.value = "&";
                    break;
                }
                case '|': {
                    token = new Token();
                    token.type = 1;
                    token.len = i - startIndex + 1;
                    token.id = 14;
                    token.value = "|";
                    break;
                }
                case '-': {
                    if (this.lastToken != null && this.lastToken.type != 5 && this.lastToken.type != 2 && this.lastToken.type != 6) {
                        token = new Token();
                        token.type = 7;
                        token.id = 26;
                        token.len = i - startIndex + 1;
                        token.value = new Double(-1.0);
                        break;
                    }
                    token = new Token();
                    token.type = 1;
                    token.len = i - startIndex + 1;
                    token.value = "-";
                    token.id = 4;
                }
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            return null;
        }
        return token;
    }

    protected Token isSpecial(String strg, int startIndex) {
        Token token = null;
        int i = this.eatWhiteSpace(strg, startIndex);
        if (i >= strg.length()) {
            token = new Token();
            token.len = 0;
            token.type = 3;
            token.value = null;
            return token;
        }
        char c = strg.charAt(i);
        switch (c) {
            case '(': {
                token = new Token();
                token.type = 4;
                token.len = i - startIndex + 1;
                token.id = 15;
                token.value = "(";
                break;
            }
            case ')': {
                token = new Token();
                token.type = 6;
                token.len = i - startIndex + 1;
                token.value = ")";
                break;
            }
        }
        return token;
    }

    protected Token getToken(String srcstr, int startIndex) {
        Token token = null;
        token = this.isSpecial(srcstr, startIndex);
        if (token == null && (token = this.isReserved(srcstr, startIndex)) == null && (token = this.isConstant(srcstr, startIndex)) == null && (token = this.isOperation(srcstr, startIndex)) == null && (token = this.getName(srcstr, startIndex)) == null) {
            return null;
        }
        this.lastToken = token;
        return token;
    }

    public void setParseInfoObject(ParseInfoInterface infoObj) {
        this.infoObj = infoObj;
    }

    public Object parseInfix(String infix) {
        boolean loop2 = true;
        int i = 0;
        Stack<Token> tstack = new Stack<Token>();
        Vector<Token> postfix = new Vector<Token>();
        this.lastToken = null;
        block9: while (i < infix.length()) {
            Token token = this.getToken(infix, i);
            if (token == null) {
                return ResourceLoader.getResourceString(this.rb, "Parser.Error_in_expression.txt", "Error in expression");
            }
            switch (token.type) {
                case 4: 
                case 7: {
                    tstack.push(token);
                    i += token.len;
                    continue block9;
                }
                case 2: 
                case 5: {
                    postfix.addElement(token);
                    i += token.len;
                    loop2 = true;
                    do {
                        if ((token = this.getToken(infix, i)) == null) {
                            return ResourceLoader.getResourceString(this.rb, "Parser.Error_in_expression.txt", "Error in expression");
                        }
                        switch (token.type) {
                            case 6: {
                                if (tstack.isEmpty()) {
                                    return ResourceLoader.getResourceString(this.rb, "Parser.Error_in_expression.txt", "Error in expression");
                                }
                                Token entry = (Token)tstack.pop();
                                while (entry.type != 4) {
                                    if (entry.type == 7 || entry.type == 1) {
                                        postfix.addElement(entry);
                                    }
                                    if (tstack.isEmpty()) {
                                        return ResourceLoader.getResourceString(this.rb, "Parser.Error_in_expression.txt", "Error in expression");
                                    }
                                    entry = (Token)tstack.pop();
                                }
                                break;
                            }
                            case 1: {
                                Token entry;
                                boolean test_higher = true;
                                do {
                                    if (tstack.isEmpty()) {
                                        tstack.push(token);
                                        loop2 = false;
                                        test_higher = false;
                                        continue;
                                    }
                                    entry = (Token)tstack.pop();
                                    int ret_val = this.comparePriority(token, entry);
                                    if (ret_val > 0) {
                                        tstack.push(entry);
                                        tstack.push(token);
                                        loop2 = false;
                                        test_higher = false;
                                        continue;
                                    }
                                    if (ret_val < 0) {
                                        postfix.addElement(entry);
                                        continue;
                                    }
                                    if (this.isLeftRightAssociativity(token)) {
                                        postfix.addElement(entry);
                                        continue;
                                    }
                                    tstack.push(entry);
                                    tstack.push(token);
                                    loop2 = false;
                                    test_higher = false;
                                } while (test_higher);
                                break;
                            }
                            case 3: {
                                Token entry;
                                while (!tstack.isEmpty()) {
                                    entry = (Token)tstack.pop();
                                    if (entry.type == 4) {
                                        return ResourceLoader.getResourceString(this.rb, "Parser.Error_in_expression_unmatched_parenthesis.txt", "Error in expression, unmatched parenthesis");
                                    }
                                    postfix.addElement(entry);
                                }
                                postfix.addElement(token);
                                return postfix;
                            }
                            default: {
                                return ResourceLoader.getResourceString(this.rb, "Parser.Error_in_expression.txt", "Error in expression");
                            }
                        }
                        i += token.len;
                    } while (loop2);
                    continue block9;
                }
            }
            return ResourceLoader.getResourceString(this.rb, "Parser.Error_in_expression.txt", "Error in expression");
        }
        return ResourceLoader.getResourceString(this.rb, "Parser.Unexpected_end_of_expression_found.txt", "Unexpected end of expression found");
    }

    protected Object doBinaryOperation(Object a, Object b, Token token) {
        boolean aIsNumeric = false;
        boolean bIsNumeric = false;
        boolean aIsMissing = false;
        boolean bIsMissing = false;
        double av = Double.NaN;
        double bv = Double.NaN;
        Constable out = null;
        String aStr = null;
        String bStr = null;
        if (a == null || b == null) {
            return null;
        }
        if (a instanceof Number) {
            av = ((Number)a).doubleValue();
            aIsNumeric = true;
            aIsMissing = Double.isNaN(av);
        }
        if (b instanceof Number) {
            bv = ((Number)b).doubleValue();
            bIsNumeric = true;
            bIsMissing = Double.isNaN(bv);
        }
        try {
            switch (token.id) {
                case 16: {
                    aStr = a.toString();
                    bStr = b.toString();
                    if (aStr == null || bStr == null) {
                        out = new Boolean(false);
                        break;
                    }
                    out = new Boolean(aStr.indexOf(bStr) >= 0);
                    break;
                }
                case 17: {
                    aStr = a.toString();
                    bStr = b.toString();
                    if (aStr == null || bStr == null) {
                        out = new Boolean(false);
                        break;
                    }
                    out = new Boolean(aStr.indexOf(bStr) < 0);
                    break;
                }
                case 9: {
                    if (aIsNumeric && bIsNumeric) {
                        if (aIsMissing && bIsMissing) {
                            out = new Boolean(true);
                            break;
                        }
                        if (aIsMissing != bIsMissing) {
                            out = new Boolean(false);
                            break;
                        }
                        out = new Boolean(av == bv);
                        break;
                    }
                    if (a.getClass() != b.getClass()) break;
                    out = new Boolean(a.equals(b));
                    break;
                }
                case 13: {
                    if (aIsNumeric && bIsNumeric) {
                        if (aIsMissing && bIsMissing) {
                            out = new Boolean(false);
                            break;
                        }
                        if (aIsMissing != bIsMissing) {
                            out = new Boolean(true);
                            break;
                        }
                        out = new Boolean(av != bv);
                        break;
                    }
                    if (a.getClass() != b.getClass()) break;
                    out = new Boolean(!a.equals(b));
                    break;
                }
                case 6: {
                    if (a.getClass() != b.getClass()) break;
                    if (a instanceof String) {
                        out = new Boolean(StringCompare.compareTo((String)a, (String)b) < 0);
                        break;
                    }
                    if (aIsNumeric && bIsNumeric) {
                        if (aIsMissing && bIsMissing) {
                            out = new Boolean(false);
                            break;
                        }
                        if (aIsMissing) {
                            out = new Boolean(true);
                            break;
                        }
                        if (bIsMissing) {
                            out = new Boolean(false);
                            break;
                        }
                        out = new Boolean(av < bv);
                        break;
                    }
                    out = null;
                    break;
                }
                case 7: {
                    if (a.getClass() != b.getClass()) break;
                    if (a instanceof String) {
                        out = new Boolean(StringCompare.compareTo((String)a, (String)b) <= 0);
                        break;
                    }
                    if (aIsNumeric && bIsNumeric) {
                        if (aIsMissing && bIsMissing) {
                            out = new Boolean(true);
                            break;
                        }
                        if (aIsMissing) {
                            out = new Boolean(true);
                            break;
                        }
                        if (bIsMissing) {
                            out = new Boolean(false);
                            break;
                        }
                        out = new Boolean(av <= bv);
                        break;
                    }
                    out = null;
                    break;
                }
                case 10: {
                    if (a instanceof String) {
                        out = new Boolean(StringCompare.compareTo((String)a, (String)b) > 0);
                        break;
                    }
                    if (aIsNumeric && bIsNumeric) {
                        if (aIsMissing && bIsMissing) {
                            out = new Boolean(false);
                            break;
                        }
                        if (aIsMissing) {
                            out = new Boolean(false);
                            break;
                        }
                        if (bIsMissing) {
                            out = new Boolean(true);
                            break;
                        }
                        out = new Boolean(av > bv);
                        break;
                    }
                    out = null;
                    break;
                }
                case 12: {
                    if (a instanceof String) {
                        out = new Boolean(StringCompare.compareTo((String)a, (String)b) >= 0);
                        break;
                    }
                    if (aIsNumeric && bIsNumeric) {
                        if (aIsMissing && bIsMissing) {
                            out = new Boolean(true);
                            break;
                        }
                        if (aIsMissing) {
                            out = new Boolean(false);
                            break;
                        }
                        if (bIsMissing) {
                            out = new Boolean(true);
                            break;
                        }
                        out = new Boolean(av >= bv);
                        break;
                    }
                    out = null;
                    break;
                }
                case 3: {
                    if (aIsMissing || bIsMissing) {
                        out = new Double(Double.NaN);
                        break;
                    }
                    out = new Double(av + bv);
                    break;
                }
                case 4: {
                    if (aIsMissing || bIsMissing) {
                        out = new Double(Double.NaN);
                        break;
                    }
                    out = new Double(av - bv);
                    break;
                }
                case 5: {
                    if (aIsMissing || bIsMissing || bv == 0.0) {
                        out = new Double(Double.NaN);
                        break;
                    }
                    out = new Double(av / bv);
                    break;
                }
                case 11: {
                    if (aIsMissing || bIsMissing) {
                        out = new Double(Double.NaN);
                        break;
                    }
                    out = new Double(Math.min(av, bv));
                    break;
                }
                case 8: {
                    if (aIsMissing) {
                        out = new Double(bv);
                        break;
                    }
                    if (bIsMissing) {
                        out = new Double(av);
                        break;
                    }
                    out = new Double(Math.max(av, bv));
                    break;
                }
                case 1: {
                    if (aIsMissing || bIsMissing) {
                        out = new Double(Double.NaN);
                        break;
                    }
                    out = new Double(av * bv);
                    break;
                }
                case 2: {
                    if (aIsMissing || bIsMissing) {
                        out = new Double(Double.NaN);
                        break;
                    }
                    out = new Double(Math.pow(av, bv));
                    break;
                }
                case 0: {
                    out = new Boolean((Boolean)a != false && (Boolean)b != false);
                    break;
                }
                case 14: {
                    out = new Boolean((Boolean)a != false || (Boolean)b != false);
                }
            }
        }
        catch (ClassCastException e) {
            return null;
        }
        return out;
    }

    protected Object doUnaryOperation(Object a, Token token) {
        Double out = null;
        try {
            double av = ((Number)a).doubleValue();
            switch (token.id) {
                case 19: {
                    if (Double.isNaN(av)) {
                        out = new Double(Double.NaN);
                        break;
                    }
                    out = new Double(Math.abs(av));
                    break;
                }
                case 10: {
                    if (Double.isNaN(av)) {
                        out = new Double(Double.NaN);
                        break;
                    }
                    out = new Double(Math.cos(av));
                    break;
                }
                case 20: {
                    if (Double.isNaN(av)) {
                        out = new Double(Double.NaN);
                        break;
                    }
                    out = new Double(Math.exp(av));
                    break;
                }
                case 21: {
                    if (Double.isNaN(av)) {
                        out = new Double(Double.NaN);
                        break;
                    }
                    out = new Double(Math.log(av));
                    break;
                }
                case 22: {
                    if (Double.isNaN(av)) {
                        out = new Double(Double.NaN);
                        break;
                    }
                    out = new Double(Math.log(av) / Math.log(10.0));
                    break;
                }
                case 23: {
                    if (Double.isNaN(av)) {
                        out = new Double(Double.NaN);
                        break;
                    }
                    out = new Double(Math.sin(av));
                    break;
                }
                case 24: {
                    if (Double.isNaN(av)) {
                        out = new Double(Double.NaN);
                        break;
                    }
                    out = new Double(Math.sqrt(av));
                    break;
                }
                case 25: {
                    if (Double.isNaN(av)) {
                        out = new Double(Double.NaN);
                        break;
                    }
                    out = new Double(Math.tan(av));
                    break;
                }
                case 26: {
                    out = Double.isNaN(av) ? new Double(Double.NaN) : new Double(-av);
                }
            }
        }
        catch (ClassCastException e) {
            return null;
        }
        return out;
    }

    public Object evaluatePostfix(Vector track) {
        Object result;
        int count = 0;
        Stack<Object> stack = new Stack<Object>();
        if (track == null || stack == null) {
            return null;
        }
        try {
            Token curtok = (Token)track.elementAt(count);
            while (curtok.type != 3) {
                switch (curtok.type) {
                    case 1: {
                        Object b = stack.pop();
                        Object a = stack.pop();
                        result = this.doBinaryOperation(a, b, curtok);
                        if (result == null) {
                            return null;
                        }
                        stack.push(result);
                        break;
                    }
                    case 2: {
                        stack.push(curtok.value);
                        break;
                    }
                    case 5: {
                        if (this.infoObj == null) {
                            return null;
                        }
                        Object a = this.infoObj.getVariableValue(curtok.value);
                        if (a == null) {
                            return null;
                        }
                        stack.push(a);
                        break;
                    }
                    case 7: {
                        Object a = stack.pop();
                        result = this.doUnaryOperation(a, curtok);
                        if (result == null) {
                            return null;
                        }
                        stack.push(result);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                curtok = (Token)track.elementAt(++count);
            }
        }
        catch (ClassCastException e) {
            return null;
        }
        result = stack.pop();
        return result;
    }
}

