/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data.where;

import com.sas.graphics.data.where.ParseInfoInterface;
import com.sas.graphics.data.where.Parser;
import com.sas.graphics.data.where.WhereFilterInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.util.Extract;
import java.util.Vector;

public class DvrWhereFilter
implements WhereFilterInterface,
ParseInfoInterface {
    protected long iCurObs = -1L;
    protected DataFilterReadInterface filter;
    protected Parser parser = new Parser();

    public DvrWhereFilter(DataFilterReadInterface filterIn) {
        this.parser.setParseInfoObject(this);
        this.setDataFilter(filterIn);
    }

    public DvrWhereFilter() {
        this(null);
    }

    @Override
    public Class getVariableClass(Object variable) {
        Object value = null;
        if (this.filter == null) {
            return null;
        }
        value = this.filter.getValue(variable, this.iCurObs);
        if (value == null) {
            return null;
        }
        return value.getClass();
    }

    @Override
    public Object getVariableValue(Object name) {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getValue(name, this.iCurObs);
    }

    protected void setCurrentObservation(Object prev, long iobs, int type) {
        if (prev == null || type <= 0) {
            this.iCurObs = iobs;
            return;
        }
        this.iCurObs = Extract.getInteger(prev, (int)iobs, type);
    }

    @Override
    public boolean setDataFilter(DataFilterReadInterface filterIn) {
        if (this.parser == null) {
            return false;
        }
        this.filter = filterIn;
        return true;
    }

    @Override
    public DataFilterReadInterface getDataFilter() {
        return this.filter;
    }

    @Override
    public Object applyWhereFilter(String clause, Object obsList) {
        int count = 0;
        int type = 0;
        Object obj = null;
        Vector<Long> vec = null;
        Vector postfix = null;
        if (this.parser == null || this.filter == null) {
            return null;
        }
        obj = this.parser.parseInfix(clause);
        if (obj == null || !(obj instanceof Vector)) {
            return null;
        }
        if (obsList == null) {
            count = this.filter.getNumberObservations(null);
        } else {
            type = Extract.getSourceType(obsList);
            if (type <= 0) {
                return null;
            }
            count = Extract.getNumberItems(obsList, type);
        }
        postfix = (Vector)obj;
        vec = new Vector<Long>();
        for (int i = 0; i < count; ++i) {
            this.setCurrentObservation(obsList, i, type);
            obj = this.parser.evaluatePostfix(postfix);
            if (obj == null || !(obj instanceof Boolean)) {
                return null;
            }
            if (!((Boolean)obj).booleanValue()) continue;
            vec.addElement(new Long(this.iCurObs));
        }
        return vec;
    }
}

