/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data.sort;

import com.sas.graphics.data.sort.ContextStoreNode;
import com.sas.graphics.data.sort.MutableSortContext;
import com.sas.graphics.data.sort.SortContext;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.util.Extract;
import java.util.Enumeration;
import java.util.Hashtable;

public class SortContextFactory {
    private static Hashtable contextStore = new Hashtable();

    public static void detachFromDataModel(Object dataModel) {
        if (dataModel == null || contextStore == null) {
            return;
        }
        if (!contextStore.containsKey(dataModel)) {
            return;
        }
        ContextStoreNode root = SortContextFactory.getRootNode(dataModel);
        root.dispose();
        contextStore.remove(dataModel);
    }

    public static SortContext getSortContext(Object model, String variable, int order) {
        return SortContextFactory.getSortContext(model, new String[]{variable}, order);
    }

    public static SortContext getSortContext(Object model, String[] variables, int order) {
        Object source = SortContextFactory.getSource(model);
        if (source == null) {
            return null;
        }
        if (order != 1 && order != 0 && order != -1) {
            return null;
        }
        int type = Extract.getSourceType(variables);
        if (Extract.getNumberItems(variables, type) <= 0) {
            return null;
        }
        Enumeration vars = Extract.elements(variables);
        ContextStoreNode node = SortContextFactory.getRootNode(source);
        while (vars.hasMoreElements()) {
            Object nextVar = vars.nextElement();
            node = node.getChild(nextVar);
        }
        SortContext rc = node.getSortContext(order);
        if (rc == null) {
            rc = new SortContext(source);
            rc.setSort(order, variables);
            node.setSortContext(order, rc);
        }
        return rc;
    }

    public static MutableSortContext getMutableSortContext(Object model, String variable, int order) {
        return SortContextFactory.getMutableSortContext(model, new String[]{variable}, order);
    }

    public static MutableSortContext getMutableSortContext(Object model, String[] variables, int order) {
        return new MutableSortContext(model, variables, order);
    }

    private static Object getSource(Object model) {
        DataFilterReadInterface dfri = FilterFactory.getDataSourceFilter(model);
        if (dfri == null) {
            return null;
        }
        Object rc = dfri;
        while (rc instanceof DataFilterReadInterface) {
            if (rc.getSource() == rc) {
                return rc;
            }
            rc = rc.getSource();
        }
        return rc;
    }

    private static ContextStoreNode getRootNode(Object model) {
        if (contextStore.containsKey(model)) {
            return (ContextStoreNode)contextStore.get(model);
        }
        ContextStoreNode rc = new ContextStoreNode(model);
        contextStore.put(model, rc);
        return rc;
    }
}

