/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data.sort;

import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.util.DynamicIntArray;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.StringCompare;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SortContext
implements DataFilterListenerInterface {
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DATA = 0;
    public static final int SORT_DESCENDING = -1;
    protected DataFilterReadInterface source = null;
    protected int sortDirection = 0;
    protected String[] variables = null;
    protected boolean isLocal = true;
    protected int[] indexes = null;
    protected Hashtable byGroups = new Hashtable();
    protected Hashtable sortedSubsetLists = new Hashtable();
    protected Vector otherFilters = new Vector();

    SortContext(Object model) {
        if (model == null) {
            throw new IllegalArgumentException("Null filter not allowed for sort context");
        }
        this.source = FilterFactory.getDataSourceFilter(model);
        this.source.addDataFilterListener(this);
        if (this.source == null) {
            throw new IllegalArgumentException("Invalid model in SortContext");
        }
        this.indexes = new int[this.source.getNumberObservations(-1)];
        for (int i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = i;
        }
    }

    void dispose() {
        if (this.source != null) {
            this.source.removeDataFilterListener(this);
        }
        this.source = null;
        if (this.otherFilters != null && this.otherFilters.size() > 0) {
            for (int i = 0; i < this.otherFilters.size(); ++i) {
                ((DataFilterReadInterface)this.otherFilters.elementAt(i)).removeDataFilterListener(this);
            }
            this.otherFilters.clear();
        }
        this.otherFilters = null;
        this.variables = null;
        this.indexes = null;
        if (this.byGroups != null) {
            this.byGroups.clear();
        }
        this.byGroups = null;
        if (this.sortedSubsetLists != null) {
            this.sortedSubsetLists.clear();
        }
        this.sortedSubsetLists = null;
    }

    boolean setSort(int order, String[] sortVariables) {
        if (order != 1 && order != 0 && order != -1) {
            return false;
        }
        if (sortVariables == null) {
            return false;
        }
        int numVars = Extract.getNumberItems(sortVariables, Extract.getSourceType(sortVariables));
        if (numVars < 1) {
            return false;
        }
        Enumeration e = Extract.elements(sortVariables);
        String[] vars = new String[numVars];
        int count = 0;
        while (e.hasMoreElements()) {
            Object var = e.nextElement();
            if (!this.source.verifyVariable(var)) {
                return false;
            }
            vars[count++] = var.toString();
        }
        this.sortDirection = order;
        this.variables = vars;
        boolean rc = this.doSort();
        return rc;
    }

    public int getSortedIndex(int i, DataFilterReadInterface filter) {
        if (!this.isLocal || this.indexes == null || i < 0 || i >= this.indexes.length) {
            return i;
        }
        if (filter == null) {
            return this.indexes[i];
        }
        if (filter.getSubsetList() == null) {
            if (this.sortedSubsetLists.containsKey(filter)) {
                this.sortedSubsetLists.remove(filter);
                filter.removeDataFilterListener(this);
                this.otherFilters.remove(filter);
            }
            return this.indexes[i];
        }
        int[] list = (int[])this.sortedSubsetLists.get(filter);
        if (list == null) {
            list = this.getSortedSubsetList(filter);
            this.sortedSubsetLists.put(filter, list);
            filter.addDataFilterListener(this);
            if (!this.otherFilters.contains(filter)) {
                this.otherFilters.add(filter);
            }
        }
        return list[i];
    }

    private int[] getSortedSubsetList(DataFilterReadInterface filter) {
        int[] rc = new int[filter.getNumberObservations(-1)];
        int current = 0;
        for (int i = 0; i < this.indexes.length; ++i) {
            if (!filter.isIndexInCurrentSubset(this.indexes[i])) continue;
            rc[current++] = this.getIndexOf(this.indexes[i], (int[])filter.getSubsetList());
        }
        return rc;
    }

    private int getIndexOf(int val, int[] list) {
        int rc = val;
        for (int i = 0; i < list.length; ++i) {
            if (val != list[i]) continue;
            rc = i;
        }
        return rc;
    }

    public Object getSource() {
        return this.source.getSource();
    }

    public int getSortOrder() {
        return this.sortDirection;
    }

    public String[] getSortVariables() {
        return this.variables;
    }

    private boolean doSort() {
        if (this.source == null || this.variables == null || this.variables.length <= 0) {
            return false;
        }
        if (this.sortDirection == 0) {
            this.indexes = null;
            this.variables = null;
            return true;
        }
        String lastSortVariable = null;
        for (int i = 0; i < this.variables.length; ++i) {
            String sortVariable = this.variables[i];
            int startIndex = 0;
            int endIndex = -1;
            if (lastSortVariable != null) {
                int[] byGroups = this.getByGroups(lastSortVariable);
                if (byGroups != null) {
                    for (int j = 0; j < byGroups.length; ++j) {
                        startIndex = endIndex + 1;
                        if (this.heapSort(this.source, sortVariable, startIndex, endIndex = byGroups[j])) continue;
                        return false;
                    }
                } else if (!this.heapSort(this.source, sortVariable, startIndex, this.source.getNumberObservations(-1) - 1)) {
                    return false;
                }
            } else if (!this.heapSort(this.source, sortVariable, startIndex, this.source.getNumberObservations(-1) - 1)) {
                return false;
            }
            lastSortVariable = sortVariable;
        }
        return true;
    }

    private int[] getByGroups(Object variable) {
        return (int[])this.byGroups.get(variable);
    }

    private void setByGroups(Object variable, int[] ilist) {
        int[] current = (int[])this.byGroups.get(variable);
        int[] list = null;
        if (current != null) {
            int i;
            DynamicIntArray arr = new DynamicIntArray();
            for (i = 0; i < current.length; ++i) {
                arr.add(current[i]);
            }
            for (i = 0; i < ilist.length; ++i) {
                arr.add(this.indexes[i]);
            }
            list = new int[arr.getNumberElements()];
            for (i = 0; i < list.length; ++i) {
                list[i] = arr.get(i);
            }
        } else {
            list = ilist;
        }
        this.byGroups.put(variable, list);
    }

    private void swap(int a, int b) {
        if (a < 0 || a >= this.indexes.length || b < 0 || b >= this.indexes.length || a == b) {
            return;
        }
        int temp = this.indexes[a];
        this.indexes[a] = this.indexes[b];
        this.indexes[b] = temp;
    }

    private boolean heapSort(DataFilterReadInterface dfri, Object variable, int startIndex, int endIndex) {
        int heapSize;
        if (dfri == null) {
            return false;
        }
        int varIndex = dfri.getVariableIndex(variable);
        if (varIndex < 0 || varIndex >= dfri.getNumberVariables()) {
            return false;
        }
        int n = heapSize = endIndex - startIndex + 1;
        for (int i = startIndex + heapSize / 2 - 1; i >= startIndex; --i) {
            this.heapify(dfri, varIndex, i, startIndex, heapSize);
        }
        Object currentByValue = null;
        DynamicIntArray byGroups = new DynamicIntArray();
        for (int i = n; i >= 1; --i) {
            this.swap(startIndex + i - 1, startIndex);
            this.stabalizeIndexList(dfri, varIndex, --heapSize, endIndex);
            Object value = dfri.getValue(varIndex, (long)this.getSortedIndex(startIndex + i - 1, null));
            if (this.compare(currentByValue, value) != 0) {
                byGroups.add(startIndex + i - 1);
                currentByValue = value;
            }
            this.heapify(dfri, varIndex, startIndex, startIndex, heapSize);
        }
        int[] by = new int[byGroups.getNumberElements()];
        int j = by.length - 1;
        int k = 0;
        while (j >= 0) {
            by[j] = byGroups.get(k);
            --j;
            ++k;
        }
        this.setByGroups(variable, by);
        return true;
    }

    private void stabalizeIndexList(DataFilterReadInterface dfri, int varIndex, int lockPosition, int endIndex) {
        if (lockPosition >= this.indexes.length || lockPosition > endIndex) {
            return;
        }
        Object iValue = dfri.getValue(varIndex, (long)this.indexes[lockPosition]);
        int swapPosition = lockPosition;
        int i = lockPosition + 1;
        while (i <= endIndex) {
            Object compareValue = dfri.getValue(varIndex, (long)this.indexes[i]);
            if (this.compare(iValue, compareValue) == 0) {
                if (this.indexes[i] >= this.indexes[swapPosition]) {
                    return;
                }
                this.swap(swapPosition, i);
            } else {
                return;
            }
            swapPosition = i++;
        }
    }

    private void heapify(DataFilterReadInterface dfri, int varIndex, int i, int heapStartIndex, int heapSize) {
        int left = heapStartIndex + 2 * (i - heapStartIndex) + 1;
        int right = heapStartIndex + 2 * (i - heapStartIndex) + 2;
        int largest = left < heapStartIndex + heapSize && this.compare(dfri.getValue(varIndex, (long)this.getSortedIndex(left, null)), dfri.getValue(varIndex, (long)this.getSortedIndex(i, null))) > 0 ? left : i;
        if (right < heapStartIndex + heapSize && this.compare(dfri.getValue(varIndex, (long)this.getSortedIndex(right, null)), dfri.getValue(varIndex, (long)this.getSortedIndex(largest, null))) > 0) {
            largest = right;
        }
        if (largest != i) {
            this.swap(i, largest);
            this.heapify(dfri, varIndex, largest, heapStartIndex, heapSize);
        }
    }

    private int compare(Object a, Object b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null || b == null) {
            return -999;
        }
        if (a instanceof Number) {
            if (!(b instanceof Number)) {
                return -999;
            }
            double aVal = ((Number)a).doubleValue();
            double bVal = ((Number)b).doubleValue();
            if (Double.isNaN(aVal) && Double.isNaN(bVal)) {
                return 0;
            }
            if (Double.isNaN(aVal)) {
                return this.sortDirection == 1 ? -1 : 1;
            }
            if (Double.isNaN(bVal)) {
                return this.sortDirection == 1 ? 1 : -1;
            }
            if (aVal < bVal) {
                return this.sortDirection == 1 ? -1 : 1;
            }
            if (bVal < aVal) {
                return this.sortDirection == 1 ? 1 : -1;
            }
            return 0;
        }
        String aVal = a.toString();
        String bVal = b.toString();
        int rc = StringCompare.compareTo(aVal, bVal);
        if (this.sortDirection == -1) {
            return -rc;
        }
        return rc;
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (evt == null || evt.source == null) {
            return;
        }
        if (evt.type == 3) {
            if (evt.source == this.source) {
                this.sortedSubsetLists.clear();
                this.indexes = new int[this.source.getNumberObservations(-1)];
                for (int i = 0; i < this.indexes.length; ++i) {
                    this.indexes[i] = i;
                }
                this.doSort();
            } else if (this.sortedSubsetLists.containsKey(evt.source)) {
                this.sortedSubsetLists.remove(evt.source);
            }
        }
    }
}

