/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data;

import com.sas.graphics.silk.data.SelectionIterator;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectionModelAdapter
implements DataFilterListenerInterface,
ListSelectionListener {
    protected DataFilterReadInterface filter = null;
    protected ListSelectionModel model = null;
    protected SelectionIterator filterSelections = null;
    protected boolean ignoreSelections = false;
    private PropertyChangeSupport propertyListeners = new PropertyChangeSupport(this);
    public static final String DATA_MODEL_SELECTION = "DATA_MODEL_SELECTION";

    public SelectionModelAdapter() {
        this(null, null);
    }

    public SelectionModelAdapter(DataFilterReadInterface filterIn, ListSelectionModel modelIn) {
        this.setFilter(filterIn);
        this.setModel(modelIn);
    }

    public void setFilter(DataFilterReadInterface filterIn) {
        if (filterIn == this.filter) {
            return;
        }
        if (this.filter != null) {
            this.filter.removeDataFilterListener(this);
        }
        this.filter = filterIn;
        if (this.filter != null) {
            this.filter.addDataFilterListener(this);
        }
        this.filterSelections = this.filter == null ? null : this.filter.getSelections();
        this.setInitialSelections();
    }

    public DataFilterReadInterface getFilter() {
        return this.filter;
    }

    public void setModel(ListSelectionModel modelIn) {
        if (modelIn == this.model) {
            return;
        }
        if (this.model != null) {
            this.model.removeListSelectionListener(this);
        }
        this.model = modelIn;
        if (this.model != null) {
            this.model.addListSelectionListener(this);
        }
        this.setInitialSelections();
    }

    public ListSelectionModel getModel() {
        return this.model;
    }

    public void removeListeners() {
        if (this.filter != null) {
            this.filter.removeDataFilterListener(this);
            this.filter = null;
        }
        if (this.model != null) {
            this.model.removeListSelectionListener(this);
            this.model = null;
        }
    }

    protected int getModelSelectionIndex(int filterIndex) {
        return filterIndex;
    }

    protected int getFilterSelectionIndex(int modelIndex) {
        return modelIndex;
    }

    protected void setInitialSelections() {
        if (this.filter != null && this.model != null) {
            this.doModelSelection(null);
        }
    }

    protected void doModelSelection(DvrDataFilterEvent evt) {
        if (evt != null && evt.isAdjusting) {
            return;
        }
        this.ignoreSelections = true;
        if (this.filterSelections != null) {
            this.filterSelections.reset();
        }
        this.model.setSelectionMode(2);
        this.model.setValueIsAdjusting(true);
        this.model.clearSelection();
        while (this.filterSelections != null && this.filterSelections.hasMoreSelections()) {
            int currentSelection = this.getModelSelectionIndex(this.filterSelections.nextSelectedIndex());
            this.model.addSelectionInterval(currentSelection, currentSelection);
        }
        this.model.setValueIsAdjusting(false);
        this.ignoreSelections = false;
    }

    protected void doFilterSelection(ListSelectionEvent evt) {
        int maxIndex;
        if (evt != null && evt.getValueIsAdjusting()) {
            return;
        }
        this.ignoreSelections = true;
        this.filter.unselectAll();
        if (this.model.isSelectionEmpty()) {
            this.ignoreSelections = false;
            return;
        }
        int minIndex = this.model.getMinSelectionIndex();
        if (minIndex == (maxIndex = this.model.getMaxSelectionIndex())) {
            this.filter.setSelected(this.getFilterSelectionIndex(minIndex), true);
        } else {
            Vector<Integer> selectList = new Vector<Integer>();
            for (int i = minIndex; i <= maxIndex; ++i) {
                if (!this.model.isSelectedIndex(i)) continue;
                selectList.add(new Integer(this.getFilterSelectionIndex(i)));
            }
            this.filter.setSelected(selectList, true);
        }
        this.ignoreSelections = false;
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (this.ignoreSelections || this.model == null || this.filter == null || evt.source != this.filter) {
            return;
        }
        switch (evt.type) {
            case 2: {
                this.doModelSelection(evt);
                this.propertyListeners.firePropertyChange(DATA_MODEL_SELECTION, null, null);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (this.ignoreSelections || this.filter == null || this.model == null || evt.getSource() != this.model) {
            return;
        }
        this.doFilterSelection(evt);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyListeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyListeners.removePropertyChangeListener(l);
    }

    public void dispose() {
        if (this.model != null) {
            this.model.removeListSelectionListener(this);
        }
        this.model = null;
        if (this.filter != null) {
            this.filter.removeDataFilterListener(this);
        }
        this.filter = null;
    }
}

