/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data;

import com.sas.sg.datamodel.impl.SgDataModel;
import com.sas.text.SASFormat;

public class SSRDataAdapter {
    private String name = null;
    private SgDataModel model = null;

    public SSRDataAdapter() {
        this(null);
    }

    public SSRDataAdapter(String name) {
        this.name = name;
        this.model = new SgDataModel();
    }

    public String getName() {
        return this.name;
    }

    public Object getDataModel() {
        return this.model;
    }

    public void addDoubleColumn(String name, String label, String fmt, double min, double max, int nmiss, double[] colData) {
        int index = this.model.getNumVars();
        this.model.addVars(index, 1, "Numeric Variable");
        if (name != null) {
            this.model.setVarName(index, name);
        }
        if (label != null) {
            this.model.setVarLabel(index, label);
        }
        if (fmt != null && fmt.trim().length() > 0) {
            this.model.setVarFormat(index, (Object)SASFormat.getInstance((String)fmt));
        }
        if (colData != null) {
            if (this.model.getNumObs() == 0) {
                this.model.addObs(index, colData.length);
            }
            this.model.setValue(index, 0, colData.length - 1, colData);
        }
    }

    public void addStringColumn(String name, String label, String fmt, int len, int nmiss, String[] colData) {
        int index = this.model.getNumVars();
        this.model.addVars(index, 1, "Charater Variable");
        if (name != null) {
            this.model.setVarName(index, name);
        }
        if (label != null) {
            this.model.setVarLabel(index, label);
        }
        if (fmt != null && fmt.trim().length() > 0) {
            this.model.setVarFormat(index, (Object)SASFormat.getInstance((String)fmt));
        }
        if (colData != null) {
            if (this.model.getNumObs() == 0) {
                this.model.addObs(index, colData.length);
            }
            this.model.setValue(index, 0, colData.length - 1, (Object[])colData);
        }
    }
}

