/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;

public class GTKDataFilterSelectionVariable
extends NumericVariable {
    private GTKDataFilterSelectionConnection connection = new GTKDataFilterSelectionConnection(this);

    protected int getRawValueCount() {
        return this.connection.getValueCount();
    }

    public void connectFrom(DataFilterReadInterface data) {
        this.connection.connectFrom(data);
        this.connectFrom();
    }

    protected void connectFrom() {
        this.setRawValuePipe(this.connection, this.connection.getValueCount());
        if (this.getName().startsWith(defaultName)) {
            this.setName(this.connection.getVariableName());
            this.setLabel(this.connection.getVariableName());
        }
        super.connectFrom();
        if (this.connection.getFormat() != null) {
            this.setFormat(this.connection.getFormat());
        }
    }

    public void disconnect() {
        this.connection.disconnect();
        super.disconnect();
    }

    public boolean isRawValueMissing(int index) {
        return this.connection.isMissing(index);
    }

    public void setModified(boolean modified) {
        super.setModified(modified);
        if (modified && this.connection != null) {
            this.connection.setModified();
        }
    }

    public int getValueIndexPriorToProcessing(int valueIndex) {
        return valueIndex;
    }

    private static class GTKDataFilterSelectionConnection
    implements NumericPipe {
        private DataFilterReadInterface data;
        private String label = null;
        private String name = null;

        public void init(AInitAction initAction) {
        }

        public void reset(AResetAction resetAction) {
        }

        public Formatter getFormatter() {
            return null;
        }

        public void setModified() {
        }

        public int getValueCount() {
            return -1;
        }

        public GTKFormat getFormat() {
            return null;
        }

        public GTKDataFilterSelectionConnection(NumericVariable variable) {
        }

        public String getVariableLabel() {
            return this.label;
        }

        public String getVariableName() {
            return this.name;
        }

        public void connectFrom(DataFilterReadInterface data) {
            this.data = data;
            this.label = "GTKDataFilterSelectionVariable";
            this.name = "GTKDataFilterSelectionVariable";
        }

        public void disconnect() {
            this.data = null;
        }

        public double getValue(int valueIndex) throws MissingValueException {
            boolean isSelected = this.data.isSelected(valueIndex);
            return isSelected ? 1.0 : 0.0;
        }

        public boolean isMissing(int index) {
            return false;
        }
    }
}

