/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data;

import com.sas.MissingValues;
import com.sas.graphics.data.GTKNumericDataFilterConnection;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.Variable;

public class GTKDataFilterResponseVariable
extends NumericVariable {
    private GTKDataFilterResponseConnection connection = new GTKDataFilterResponseConnection((Variable)this);

    public void connectFrom(DataFilterReadInterface data, int responseVariableIndex, int freqVariableIndex) {
        this.connection.connectFrom(data, responseVariableIndex, freqVariableIndex);
        this.connectFrom();
    }

    public void connectFrom(DataFilterReadInterface data, String responseVariableLabel, String freqVariableLabel) {
        this.connection.connectFrom(data, responseVariableLabel, freqVariableLabel);
        this.connectFrom();
    }

    protected void connectFrom() {
        this.setRawValuePipe(this.connection, this.connection.getValueCount());
        if (this.getName().startsWith(defaultName)) {
            this.setName(this.connection.getVariableName());
            this.setLabel(this.connection.getVariableName());
        }
        super.connectFrom();
        super.connectFrom();
        if (this.connection.getFormat() != null) {
            this.setFormat(this.connection.getFormat());
        }
    }

    protected int getRawValueCount() {
        return this.connection.getValueCount();
    }

    public void disconnect() {
        this.connection.disconnect();
        super.disconnect();
    }

    public boolean isRawValueMissing(int index) {
        return this.connection.isMissing(index);
    }

    public void setModified(boolean modified) {
        super.setModified(modified);
        if (modified && this.connection != null) {
            this.connection.setModified();
        }
    }

    private class GTKDataFilterResponseConnection
    implements NumericPipe {
        private GTKNumericDataFilterConnection responseConnection;
        private GTKNumericDataFilterConnection freqConnection;

        public GTKDataFilterResponseConnection(Variable variable) {
            this.responseConnection = new GTKNumericDataFilterConnection(variable);
            this.freqConnection = new GTKNumericDataFilterConnection(variable);
        }

        public int getValueCount() {
            int respVC = this.responseConnection.getValueCount();
            int freqVC = this.freqConnection.getValueCount();
            return Math.max(respVC, freqVC);
        }

        public GTKFormat getFormat() {
            return this.responseConnection.getFormat();
        }

        public String getVariableName() {
            return this.responseConnection.getVariableName();
        }

        public void setModified() {
            this.responseConnection.setModified();
            this.freqConnection.setModified();
        }

        public boolean isMissing(int index) {
            return this.responseConnection.isMissing(index) | this.freqConnection.isMissing(index);
        }

        public void disconnect() {
            this.responseConnection.disconnect();
            this.freqConnection.disconnect();
        }

        public void connectFrom(DataFilterReadInterface data, String responseVariableLabel, String freqVariableLabel) {
            this.responseConnection.connectFrom(data, responseVariableLabel);
            this.freqConnection.connectFrom(data, freqVariableLabel);
        }

        public void connectFrom(DataFilterReadInterface data, int responseVariableIndex, int freqVariableIndex) {
            this.responseConnection.connectFrom(data, responseVariableIndex);
            this.freqConnection.connectFrom(data, freqVariableIndex);
        }

        public double getValue(int index) throws MissingValueException {
            double r = this.responseConnection.getValue(index);
            double f = this.freqConnection.getValue(index);
            if (f > 0.0) {
                return r * f;
            }
            MissingValueException mv = MissingValueException.getDefaultMissingValueExeption();
            mv.setMissingValue(MissingValues.Dot);
            throw mv;
        }

        public void init(AInitAction initAction) {
            this.responseConnection.init(initAction);
            this.freqConnection.init(initAction);
        }

        public void reset(AResetAction resetAction) {
            this.responseConnection.reset(resetAction);
            this.freqConnection.reset(resetAction);
        }

        public Formatter getFormatter() {
            return null;
        }
    }
}

