/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data;

import com.sas.graphics.data.DataSourceEntry;
import com.sas.graphics.data.DvrDataEvent;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.DataInterface;
import com.sas.graphics.silk.interfaces.DataListenerInterface;
import com.sas.graphics.silk.util.ResourceLoader;
import java.util.Locale;
import java.util.Vector;

public class DvrData
implements DataInterface {
    protected Vector dataSourceObjects;
    protected Vector listeners;
    protected DvrDataEvent evt = new DvrDataEvent();

    public DvrData(Object id, Object dataSource, DataFilterReadInterface filter, Locale localeIn) {
        this.dataSourceObjects = new Vector();
        this.listeners = new Vector();
        this.dataSourceObjects.addElement(new DataSourceEntry(id, dataSource, filter, localeIn));
    }

    public DvrData(Object id, Object dataSource, DataFilterReadInterface filter) {
        this(id, dataSource, filter, null);
    }

    public DvrData(Object dataSource, DataFilterReadInterface filter) {
        this(ResourceLoader.getResourceString(ResourceLoader.loadBundle("com.sas.graphics.data.Resources_SGCommon"), "DvrData.Default.txt", "Default"), dataSource, filter, null);
    }

    public DvrData() {
        this(null, null);
    }

    protected int findEntryById(Object id) {
        int count = 0;
        int out = -1;
        Object cur = null;
        DataSourceEntry dse = null;
        if (this.dataSourceObjects == null) {
            return -1;
        }
        count = this.dataSourceObjects.size();
        for (int i = 0; i < count; ++i) {
            Object e = this.dataSourceObjects.elementAt(i);
            cur = e;
            if (e == null || !(cur instanceof DataSourceEntry)) continue;
            dse = cur;
            if (id == null) {
                out = i;
                break;
            }
            if (dse.id == null || dse.id.getClass() != id.getClass() || !dse.id.equals(id)) continue;
            out = i;
            break;
        }
        return out;
    }

    protected DataSourceEntry getEntry(int idx) {
        Object obj = null;
        if (this.dataSourceObjects == null || idx < 0 || idx >= this.dataSourceObjects.size()) {
            return null;
        }
        Object e = this.dataSourceObjects.elementAt(idx);
        obj = e;
        if (e == null) {
            return null;
        }
        if (!(obj instanceof DataSourceEntry)) {
            return null;
        }
        return obj;
    }

    protected void throwEvent(int changed, DataFilterReadInterface filter) {
        int count;
        if (this.listeners == null || (count = this.listeners.size()) <= 0 || this.evt == null) {
            return;
        }
        this.evt.change = changed;
        this.evt.source = this;
        this.evt.filter = filter;
        for (int i = 0; i < count; ++i) {
            DataListenerInterface recipient = (DataListenerInterface)this.listeners.elementAt(i);
            if (recipient == null) continue;
            recipient.dataFilterChanged(this.evt);
        }
    }

    @Override
    public DataFilterReadInterface getDataSource(Object id) {
        DataSourceEntry dse = null;
        int idx = id == null ? 0 : this.findEntryById(id);
        dse = this.getEntry(idx);
        if (dse == null) {
            return null;
        }
        return dse.filter;
    }

    @Override
    public Object getDataSourceIdAt(int index) {
        DataSourceEntry entry = this.getEntry(index);
        if (entry == null) {
            return null;
        }
        return entry.filter.getSource();
    }

    @Override
    public boolean setDataSource(Object id, Object source, DataFilterReadInterface filter, Locale localeIn) {
        if (id == null) {
            return false;
        }
        int idx = this.findEntryById(id);
        if (idx >= 0) {
            this.dataSourceObjects.setElementAt(new DataSourceEntry(id, source, filter, localeIn), idx);
        } else {
            this.dataSourceObjects.addElement(new DataSourceEntry(id, source, filter, localeIn));
        }
        this.throwEvent(1, filter);
        return true;
    }

    @Override
    public boolean removeDataSource(Object id) {
        int count = this.getNumberDataSources();
        int idx = id == null ? 0 : this.findEntryById(id);
        if (idx < 0 || idx >= count) {
            return false;
        }
        DataSourceEntry entry = (DataSourceEntry)this.dataSourceObjects.elementAt(idx);
        this.dataSourceObjects.removeElementAt(idx);
        if (entry != null) {
            this.throwEvent(2, entry.filter);
        }
        return true;
    }

    @Override
    public int getNumberDataSources() {
        int count = 0;
        if (this.dataSourceObjects != null) {
            count = this.dataSourceObjects.size();
        }
        return count;
    }

    @Override
    public boolean setMetaData(Object id, Object metaData) {
        DataSourceEntry entry = this.getEntry(this.findEntryById(id));
        if (entry == null) {
            return false;
        }
        entry.metaData = metaData;
        return true;
    }

    @Override
    public Object getMetaData(Object id) {
        DataSourceEntry entry = this.getEntry(this.findEntryById(id));
        if (entry == null) {
            return null;
        }
        return entry.metaData;
    }

    @Override
    public boolean addDataListener(Object listener) {
        if (listener == null || !(listener instanceof DataListenerInterface) || this.listeners == null) {
            return false;
        }
        if (this.listeners.contains(listener)) {
            return false;
        }
        this.listeners.addElement(listener);
        return true;
    }

    @Override
    public boolean removeDataListener(Object listener) {
        if (listener == null) {
            return false;
        }
        int idx = this.listeners.indexOf(listener);
        if (idx < 0) {
            return false;
        }
        this.listeners.removeElementAt(idx);
        return true;
    }
}

